/*
 * scantab.h
 *
 * Description of this file:
 *    tAVS2 scan tables of the davs2 library (this file is ONLY included by aec.c)
 *
 * --------------------------------------------------------------------------
 *
 *    davs2 - video encoder of AVS2/IEEE1857.4 video coding standard
 *    Copyright (C) 2018~ VCL, NELVT, Peking University
 *
 *    Authors: Falei LUO <falei.luo@gmail.com>
 *             etc.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.
 *
 *    This program is also available under a commercial proprietary license.
 *    For more information, contact us at sswang @ pku.edu.cn.
 */


#ifndef DAVS2_SCAN_TAB_H
#define DAVS2_SCAN_TAB_H
#ifdef __cplusplus
extern "C" {
#endif

/**
 * ===========================================================================
 * global variables (const tables)
 * ===========================================================================
 */

/* ---------------------------------------------------------------------------
 */
static const int16_t tab_scan_2x2[4][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 1, 1 }
};

static const int16_t tab_scan_4x4[16][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 },
    { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 1, 3 }, { 2, 2 },
    { 3, 1 }, { 3, 2 }, { 2, 3 }, { 3, 3 }
};

static const int16_t tab_scan_8x8[64][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 0, 4 }, { 1, 3 }, { 2, 2 }, { 3, 1 }, { 4, 0 }, { 5, 0 },
    { 4, 1 }, { 3, 2 }, { 2, 3 }, { 1, 4 }, { 0, 5 }, { 0, 6 }, { 1, 5 }, { 2, 4 },
    { 3, 3 }, { 4, 2 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 }, { 5, 2 }, { 4, 3 },
    { 3, 4 }, { 2, 5 }, { 1, 6 }, { 0, 7 }, { 1, 7 }, { 2, 6 }, { 3, 5 }, { 4, 4 },
    { 5, 3 }, { 6, 2 }, { 7, 1 }, { 7, 2 }, { 6, 3 }, { 5, 4 }, { 4, 5 }, { 3, 6 },
    { 2, 7 }, { 3, 7 }, { 4, 6 }, { 5, 5 }, { 6, 4 }, { 7, 3 }, { 7, 4 }, { 6, 5 },
    { 5, 6 }, { 4, 7 }, { 5, 7 }, { 6, 6 }, { 7, 5 }, { 7, 6 }, { 6, 7 }, { 7, 7 }
};

static const int16_t tab_scan_16x16[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  0,  4}, {  1,  3}, {  2,  2}, {  3,  1}, {  4,  0}, {  5,  0},
    {  4,  1}, {  3,  2}, {  2,  3}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4},
    {  3,  3}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1}, {  5,  2}, {  4,  3},
    {  3,  4}, {  2,  5}, {  1,  6}, {  0,  7}, {  0,  8}, {  1,  7}, {  2,  6}, {  3,  5},
    {  4,  4}, {  5,  3}, {  6,  2}, {  7,  1}, {  8,  0}, {  9,  0}, {  8,  1}, {  7,  2},
    {  6,  3}, {  5,  4}, {  4,  5}, {  3,  6}, {  2,  7}, {  1,  8}, {  0,  9}, {  0, 10},
    {  1,  9}, {  2,  8}, {  3,  7}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  3}, {  8,  2},
    {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1}, {  9,  2}, {  8,  3}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  3,  8}, {  2,  9}, {  1, 10}, {  0, 11}, {  0, 12}, {  1, 11},
    {  2, 10}, {  3,  9}, {  4,  8}, {  5,  7}, {  6,  6}, {  7,  5}, {  8,  4}, {  9,  3},
    { 10,  2}, { 11,  1}, { 12,  0}, { 13,  0}, { 12,  1}, { 11,  2}, { 10,  3}, {  9,  4},
    {  8,  5}, {  7,  6}, {  6,  7}, {  5,  8}, {  4,  9}, {  3, 10}, {  2, 11}, {  1, 12},
    {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 11}, {  4, 10}, {  5,  9}, {  6,  8},
    {  7,  7}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  3}, { 12,  2}, { 13,  1}, { 14,  0},
    { 15,  0}, { 14,  1}, { 13,  2}, { 12,  3}, { 11,  4}, { 10,  5}, {  9,  6}, {  8,  7},
    {  7,  8}, {  6,  9}, {  5, 10}, {  4, 11}, {  3, 12}, {  2, 13}, {  1, 14}, {  0, 15},
    {  1, 15}, {  2, 14}, {  3, 13}, {  4, 12}, {  5, 11}, {  6, 10}, {  7,  9}, {  8,  8},
    {  9,  7}, { 10,  6}, { 11,  5}, { 12,  4}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2},
    { 14,  3}, { 13,  4}, { 12,  5}, { 11,  6}, { 10,  7}, {  9,  8}, {  8,  9}, {  7, 10},
    {  6, 11}, {  5, 12}, {  4, 13}, {  3, 14}, {  2, 15}, {  3, 15}, {  4, 14}, {  5, 13},
    {  6, 12}, {  7, 11}, {  8, 10}, {  9,  9}, { 10,  8}, { 11,  7}, { 12,  6}, { 13,  5},
    { 14,  4}, { 15,  3}, { 15,  4}, { 14,  5}, { 13,  6}, { 12,  7}, { 11,  8}, { 10,  9},
    {  9, 10}, {  8, 11}, {  7, 12}, {  6, 13}, {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14},
    {  7, 13}, {  8, 12}, {  9, 11}, { 10, 10}, { 11,  9}, { 12,  8}, { 13,  7}, { 14,  6},
    { 15,  5}, { 15,  6}, { 14,  7}, { 13,  8}, { 12,  9}, { 11, 10}, { 10, 11}, {  9, 12},
    {  8, 13}, {  7, 14}, {  6, 15}, {  7, 15}, {  8, 14}, {  9, 13}, { 10, 12}, { 11, 11},
    { 12, 10}, { 13,  9}, { 14,  8}, { 15,  7}, { 15,  8}, { 14,  9}, { 13, 10}, { 12, 11},
    { 11, 12}, { 10, 13}, {  9, 14}, {  8, 15}, {  9, 15}, { 10, 14}, { 11, 13}, { 12, 12},
    { 13, 11}, { 14, 10}, { 15,  9}, { 15, 10}, { 14, 11}, { 13, 12}, { 12, 13}, { 11, 14},
    { 10, 15}, { 11, 15}, { 12, 14}, { 13, 13}, { 14, 12}, { 15, 11}, { 15, 12}, { 14, 13},
    { 13, 14}, { 12, 15}, { 13, 15}, { 14, 14}, { 15, 13}, { 15, 14}, { 14, 15}, { 15, 15}
};

/* ---------------------------------------------------------------------------
 */
static const int16_t tab_scan_1x4[4][2] = {
    { 0, 0 }, { 1, 0 }, { 2, 0 }, { 3, 0 },
};

/* ---------------------------------------------------------------------------
 */
static const int16_t tab_scan_4x1[4][2] = {
    { 0, 0 }, { 0, 1 }, { 0, 2 }, { 0, 3 },
};

static const int16_t tab_scan_2x8[16][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 }, { 3, 1 },
    { 4, 0 }, { 5, 0 }, { 4, 1 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 }, { 7, 1 }
};

static const int16_t tab_scan_8x2[16][2] = {
    { 0, 0 }, { 1, 0 },
    { 0, 1 }, { 0, 2 },
    { 1, 1 }, { 1, 2 },
    { 0, 3 }, { 0, 4 },
    { 1, 3 }, { 1, 4 },
    { 0, 5 }, { 0, 6 },
    { 1, 5 }, { 1, 6 },
    { 0, 7 }, { 1, 7 }
};

static const int16_t tab_scan_4x16[64][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2},
    {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2},
    {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2},
    {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2},
    {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2},
    {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2},
    { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2},
    { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2},
    { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3}
};

static const int16_t tab_scan_16x4[64][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2},
    {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2},
    {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6},
    {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6},
    {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10},
    {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10},
    {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14},
    {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14},
    {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15}
};

static const int16_t tab_scan_8x32[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 16,  0}, { 17,  0}, { 16,  1}, { 16,  2}, { 17,  1}, { 18,  0}, { 19,  0}, { 18,  1},
    { 17,  2}, { 16,  3}, { 17,  3}, { 18,  2}, { 19,  1}, { 19,  2}, { 18,  3}, { 19,  3},
    { 20,  0}, { 21,  0}, { 20,  1}, { 20,  2}, { 21,  1}, { 22,  0}, { 23,  0}, { 22,  1},
    { 21,  2}, { 20,  3}, { 21,  3}, { 22,  2}, { 23,  1}, { 23,  2}, { 22,  3}, { 23,  3},
    { 16,  4}, { 17,  4}, { 16,  5}, { 16,  6}, { 17,  5}, { 18,  4}, { 19,  4}, { 18,  5},
    { 17,  6}, { 16,  7}, { 17,  7}, { 18,  6}, { 19,  5}, { 19,  6}, { 18,  7}, { 19,  7},
    { 20,  4}, { 21,  4}, { 20,  5}, { 20,  6}, { 21,  5}, { 22,  4}, { 23,  4}, { 22,  5},
    { 21,  6}, { 20,  7}, { 21,  7}, { 22,  6}, { 23,  5}, { 23,  6}, { 22,  7}, { 23,  7},
    { 24,  0}, { 25,  0}, { 24,  1}, { 24,  2}, { 25,  1}, { 26,  0}, { 27,  0}, { 26,  1},
    { 25,  2}, { 24,  3}, { 25,  3}, { 26,  2}, { 27,  1}, { 27,  2}, { 26,  3}, { 27,  3},
    { 28,  0}, { 29,  0}, { 28,  1}, { 28,  2}, { 29,  1}, { 30,  0}, { 31,  0}, { 30,  1},
    { 29,  2}, { 28,  3}, { 29,  3}, { 30,  2}, { 31,  1}, { 31,  2}, { 30,  3}, { 31,  3},
    { 24,  4}, { 25,  4}, { 24,  5}, { 24,  6}, { 25,  5}, { 26,  4}, { 27,  4}, { 26,  5},
    { 25,  6}, { 24,  7}, { 25,  7}, { 26,  6}, { 27,  5}, { 27,  6}, { 26,  7}, { 27,  7},
    { 28,  4}, { 29,  4}, { 28,  5}, { 28,  6}, { 29,  5}, { 30,  4}, { 31,  4}, { 30,  5},
    { 29,  6}, { 28,  7}, { 29,  7}, { 30,  6}, { 31,  5}, { 31,  6}, { 30,  7}, { 31,  7}
};

static const int16_t tab_scan_32x8[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  0, 16}, {  1, 16}, {  0, 17}, {  0, 18}, {  1, 17}, {  2, 16}, {  3, 16}, {  2, 17},
    {  1, 18}, {  0, 19}, {  1, 19}, {  2, 18}, {  3, 17}, {  3, 18}, {  2, 19}, {  3, 19},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  4, 16}, {  5, 16}, {  4, 17}, {  4, 18}, {  5, 17}, {  6, 16}, {  7, 16}, {  6, 17},
    {  5, 18}, {  4, 19}, {  5, 19}, {  6, 18}, {  7, 17}, {  7, 18}, {  6, 19}, {  7, 19},
    {  0, 20}, {  1, 20}, {  0, 21}, {  0, 22}, {  1, 21}, {  2, 20}, {  3, 20}, {  2, 21},
    {  1, 22}, {  0, 23}, {  1, 23}, {  2, 22}, {  3, 21}, {  3, 22}, {  2, 23}, {  3, 23},
    {  0, 24}, {  1, 24}, {  0, 25}, {  0, 26}, {  1, 25}, {  2, 24}, {  3, 24}, {  2, 25},
    {  1, 26}, {  0, 27}, {  1, 27}, {  2, 26}, {  3, 25}, {  3, 26}, {  2, 27}, {  3, 27},
    {  4, 20}, {  5, 20}, {  4, 21}, {  4, 22}, {  5, 21}, {  6, 20}, {  7, 20}, {  6, 21},
    {  5, 22}, {  4, 23}, {  5, 23}, {  6, 22}, {  7, 21}, {  7, 22}, {  6, 23}, {  7, 23},
    {  4, 24}, {  5, 24}, {  4, 25}, {  4, 26}, {  5, 25}, {  6, 24}, {  7, 24}, {  6, 25},
    {  5, 26}, {  4, 27}, {  5, 27}, {  6, 26}, {  7, 25}, {  7, 26}, {  6, 27}, {  7, 27},
    {  0, 28}, {  1, 28}, {  0, 29}, {  0, 30}, {  1, 29}, {  2, 28}, {  3, 28}, {  2, 29},
    {  1, 30}, {  0, 31}, {  1, 31}, {  2, 30}, {  3, 29}, {  3, 30}, {  2, 31}, {  3, 31},
    {  4, 28}, {  5, 28}, {  4, 29}, {  4, 30}, {  5, 29}, {  6, 28}, {  7, 28}, {  6, 29},
    {  5, 30}, {  4, 31}, {  5, 31}, {  6, 30}, {  7, 29}, {  7, 30}, {  6, 31}, {  7, 31}
};

static const int16_t tab_scan_cg_8x8[64][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 1, 3 }, { 2, 2 }, { 3, 1 }, { 3, 2 }, { 2, 3 }, { 3, 3 },
    { 4, 0 }, { 5, 0 }, { 4, 1 }, { 4, 2 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 },
    { 5, 2 }, { 4, 3 }, { 5, 3 }, { 6, 2 }, { 7, 1 }, { 7, 2 }, { 6, 3 }, { 7, 3 },
    { 0, 4 }, { 1, 4 }, { 0, 5 }, { 0, 6 }, { 1, 5 }, { 2, 4 }, { 3, 4 }, { 2, 5 },
    { 1, 6 }, { 0, 7 }, { 1, 7 }, { 2, 6 }, { 3, 5 }, { 3, 6 }, { 2, 7 }, { 3, 7 },
    { 4, 4 }, { 5, 4 }, { 4, 5 }, { 4, 6 }, { 5, 5 }, { 6, 4 }, { 7, 4 }, { 6, 5 },
    { 5, 6 }, { 4, 7 }, { 5, 7 }, { 6, 6 }, { 7, 5 }, { 7, 6 }, { 6, 7 }, { 7, 7 }
};

static const int16_t tab_scan_cg_16x16[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  8,  8}, {  9,  8}, {  8,  9}, {  8, 10}, {  9,  9}, { 10,  8}, { 11,  8}, { 10,  9},
    {  9, 10}, {  8, 11}, {  9, 11}, { 10, 10}, { 11,  9}, { 11, 10}, { 10, 11}, { 11, 11},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 12,  8}, { 13,  8}, { 12,  9}, { 12, 10}, { 13,  9}, { 14,  8}, { 15,  8}, { 14,  9},
    { 13, 10}, { 12, 11}, { 13, 11}, { 14, 10}, { 15,  9}, { 15, 10}, { 14, 11}, { 15, 11},
    {  8, 12}, {  9, 12}, {  8, 13}, {  8, 14}, {  9, 13}, { 10, 12}, { 11, 12}, { 10, 13},
    {  9, 14}, {  8, 15}, {  9, 15}, { 10, 14}, { 11, 13}, { 11, 14}, { 10, 15}, { 11, 15},
    { 12, 12}, { 13, 12}, { 12, 13}, { 12, 14}, { 13, 13}, { 14, 12}, { 15, 12}, { 14, 13},
    { 13, 14}, { 12, 15}, { 13, 15}, { 14, 14}, { 15, 13}, { 15, 14}, { 14, 15}, { 15, 15}
};

static const int16_t tab_scan_cg_32x32[1024][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  0, 16}, {  1, 16}, {  0, 17}, {  0, 18}, {  1, 17}, {  2, 16}, {  3, 16}, {  2, 17},
    {  1, 18}, {  0, 19}, {  1, 19}, {  2, 18}, {  3, 17}, {  3, 18}, {  2, 19}, {  3, 19},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  8,  8}, {  9,  8}, {  8,  9}, {  8, 10}, {  9,  9}, { 10,  8}, { 11,  8}, { 10,  9},
    {  9, 10}, {  8, 11}, {  9, 11}, { 10, 10}, { 11,  9}, { 11, 10}, { 10, 11}, { 11, 11},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 16,  0}, { 17,  0}, { 16,  1}, { 16,  2}, { 17,  1}, { 18,  0}, { 19,  0}, { 18,  1},
    { 17,  2}, { 16,  3}, { 17,  3}, { 18,  2}, { 19,  1}, { 19,  2}, { 18,  3}, { 19,  3},
    { 20,  0}, { 21,  0}, { 20,  1}, { 20,  2}, { 21,  1}, { 22,  0}, { 23,  0}, { 22,  1},
    { 21,  2}, { 20,  3}, { 21,  3}, { 22,  2}, { 23,  1}, { 23,  2}, { 22,  3}, { 23,  3},
    { 16,  4}, { 17,  4}, { 16,  5}, { 16,  6}, { 17,  5}, { 18,  4}, { 19,  4}, { 18,  5},
    { 17,  6}, { 16,  7}, { 17,  7}, { 18,  6}, { 19,  5}, { 19,  6}, { 18,  7}, { 19,  7},
    { 12,  8}, { 13,  8}, { 12,  9}, { 12, 10}, { 13,  9}, { 14,  8}, { 15,  8}, { 14,  9},
    { 13, 10}, { 12, 11}, { 13, 11}, { 14, 10}, { 15,  9}, { 15, 10}, { 14, 11}, { 15, 11},
    {  8, 12}, {  9, 12}, {  8, 13}, {  8, 14}, {  9, 13}, { 10, 12}, { 11, 12}, { 10, 13},
    {  9, 14}, {  8, 15}, {  9, 15}, { 10, 14}, { 11, 13}, { 11, 14}, { 10, 15}, { 11, 15},
    {  4, 16}, {  5, 16}, {  4, 17}, {  4, 18}, {  5, 17}, {  6, 16}, {  7, 16}, {  6, 17},
    {  5, 18}, {  4, 19}, {  5, 19}, {  6, 18}, {  7, 17}, {  7, 18}, {  6, 19}, {  7, 19},
    {  0, 20}, {  1, 20}, {  0, 21}, {  0, 22}, {  1, 21}, {  2, 20}, {  3, 20}, {  2, 21},
    {  1, 22}, {  0, 23}, {  1, 23}, {  2, 22}, {  3, 21}, {  3, 22}, {  2, 23}, {  3, 23},
    {  0, 24}, {  1, 24}, {  0, 25}, {  0, 26}, {  1, 25}, {  2, 24}, {  3, 24}, {  2, 25},
    {  1, 26}, {  0, 27}, {  1, 27}, {  2, 26}, {  3, 25}, {  3, 26}, {  2, 27}, {  3, 27},
    {  4, 20}, {  5, 20}, {  4, 21}, {  4, 22}, {  5, 21}, {  6, 20}, {  7, 20}, {  6, 21},
    {  5, 22}, {  4, 23}, {  5, 23}, {  6, 22}, {  7, 21}, {  7, 22}, {  6, 23}, {  7, 23},
    {  8, 16}, {  9, 16}, {  8, 17}, {  8, 18}, {  9, 17}, { 10, 16}, { 11, 16}, { 10, 17},
    {  9, 18}, {  8, 19}, {  9, 19}, { 10, 18}, { 11, 17}, { 11, 18}, { 10, 19}, { 11, 19},
    { 12, 12}, { 13, 12}, { 12, 13}, { 12, 14}, { 13, 13}, { 14, 12}, { 15, 12}, { 14, 13},
    { 13, 14}, { 12, 15}, { 13, 15}, { 14, 14}, { 15, 13}, { 15, 14}, { 14, 15}, { 15, 15},
    { 16,  8}, { 17,  8}, { 16,  9}, { 16, 10}, { 17,  9}, { 18,  8}, { 19,  8}, { 18,  9},
    { 17, 10}, { 16, 11}, { 17, 11}, { 18, 10}, { 19,  9}, { 19, 10}, { 18, 11}, { 19, 11},
    { 20,  4}, { 21,  4}, { 20,  5}, { 20,  6}, { 21,  5}, { 22,  4}, { 23,  4}, { 22,  5},
    { 21,  6}, { 20,  7}, { 21,  7}, { 22,  6}, { 23,  5}, { 23,  6}, { 22,  7}, { 23,  7},
    { 24,  0}, { 25,  0}, { 24,  1}, { 24,  2}, { 25,  1}, { 26,  0}, { 27,  0}, { 26,  1},
    { 25,  2}, { 24,  3}, { 25,  3}, { 26,  2}, { 27,  1}, { 27,  2}, { 26,  3}, { 27,  3},
    { 28,  0}, { 29,  0}, { 28,  1}, { 28,  2}, { 29,  1}, { 30,  0}, { 31,  0}, { 30,  1},
    { 29,  2}, { 28,  3}, { 29,  3}, { 30,  2}, { 31,  1}, { 31,  2}, { 30,  3}, { 31,  3},
    { 24,  4}, { 25,  4}, { 24,  5}, { 24,  6}, { 25,  5}, { 26,  4}, { 27,  4}, { 26,  5},
    { 25,  6}, { 24,  7}, { 25,  7}, { 26,  6}, { 27,  5}, { 27,  6}, { 26,  7}, { 27,  7},
    { 20,  8}, { 21,  8}, { 20,  9}, { 20, 10}, { 21,  9}, { 22,  8}, { 23,  8}, { 22,  9},
    { 21, 10}, { 20, 11}, { 21, 11}, { 22, 10}, { 23,  9}, { 23, 10}, { 22, 11}, { 23, 11},
    { 16, 12}, { 17, 12}, { 16, 13}, { 16, 14}, { 17, 13}, { 18, 12}, { 19, 12}, { 18, 13},
    { 17, 14}, { 16, 15}, { 17, 15}, { 18, 14}, { 19, 13}, { 19, 14}, { 18, 15}, { 19, 15},
    { 12, 16}, { 13, 16}, { 12, 17}, { 12, 18}, { 13, 17}, { 14, 16}, { 15, 16}, { 14, 17},
    { 13, 18}, { 12, 19}, { 13, 19}, { 14, 18}, { 15, 17}, { 15, 18}, { 14, 19}, { 15, 19},
    {  8, 20}, {  9, 20}, {  8, 21}, {  8, 22}, {  9, 21}, { 10, 20}, { 11, 20}, { 10, 21},
    {  9, 22}, {  8, 23}, {  9, 23}, { 10, 22}, { 11, 21}, { 11, 22}, { 10, 23}, { 11, 23},
    {  4, 24}, {  5, 24}, {  4, 25}, {  4, 26}, {  5, 25}, {  6, 24}, {  7, 24}, {  6, 25},
    {  5, 26}, {  4, 27}, {  5, 27}, {  6, 26}, {  7, 25}, {  7, 26}, {  6, 27}, {  7, 27},
    {  0, 28}, {  1, 28}, {  0, 29}, {  0, 30}, {  1, 29}, {  2, 28}, {  3, 28}, {  2, 29},
    {  1, 30}, {  0, 31}, {  1, 31}, {  2, 30}, {  3, 29}, {  3, 30}, {  2, 31}, {  3, 31},
    {  4, 28}, {  5, 28}, {  4, 29}, {  4, 30}, {  5, 29}, {  6, 28}, {  7, 28}, {  6, 29},
    {  5, 30}, {  4, 31}, {  5, 31}, {  6, 30}, {  7, 29}, {  7, 30}, {  6, 31}, {  7, 31},
    {  8, 24}, {  9, 24}, {  8, 25}, {  8, 26}, {  9, 25}, { 10, 24}, { 11, 24}, { 10, 25},
    {  9, 26}, {  8, 27}, {  9, 27}, { 10, 26}, { 11, 25}, { 11, 26}, { 10, 27}, { 11, 27},
    { 12, 20}, { 13, 20}, { 12, 21}, { 12, 22}, { 13, 21}, { 14, 20}, { 15, 20}, { 14, 21},
    { 13, 22}, { 12, 23}, { 13, 23}, { 14, 22}, { 15, 21}, { 15, 22}, { 14, 23}, { 15, 23},
    { 16, 16}, { 17, 16}, { 16, 17}, { 16, 18}, { 17, 17}, { 18, 16}, { 19, 16}, { 18, 17},
    { 17, 18}, { 16, 19}, { 17, 19}, { 18, 18}, { 19, 17}, { 19, 18}, { 18, 19}, { 19, 19},
    { 20, 12}, { 21, 12}, { 20, 13}, { 20, 14}, { 21, 13}, { 22, 12}, { 23, 12}, { 22, 13},
    { 21, 14}, { 20, 15}, { 21, 15}, { 22, 14}, { 23, 13}, { 23, 14}, { 22, 15}, { 23, 15},
    { 24,  8}, { 25,  8}, { 24,  9}, { 24, 10}, { 25,  9}, { 26,  8}, { 27,  8}, { 26,  9},
    { 25, 10}, { 24, 11}, { 25, 11}, { 26, 10}, { 27,  9}, { 27, 10}, { 26, 11}, { 27, 11},
    { 28,  4}, { 29,  4}, { 28,  5}, { 28,  6}, { 29,  5}, { 30,  4}, { 31,  4}, { 30,  5},
    { 29,  6}, { 28,  7}, { 29,  7}, { 30,  6}, { 31,  5}, { 31,  6}, { 30,  7}, { 31,  7},
    { 28,  8}, { 29,  8}, { 28,  9}, { 28, 10}, { 29,  9}, { 30,  8}, { 31,  8}, { 30,  9},
    { 29, 10}, { 28, 11}, { 29, 11}, { 30, 10}, { 31,  9}, { 31, 10}, { 30, 11}, { 31, 11},
    { 24, 12}, { 25, 12}, { 24, 13}, { 24, 14}, { 25, 13}, { 26, 12}, { 27, 12}, { 26, 13},
    { 25, 14}, { 24, 15}, { 25, 15}, { 26, 14}, { 27, 13}, { 27, 14}, { 26, 15}, { 27, 15},
    { 20, 16}, { 21, 16}, { 20, 17}, { 20, 18}, { 21, 17}, { 22, 16}, { 23, 16}, { 22, 17},
    { 21, 18}, { 20, 19}, { 21, 19}, { 22, 18}, { 23, 17}, { 23, 18}, { 22, 19}, { 23, 19},
    { 16, 20}, { 17, 20}, { 16, 21}, { 16, 22}, { 17, 21}, { 18, 20}, { 19, 20}, { 18, 21},
    { 17, 22}, { 16, 23}, { 17, 23}, { 18, 22}, { 19, 21}, { 19, 22}, { 18, 23}, { 19, 23},
    { 12, 24}, { 13, 24}, { 12, 25}, { 12, 26}, { 13, 25}, { 14, 24}, { 15, 24}, { 14, 25},
    { 13, 26}, { 12, 27}, { 13, 27}, { 14, 26}, { 15, 25}, { 15, 26}, { 14, 27}, { 15, 27},
    {  8, 28}, {  9, 28}, {  8, 29}, {  8, 30}, {  9, 29}, { 10, 28}, { 11, 28}, { 10, 29},
    {  9, 30}, {  8, 31}, {  9, 31}, { 10, 30}, { 11, 29}, { 11, 30}, { 10, 31}, { 11, 31},
    { 12, 28}, { 13, 28}, { 12, 29}, { 12, 30}, { 13, 29}, { 14, 28}, { 15, 28}, { 14, 29},
    { 13, 30}, { 12, 31}, { 13, 31}, { 14, 30}, { 15, 29}, { 15, 30}, { 14, 31}, { 15, 31},
    { 16, 24}, { 17, 24}, { 16, 25}, { 16, 26}, { 17, 25}, { 18, 24}, { 19, 24}, { 18, 25},
    { 17, 26}, { 16, 27}, { 17, 27}, { 18, 26}, { 19, 25}, { 19, 26}, { 18, 27}, { 19, 27},
    { 20, 20}, { 21, 20}, { 20, 21}, { 20, 22}, { 21, 21}, { 22, 20}, { 23, 20}, { 22, 21},
    { 21, 22}, { 20, 23}, { 21, 23}, { 22, 22}, { 23, 21}, { 23, 22}, { 22, 23}, { 23, 23},
    { 24, 16}, { 25, 16}, { 24, 17}, { 24, 18}, { 25, 17}, { 26, 16}, { 27, 16}, { 26, 17},
    { 25, 18}, { 24, 19}, { 25, 19}, { 26, 18}, { 27, 17}, { 27, 18}, { 26, 19}, { 27, 19},
    { 28, 12}, { 29, 12}, { 28, 13}, { 28, 14}, { 29, 13}, { 30, 12}, { 31, 12}, { 30, 13},
    { 29, 14}, { 28, 15}, { 29, 15}, { 30, 14}, { 31, 13}, { 31, 14}, { 30, 15}, { 31, 15},
    { 28, 16}, { 29, 16}, { 28, 17}, { 28, 18}, { 29, 17}, { 30, 16}, { 31, 16}, { 30, 17},
    { 29, 18}, { 28, 19}, { 29, 19}, { 30, 18}, { 31, 17}, { 31, 18}, { 30, 19}, { 31, 19},
    { 24, 20}, { 25, 20}, { 24, 21}, { 24, 22}, { 25, 21}, { 26, 20}, { 27, 20}, { 26, 21},
    { 25, 22}, { 24, 23}, { 25, 23}, { 26, 22}, { 27, 21}, { 27, 22}, { 26, 23}, { 27, 23},
    { 20, 24}, { 21, 24}, { 20, 25}, { 20, 26}, { 21, 25}, { 22, 24}, { 23, 24}, { 22, 25},
    { 21, 26}, { 20, 27}, { 21, 27}, { 22, 26}, { 23, 25}, { 23, 26}, { 22, 27}, { 23, 27},
    { 16, 28}, { 17, 28}, { 16, 29}, { 16, 30}, { 17, 29}, { 18, 28}, { 19, 28}, { 18, 29},
    { 17, 30}, { 16, 31}, { 17, 31}, { 18, 30}, { 19, 29}, { 19, 30}, { 18, 31}, { 19, 31},
    { 20, 28}, { 21, 28}, { 20, 29}, { 20, 30}, { 21, 29}, { 22, 28}, { 23, 28}, { 22, 29},
    { 21, 30}, { 20, 31}, { 21, 31}, { 22, 30}, { 23, 29}, { 23, 30}, { 22, 31}, { 23, 31},
    { 24, 24}, { 25, 24}, { 24, 25}, { 24, 26}, { 25, 25}, { 26, 24}, { 27, 24}, { 26, 25},
    { 25, 26}, { 24, 27}, { 25, 27}, { 26, 26}, { 27, 25}, { 27, 26}, { 26, 27}, { 27, 27},
    { 28, 20}, { 29, 20}, { 28, 21}, { 28, 22}, { 29, 21}, { 30, 20}, { 31, 20}, { 30, 21},
    { 29, 22}, { 28, 23}, { 29, 23}, { 30, 22}, { 31, 21}, { 31, 22}, { 30, 23}, { 31, 23},
    { 28, 24}, { 29, 24}, { 28, 25}, { 28, 26}, { 29, 25}, { 30, 24}, { 31, 24}, { 30, 25},
    { 29, 26}, { 28, 27}, { 29, 27}, { 30, 26}, { 31, 25}, { 31, 26}, { 30, 27}, { 31, 27},
    { 24, 28}, { 25, 28}, { 24, 29}, { 24, 30}, { 25, 29}, { 26, 28}, { 27, 28}, { 26, 29},
    { 25, 30}, { 24, 31}, { 25, 31}, { 26, 30}, { 27, 29}, { 27, 30}, { 26, 31}, { 27, 31},
    { 28, 28}, { 29, 28}, { 28, 29}, { 28, 30}, { 29, 29}, { 30, 28}, { 31, 28}, { 30, 29},
    { 29, 30}, { 28, 31}, { 29, 31}, { 30, 30}, { 31, 29}, { 31, 30}, { 30, 31}, { 31, 31}
};

/* ---------------------------------------------------------------------------
 * ϵɨ
 */
static const int16_t(*tab_scan_coeff[4][4])[2] = {
    /* 4x4 */
    {tab_scan_4x4, NULL, NULL, tab_scan_4x4},
    /* 8x8,  16x4,  4x16 */
    {tab_scan_cg_8x8, tab_scan_4x16, tab_scan_16x4, tab_scan_cg_8x8},
    /* 16x16, 32x8, 8x32 */
    {tab_scan_cg_16x16, tab_scan_8x32, tab_scan_32x8, tab_scan_cg_16x16},
    /* 32x32, 64x16, 16x64 */
    {tab_scan_cg_32x32, NULL, NULL, tab_scan_cg_32x32},
};

/* ---------------------------------------------------------------------------
 * CGɨ˳
 */
static const int16_t(*tab_scan_cg[4][4])[2] = {
    /* 4x4 */
    {tab_scan_2x2, NULL, NULL, tab_scan_2x2},
    /* 8x8,  16x4,  4x16 */
    {tab_scan_2x2, tab_scan_1x4, tab_scan_4x1, tab_scan_2x2},
    /* 16x16, 32x8, 8x32 */
    {tab_scan_4x4, tab_scan_2x8, tab_scan_8x2, tab_scan_4x4},
    /* 32x32, 64x16, 16x64 */
    {tab_scan_8x8, NULL, NULL, tab_scan_8x8},
};

#ifdef __cplusplus
}
#endif
#endif  // DAVS2_SCAN_TAB_H
