#-*- coding: utf-8 -*-
from gi.repository import Gtk
import logging
import os.path

from foobnix.gui.service.path_service import get_foobnix_resourse_path_by_name
from foobnix.util.const import ICON_FOOBNIX
from foobnix.util.file_utils import get_file_extension



def m3u_writer(name, current_folder, paths):
    try:
        absolute = False
        for path in paths:
            if not path.startswith(current_folder):
                absolute = True
                break

        if not absolute:
            absolute = message_on_save()
        if not absolute:
            paths = [path.lstrip(current_folder+'/').replace("/", "\\")+'\r\n' for path in paths]
        else:
            paths = [path +'\r\n' for path in paths]

        m3u_file = open(name, "w")
        m3u_file.write("# This file is generated by Foobnix - the best linux player\r\n")
        map(m3u_file.write, paths)
    except UnboundLocalError:
        logging.warn("You try to save empty playlist")

def is_m3u(path):
    extension = get_file_extension(path)
    if extension and extension.lower() in [".m3u", ".m3u8"]:
        return True
    return False

def message_on_save(absolute=True):
    dialog = Gtk.Dialog(buttons=("Yes", Gtk.ResponseType.OK, "No", Gtk.ResponseType.REJECT))
    dialog.set_title(_("Choose window"))
    dialog.set_border_width(5)
    dialog.set_icon_from_file(get_foobnix_resourse_path_by_name(ICON_FOOBNIX))
    label = Gtk.Label.new(None)
    label.set_markup(_("""<big><b>\t\t\t\t\t\t\t\tAttention!\n</b></big>\t\
The relative location of the \
playlist and music files allows you to save a relative
paths to the files in your playlist. This will allow to carry along the playlist with the
files (only together) at any place of the computer or even at another computer.
Also, it will make library compatible with OS Windows. However, in this case you can't
change the relative location of the playlist file  and music files.
\tAbsolute file paths make it impossible to transfer a playlist on other computer
or use it in OS Windows, but it will put the library anywhere in the file system sepa-
rate from the music files (the library will be working).\n
\tDo you want to save the playlist with relative paths?\n"""))
    label.show()
    dialog.vbox.pack_start(label, False, False, 0)
    dialog.vbox.show()
    dialog.show_all()
    response = dialog.run()
    if response == Gtk.ResponseType.OK:
        dialog.destroy()
        return False
    else:
        dialog.destroy()
        return True

"""message_on_save(absolute=True)
Gtk.main()"""
