# -*- coding: ISO-8859-1 -*-
# generated by wxGlade 0.3.5.1 on Fri Apr 15 17:02:14 2005

# Papagayo-NG, a lip-sync tool for use with several different animation suites
# Original Copyright (C) 2005 Mike Clifton
# Contact information at http://www.lostmarble.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

# import os

from PySide2 import QtGui, QtCore, QtWidgets

from utilities import *


class MouthView(QtWidgets.QGraphicsView):
    def __init__(self, parent=None):
        super(MouthView, self).__init__(parent)
        self.setScene(QtWidgets.QGraphicsScene(self))
        self.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        self.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)
        # Other initialization
        self.doc = None
        self.cur_frame = 0
        self.old_frame = 0
        self.current_phoneme = "rest"
        self.current_mouth = None
        self.mouths = {}
        self.load_mouths()

    def draw_me(self, dc=None):
        if (self.doc is not None) and (self.doc.sound is not None) and (self.doc.sound.is_playing()):
            if self.doc.current_voice is not None:
                phoneme = self.doc.current_voice.get_phoneme_at_frame(self.cur_frame)
            else:
                phoneme = "rest"
            if phoneme == self.current_phoneme:
                return
            else:
                self.current_phoneme = phoneme
        else:
            self.current_phoneme = "rest"
        if not self.current_mouth:
            self.current_mouth = list(self.mouths)[0]
        if self.current_mouth in self.mouths.keys():
            if self.current_phoneme in self.mouths[self.current_mouth].keys():
                bitmap = self.mouths[self.current_mouth][self.current_phoneme]
            else:
                bitmap = self.mouths[self.current_mouth]["rest"]
        else:
            bitmap = self.mouths[list(self.mouths)[0]]["rest"]
        self.scene().clear()
        self.scene().addPixmap(bitmap)
        if self.current_phoneme not in self.mouths[self.current_mouth].keys():
            self.scene().addText("Missing Mouth: {0}".format(self.current_phoneme), QtGui.QFont("Swiss", 14))
        self.fitInView(self.x(), self.y(), self.width(), self.height())

    def set_frame(self, frame):
        self.old_frame = self.cur_frame
        self.cur_frame = frame
        self.draw_me()

    def set_document(self, doc):
        self.doc = doc
        self.draw_me()

    def process_mouth_dir(self, dir_name, names, supported_imagetypes):
        has_images = False
        for files in names:
            files = files.lower()
            if files.split(".")[-1] in supported_imagetypes:
                has_images = True
        if not has_images:
            return
        print(os.path.normpath(dir_name), names)
        self.add_mouth(os.path.normpath(dir_name), names)

    def load_mouths(self):
        # print(os.path.join(get_main_dir(), "rsrc", "mouths"))
        supported_imagetypes = QtGui.QImageReader.supportedImageFormats()
        for directory, dir_names, file_names in os.walk(os.path.join(get_main_dir(), "rsrc", "mouths")):
            self.process_mouth_dir(directory, file_names, supported_imagetypes)

    def add_mouth(self, dir_name, names):
        bitmaps = {}
        for files in names:
            if ".svn" in files:
                continue
            path = os.path.normpath(os.path.join(dir_name, files))
            bitmaps[files.split('.')[0]] = QtGui.QPixmap(path)
        self.mouths[os.path.basename(dir_name)] = bitmaps
        if self.current_mouth is None:
            self.current_mouth = os.path.basename(dir_name)

# end of class MouthView
