/* ----------------------------------------------------------------

SmillaEnlarger  -  resize, especially magnify bitmaps in high quality
    ColorEnlargerClass.cpp: the enlarging algorithm

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#include <iostream>
#include <math.h>
#include <stdio.h> 
#include "ConstDefs.h"
#include "Array.h"
#include "Array4D.h"
#include "Array_IO.h"
#include "ColorEnlargerClass.h"
#include "EnlargerTemplate.h"
#include "EnlargerTemplateDefs.h"

using namespace std;

//template class BasicEnlarger<Point4>;  // explicit instantiation

ColorEnlarger::ColorEnlarger( ArrayARGB *srcArray, float scaleF)
   : BasicEnlarger<Point4> ( srcArray->SizeX(), srcArray->SizeY(), scaleF )
{
   src = srcArray;
   dst = 0;
}

// Enlarge the clip-rect
void ColorEnlarger::Enlarge( int x0, int y0, ArrayARGB *dstArr ) {
   int dstX,dstY;

   dst = dstArr;
   SetDestClip( x0, y0, x0 + dstArr->SizeX(), y0 + dstArr->SizeY() );
   tTotal.Clear();
   t1.Clear();
   t2.Clear();
   tTotal.Start();

   for( dstY = ClipY0(); dstY < ClipY1(); dstY += blockLen) {
      cout<<"["<<flush;
      for( dstX=ClipX0(); dstX<ClipX1(); dstX += blockLen) {
         BlockBegin( dstX, dstY );
         ReadSrcBlock();
         SrcBlockReduceNoise();
         SrcBlockSharpen();
         EnlargeBlock();
         WriteDstBlock();
         cout<<".";cout.flush();
      }
      cout<<"]\n"<<flush;
   }

   tTotal.Stop();
   cout<<" Enlarge: total Time: ..............."<<tTotal.Get()<<"\n"<<flush;
   cout<<"    Timer 1: ........................"<<t1.Get()<<"\n"<<flush;
   cout<<"    Timer 2: ........................"<<t2.Get()<<"\n"<<flush;
}

void ColorEnlarger::ReadSrcBlock( void ) {
   // copy data, pos outside src is ok, filled with margin-data
   src->CopyToArray( CurrentSrcBlock(), SrcBlockEdgeX(), SrcBlockEdgeY() );
}

void ColorEnlarger::WriteDstBlock( void ) {
   int dstBX, dstBY;
 
   for( dstBY = DstMinBY(); dstBY < DstMaxBY(); dstBY++ ) {
      for( dstBX = DstMinBX(); dstBX < DstMaxBX(); dstBX++ ) {
         int dstCX =  dstBX + DstBlockEdgeX() - ClipX0();
         int dstCY =  dstBY + DstBlockEdgeY() - ClipY0();
         dst->Set( dstCX, dstCY, CurrentDstBlock()->Get( dstBX, dstBY ) );
      }
   }
}

//
//-----------------------------------------------------------------------
//
