/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha512_mgf1sha1_vectors_h__
#define rsa_oaep_2048_sha512_mgf1sha1_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> priv_key_3{
    0x30, 0x82, 0x04, 0xbc, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
    0x04, 0xa6, 0x30, 0x82, 0x04, 0xa2, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
    0x01, 0x00, 0xc2, 0xc4, 0xa8, 0x60, 0x23, 0x6d, 0x3c, 0x90, 0x96, 0xa0,
    0x76, 0xd6, 0xba, 0x51, 0x07, 0xe0, 0xf7, 0xbd, 0x81, 0xe1, 0xba, 0x91,
    0x6f, 0x73, 0x75, 0x72, 0x4b, 0xd2, 0xb0, 0xb0, 0xb6, 0x39, 0x56, 0x81,
    0x37, 0x15, 0xa3, 0x45, 0x7a, 0xb0, 0x45, 0x8b, 0x71, 0xfb, 0x35, 0xa4,
    0x5b, 0x27, 0xf9, 0xef, 0x7a, 0xc3, 0xe5, 0x79, 0xde, 0xa4, 0x5d, 0xfb,
    0xfd, 0x07, 0x81, 0x9e, 0xd6, 0xb7, 0x02, 0x1a, 0xa5, 0x33, 0x6c, 0x58,
    0x44, 0x2a, 0xad, 0xd9, 0x6c, 0xa9, 0xee, 0x9d, 0x32, 0x47, 0x3e, 0x9d,
    0x92, 0x78, 0x56, 0x2b, 0x4d, 0x10, 0x25, 0x8a, 0xde, 0x6a, 0x98, 0xfb,
    0x1c, 0x7c, 0xfd, 0xc3, 0xb3, 0x71, 0x6e, 0xf5, 0xde, 0xc5, 0x8c, 0xf7,
    0x3b, 0x35, 0x9f, 0x38, 0x95, 0x99, 0xb4, 0xb5, 0x86, 0x5a, 0x98, 0x63,
    0x51, 0x9e, 0xb0, 0x01, 0xc3, 0x24, 0x38, 0x7d, 0xa7, 0x55, 0x45, 0x0d,
    0xb3, 0x41, 0x30, 0x93, 0x60, 0xe3, 0x80, 0x7c, 0x05, 0x65, 0xb8, 0xe2,
    0xc4, 0x4f, 0xbd, 0x5e, 0x6e, 0x8d, 0x04, 0xd0, 0x06, 0xd7, 0xee, 0x76,
    0x8b, 0x8e, 0x84, 0x36, 0x08, 0x2a, 0x90, 0xfa, 0x0e, 0x83, 0x7f, 0x32,
    0xf4, 0x60, 0x87, 0xab, 0x4a, 0x0d, 0x9b, 0xe2, 0x8a, 0xa7, 0xda, 0x17,
    0x94, 0xce, 0xb0, 0x17, 0x2a, 0x7f, 0x50, 0xed, 0x20, 0xf6, 0xdf, 0x64,
    0x1e, 0xfb, 0xcb, 0xfd, 0x2a, 0xac, 0x89, 0x77, 0x5c, 0x76, 0x1a, 0x73,
    0x10, 0x09, 0x3c, 0x67, 0x1c, 0x97, 0x7f, 0xa1, 0x8b, 0x0d, 0x6e, 0x01,
    0xfb, 0x25, 0xf7, 0xa4, 0x32, 0xb4, 0x2c, 0x65, 0x35, 0x97, 0x84, 0xc6,
    0x89, 0x20, 0x57, 0x19, 0xc1, 0xcf, 0x6e, 0x3a, 0x65, 0xda, 0xe2, 0xda,
    0x43, 0x4c, 0x32, 0x6d, 0xde, 0x81, 0xbb, 0x6f, 0xff, 0xfb, 0xdb, 0xf6,
    0xde, 0x5c, 0x16, 0xbb, 0xa7, 0x49, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
    0x82, 0x01, 0x00, 0x0a, 0x5c, 0x27, 0x90, 0xa5, 0x91, 0xc3, 0xec, 0xf4,
    0xf6, 0x28, 0x1c, 0x17, 0xe1, 0x03, 0x88, 0x45, 0xe5, 0x40, 0xa9, 0x5f,
    0x21, 0x29, 0x4a, 0x7c, 0xee, 0xcd, 0x75, 0xb1, 0x8c, 0x54, 0xc5, 0x0c,
    0x02, 0xe7, 0x89, 0x31, 0x1c, 0x1b, 0x00, 0x91, 0x52, 0x6f, 0x87, 0xab,
    0x3c, 0xc8, 0xd4, 0x81, 0x88, 0xe9, 0x80, 0xce, 0x0e, 0x03, 0x77, 0xbe,
    0xc0, 0x0e, 0x9f, 0x7d, 0x97, 0x93, 0x58, 0x3c, 0xb6, 0x6a, 0x1f, 0x28,
    0x1e, 0x31, 0xd2, 0x0b, 0x59, 0x4b, 0x5c, 0x66, 0xa2, 0xd9, 0xef, 0xcc,
    0x36, 0xd9, 0x79, 0xa9, 0x2b, 0xb8, 0x77, 0xa9, 0x67, 0x8f, 0x99, 0x1f,
    0xf6, 0x0b, 0x77, 0xe2, 0x8f, 0xac, 0x55, 0xd6, 0x4f, 0x21, 0xc0, 0x64,
    0x55, 0x2a, 0x43, 0x19, 0xeb, 0x0a, 0x9a, 0x18, 0x70, 0xa7, 0x6a, 0xde,
    0x3c, 0x3a, 0x35, 0x34, 0xab, 0x83, 0x53, 0xc3, 0xe5, 0x7b, 0x27, 0x08,
    0x36, 0x38, 0x59, 0xad, 0x3a, 0x63, 0x37, 0xfc, 0x15, 0xff, 0xb9, 0x09,
    0x80, 0xd9, 0x37, 0x43, 0xf9, 0x72, 0xd7, 0x43, 0xc3, 0xdc, 0x6f, 0xdd,
    0xb4, 0x42, 0x79, 0x07, 0x9a, 0x80, 0x9a, 0xbe, 0xc8, 0x11, 0x3a, 0x6f,
    0x98, 0x7f, 0x71, 0x74, 0x8c, 0x03, 0x6a, 0x4d, 0xaf, 0x35, 0x3b, 0x27,
    0xa8, 0x1e, 0x69, 0x83, 0xd5, 0x6a, 0x2d, 0x65, 0xb7, 0x1b, 0x93, 0x12,
    0x8d, 0x55, 0x69, 0x49, 0x9d, 0x10, 0xad, 0x13, 0x96, 0xf0, 0x94, 0xee,
    0xd7, 0x7c, 0x04, 0x4e, 0x3c, 0xe9, 0xef, 0x82, 0xf0, 0x01, 0x4c, 0x25,
    0xba, 0x69, 0x39, 0x28, 0xc0, 0x0b, 0x50, 0x43, 0xb6, 0x41, 0xb0, 0x16,
    0xe3, 0x56, 0x9b, 0x4b, 0xd8, 0x4d, 0x68, 0x33, 0x72, 0x53, 0x86, 0x71,
    0x30, 0x73, 0x21, 0xc2, 0x5e, 0x59, 0x0f, 0x14, 0xbe, 0xf2, 0x41, 0xe6,
    0xd8, 0xed, 0xf2, 0x4f, 0xf3, 0x98, 0x59, 0x02, 0x81, 0x81, 0x00, 0xe7,
    0x4a, 0x12, 0x47, 0x59, 0xa1, 0x74, 0xde, 0x33, 0x18, 0x59, 0x96, 0xb3,
    0xb4, 0x37, 0xc2, 0x4e, 0xd2, 0x48, 0x20, 0x3d, 0x67, 0x4a, 0x87, 0xbc,
    0xc2, 0xe7, 0x6a, 0x66, 0x7b, 0xe3, 0xf5, 0x4a, 0xc1, 0x5e, 0x8f, 0x04,
    0xe4, 0xc5, 0xe5, 0x40, 0xf4, 0xe1, 0x9f, 0x40, 0x2a, 0x71, 0xd3, 0x7d,
    0x39, 0x75, 0x6d, 0xce, 0xfb, 0xfa, 0xef, 0xb3, 0x80, 0x09, 0x5b, 0x6c,
    0xfb, 0xdf, 0x4d, 0x78, 0xdd, 0x20, 0xcf, 0x08, 0x5a, 0x1f, 0x12, 0x76,
    0x10, 0xe3, 0xb7, 0x10, 0x2c, 0xa6, 0xbd, 0xe1, 0x82, 0x59, 0x41, 0xab,
    0x60, 0x2e, 0x9b, 0x72, 0xc0, 0x8e, 0x45, 0x33, 0xac, 0x50, 0x31, 0x71,
    0x38, 0xe1, 0x0b, 0xf7, 0xed, 0xfe, 0xa3, 0x0f, 0x52, 0xee, 0x91, 0xea,
    0x66, 0x28, 0xc2, 0xcc, 0x65, 0xe7, 0x6b, 0xaf, 0xc0, 0x2e, 0xb9, 0xd2,
    0x1a, 0xb6, 0x6a, 0xd3, 0x74, 0xef, 0x27, 0x02, 0x81, 0x81, 0x00, 0xd7,
    0x93, 0xb4, 0xf5, 0x51, 0x49, 0x21, 0xbf, 0xbc, 0x47, 0xa1, 0xe4, 0x5f,
    0xaa, 0x04, 0x3e, 0xea, 0x03, 0xf0, 0x52, 0xbc, 0xe6, 0x00, 0xec, 0x4f,
    0x5c, 0x62, 0xb0, 0x14, 0xa7, 0xc4, 0x5a, 0xeb, 0x3f, 0x4b, 0xc0, 0x21,
    0x60, 0xe7, 0xb1, 0x2d, 0xee, 0x13, 0x5e, 0x44, 0xb2, 0x27, 0xa3, 0x18,
    0x54, 0xca, 0x83, 0x3a, 0xc7, 0x06, 0xd1, 0x46, 0x70, 0xab, 0x59, 0x32,
    0xa2, 0x69, 0xc9, 0xb6, 0xf9, 0x18, 0x8a, 0xcb, 0x93, 0xe6, 0x98, 0xb4,
    0xa7, 0xdf, 0xf6, 0x5b, 0xb9, 0xc9, 0x63, 0xc2, 0xe0, 0x2b, 0x2c, 0xea,
    0x3f, 0x2d, 0x5c, 0xb2, 0x54, 0xe0, 0x7b, 0x61, 0x67, 0x92, 0x89, 0x6e,
    0x37, 0x55, 0x0c, 0xb3, 0x81, 0x71, 0xc4, 0xc3, 0x2e, 0x0a, 0x65, 0x43,
    0xbb, 0xe6, 0xac, 0xd4, 0xe9, 0x9a, 0xbe, 0xab, 0xa1, 0x34, 0x0a, 0x96,
    0x10, 0x17, 0x41, 0x2b, 0x57, 0xbc, 0x0f, 0x02, 0x81, 0x80, 0x4d, 0xd4,
    0x02, 0x04, 0x9a, 0x67, 0x97, 0x30, 0xf2, 0x16, 0x9e, 0x86, 0xf4, 0x9f,
    0x8f, 0x27, 0xc6, 0x68, 0x42, 0x36, 0xff, 0x12, 0x93, 0xe4, 0xcb, 0x22,
    0xf6, 0xc6, 0x3a, 0x08, 0x34, 0x74, 0x25, 0x1c, 0x9e, 0x9a, 0x17, 0xb6,
    0x77, 0xd5, 0x26, 0x1f, 0x81, 0x10, 0x9a, 0x81, 0xed, 0xdd, 0x91, 0xc4,
    0xd4, 0xfc, 0x07, 0x6b, 0x89, 0x4c, 0x41, 0xa5, 0xb3, 0x00, 0x5d, 0xd2,
    0xff, 0x98, 0x4d, 0x34, 0x73, 0xc6, 0xd6, 0xf3, 0xa4, 0x83, 0x0c, 0xd1,
    0xb0, 0x1e, 0xb8, 0xc5, 0x9d, 0xb2, 0x45, 0x81, 0x1c, 0x51, 0xd9, 0xbe,
    0x3a, 0xd0, 0xba, 0x33, 0x8b, 0x6c, 0x43, 0xf0, 0x16, 0xe8, 0x1c, 0x46,
    0x5c, 0x8c, 0x2f, 0x78, 0x99, 0x77, 0xfb, 0x3f, 0x17, 0xe2, 0x67, 0xf2,
    0xca, 0x82, 0x8a, 0x4f, 0x3c, 0x29, 0x63, 0x71, 0x93, 0x07, 0x9a, 0x68,
    0xbc, 0xbb, 0x83, 0xbe, 0x54, 0x7f, 0x02, 0x81, 0x80, 0x76, 0x7a, 0x35,
    0x2f, 0xc5, 0xd6, 0xbd, 0x77, 0x94, 0xd0, 0x81, 0x86, 0xf3, 0x94, 0x8a,
    0xf4, 0xd0, 0xc4, 0x0d, 0x66, 0x4b, 0x6e, 0xd4, 0xff, 0x0a, 0xb6, 0xa9,
    0x7e, 0x40, 0x3b, 0xdb, 0xcc, 0x64, 0x11, 0xcb, 0x5d, 0xf2, 0x7a, 0x41,
    0x9b, 0xbc, 0xb4, 0x65, 0x6c, 0x9f, 0xb0, 0x91, 0xdc, 0x2e, 0xd9, 0x1a,
    0xdb, 0x78, 0x88, 0x3d, 0x94, 0xf2, 0x73, 0xa5, 0x98, 0x46, 0x1d, 0xc0,
    0xaa, 0x1d, 0xa7, 0x54, 0xf7, 0xa2, 0xde, 0xcc, 0x13, 0x0c, 0xe6, 0x5e,
    0x4e, 0x15, 0x27, 0x4c, 0x29, 0x49, 0xc6, 0xcd, 0xb3, 0xc7, 0xa1, 0xa5,
    0x1a, 0x96, 0xdf, 0xd2, 0xe7, 0xbc, 0x26, 0xa2, 0x00, 0x69, 0xd4, 0x7b,
    0x27, 0x99, 0xd8, 0x00, 0x60, 0xb5, 0x2c, 0x2e, 0x86, 0x6c, 0xed, 0x6d,
    0xdf, 0x7a, 0xbc, 0x50, 0x51, 0x8e, 0x1d, 0xf0, 0x6e, 0x08, 0xff, 0x1a,
    0xe8, 0xb4, 0x1b, 0x69, 0xbd, 0x02, 0x81, 0x80, 0x54, 0x79, 0xdd, 0xa3,
    0x0f, 0xc0, 0x6b, 0x63, 0xcb, 0x5f, 0x77, 0xe2, 0x0b, 0xb2, 0x9d, 0xb7,
    0xee, 0xc7, 0xa6, 0xb3, 0x7a, 0x50, 0x07, 0xf9, 0x65, 0x1a, 0x46, 0xff,
    0xb6, 0x6c, 0x90, 0x16, 0x0b, 0xe5, 0x70, 0x01, 0x45, 0xc6, 0xa0, 0x8d,
    0x97, 0x37, 0xa9, 0x8c, 0x5f, 0x7b, 0xa0, 0xdc, 0xef, 0x39, 0x35, 0x2c,
    0xc5, 0xd8, 0x61, 0x2d, 0x94, 0xfd, 0x02, 0x38, 0x3b, 0x8e, 0x09, 0x31,
    0x15, 0x37, 0x6b, 0x15, 0x4f, 0xa1, 0xce, 0xbd, 0xf9, 0x15, 0xdd, 0xc0,
    0x51, 0xa7, 0x01, 0x7d, 0x67, 0xa2, 0x38, 0xfb, 0x43, 0x76, 0x74, 0x9c,
    0xed, 0x94, 0x71, 0x2b, 0x11, 0x7a, 0x1d, 0x0c, 0xa3, 0x1c, 0xd6, 0x53,
    0xa1, 0x95, 0x5d, 0xd5, 0x47, 0x34, 0x6d, 0x03, 0xb2, 0x1e, 0xb0, 0xad,
    0x3c, 0x12, 0x3f, 0xb8, 0x5e, 0x92, 0xc8, 0xaf, 0x50, 0xa9, 0x85, 0xdb,
    0x10, 0xeb, 0xa7, 0x9b};

const RsaOaepTestVector kRsaOaep2048Sha512Mgf1Sha1WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     1,
     {},
     {0x40, 0x92, 0x25, 0xdd, 0x22, 0x29, 0xd1, 0x1a, 0xcc, 0xb9, 0x98, 0x04,
      0xe4, 0xda, 0x69, 0xfb, 0xcb, 0x86, 0x2d, 0x3a, 0x74, 0xa1, 0xdc, 0xeb,
      0x8f, 0x11, 0x86, 0xd8, 0xd1, 0x3b, 0x15, 0x69, 0xaa, 0x4f, 0xce, 0x51,
      0xaf, 0xf2, 0x73, 0xac, 0xeb, 0x1f, 0x0c, 0x87, 0x5d, 0x87, 0xa9, 0x79,
      0xf9, 0x91, 0x5f, 0xd4, 0x00, 0xa2, 0xeb, 0x17, 0x13, 0xb5, 0xa1, 0xed,
      0x12, 0x9e, 0x6b, 0x0c, 0x7c, 0xa1, 0x4a, 0x61, 0xa0, 0x93, 0x9a, 0x87,
      0xae, 0x88, 0xc5, 0x3e, 0x91, 0xff, 0xdd, 0x63, 0x5f, 0x7d, 0xdd, 0xe6,
      0x18, 0x5d, 0xfe, 0x9b, 0x5b, 0x7b, 0xd7, 0x39, 0xb5, 0x3c, 0x4c, 0x19,
      0x8d, 0xc8, 0x33, 0x3a, 0x36, 0x46, 0x1c, 0x4d, 0x75, 0x07, 0x73, 0xdf,
      0x1c, 0x84, 0xf0, 0x24, 0xe1, 0x8d, 0xc7, 0x8d, 0x09, 0xfb, 0xbc, 0xdc,
      0x4d, 0x12, 0xbb, 0x29, 0x85, 0x4b, 0x2a, 0xe0, 0x4c, 0x1b, 0x8b, 0x14,
      0x1e, 0xba, 0x75, 0x3e, 0xed, 0x9c, 0xd9, 0x0a, 0x5b, 0x66, 0xfe, 0xa3,
      0x76, 0x12, 0xac, 0xa4, 0xc5, 0x5f, 0x65, 0xa8, 0x38, 0x1c, 0x4e, 0xff,
      0x13, 0xc3, 0x7a, 0xe1, 0xf9, 0xed, 0x06, 0x88, 0x51, 0x47, 0x88, 0xba,
      0xbc, 0x8e, 0xe2, 0x7f, 0x8e, 0x76, 0x29, 0x64, 0x95, 0xdf, 0x25, 0x41,
      0x45, 0x33, 0x1a, 0x49, 0xd1, 0x1e, 0x7b, 0xee, 0x5a, 0x83, 0xa3, 0x71,
      0x3d, 0x4b, 0xbd, 0x5a, 0x80, 0x5f, 0xdd, 0x8e, 0x84, 0xba, 0x6a, 0xb8,
      0x69, 0x00, 0x2b, 0x26, 0xe4, 0x0b, 0x36, 0xd1, 0xd6, 0xc1, 0x18, 0x9b,
      0x8c, 0xa1, 0xc6, 0xfe, 0x19, 0x49, 0x7a, 0x80, 0x59, 0x41, 0x4a, 0xbd,
      0xc8, 0x8c, 0xa7, 0x12, 0x52, 0xfa, 0x86, 0x70, 0x5e, 0xc9, 0x6a, 0x78,
      0x99, 0x29, 0x69, 0x25, 0xf8, 0x85, 0xfe, 0x55, 0xc9, 0xc6, 0xd2, 0xcb,
      0xe7, 0xca, 0x85, 0x78},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x7a, 0xb3, 0x51, 0x68, 0xdc, 0x51, 0xcb, 0x7b, 0x3d, 0x8e, 0x5e, 0x3f,
      0x95, 0x68, 0xe5, 0x88, 0xc2, 0x7d, 0xc3, 0x95, 0xe8, 0x25, 0xf9, 0x09,
      0xf3, 0xef, 0x2a, 0x88, 0xc5, 0xef, 0x8e, 0x1e, 0xe4, 0x91, 0x8d, 0xcc,
      0xe7, 0xaa, 0x0c, 0x3a, 0xb6, 0x86, 0x0f, 0x69, 0xde, 0x90, 0xe3, 0x6d,
      0x19, 0x28, 0x4a, 0x15, 0x95, 0x4a, 0x3b, 0xce, 0x2c, 0x95, 0xbb, 0x52,
      0xb1, 0xa5, 0xcc, 0x75, 0x2e, 0x35, 0xa7, 0xe0, 0x8f, 0xc3, 0x27, 0xf2,
      0xa9, 0x5b, 0xa0, 0x5c, 0x47, 0x4c, 0x4a, 0x5e, 0x62, 0x5b, 0x5c, 0x0b,
      0x78, 0x0b, 0x3b, 0xed, 0x96, 0x1e, 0x69, 0xbd, 0xfe, 0x07, 0x3b, 0xc3,
      0x24, 0xa8, 0xdf, 0xeb, 0x37, 0x82, 0x41, 0x31, 0x09, 0xfc, 0xe1, 0xd7,
      0x95, 0xef, 0x01, 0xa8, 0xeb, 0x06, 0x08, 0xea, 0x42, 0x86, 0x6c, 0xa9,
      0x97, 0xb8, 0xcd, 0x3c, 0x7b, 0x84, 0x91, 0x90, 0xe4, 0x2e, 0x84, 0xc3,
      0xd6, 0x0f, 0x93, 0x58, 0x86, 0xdf, 0x8d, 0x3d, 0xff, 0x5c, 0xca, 0x41,
      0x57, 0x15, 0x2e, 0x9e, 0xc9, 0xf9, 0x54, 0xa7, 0xea, 0x7b, 0x1e, 0xc4,
      0xb0, 0xe1, 0xfb, 0xc1, 0x4c, 0xef, 0x0f, 0x3e, 0xd1, 0x6f, 0x1b, 0x01,
      0x3c, 0xef, 0x87, 0x53, 0xe1, 0xf5, 0x49, 0x3e, 0xf7, 0xd0, 0xf7, 0x53,
      0xed, 0x0a, 0x18, 0xae, 0x52, 0x75, 0x45, 0x9d, 0x15, 0xb8, 0x6d, 0xa9,
      0x54, 0x45, 0xdd, 0x65, 0x58, 0x0a, 0x78, 0x93, 0x54, 0x61, 0x6e, 0x9a,
      0x8a, 0x56, 0x72, 0x03, 0x94, 0xa2, 0x2f, 0xf3, 0x0a, 0x01, 0xf3, 0x8b,
      0x17, 0x32, 0x59, 0xa9, 0x82, 0x9b, 0x8a, 0x4d, 0x14, 0x74, 0x73, 0x26,
      0x59, 0x7e, 0xc3, 0x32, 0xe1, 0xd4, 0x02, 0x91, 0x5c, 0x7f, 0x46, 0xa9,
      0x6c, 0x20, 0xbc, 0xd2, 0x5a, 0x82, 0xca, 0x30, 0x84, 0x66, 0x0b, 0x41,
      0x71, 0xcc, 0x31, 0xa3},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x93, 0x0b, 0x4f, 0x61, 0x3d, 0xa1, 0x12, 0xcd, 0x29, 0xf8, 0xfb, 0xb2,
      0x35, 0xce, 0x07, 0x15, 0xee, 0xf8, 0x5b, 0xd5, 0xa3, 0x4f, 0xdf, 0x3a,
      0x67, 0xb4, 0xaf, 0x55, 0x01, 0x52, 0x69, 0xce, 0x99, 0xac, 0x81, 0x12,
      0xee, 0x81, 0xb5, 0x76, 0xb3, 0x1f, 0x08, 0x31, 0x60, 0xc5, 0x89, 0x0d,
      0xc2, 0xdb, 0x20, 0x4d, 0x58, 0x1a, 0xba, 0x97, 0x69, 0x74, 0x05, 0x6a,
      0x8b, 0xad, 0x36, 0x7f, 0xf0, 0x59, 0x84, 0x97, 0x4c, 0x10, 0xf7, 0x1f,
      0x5b, 0x03, 0x48, 0x2c, 0x7f, 0x7d, 0xd8, 0x6a, 0xea, 0xbf, 0x5c, 0x90,
      0x60, 0xb5, 0x4b, 0x04, 0x87, 0xf4, 0x0d, 0x30, 0x62, 0x7e, 0x0a, 0x46,
      0xfd, 0x7e, 0x80, 0x1e, 0x5f, 0x1b, 0x2b, 0x81, 0x3c, 0x43, 0x85, 0xf8,
      0x70, 0x25, 0x8b, 0xc2, 0xcc, 0x18, 0x65, 0x99, 0xe1, 0x24, 0xb9, 0xeb,
      0xca, 0x2a, 0x29, 0xa4, 0x3d, 0xbc, 0x06, 0xbb, 0xd3, 0x9f, 0xaf, 0x7f,
      0x30, 0x5a, 0x90, 0x2e, 0x7f, 0xfa, 0x40, 0x3a, 0xbc, 0x3b, 0xce, 0xdf,
      0x29, 0xee, 0x11, 0x36, 0x1b, 0xa0, 0xa0, 0xb3, 0x4f, 0x3b, 0xf9, 0xa9,
      0x28, 0x56, 0x60, 0xf6, 0x6b, 0x4b, 0x75, 0xcf, 0x75, 0xe0, 0xee, 0xd8,
      0xf4, 0x63, 0xe2, 0x04, 0xd9, 0x36, 0x54, 0xa9, 0xc8, 0x5b, 0x97, 0x88,
      0xbf, 0x8e, 0x32, 0x89, 0x0b, 0x65, 0x8e, 0xa7, 0x32, 0xef, 0xe3, 0xa5,
      0x6a, 0x4d, 0xdd, 0x2e, 0x7a, 0x42, 0x6f, 0xec, 0x64, 0x86, 0xa0, 0xf5,
      0x91, 0xa8, 0xa1, 0xd4, 0xf0, 0x89, 0xeb, 0x9c, 0x95, 0xa6, 0x33, 0x2e,
      0x7e, 0x0d, 0xb1, 0x03, 0xdc, 0x3d, 0xaf, 0x8c, 0xeb, 0xf3, 0x55, 0x54,
      0xd1, 0x8c, 0xb6, 0xda, 0x33, 0xdf, 0xe6, 0xdf, 0xbe, 0x0c, 0x8c, 0xf0,
      0x4a, 0x4f, 0x63, 0x05, 0x69, 0x3e, 0x94, 0xe8, 0x7f, 0x68, 0x53, 0x9f,
      0x67, 0x89, 0x29, 0x76},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x91, 0xd3, 0xf1, 0xfd, 0x66, 0x16, 0x3e, 0xf8, 0xa8, 0xfe, 0x02, 0xf9,
      0x88, 0x02, 0x21, 0x9f, 0x37, 0x09, 0x38, 0xf2, 0x1b, 0xaa, 0xab, 0x87,
      0x1d, 0x6e, 0xd2, 0x0d, 0xe4, 0x44, 0x9d, 0x5c, 0x61, 0x5f, 0x39, 0x5f,
      0x89, 0xb5, 0xe4, 0x55, 0xd3, 0x01, 0x08, 0x82, 0x85, 0xcf, 0x7a, 0xc4,
      0x2b, 0x51, 0xee, 0xac, 0xc1, 0xc7, 0xd4, 0x22, 0x0c, 0xf4, 0xc4, 0x56,
      0x17, 0x8b, 0x9a, 0x2d, 0x6b, 0xa9, 0x3b, 0x0b, 0x1c, 0x33, 0x4b, 0x6a,
      0xa6, 0xf1, 0x9c, 0xb7, 0x5f, 0x37, 0x4d, 0x88, 0xd9, 0xd2, 0x84, 0xfe,
      0xda, 0x4e, 0xea, 0x32, 0xc5, 0xa4, 0xd9, 0xba, 0xa0, 0xe1, 0x2f, 0xec,
      0x0f, 0x72, 0x30, 0x83, 0x22, 0xee, 0xea, 0xc9, 0xb0, 0x76, 0x9f, 0x16,
      0x14, 0x91, 0xdd, 0xbe, 0xa0, 0x89, 0x83, 0xea, 0x56, 0x50, 0x58, 0xd9,
      0x88, 0x38, 0xb8, 0x6d, 0xf1, 0x81, 0x08, 0x8d, 0xc9, 0x04, 0x80, 0x91,
      0x45, 0x0b, 0xed, 0xf4, 0xa6, 0x71, 0xfe, 0x0a, 0x57, 0xf9, 0xd4, 0xed,
      0x67, 0xcc, 0x41, 0xca, 0x6e, 0xb6, 0xa8, 0x32, 0x4c, 0xe1, 0x4d, 0x62,
      0x02, 0xde, 0x07, 0xd5, 0x5e, 0x80, 0xd5, 0x66, 0x60, 0xcc, 0xc3, 0x58,
      0xb1, 0xcf, 0x6e, 0xd5, 0x60, 0x61, 0xa2, 0xef, 0xdd, 0xe8, 0x07, 0x55,
      0x53, 0xc3, 0x26, 0xe9, 0xa1, 0x5d, 0x44, 0x14, 0x32, 0xc5, 0x2c, 0x72,
      0x09, 0xa6, 0xea, 0x6c, 0xb6, 0xae, 0x8f, 0xb1, 0xfb, 0x12, 0x8d, 0x8a,
      0xa3, 0x1c, 0xea, 0x24, 0xe5, 0x64, 0x8b, 0xaa, 0x08, 0x7e, 0xff, 0x83,
      0x76, 0xbc, 0x01, 0xb6, 0x08, 0x4e, 0x04, 0x76, 0xd3, 0xd5, 0xc5, 0x53,
      0x3d, 0x9c, 0x2c, 0x36, 0x80, 0x3e, 0x93, 0x9b, 0x8f, 0x52, 0x5c, 0x2e,
      0xd7, 0x70, 0xba, 0x08, 0xe2, 0x21, 0xcb, 0x94, 0x6d, 0x21, 0xd6, 0x11,
      0xc0, 0xfc, 0xfc, 0x15},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0x41, 0xc0, 0x4a, 0xef, 0xc7, 0x03, 0xaa, 0xa7, 0x1f, 0x40, 0xce, 0x9f,
      0x4f, 0x56, 0xa7, 0x71, 0x91, 0x26, 0xca, 0x19, 0x2d, 0x2e, 0x9c, 0x33,
      0xdf, 0xc6, 0xa8, 0xc1, 0x76, 0xe8, 0xc1, 0xc2, 0x2d, 0x9d, 0x7a, 0x83,
      0xf3, 0x99, 0x55, 0x40, 0x3a, 0x77, 0x98, 0xd1, 0x61, 0xe4, 0xad, 0x17,
      0xb1, 0x57, 0x5c, 0x35, 0xcd, 0x8f, 0x2a, 0xba, 0xb6, 0x39, 0x30, 0x72,
      0x22, 0x39, 0x53, 0x48, 0xb6, 0x7a, 0xe8, 0xb7, 0xed, 0xc4, 0x1e, 0xb0,
      0xb9, 0xa3, 0x8a, 0xc5, 0x08, 0xf1, 0xc0, 0x84, 0x89, 0xeb, 0xc2, 0x1e,
      0x5d, 0xb9, 0x09, 0xd9, 0x8d, 0x69, 0xa7, 0x4b, 0x21, 0x0d, 0xe7, 0x6a,
      0x92, 0x47, 0x87, 0xb2, 0xfe, 0x19, 0x13, 0xc9, 0x6e, 0xa9, 0x34, 0xef,
      0x88, 0xbe, 0x13, 0x96, 0x9c, 0xb2, 0x6f, 0xbb, 0xf0, 0x07, 0xff, 0xf7,
      0xf6, 0x39, 0x76, 0x0c, 0xa7, 0xde, 0x90, 0x41, 0xdd, 0xfe, 0x79, 0xb3,
      0xbe, 0x77, 0x10, 0xcb, 0xbf, 0x55, 0x9d, 0xb4, 0x4d, 0x2d, 0xb8, 0xaa,
      0x32, 0xf8, 0x8b, 0xe3, 0x34, 0x63, 0xb3, 0x66, 0x92, 0x4b, 0x84, 0x5d,
      0x07, 0xe2, 0xc0, 0x0b, 0xf0, 0x7f, 0xb3, 0x62, 0x5a, 0x60, 0x0b, 0x4f,
      0x84, 0x04, 0x1c, 0x73, 0xd7, 0x77, 0xc0, 0x82, 0x2b, 0xd8, 0x96, 0xae,
      0xe8, 0xb0, 0x8c, 0x4f, 0x6e, 0x30, 0xdd, 0x45, 0x69, 0x20, 0x8f, 0xc8,
      0xca, 0xec, 0x74, 0x58, 0x0a, 0x43, 0xac, 0xaf, 0x7f, 0xcb, 0x2b, 0x6d,
      0xaa, 0xd5, 0x69, 0xf4, 0xa5, 0x8e, 0x28, 0x12, 0x98, 0xca, 0xf9, 0xb6,
      0xf1, 0x55, 0xcf, 0x30, 0xe9, 0x4f, 0xf6, 0x71, 0xde, 0x9b, 0xb0, 0xcb,
      0xab, 0xd1, 0x84, 0xb8, 0x54, 0xef, 0x1d, 0x2b, 0x7c, 0xae, 0x33, 0xe7,
      0xdc, 0x60, 0x72, 0x23, 0x0e, 0xbe, 0x4b, 0xcd, 0x4d, 0x49, 0x25, 0x3a,
      0xef, 0x56, 0x3e, 0x92},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     6,
     {0x61},
     {0x32, 0xaf, 0x08, 0xd0, 0xe1, 0x92, 0xb8, 0x7a, 0x39, 0x2e, 0x69, 0xc0,
      0xe4, 0xf1, 0xfa, 0xf5, 0x25, 0xf9, 0x70, 0x5a, 0xf0, 0x43, 0x01, 0xbc,
      0xf4, 0x77, 0x3c, 0xaa, 0xda, 0x60, 0xba, 0xf8, 0xc9, 0xe3, 0xef, 0x5b,
      0x23, 0xf2, 0x2e, 0x38, 0xf9, 0x96, 0x68, 0x49, 0xf5, 0x5e, 0x07, 0x5a,
      0xab, 0x69, 0xf1, 0xbb, 0x76, 0xd2, 0xc9, 0xe4, 0x43, 0xf3, 0x4d, 0xcc,
      0x1a, 0x9e, 0xd8, 0xd3, 0x2a, 0x7e, 0xd3, 0xf9, 0xec, 0xfc, 0x05, 0xcb,
      0x15, 0x42, 0x35, 0xe2, 0xe5, 0x32, 0xaf, 0x1b, 0x6f, 0x1f, 0xcc, 0x39,
      0x26, 0x76, 0xa5, 0x00, 0xb5, 0x53, 0x9f, 0x6a, 0x86, 0xbe, 0x79, 0x2d,
      0xe0, 0x13, 0xa4, 0xd6, 0x14, 0x12, 0x98, 0x52, 0xab, 0x57, 0xe0, 0x30,
      0x52, 0x1e, 0x1a, 0x77, 0x6d, 0x17, 0xa9, 0xc5, 0x40, 0x61, 0xb7, 0x45,
      0x7e, 0x05, 0x17, 0xf2, 0x60, 0x82, 0x66, 0x40, 0xd2, 0x4e, 0x60, 0x4a,
      0x08, 0x84, 0x9f, 0x9c, 0x14, 0xa8, 0xb9, 0xb6, 0x12, 0x6a, 0x39, 0x4d,
      0x14, 0x51, 0x64, 0x93, 0x26, 0xb1, 0x5a, 0x44, 0x0f, 0x52, 0xda, 0x5f,
      0xa9, 0x17, 0xb1, 0x51, 0x89, 0xa7, 0x3f, 0x0c, 0xa9, 0x3c, 0x6f, 0x1c,
      0xa6, 0x5a, 0x8b, 0x00, 0xf9, 0x65, 0x16, 0xb9, 0xf8, 0x75, 0x19, 0xe6,
      0xac, 0x96, 0xaf, 0x33, 0xdf, 0x11, 0x2e, 0xb8, 0xcc, 0x66, 0x91, 0x17,
      0x82, 0x1d, 0x7f, 0x31, 0x8e, 0xb7, 0xf0, 0x9a, 0xe7, 0x4f, 0xe2, 0x83,
      0xff, 0x4d, 0xed, 0x8a, 0x2e, 0x6b, 0x36, 0x35, 0x43, 0x83, 0x3a, 0x31,
      0x1c, 0x2b, 0x7b, 0xe7, 0xb6, 0xf0, 0x77, 0x98, 0xba, 0x35, 0x5a, 0x71,
      0x67, 0x07, 0xb0, 0x6c, 0x4d, 0x50, 0x79, 0x2c, 0x88, 0x84, 0x24, 0xa5,
      0xa0, 0x49, 0xb1, 0xb0, 0xa3, 0x3c, 0x88, 0x10, 0x59, 0xdc, 0x81, 0x78,
      0x11, 0x96, 0x76, 0xa2},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0x60, 0x2a, 0x88, 0x77, 0x9a, 0xe2, 0x6e, 0x4a, 0xea, 0x37, 0x70, 0x0b,
      0x4e, 0xd5, 0x13, 0xab, 0xed, 0x88, 0x9d, 0x15, 0xde, 0x24, 0x52, 0x3a,
      0xeb, 0xf3, 0x4c, 0x90, 0x27, 0xfb, 0xd6, 0x27, 0x47, 0xfa, 0xdb, 0xdf,
      0x46, 0x44, 0x9a, 0xb8, 0xcf, 0x1b, 0xf5, 0xf2, 0xc4, 0xc9, 0x42, 0x42,
      0x3e, 0x0c, 0x22, 0xdf, 0x00, 0xe2, 0xb5, 0x13, 0xaa, 0xa7, 0xa9, 0x50,
      0x2e, 0xe3, 0x30, 0xbe, 0x44, 0x12, 0x74, 0xa0, 0x9a, 0xc0, 0xb8, 0x72,
      0x15, 0x0d, 0x73, 0xe5, 0x2f, 0x34, 0x76, 0x38, 0x79, 0xc5, 0x6d, 0x09,
      0xc4, 0x00, 0x52, 0x1a, 0xff, 0x0c, 0x7a, 0x8d, 0xdb, 0xba, 0xe2, 0x80,
      0x28, 0x91, 0x13, 0xbd, 0x4f, 0x5c, 0xb1, 0x78, 0x0e, 0xb1, 0x60, 0x40,
      0x97, 0x4f, 0x41, 0xb6, 0xec, 0x4e, 0x0b, 0x06, 0x02, 0x09, 0xe7, 0x74,
      0x3d, 0xf3, 0x21, 0xa5, 0x97, 0xa8, 0xa0, 0xfe, 0x00, 0xdf, 0x28, 0x57,
      0x80, 0x07, 0x3a, 0x03, 0x60, 0x0c, 0x16, 0xef, 0x62, 0x49, 0x6e, 0x7e,
      0x06, 0x33, 0x5b, 0x73, 0x11, 0xd1, 0x6a, 0x8c, 0xd3, 0x76, 0x78, 0x4f,
      0x27, 0x28, 0x9d, 0x02, 0xaa, 0xdd, 0x1b, 0xe5, 0x39, 0x0e, 0x6e, 0x61,
      0x8c, 0xf8, 0x27, 0x1d, 0xbd, 0x9c, 0xa7, 0xf8, 0x33, 0x83, 0x92, 0x07,
      0x6c, 0xa5, 0x3f, 0xee, 0x75, 0x0f, 0x30, 0xc9, 0x5a, 0xeb, 0xfb, 0x26,
      0xc8, 0xce, 0xe5, 0x68, 0xa2, 0x25, 0x3f, 0x20, 0x75, 0xef, 0xf7, 0x94,
      0x1b, 0x45, 0x53, 0x17, 0x72, 0x8b, 0xb1, 0xad, 0x04, 0x42, 0xd6, 0x91,
      0x16, 0x7f, 0x64, 0x72, 0x88, 0x3b, 0x6e, 0x8b, 0x07, 0xe7, 0xf6, 0xc5,
      0xbf, 0x10, 0xe4, 0xde, 0xf8, 0xf2, 0x71, 0xe6, 0x22, 0xda, 0xbe, 0x23,
      0xd6, 0xd3, 0xe8, 0xc0, 0xa1, 0xe2, 0x77, 0x78, 0x1e, 0x58, 0x88, 0x23,
      0x7e, 0x83, 0xbf, 0xfd},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x73, 0x8a, 0x92, 0x65, 0x6e, 0x1e, 0x75, 0x9b, 0xbf, 0x45, 0x15, 0xa1,
      0x35, 0x98, 0xef, 0xa7, 0xc7, 0xc3, 0xb3, 0x75, 0x9c, 0xa8, 0x7e, 0xe1,
      0x97, 0x4e, 0x7f, 0xf8, 0xf3, 0x79, 0x95, 0x3b, 0x7c, 0xb1, 0x07, 0xfd,
      0x42, 0x12, 0x25, 0xd4, 0xc9, 0x2c, 0x59, 0xe4, 0x59, 0xe3, 0x32, 0x90,
      0xe6, 0xb7, 0x3f, 0x88, 0x96, 0xf5, 0xf0, 0x64, 0xbe, 0x8d, 0xe4, 0x3c,
      0x67, 0xc6, 0x8b, 0xf6, 0xda, 0x3c, 0x7e, 0x46, 0x39, 0x26, 0x8e, 0x5f,
      0x20, 0x4a, 0x7a, 0x98, 0x32, 0xfc, 0x1b, 0x1b, 0x5c, 0x47, 0x56, 0xc2,
      0xe5, 0xb4, 0x9c, 0x09, 0x12, 0xbb, 0x0d, 0xbd, 0xc0, 0x49, 0x94, 0x90,
      0x90, 0x34, 0x43, 0x01, 0xc4, 0x26, 0x19, 0x14, 0x3e, 0xb8, 0x02, 0x4c,
      0xd6, 0x33, 0xa5, 0xa8, 0x42, 0x9c, 0x9c, 0x71, 0x74, 0x31, 0xf9, 0xda,
      0xe7, 0x2c, 0xe8, 0xf8, 0x48, 0xce, 0xd2, 0x28, 0xb7, 0x25, 0x62, 0x51,
      0x70, 0x06, 0xf5, 0xca, 0x77, 0xef, 0x35, 0x6a, 0xf9, 0x8f, 0x1d, 0x28,
      0x28, 0xa5, 0x9d, 0xc7, 0x5f, 0xff, 0xb5, 0x24, 0x37, 0xef, 0x82, 0x2a,
      0x15, 0x1b, 0xc6, 0x96, 0x91, 0x7a, 0x4c, 0xd0, 0xe6, 0x88, 0xbe, 0xaa,
      0x6c, 0xa9, 0xe7, 0xff, 0x15, 0x00, 0x7c, 0x5c, 0xa1, 0x2f, 0xf4, 0xda,
      0x95, 0xe5, 0x78, 0x0b, 0x8f, 0x72, 0x88, 0xfe, 0x98, 0x12, 0xdf, 0x20,
      0x5a, 0x1a, 0x25, 0xba, 0xed, 0x93, 0x59, 0xac, 0x87, 0x51, 0x1b, 0xc8,
      0xd4, 0xf0, 0x28, 0x7d, 0xe5, 0x99, 0x40, 0xf0, 0xcd, 0x45, 0xe2, 0xf8,
      0xce, 0xb7, 0xcc, 0xb1, 0x2b, 0x76, 0x3b, 0x24, 0x3a, 0xdc, 0xec, 0x6d,
      0xa3, 0xd3, 0xde, 0xf4, 0xe7, 0x85, 0x6d, 0xf4, 0xe4, 0xa4, 0xcd, 0x75,
      0xfa, 0x03, 0xe1, 0x4d, 0x5a, 0x63, 0xa5, 0x80, 0x8b, 0xca, 0xd7, 0x98,
      0xee, 0x2d, 0x2c, 0x8d},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_3,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x57, 0xc8, 0x21, 0x09, 0x3f, 0x34, 0x02, 0x32, 0xc5, 0xdf, 0x14, 0xfe,
      0x7f, 0x65, 0x61, 0xc0, 0x63, 0xd6, 0x4e, 0x56, 0x60, 0xa3, 0x53, 0xe6,
      0x74, 0x17, 0x74, 0x84, 0x2e, 0x0f, 0xa0, 0xb4, 0xcd, 0x63, 0x7e, 0xce,
      0x4e, 0x93, 0x5f, 0x7d, 0x94, 0x8f, 0xa8, 0x75, 0xb5, 0x97, 0x88, 0x86,
      0xb8, 0x68, 0x19, 0x5f, 0x55, 0x98, 0xa8, 0x6e, 0x83, 0xf8, 0xd2, 0x5b,
      0xfa, 0xf4, 0x45, 0xbf, 0x45, 0x3c, 0x0a, 0x7b, 0xa4, 0x08, 0x8e, 0x38,
      0xeb, 0x6f, 0xb1, 0x23, 0x78, 0x8a, 0xd1, 0xdb, 0xa2, 0xa3, 0x09, 0x8e,
      0x33, 0xcc, 0x7f, 0x35, 0x4b, 0xd9, 0x62, 0x27, 0x95, 0x72, 0x0d, 0x3f,
      0x31, 0x48, 0xdb, 0x48, 0x4f, 0xb9, 0x82, 0xd5, 0xb0, 0x85, 0x5e, 0x58,
      0xef, 0x8d, 0x74, 0xd1, 0x2f, 0xe9, 0x3e, 0x89, 0x1f, 0x89, 0x87, 0xcf,
      0x47, 0xd7, 0x40, 0x24, 0xd1, 0xa2, 0x82, 0x4b, 0x3d, 0x6a, 0x95, 0x56,
      0x70, 0x55, 0x2d, 0x00, 0x05, 0x5e, 0xc3, 0xbb, 0x0f, 0x6b, 0x4c, 0xfb,
      0x87, 0x20, 0x2c, 0xd6, 0x6c, 0x36, 0xd8, 0x31, 0xa6, 0x24, 0x71, 0xc5,
      0x9c, 0x7d, 0x2c, 0xcd, 0x43, 0x02, 0x86, 0x54, 0x96, 0x90, 0x4b, 0xfc,
      0xe0, 0xa4, 0x1a, 0xc3, 0xdb, 0x7a, 0xc1, 0x52, 0xfd, 0xfc, 0xec, 0x6b,
      0xd9, 0x84, 0xc9, 0xf6, 0x3b, 0xda, 0x06, 0xd4, 0xb4, 0x67, 0xef, 0x17,
      0x48, 0xf3, 0xa0, 0xc7, 0xf1, 0xe5, 0xa8, 0xee, 0x5e, 0xfd, 0x56, 0xaa,
      0xae, 0x89, 0x81, 0xfb, 0x15, 0x32, 0x9c, 0x44, 0xba, 0x92, 0xd1, 0x5e,
      0xdd, 0x20, 0xc9, 0x82, 0xe5, 0x55, 0x09, 0x6b, 0x93, 0x92, 0x1b, 0x08,
      0x1e, 0x68, 0xbd, 0x1e, 0x36, 0xb1, 0xdb, 0xe3, 0x6f, 0xb3, 0xbd, 0xb6,
      0x9b, 0xdd, 0xc8, 0xe9, 0xd9, 0xf6, 0xf1, 0xca, 0x31, 0x7b, 0xa1, 0x6f,
      0x66, 0x40, 0x34, 0xa2},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_3,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x3d, 0x77, 0x87, 0xe4, 0x41, 0xea, 0x11, 0x70, 0x85, 0x27, 0xa3, 0x74,
      0x64, 0xa5, 0x29, 0x44, 0x96, 0x50, 0x26, 0x5f, 0x04, 0xb5, 0x52, 0x94,
      0xa7, 0x1f, 0x34, 0x52, 0x58, 0x6f, 0x55, 0xc1, 0x30, 0x4f, 0xac, 0x48,
      0xa4, 0x6f, 0xaa, 0x70, 0x82, 0xcf, 0x1b, 0x5d, 0x1d, 0x72, 0x8f, 0xe3,
      0x37, 0x05, 0x65, 0x51, 0x48, 0x6d, 0x89, 0x2e, 0xec, 0x14, 0x03, 0x55,
      0x0d, 0xd8, 0x51, 0xed, 0x69, 0x97, 0xe4, 0x1f, 0x70, 0xac, 0xf7, 0xf4,
      0x01, 0xd1, 0xac, 0x92, 0xc5, 0xe4, 0x16, 0xe7, 0x3f, 0x1f, 0x1a, 0x02,
      0x4e, 0x54, 0x2e, 0xe2, 0x79, 0x48, 0x4d, 0xb7, 0x70, 0xc9, 0xa6, 0xc9,
      0x1c, 0x14, 0xd4, 0x87, 0xbf, 0xf3, 0x79, 0x60, 0xdb, 0x7a, 0x11, 0x06,
      0x4d, 0xcb, 0xbe, 0x07, 0x27, 0x2c, 0xc0, 0x36, 0xa1, 0xe0, 0x94, 0x6d,
      0x71, 0xf1, 0xfe, 0x97, 0xdc, 0xbd, 0xca, 0xb9, 0x11, 0xb1, 0x4d, 0x6e,
      0x4d, 0xab, 0x44, 0xa0, 0x7d, 0x8c, 0xd5, 0xbc, 0x3c, 0x0f, 0x00, 0x8d,
      0x99, 0x29, 0xf2, 0xd6, 0x0b, 0x4c, 0x6e, 0xad, 0x2e, 0x84, 0xdc, 0xb8,
      0x60, 0x02, 0xad, 0xba, 0x05, 0x6b, 0x35, 0x59, 0xfe, 0x40, 0xaf, 0xd0,
      0x27, 0xcb, 0x05, 0xd4, 0x1e, 0xa7, 0xf9, 0x67, 0xe2, 0xcb, 0x43, 0x45,
      0xc1, 0x4e, 0xe3, 0x7c, 0x25, 0xae, 0xf4, 0x15, 0xec, 0x93, 0x27, 0x76,
      0xde, 0x1a, 0xb9, 0x92, 0x45, 0x82, 0x03, 0xeb, 0x58, 0xa5, 0xeb, 0x1a,
      0x21, 0xc3, 0xa6, 0x19, 0xbf, 0x06, 0xaa, 0x0d, 0x6d, 0x74, 0xb5, 0xea,
      0x6d, 0xec, 0xb2, 0x56, 0x02, 0x13, 0x97, 0x33, 0xc0, 0x1e, 0x13, 0x1c,
      0x64, 0xb7, 0xde, 0x34, 0x65, 0xdb, 0x27, 0x16, 0x94, 0x0d, 0x00, 0xec,
      0xb5, 0xdb, 0x6b, 0xa7, 0xc5, 0x41, 0x54, 0x3d, 0xa5, 0x3b, 0xa6, 0x11,
      0x9e, 0x7c, 0x11, 0x7b},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_3,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
     {0x76, 0xa3, 0x90, 0x23, 0x06, 0x03, 0xa8, 0x34, 0x30, 0x57, 0x83, 0xf4,
      0x93, 0xb7, 0x21, 0xb4, 0xf3, 0x17, 0xf3, 0xd4, 0xb6, 0xe1, 0xbc, 0x26,
      0xd1, 0x98, 0x3f, 0xf1, 0xf4, 0x94, 0x48, 0xba, 0xbb, 0xeb, 0xa0, 0x61,
      0xe9, 0x4e, 0xf6, 0xb4, 0x83, 0x57, 0x95, 0x64, 0x49, 0x6e, 0xa8, 0x9f,
      0x9e, 0x2e, 0x78, 0x4e, 0x8e, 0x8d, 0xb8, 0x3c, 0xd0, 0xd2, 0xa6, 0x08,
      0x10, 0x48, 0xe4, 0xbe, 0xce, 0x72, 0x11, 0x97, 0xe6, 0x6a, 0x54, 0x17,
      0x8a, 0xcc, 0x69, 0x76, 0x08, 0x9a, 0x4f, 0x6f, 0x26, 0x8f, 0x8a, 0x54,
      0xa2, 0xa9, 0xa3, 0xe9, 0x0f, 0x58, 0x31, 0x71, 0x40, 0x11, 0x73, 0xf7,
      0xf6, 0x46, 0xd8, 0xcb, 0x42, 0x2e, 0x4e, 0xe1, 0x4f, 0xe0, 0x57, 0x68,
      0x6b, 0x00, 0x72, 0x28, 0x1e, 0x06, 0x6a, 0x28, 0xcc, 0x01, 0x33, 0xc6,
      0xb7, 0x07, 0x78, 0x1b, 0x71, 0x8f, 0x53, 0x5f, 0xa3, 0xa9, 0xc9, 0x9a,
      0x65, 0x36, 0x05, 0x40, 0xd3, 0x18, 0x26, 0x72, 0xac, 0xb1, 0xdb, 0x46,
      0x89, 0xc5, 0xd6, 0xd3, 0x31, 0x59, 0xf3, 0x7a, 0xa7, 0xe1, 0x6d, 0x98,
      0x8d, 0x49, 0xf7, 0x3b, 0x5e, 0x60, 0x3f, 0x81, 0x16, 0xe1, 0xb5, 0x05,
      0x3c, 0xa4, 0x5e, 0x6c, 0x04, 0x74, 0x3c, 0xae, 0x29, 0xfa, 0xa0, 0x4e,
      0xd9, 0x39, 0x19, 0x6b, 0x15, 0xfa, 0xae, 0x2f, 0xe4, 0x30, 0x3d, 0x7f,
      0xea, 0xb2, 0x02, 0xd8, 0x80, 0x9a, 0x7a, 0x2a, 0xd3, 0x0d, 0xee, 0xec,
      0x88, 0x09, 0x90, 0x33, 0x4f, 0x0d, 0xa9, 0xc7, 0xfa, 0xae, 0xbc, 0x1f,
      0x7f, 0x64, 0xf0, 0xc8, 0xc2, 0x02, 0x70, 0xc4, 0x4b, 0x70, 0x46, 0xee,
      0x30, 0x9d, 0x4b, 0xee, 0x15, 0x1a, 0x50, 0x4b, 0xda, 0xe8, 0x96, 0xe8,
      0x56, 0xe2, 0x02, 0xc8, 0xc5, 0xd8, 0xdc, 0x5d, 0x6f, 0x66, 0xc9, 0x99,
      0x61, 0xb6, 0x16, 0x8b},
     {},
     priv_key_3,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x60, 0xa6, 0x39, 0xb9, 0x45, 0x48, 0x30, 0x83, 0xeb, 0x99, 0xc1, 0xc1,
      0x58, 0xf2, 0xcf, 0xd6, 0x8b, 0xa8, 0xda, 0x37, 0x61, 0x5b, 0x6f, 0x14,
      0xf4, 0xa9, 0x99, 0xb7, 0x5d, 0xa7, 0xfa, 0xda, 0x3f, 0xb5, 0xb0, 0x71,
      0x61, 0x68, 0xf5, 0x34, 0x20, 0x63, 0x30, 0x6d, 0x88, 0x45, 0xab, 0x56,
      0x5b, 0xe1, 0x76, 0xf4, 0x57, 0xb6, 0xd2, 0x6f, 0x2d, 0xf5, 0x19, 0x53,
      0x56, 0xaf, 0x72, 0xbe, 0x2e, 0xab, 0x11, 0x85, 0x24, 0x0d, 0x2b, 0x27,
      0xd0, 0x23, 0x14, 0x1c, 0x06, 0x0c, 0x37, 0xe4, 0x6f, 0xc1, 0x39, 0xd5,
      0xdf, 0x47, 0x66, 0x7a, 0xdb, 0x1e, 0x2a, 0xcc, 0x5b, 0xf0, 0xb9, 0xd3,
      0xad, 0xb7, 0xde, 0x08, 0x7e, 0xaf, 0xde, 0x53, 0xa1, 0x57, 0x66, 0x9b,
      0x5e, 0x07, 0x50, 0x74, 0x32, 0xfb, 0x36, 0x6f, 0x43, 0x36, 0xf0, 0x23,
      0x1a, 0x04, 0xa3, 0xff, 0x91, 0x6e, 0xbc, 0x5f, 0x3a, 0x67, 0x92, 0x39,
      0xb3, 0x9f, 0x95, 0x2e, 0xfe, 0x24, 0xaa, 0x5f, 0x05, 0x3d, 0xce, 0xa1,
      0x00, 0x10, 0x98, 0x64, 0x95, 0xbd, 0x2e, 0x1b, 0x6c, 0xad, 0x62, 0x7f,
      0x6c, 0x78, 0x8b, 0x4a, 0xdc, 0x6e, 0xbe, 0x48, 0x2d, 0xf6, 0x3c, 0x13,
      0xfc, 0xa3, 0xb0, 0x37, 0x10, 0x96, 0xed, 0x74, 0xc0, 0x79, 0xd8, 0xfa,
      0x8f, 0xc3, 0xab, 0x74, 0x8b, 0x2e, 0x19, 0x35, 0x20, 0x9a, 0x89, 0x34,
      0xd4, 0xd4, 0xcd, 0x3b, 0xaa, 0xd9, 0x4a, 0x6b, 0xf5, 0xbe, 0x7c, 0x85,
      0x17, 0xdf, 0xd5, 0x5f, 0x76, 0xc2, 0x59, 0x29, 0xcf, 0x3c, 0x14, 0xb6,
      0x4f, 0xed, 0x9c, 0x35, 0x10, 0x1e, 0x3b, 0xba, 0xa8, 0xc7, 0x1e, 0xe8,
      0x16, 0x09, 0x87, 0x41, 0x00, 0x74, 0x96, 0xf2, 0x01, 0x61, 0xaa, 0xc1,
      0x6f, 0x1b, 0x4b, 0xc5, 0x4b, 0x6a, 0x00, 0x4d, 0x1e, 0x63, 0xbe, 0xaf,
      0xc7, 0xbb, 0xd1, 0xf2},
     {},
     priv_key_3,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xae, 0xce, 0x8a, 0x87, 0xa0, 0xc2, 0x5a, 0xc3, 0x3f, 0xe3, 0x22, 0x5e,
      0x26, 0x2e, 0x5d, 0x26, 0x76, 0xca, 0x68, 0xfe, 0x15, 0x3b, 0x84, 0xc2,
      0x6b, 0x65, 0xe8, 0x6f, 0x4d, 0xce, 0x65, 0x85, 0xf8, 0x01, 0xe0, 0xb1,
      0xd7, 0x48, 0xae, 0x6f, 0x3b, 0xcf, 0xcb, 0xa4, 0xc5, 0xb9, 0x5a, 0xb7,
      0x8f, 0x61, 0x44, 0x99, 0xb5, 0x47, 0x11, 0x8d, 0x1e, 0xed, 0x2f, 0x6e,
      0xde, 0x6e, 0x4a, 0x59, 0x66, 0xae, 0x86, 0xc6, 0x97, 0x57, 0x7c, 0xe3,
      0xd4, 0xf0, 0x2c, 0xaf, 0xac, 0xb7, 0x6e, 0x2d, 0x90, 0xdc, 0x18, 0x22,
      0x2e, 0xad, 0xea, 0x26, 0x68, 0x71, 0x76, 0x00, 0xe5, 0xee, 0xe9, 0x3f,
      0x3a, 0x20, 0xd5, 0x83, 0x95, 0x5e, 0xbd, 0xf9, 0xa6, 0x6d, 0x5f, 0x95,
      0x7e, 0x42, 0x22, 0x2a, 0x90, 0xf9, 0xde, 0x72, 0x32, 0xef, 0x1d, 0x8e,
      0xed, 0xbf, 0x88, 0x4e, 0xfe, 0x5e, 0x4f, 0xc0, 0xcc, 0xa5, 0x3f, 0xe4,
      0xd7, 0xf6, 0x02, 0x75, 0xc8, 0x16, 0xf4, 0xf7, 0x25, 0xb2, 0xd7, 0x53,
      0x9c, 0xe3, 0x8a, 0xd3, 0xe6, 0x43, 0xb7, 0xe4, 0xb4, 0x43, 0x28, 0x42,
      0x28, 0x8e, 0x03, 0x73, 0x4a, 0xe9, 0xdc, 0xb3, 0xd2, 0x6f, 0x5e, 0x76,
      0xae, 0x22, 0x7e, 0x70, 0x50, 0xea, 0x7e, 0x0e, 0x5e, 0x2a, 0x75, 0x5f,
      0xd4, 0x81, 0xa5, 0x7d, 0x65, 0xcb, 0xc0, 0x36, 0xaa, 0x9c, 0xb4, 0x06,
      0x2b, 0x5c, 0xee, 0x0d, 0x07, 0xe9, 0xdb, 0xae, 0x45, 0xb9, 0xa1, 0x13,
      0x57, 0x5b, 0xe9, 0x6e, 0x9a, 0xdd, 0x15, 0x70, 0xdd, 0xf6, 0xb4, 0x84,
      0x99, 0x17, 0xe0, 0x4b, 0xd9, 0x63, 0x6f, 0x17, 0x3c, 0xd5, 0xf7, 0x9d,
      0x3d, 0x05, 0xb1, 0xa0, 0x34, 0x4c, 0xc6, 0x2d, 0xbb, 0x52, 0x3d, 0xd2,
      0x9c, 0x8c, 0xb7, 0x70, 0x83, 0x95, 0x25, 0xb9, 0xe6, 0xf7, 0xbb, 0xaf,
      0x17, 0x38, 0x5e, 0x2a},
     {},
     priv_key_3,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xb0, 0x5a, 0xd1, 0xbc, 0x0a, 0x5c, 0x64, 0x37, 0xaa, 0xc3, 0x3f, 0x12,
      0x3c, 0x62, 0xb9, 0x4d, 0xb2, 0x4e, 0xb9, 0x8d, 0x88, 0x80, 0x8e, 0xbb,
      0x16, 0x17, 0xb2, 0x86, 0x6c, 0xc8, 0x51, 0xc3, 0x81, 0x8d, 0xd9, 0xc1,
      0x8e, 0x68, 0xc0, 0x14, 0x16, 0xb1, 0xd5, 0x93, 0xca, 0xba, 0xc1, 0xc3,
      0x64, 0xf8, 0x9b, 0x18, 0x17, 0xbc, 0x58, 0xd0, 0x21, 0xd9, 0x80, 0x6f,
      0x27, 0xd4, 0xab, 0x4e, 0xc8, 0x12, 0xd2, 0xa9, 0x64, 0xdd, 0x70, 0x29,
      0x5c, 0xe9, 0x52, 0x4c, 0xbc, 0x92, 0xb7, 0x54, 0xe4, 0x05, 0x7b, 0x29,
      0x74, 0xb3, 0x64, 0x8f, 0xec, 0x4a, 0x61, 0xc2, 0x35, 0x48, 0xc7, 0x91,
      0x9a, 0xd4, 0xb9, 0x7b, 0xc0, 0x56, 0x39, 0xe6, 0xf7, 0x27, 0xdf, 0x47,
      0x24, 0x86, 0xc9, 0xf5, 0x02, 0x65, 0xe2, 0x27, 0xd6, 0x48, 0xc5, 0x6c,
      0x13, 0xeb, 0x1f, 0xf4, 0xe5, 0xd7, 0x43, 0xcd, 0x0a, 0x52, 0x2f, 0x5b,
      0x01, 0xf8, 0xef, 0xea, 0x61, 0xb9, 0x34, 0xed, 0x1f, 0x04, 0xfa, 0x0e,
      0xff, 0xc0, 0xb7, 0xa5, 0xa4, 0x8b, 0x26, 0x62, 0x82, 0x6c, 0xe7, 0x2a,
      0xba, 0xa3, 0x74, 0x6e, 0x17, 0x18, 0xe7, 0x3d, 0x06, 0xe3, 0xfa, 0x97,
      0x3f, 0x31, 0x17, 0xa4, 0x5b, 0x57, 0x8d, 0x75, 0x9f, 0x89, 0x19, 0x6b,
      0x70, 0x8e, 0x86, 0x85, 0xa3, 0x14, 0xb8, 0xdc, 0x93, 0x87, 0xb4, 0xe8,
      0x2d, 0xbb, 0xad, 0x89, 0x77, 0x08, 0xea, 0xf1, 0x0c, 0x28, 0x5b, 0x94,
      0x71, 0x46, 0x8e, 0x2e, 0x46, 0x4e, 0x57, 0x70, 0x5e, 0x89, 0x40, 0x18,
      0xd2, 0xa0, 0x2e, 0xa2, 0x05, 0x9c, 0xcc, 0x7c, 0x7a, 0x92, 0x16, 0x87,
      0xed, 0x9e, 0x35, 0x8a, 0xf5, 0xbc, 0x13, 0xc1, 0xd0, 0x6d, 0x42, 0xaf,
      0xc5, 0xce, 0xc3, 0x3e, 0x34, 0x97, 0xad, 0x3c, 0x20, 0xb6, 0x20, 0xf8,
      0x0e, 0xee, 0xe5, 0x6e},
     {},
     priv_key_3,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x96, 0xa6, 0xcd, 0x66, 0x56, 0xb9, 0x9e, 0xc4, 0x5d, 0xae, 0x88, 0x79,
      0x58, 0x14, 0x8f, 0x67, 0x48, 0xcf, 0x84, 0xdb, 0xa9, 0x50, 0xd7, 0x35,
      0x10, 0x33, 0xe9, 0x8a, 0xae, 0x44, 0x0c, 0x6f, 0x36, 0x03, 0xed, 0x65,
      0xbe, 0xc3, 0x11, 0xa5, 0x5c, 0x6e, 0xc2, 0xbb, 0xc8, 0x92, 0x44, 0x2c,
      0xb1, 0x27, 0x30, 0x95, 0x7b, 0x79, 0x7e, 0xa8, 0xe3, 0x01, 0x0e, 0xfb,
      0x85, 0x99, 0x89, 0x1a, 0x3e, 0x8d, 0x20, 0x9e, 0xa0, 0xeb, 0x6b, 0x32,
      0x44, 0x8e, 0x57, 0xf4, 0x00, 0x3d, 0x2a, 0xc3, 0xdc, 0xf8, 0xc2, 0x9a,
      0x44, 0x45, 0x4d, 0x0b, 0xe7, 0x99, 0xa5, 0xa7, 0x72, 0x34, 0x42, 0x82,
      0x73, 0x7e, 0x42, 0xf7, 0x85, 0xee, 0x3a, 0xbd, 0x3e, 0xf8, 0x0d, 0x5d,
      0x46, 0x53, 0x93, 0x18, 0x28, 0xd5, 0xf0, 0x64, 0x35, 0x4a, 0xee, 0x25,
      0x6b, 0x62, 0x71, 0x81, 0x7e, 0x38, 0x07, 0xe1, 0x5c, 0x80, 0x5a, 0xfa,
      0xe2, 0x87, 0x7c, 0x85, 0x31, 0xcd, 0xcc, 0xd2, 0xf8, 0xd6, 0x6f, 0x3c,
      0xd6, 0x6d, 0x38, 0x66, 0xb5, 0x56, 0x5d, 0x99, 0x15, 0x4f, 0x1e, 0xb5,
      0xa4, 0xf0, 0x32, 0x59, 0x62, 0x44, 0xdf, 0xf7, 0x95, 0x93, 0x98, 0x0d,
      0x07, 0xe6, 0xe0, 0x6d, 0xe0, 0x96, 0x0c, 0x1d, 0xf2, 0xc3, 0xf8, 0x4d,
      0xe2, 0x24, 0xc1, 0x13, 0x49, 0x4a, 0xde, 0x9d, 0x03, 0xf5, 0x54, 0x87,
      0x1a, 0x0e, 0xf5, 0xc2, 0x87, 0xfd, 0x0a, 0xf2, 0xba, 0xbd, 0x16, 0xfb,
      0xf2, 0x98, 0x3c, 0x75, 0x8c, 0x79, 0x2b, 0x48, 0x91, 0x56, 0xe3, 0xa0,
      0xdb, 0x06, 0x0a, 0x64, 0xd7, 0x17, 0xe0, 0xd1, 0x49, 0xc3, 0x43, 0xc4,
      0x00, 0x15, 0xcc, 0xaf, 0xf4, 0x5b, 0xd4, 0xe3, 0xb1, 0x55, 0xb9, 0xc4,
      0x56, 0x3d, 0x5b, 0x8c, 0x3d, 0x5c, 0xaa, 0x97, 0xd7, 0xd4, 0x6d, 0x4c,
      0x5a, 0x2d, 0x20, 0x77},
     {},
     priv_key_3,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x03, 0x1e, 0xfe, 0x79, 0x85, 0x31, 0xe2, 0xce, 0x64, 0x0d, 0x49, 0x2b,
      0x62, 0x3c, 0x63, 0x01, 0x90, 0xa8, 0xda, 0x56, 0xe0, 0xfa, 0x3e, 0x29,
      0x81, 0x68, 0x0b, 0x20, 0xf1, 0x4d, 0xb0, 0x24, 0xab, 0xb3, 0xbb, 0xfa,
      0x08, 0xbd, 0xda, 0x51, 0xaa, 0x9d, 0x2f, 0xec, 0x81, 0xd2, 0x34, 0x01,
      0xa0, 0x07, 0x32, 0x6a, 0xa5, 0x84, 0x9b, 0x24, 0xb0, 0x99, 0xce, 0x95,
      0x7c, 0x7e, 0x2b, 0x83, 0x52, 0xf9, 0x72, 0x10, 0xa1, 0xe7, 0xff, 0x68,
      0x39, 0x8a, 0xa3, 0x88, 0x4a, 0x02, 0x7f, 0x53, 0xf2, 0x7e, 0x3c, 0x4f,
      0xf6, 0x5e, 0xe8, 0x1a, 0xf6, 0xaf, 0xd4, 0xbc, 0x53, 0x9e, 0x2f, 0x93,
      0x28, 0x2e, 0xd2, 0xa2, 0x27, 0x40, 0x93, 0x30, 0x55, 0x16, 0xb9, 0x80,
      0x0c, 0x54, 0x7e, 0x4a, 0x89, 0x33, 0xdb, 0x99, 0xb8, 0x02, 0xb0, 0xed,
      0x67, 0x50, 0x3f, 0xa5, 0x8b, 0xd1, 0xec, 0x8f, 0x08, 0x6f, 0x1d, 0x64,
      0x6f, 0xb4, 0xfb, 0x3e, 0x46, 0x8c, 0x75, 0x83, 0x5e, 0xfa, 0xd1, 0xa1,
      0x7c, 0x5c, 0x1c, 0x79, 0x63, 0xcd, 0x74, 0xef, 0xc0, 0xc1, 0x5d, 0x97,
      0x9a, 0x68, 0x6f, 0xfc, 0x72, 0xf6, 0x5b, 0x16, 0x4d, 0xbf, 0xeb, 0x29,
      0x93, 0x09, 0x25, 0xee, 0x5b, 0x2b, 0xd5, 0x06, 0x37, 0x8f, 0xef, 0xc7,
      0x97, 0xd9, 0x6b, 0xcb, 0x1b, 0x55, 0xdb, 0xd4, 0xc5, 0x8f, 0x0d, 0xd6,
      0x83, 0xc5, 0x1c, 0x6d, 0x11, 0xc9, 0x42, 0x7b, 0x4b, 0x45, 0x2d, 0xcd,
      0x7c, 0xc4, 0x34, 0x4f, 0x21, 0xba, 0x88, 0xda, 0xb0, 0x82, 0xfa, 0x69,
      0x9a, 0xcc, 0xe7, 0xf0, 0xcb, 0x3e, 0x67, 0x7d, 0x2d, 0x8a, 0xe8, 0x03,
      0xe0, 0xf1, 0xba, 0xfb, 0x0d, 0x2b, 0xc5, 0x4d, 0x4e, 0xf8, 0x8d, 0xdb,
      0x91, 0x63, 0x0f, 0xa6, 0xaa, 0x14, 0x1b, 0x85, 0x4b, 0x47, 0x5a, 0xc1,
      0x90, 0xb6, 0x96, 0xd7},
     {},
     priv_key_3,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xbc, 0x29, 0x65, 0x54, 0xa7, 0x3f, 0x00, 0x0d, 0xc5, 0xb0, 0x4a, 0x4d,
      0xd9, 0x6d, 0x91, 0xa8, 0x27, 0x92, 0xcc, 0xa1, 0x20, 0xe5, 0x2c, 0x7b,
      0x93, 0x28, 0xa5, 0xb7, 0x51, 0x8f, 0x4b, 0x80, 0x44, 0xe3, 0xbc, 0xeb,
      0xe8, 0x43, 0x0b, 0xad, 0xc9, 0x33, 0xa8, 0x51, 0x36, 0x41, 0xd6, 0x81,
      0x27, 0xd9, 0x3a, 0x91, 0x37, 0xa9, 0x6c, 0x81, 0xc6, 0x7c, 0x4a, 0xd5,
      0x90, 0x48, 0x06, 0x79, 0x90, 0xd1, 0x4a, 0x20, 0x8f, 0xd6, 0xb0, 0xd4,
      0x4d, 0x06, 0x8c, 0x6b, 0xba, 0x72, 0xb2, 0x83, 0x68, 0xc5, 0x78, 0x12,
      0x98, 0xd7, 0xbe, 0x36, 0xcd, 0x3d, 0x46, 0x2f, 0xdc, 0xf4, 0xf3, 0xc0,
      0x9f, 0xc0, 0xbe, 0xdf, 0x83, 0x41, 0xb2, 0x3f, 0x67, 0x22, 0xdb, 0x3f,
      0x0c, 0x96, 0xd7, 0x01, 0x36, 0x03, 0xcb, 0xc3, 0x53, 0x94, 0xdd, 0xb1,
      0xf9, 0xed, 0xb8, 0xac, 0x55, 0x0c, 0x25, 0xd4, 0xca, 0x6f, 0xe0, 0x06,
      0x2c, 0xb7, 0x5f, 0xf3, 0xac, 0xed, 0x20, 0x04, 0x0d, 0xbf, 0x75, 0x27,
      0x83, 0xa9, 0x70, 0x78, 0x3e, 0x78, 0xac, 0x9f, 0x1c, 0x57, 0x2c, 0x85,
      0x97, 0x3b, 0x25, 0x44, 0x34, 0xcb, 0x7c, 0xea, 0xb1, 0x5a, 0xea, 0xa9,
      0x65, 0x87, 0x8d, 0x1b, 0xc4, 0xbe, 0x56, 0x08, 0x38, 0xb8, 0x21, 0xc3,
      0x5c, 0x21, 0x8c, 0x06, 0xc5, 0xf6, 0xd6, 0x90, 0xb8, 0x6b, 0xd3, 0x87,
      0xe6, 0x51, 0x12, 0x94, 0xcf, 0x97, 0x23, 0xd3, 0x82, 0x26, 0xd9, 0x5e,
      0x3a, 0xd5, 0xd3, 0x6c, 0xea, 0xe4, 0x88, 0x89, 0xb7, 0x42, 0x8d, 0x1f,
      0x41, 0x88, 0x20, 0x6c, 0xbe, 0x76, 0x73, 0xcf, 0xa2, 0xc2, 0x8f, 0x51,
      0xc4, 0xe4, 0x51, 0xc5, 0xe2, 0xad, 0x92, 0xc9, 0x88, 0x03, 0x80, 0x48,
      0xc6, 0xc0, 0x3b, 0x37, 0x2f, 0x04, 0xeb, 0x24, 0x63, 0x51, 0x2f, 0x5e,
      0x85, 0x86, 0x75, 0x04},
     {},
     priv_key_3,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x6b, 0x36, 0x86, 0x2a, 0x42, 0x4e, 0xde, 0x6c, 0x74, 0x4f, 0x09, 0x49,
      0xdd, 0x9a, 0x30, 0x91, 0xd8, 0x50, 0xee, 0x16, 0x94, 0xde, 0xca, 0x2f,
      0x84, 0x4d, 0x86, 0x46, 0x98, 0xea, 0xc2, 0x9b, 0x2f, 0x11, 0x25, 0xab,
      0x31, 0x06, 0x08, 0x06, 0x7c, 0x37, 0x94, 0x3b, 0xd3, 0x86, 0x73, 0x2b,
      0x90, 0x3e, 0x25, 0x88, 0x65, 0xe0, 0xae, 0x33, 0xeb, 0x38, 0xa8, 0xc3,
      0x5a, 0x84, 0xb3, 0x86, 0x4b, 0x71, 0x7b, 0xa2, 0x9a, 0xec, 0xd5, 0xd5,
      0xef, 0x53, 0xf0, 0xde, 0xf2, 0x57, 0xb2, 0x95, 0x1e, 0xe1, 0x4b, 0xc9,
      0x50, 0x70, 0x35, 0x6a, 0x9e, 0x9b, 0xf2, 0xf3, 0x62, 0x32, 0x96, 0x6c,
      0x50, 0x17, 0x10, 0xd0, 0x82, 0x81, 0xc9, 0xb5, 0x94, 0x4c, 0x5c, 0x92,
      0x3d, 0x65, 0x37, 0x6f, 0x0c, 0xf5, 0x92, 0xd3, 0x75, 0x06, 0x03, 0xa7,
      0x58, 0xc1, 0x6d, 0x30, 0xb9, 0xc3, 0x07, 0xe3, 0x25, 0x43, 0xa3, 0x11,
      0xbf, 0xf7, 0xd4, 0x79, 0x38, 0xf3, 0x1f, 0x35, 0x47, 0xcc, 0x0f, 0xfc,
      0x71, 0x44, 0x1a, 0x13, 0x91, 0xf3, 0x03, 0x97, 0x0d, 0x97, 0x50, 0x01,
      0xd2, 0xdf, 0x00, 0x33, 0x17, 0x0c, 0xc0, 0x0f, 0x26, 0xae, 0x11, 0x8b,
      0xac, 0xb3, 0x17, 0x07, 0xfd, 0xe9, 0x3c, 0x24, 0xab, 0xbb, 0xb8, 0x30,
      0x4b, 0x55, 0x8c, 0x1b, 0xd5, 0x2e, 0x9e, 0x6d, 0xab, 0xae, 0x23, 0xb7,
      0x89, 0xfb, 0x79, 0x9f, 0x4f, 0x86, 0x67, 0xf6, 0xb7, 0xb7, 0x24, 0x32,
      0x1d, 0x45, 0x5f, 0xf4, 0xf3, 0x91, 0xe8, 0xf1, 0x98, 0x9f, 0x27, 0x12,
      0x04, 0xaa, 0x81, 0xeb, 0xb9, 0x49, 0x12, 0x41, 0x87, 0x14, 0x72, 0xca,
      0x1e, 0xbc, 0x38, 0xa0, 0x5b, 0x93, 0xd5, 0x57, 0xc4, 0x00, 0x0e, 0x2c,
      0xef, 0x7c, 0x5c, 0x9c, 0x0a, 0x85, 0xf8, 0xa6, 0x30, 0x49, 0x17, 0x0c,
      0x90, 0xb2, 0xd9, 0x01},
     {},
     priv_key_3,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8c, 0xd7, 0xfc, 0xfd, 0xeb, 0x18, 0x14, 0x0c, 0x47, 0x0d, 0x23, 0x0b,
      0x89, 0x44, 0x4a, 0x63, 0x76, 0x3c, 0x10, 0x25, 0xf6, 0x94, 0x09, 0x75,
      0x7b, 0xe5, 0x74, 0xbf, 0x71, 0xfe, 0x7d, 0x89, 0x94, 0x67, 0xcf, 0xe1,
      0xa6, 0x5d, 0x23, 0xd2, 0x40, 0x1b, 0x72, 0x09, 0xe8, 0x6b, 0xe5, 0xa4,
      0x77, 0x53, 0xad, 0x29, 0x5c, 0x72, 0x03, 0xd2, 0xc9, 0x35, 0xbd, 0x9d,
      0xe1, 0x45, 0x56, 0x48, 0x69, 0x08, 0xa7, 0xbf, 0x83, 0xdd, 0x9a, 0xee,
      0x74, 0xb6, 0xe5, 0x72, 0x04, 0xf9, 0xeb, 0x04, 0xcc, 0xa1, 0x5e, 0x2d,
      0x50, 0xb2, 0x2c, 0x5f, 0x45, 0xc7, 0xf3, 0x62, 0xf2, 0x3e, 0xd9, 0x48,
      0x19, 0x53, 0x92, 0xa1, 0x5b, 0x96, 0xa2, 0x38, 0xb4, 0xe0, 0x3d, 0xaa,
      0xe8, 0xb7, 0x25, 0x8a, 0xe6, 0x07, 0xa9, 0xd5, 0xda, 0x0d, 0xba, 0x56,
      0x29, 0x57, 0x5e, 0xdb, 0x56, 0xb4, 0x44, 0x81, 0x78, 0x24, 0xb8, 0x49,
      0x3b, 0x12, 0x5d, 0x5d, 0xa6, 0x3d, 0xd8, 0x1e, 0xba, 0x51, 0xdc, 0xc1,
      0x1f, 0x79, 0x79, 0xb1, 0x6c, 0xa0, 0x31, 0x4f, 0x02, 0xaf, 0x42, 0x12,
      0xa5, 0xea, 0x84, 0x0d, 0xaf, 0x21, 0x5e, 0x9f, 0xa0, 0x82, 0xa7, 0x08,
      0x95, 0x50, 0xe5, 0xdd, 0x0c, 0x0d, 0x0f, 0x26, 0x4d, 0x23, 0x0a, 0x62,
      0x49, 0xb4, 0x59, 0x26, 0xfd, 0x36, 0x0a, 0x4a, 0x56, 0xac, 0x05, 0x91,
      0x0a, 0x15, 0x20, 0x12, 0x92, 0xd5, 0xdc, 0x3d, 0x92, 0x30, 0x8f, 0x98,
      0x17, 0x5c, 0x0f, 0xb4, 0xf9, 0x03, 0x4e, 0xc8, 0xfc, 0x8d, 0x5b, 0x58,
      0x4e, 0x95, 0xeb, 0xb9, 0x42, 0xfd, 0x16, 0xd0, 0x4c, 0xd6, 0x86, 0x7f,
      0xbb, 0x2a, 0xa5, 0x33, 0x77, 0xdc, 0xa9, 0x3e, 0x5c, 0xa2, 0x38, 0x0d,
      0xe6, 0x4e, 0x59, 0xab, 0x41, 0xf7, 0x1e, 0x44, 0x9b, 0xe3, 0xea, 0xfa,
      0xd6, 0x3b, 0x41, 0x58},
     {},
     priv_key_3,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa8, 0x3a, 0x07, 0xc4, 0xb0, 0xe4, 0x08, 0xdd, 0x20, 0x5a, 0xdb, 0xed,
      0x9d, 0x92, 0x9d, 0x41, 0x8e, 0x19, 0xe6, 0xcb, 0x0c, 0x2d, 0x48, 0x6b,
      0xf7, 0x16, 0xab, 0x66, 0xc2, 0x1d, 0x1b, 0xdb, 0x34, 0x16, 0x36, 0xec,
      0x9b, 0x57, 0x34, 0xab, 0x97, 0x78, 0xce, 0x1e, 0x28, 0xf8, 0x82, 0xfa,
      0x98, 0x58, 0x23, 0x13, 0xd9, 0x84, 0x0c, 0x05, 0xcb, 0x45, 0x39, 0x73,
      0xdc, 0x13, 0x84, 0xe7, 0x3e, 0x25, 0x86, 0xb5, 0xe7, 0x53, 0x9a, 0x33,
      0x67, 0xf9, 0xec, 0x78, 0x86, 0x44, 0xf8, 0x81, 0xbe, 0x29, 0xc9, 0x91,
      0xb0, 0xe2, 0x3d, 0xe4, 0xe9, 0xe2, 0x99, 0xdd, 0xed, 0x39, 0xe3, 0x49,
      0x80, 0x73, 0x18, 0xc5, 0xbe, 0xd4, 0xd3, 0x2b, 0x52, 0xd0, 0x40, 0xef,
      0x5e, 0x99, 0xf0, 0x6b, 0x1c, 0x14, 0x24, 0x43, 0x47, 0xf5, 0x0e, 0x57,
      0xa8, 0xcb, 0x26, 0x46, 0x38, 0xdb, 0x98, 0xb3, 0xcf, 0xd4, 0x67, 0xc2,
      0xfb, 0x62, 0x13, 0x66, 0xf8, 0x3c, 0xbc, 0x68, 0xa2, 0x7b, 0x0d, 0x35,
      0x67, 0xe5, 0x74, 0x1d, 0x1c, 0xca, 0xe5, 0x68, 0xea, 0xca, 0x51, 0xac,
      0x93, 0xf4, 0xc5, 0xfe, 0xbc, 0xa4, 0xe2, 0x3c, 0xc7, 0x3f, 0xbf, 0x50,
      0x6e, 0xa3, 0x37, 0xb0, 0xdf, 0xb4, 0x7a, 0xfd, 0xb3, 0x51, 0xac, 0x03,
      0xe7, 0xbb, 0x81, 0xf1, 0xf6, 0xe8, 0x67, 0xe4, 0x42, 0x8d, 0x9b, 0x26,
      0x2d, 0x00, 0x69, 0x76, 0xfb, 0x39, 0x90, 0x1e, 0x84, 0xa2, 0x33, 0x1b,
      0x65, 0xb5, 0x9f, 0xb9, 0x67, 0x04, 0xf0, 0x8b, 0xd7, 0x7c, 0xbb, 0x7e,
      0x0a, 0x39, 0xf3, 0x57, 0xbc, 0x11, 0x00, 0xa7, 0x03, 0x42, 0xe5, 0xf4,
      0x7c, 0x09, 0x2a, 0x81, 0x73, 0x74, 0xac, 0x5e, 0xd1, 0xf6, 0x6a, 0x4b,
      0xeb, 0x6f, 0x3a, 0x48, 0x20, 0xb6, 0x10, 0x9b, 0x07, 0x5c, 0xd8, 0x0e,
      0x0f, 0xbd, 0x84, 0x0e},
     {},
     priv_key_3,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x66, 0xe2, 0xbd, 0x9c, 0xb7, 0x4a, 0x6a, 0xbe, 0xa3, 0x4c, 0x22, 0x85,
      0x16, 0x59, 0x02, 0xc9, 0xa5, 0xaa, 0x5e, 0x11, 0x20, 0x8f, 0x38, 0xa1,
      0x61, 0xec, 0x72, 0xb0, 0xba, 0x11, 0xe4, 0x00, 0x6a, 0x9f, 0xf8, 0xb1,
      0x18, 0xde, 0x42, 0xbc, 0x45, 0x29, 0x7a, 0x53, 0x8e, 0x6a, 0xff, 0x1f,
      0x4b, 0x56, 0x51, 0x9e, 0x6d, 0x31, 0xd7, 0xff, 0x9e, 0x5f, 0xf3, 0x2e,
      0x2f, 0xf0, 0x5d, 0xb6, 0x8d, 0x02, 0x3e, 0xfb, 0x5f, 0xc1, 0x0f, 0x5b,
      0x57, 0xd4, 0xa3, 0xb2, 0x16, 0xb6, 0x30, 0x48, 0xc4, 0xae, 0xbd, 0x88,
      0xba, 0x40, 0x9e, 0xc8, 0x7e, 0x95, 0xbc, 0x23, 0x93, 0x17, 0xc2, 0x32,
      0x0a, 0x06, 0xba, 0xd2, 0xda, 0x6c, 0xf7, 0xdc, 0x88, 0x67, 0x1c, 0x76,
      0x85, 0x9e, 0x47, 0x50, 0xeb, 0x39, 0xd0, 0x9f, 0xbc, 0x2e, 0x27, 0xfe,
      0xf6, 0xe6, 0x24, 0x7b, 0x23, 0x98, 0x1a, 0x50, 0x6e, 0x8b, 0xa9, 0xe8,
      0xee, 0x29, 0x70, 0x9e, 0x0a, 0x84, 0x6a, 0x61, 0x76, 0x49, 0x08, 0x3e,
      0xf5, 0xee, 0x38, 0x32, 0x09, 0x03, 0x6b, 0xa6, 0x66, 0xf1, 0x24, 0x03,
      0x89, 0x32, 0x8a, 0xab, 0xf6, 0x19, 0x96, 0x56, 0x3f, 0x65, 0xfc, 0xed,
      0xa0, 0x7a, 0x24, 0x05, 0x2e, 0x68, 0x89, 0x6c, 0x65, 0xac, 0xea, 0xa8,
      0xd4, 0xe5, 0x43, 0xad, 0x4a, 0x28, 0x58, 0xa3, 0x73, 0x69, 0xae, 0x62,
      0x29, 0x24, 0xaf, 0x97, 0x5b, 0xc6, 0x92, 0x4f, 0xd5, 0xee, 0xf3, 0x27,
      0xa0, 0x1b, 0xaf, 0x0b, 0x86, 0x4c, 0x55, 0x7c, 0xe8, 0x6b, 0xfc, 0x2e,
      0x84, 0xc1, 0x90, 0x0d, 0x20, 0x1e, 0x5f, 0x66, 0x78, 0x6b, 0x49, 0x97,
      0x41, 0xe0, 0xf3, 0x50, 0x42, 0x86, 0xca, 0x6a, 0xda, 0xd8, 0x2d, 0x37,
      0x93, 0x94, 0xd4, 0xb8, 0xab, 0x6f, 0x3a, 0x4e, 0xc3, 0xb1, 0x6e, 0xee,
      0x55, 0x06, 0xd9, 0x8e},
     {},
     priv_key_3,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x2d, 0x18, 0xa3, 0x1f, 0x2e, 0x87, 0x62, 0x31, 0x7a, 0xd9, 0x43, 0xdb,
      0x09, 0x65, 0x5b, 0x96, 0xae, 0x7d, 0xd2, 0xb7, 0xc4, 0x75, 0x4a, 0xf2,
      0xe8, 0x52, 0xbd, 0x0f, 0xa8, 0x77, 0xc5, 0x8b, 0x16, 0x0d, 0x62, 0xab,
      0x93, 0x78, 0xc0, 0x6c, 0x09, 0x56, 0xd5, 0x6b, 0x96, 0xd6, 0x3d, 0x56,
      0x93, 0xed, 0x28, 0xb5, 0xd5, 0x7a, 0x63, 0x54, 0x32, 0xfb, 0xcd, 0xc2,
      0x91, 0x1c, 0x98, 0x43, 0xc6, 0x80, 0x94, 0x30, 0x1c, 0x6e, 0xb1, 0xec,
      0x02, 0xff, 0x41, 0x40, 0x0b, 0x9d, 0x98, 0x06, 0x67, 0x3a, 0x0c, 0x07,
      0x31, 0x0a, 0x0a, 0x0e, 0x91, 0x97, 0x37, 0x61, 0xa2, 0xcb, 0xa9, 0x1e,
      0x38, 0x14, 0x02, 0x17, 0x59, 0x0c, 0xc2, 0x63, 0x4c, 0x85, 0x24, 0x78,
      0x86, 0xf6, 0x36, 0x4d, 0x5e, 0x54, 0x99, 0xc6, 0xe9, 0x9f, 0x43, 0x82,
      0x22, 0x41, 0xd4, 0xe8, 0xce, 0x69, 0x06, 0xb4, 0xd9, 0xb6, 0x6c, 0xe4,
      0x40, 0x7c, 0x6e, 0x8f, 0xcd, 0xa8, 0xf1, 0x8a, 0xae, 0x28, 0x31, 0xc3,
      0x82, 0xaf, 0xc9, 0xa8, 0xd2, 0x73, 0xf1, 0x7e, 0x2d, 0x44, 0xcf, 0xde,
      0x2f, 0x46, 0x3e, 0xa4, 0x7a, 0x32, 0x92, 0xa7, 0x4f, 0x74, 0x3b, 0x1a,
      0x99, 0xbb, 0x9a, 0xdd, 0xa4, 0xb6, 0x5c, 0x84, 0x15, 0x04, 0x08, 0x34,
      0xf3, 0x1e, 0x0f, 0x43, 0x92, 0x57, 0x2d, 0x3a, 0x12, 0x37, 0xd8, 0x22,
      0x7a, 0xdc, 0x38, 0x0f, 0x79, 0x49, 0x19, 0xe1, 0x61, 0x44, 0x59, 0x0f,
      0xde, 0x3f, 0xfb, 0x92, 0xfa, 0xe4, 0x35, 0x3f, 0xab, 0x40, 0x5f, 0xc0,
      0x9b, 0x25, 0x28, 0x24, 0x50, 0xf6, 0x64, 0x33, 0xd2, 0x5a, 0x31, 0x78,
      0x65, 0x55, 0x45, 0xdd, 0xa9, 0xda, 0x0a, 0x47, 0x59, 0xc8, 0x51, 0x0e,
      0x6e, 0x8f, 0x3f, 0x85, 0x79, 0x92, 0x26, 0x71, 0x5e, 0x7b, 0x2b, 0xe7,
      0x86, 0x7d, 0x1f, 0xa3},
     {},
     priv_key_3,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_3,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_3,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xc2, 0xc4, 0xa8, 0x60, 0x23, 0x6d, 0x3c, 0x90, 0x96, 0xa0, 0x76, 0xd6,
      0xba, 0x51, 0x07, 0xe0, 0xf7, 0xbd, 0x81, 0xe1, 0xba, 0x91, 0x6f, 0x73,
      0x75, 0x72, 0x4b, 0xd2, 0xb0, 0xb0, 0xb6, 0x39, 0x56, 0x81, 0x37, 0x15,
      0xa3, 0x45, 0x7a, 0xb0, 0x45, 0x8b, 0x71, 0xfb, 0x35, 0xa4, 0x5b, 0x27,
      0xf9, 0xef, 0x7a, 0xc3, 0xe5, 0x79, 0xde, 0xa4, 0x5d, 0xfb, 0xfd, 0x07,
      0x81, 0x9e, 0xd6, 0xb7, 0x02, 0x1a, 0xa5, 0x33, 0x6c, 0x58, 0x44, 0x2a,
      0xad, 0xd9, 0x6c, 0xa9, 0xee, 0x9d, 0x32, 0x47, 0x3e, 0x9d, 0x92, 0x78,
      0x56, 0x2b, 0x4d, 0x10, 0x25, 0x8a, 0xde, 0x6a, 0x98, 0xfb, 0x1c, 0x7c,
      0xfd, 0xc3, 0xb3, 0x71, 0x6e, 0xf5, 0xde, 0xc5, 0x8c, 0xf7, 0x3b, 0x35,
      0x9f, 0x38, 0x95, 0x99, 0xb4, 0xb5, 0x86, 0x5a, 0x98, 0x63, 0x51, 0x9e,
      0xb0, 0x01, 0xc3, 0x24, 0x38, 0x7d, 0xa7, 0x55, 0x45, 0x0d, 0xb3, 0x41,
      0x30, 0x93, 0x60, 0xe3, 0x80, 0x7c, 0x05, 0x65, 0xb8, 0xe2, 0xc4, 0x4f,
      0xbd, 0x5e, 0x6e, 0x8d, 0x04, 0xd0, 0x06, 0xd7, 0xee, 0x76, 0x8b, 0x8e,
      0x84, 0x36, 0x08, 0x2a, 0x90, 0xfa, 0x0e, 0x83, 0x7f, 0x32, 0xf4, 0x60,
      0x87, 0xab, 0x4a, 0x0d, 0x9b, 0xe2, 0x8a, 0xa7, 0xda, 0x17, 0x94, 0xce,
      0xb0, 0x17, 0x2a, 0x7f, 0x50, 0xed, 0x20, 0xf6, 0xdf, 0x64, 0x1e, 0xfb,
      0xcb, 0xfd, 0x2a, 0xac, 0x89, 0x77, 0x5c, 0x76, 0x1a, 0x73, 0x10, 0x09,
      0x3c, 0x67, 0x1c, 0x97, 0x7f, 0xa1, 0x8b, 0x0d, 0x6e, 0x01, 0xfb, 0x25,
      0xf7, 0xa4, 0x32, 0xb4, 0x2c, 0x65, 0x35, 0x97, 0x84, 0xc6, 0x89, 0x20,
      0x57, 0x19, 0xc1, 0xcf, 0x6e, 0x3a, 0x65, 0xda, 0xe2, 0xda, 0x43, 0x4c,
      0x32, 0x6d, 0xde, 0x81, 0xbb, 0x6f, 0xff, 0xfb, 0xdb, 0xf6, 0xde, 0x5c,
      0x16, 0xbb, 0xa7, 0x48},
     {},
     priv_key_3,
     false},

    // Comment: ciphertext is empty
    // tcID: 26
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_3,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 27
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x91, 0xd3, 0xf1, 0xfd, 0x66, 0x16, 0x3e, 0xf8, 0xa8, 0xfe,
      0x02, 0xf9, 0x88, 0x02, 0x21, 0x9f, 0x37, 0x09, 0x38, 0xf2, 0x1b, 0xaa,
      0xab, 0x87, 0x1d, 0x6e, 0xd2, 0x0d, 0xe4, 0x44, 0x9d, 0x5c, 0x61, 0x5f,
      0x39, 0x5f, 0x89, 0xb5, 0xe4, 0x55, 0xd3, 0x01, 0x08, 0x82, 0x85, 0xcf,
      0x7a, 0xc4, 0x2b, 0x51, 0xee, 0xac, 0xc1, 0xc7, 0xd4, 0x22, 0x0c, 0xf4,
      0xc4, 0x56, 0x17, 0x8b, 0x9a, 0x2d, 0x6b, 0xa9, 0x3b, 0x0b, 0x1c, 0x33,
      0x4b, 0x6a, 0xa6, 0xf1, 0x9c, 0xb7, 0x5f, 0x37, 0x4d, 0x88, 0xd9, 0xd2,
      0x84, 0xfe, 0xda, 0x4e, 0xea, 0x32, 0xc5, 0xa4, 0xd9, 0xba, 0xa0, 0xe1,
      0x2f, 0xec, 0x0f, 0x72, 0x30, 0x83, 0x22, 0xee, 0xea, 0xc9, 0xb0, 0x76,
      0x9f, 0x16, 0x14, 0x91, 0xdd, 0xbe, 0xa0, 0x89, 0x83, 0xea, 0x56, 0x50,
      0x58, 0xd9, 0x88, 0x38, 0xb8, 0x6d, 0xf1, 0x81, 0x08, 0x8d, 0xc9, 0x04,
      0x80, 0x91, 0x45, 0x0b, 0xed, 0xf4, 0xa6, 0x71, 0xfe, 0x0a, 0x57, 0xf9,
      0xd4, 0xed, 0x67, 0xcc, 0x41, 0xca, 0x6e, 0xb6, 0xa8, 0x32, 0x4c, 0xe1,
      0x4d, 0x62, 0x02, 0xde, 0x07, 0xd5, 0x5e, 0x80, 0xd5, 0x66, 0x60, 0xcc,
      0xc3, 0x58, 0xb1, 0xcf, 0x6e, 0xd5, 0x60, 0x61, 0xa2, 0xef, 0xdd, 0xe8,
      0x07, 0x55, 0x53, 0xc3, 0x26, 0xe9, 0xa1, 0x5d, 0x44, 0x14, 0x32, 0xc5,
      0x2c, 0x72, 0x09, 0xa6, 0xea, 0x6c, 0xb6, 0xae, 0x8f, 0xb1, 0xfb, 0x12,
      0x8d, 0x8a, 0xa3, 0x1c, 0xea, 0x24, 0xe5, 0x64, 0x8b, 0xaa, 0x08, 0x7e,
      0xff, 0x83, 0x76, 0xbc, 0x01, 0xb6, 0x08, 0x4e, 0x04, 0x76, 0xd3, 0xd5,
      0xc5, 0x53, 0x3d, 0x9c, 0x2c, 0x36, 0x80, 0x3e, 0x93, 0x9b, 0x8f, 0x52,
      0x5c, 0x2e, 0xd7, 0x70, 0xba, 0x08, 0xe2, 0x21, 0xcb, 0x94, 0x6d, 0x21,
      0xd6, 0x11, 0xc0, 0xfc, 0xfc, 0x15},
     {},
     priv_key_3,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x91, 0xd3, 0xf1, 0xfd, 0x66, 0x16, 0x3e, 0xf8, 0xa8, 0xfe, 0x02, 0xf9,
      0x88, 0x02, 0x21, 0x9f, 0x37, 0x09, 0x38, 0xf2, 0x1b, 0xaa, 0xab, 0x87,
      0x1d, 0x6e, 0xd2, 0x0d, 0xe4, 0x44, 0x9d, 0x5c, 0x61, 0x5f, 0x39, 0x5f,
      0x89, 0xb5, 0xe4, 0x55, 0xd3, 0x01, 0x08, 0x82, 0x85, 0xcf, 0x7a, 0xc4,
      0x2b, 0x51, 0xee, 0xac, 0xc1, 0xc7, 0xd4, 0x22, 0x0c, 0xf4, 0xc4, 0x56,
      0x17, 0x8b, 0x9a, 0x2d, 0x6b, 0xa9, 0x3b, 0x0b, 0x1c, 0x33, 0x4b, 0x6a,
      0xa6, 0xf1, 0x9c, 0xb7, 0x5f, 0x37, 0x4d, 0x88, 0xd9, 0xd2, 0x84, 0xfe,
      0xda, 0x4e, 0xea, 0x32, 0xc5, 0xa4, 0xd9, 0xba, 0xa0, 0xe1, 0x2f, 0xec,
      0x0f, 0x72, 0x30, 0x83, 0x22, 0xee, 0xea, 0xc9, 0xb0, 0x76, 0x9f, 0x16,
      0x14, 0x91, 0xdd, 0xbe, 0xa0, 0x89, 0x83, 0xea, 0x56, 0x50, 0x58, 0xd9,
      0x88, 0x38, 0xb8, 0x6d, 0xf1, 0x81, 0x08, 0x8d, 0xc9, 0x04, 0x80, 0x91,
      0x45, 0x0b, 0xed, 0xf4, 0xa6, 0x71, 0xfe, 0x0a, 0x57, 0xf9, 0xd4, 0xed,
      0x67, 0xcc, 0x41, 0xca, 0x6e, 0xb6, 0xa8, 0x32, 0x4c, 0xe1, 0x4d, 0x62,
      0x02, 0xde, 0x07, 0xd5, 0x5e, 0x80, 0xd5, 0x66, 0x60, 0xcc, 0xc3, 0x58,
      0xb1, 0xcf, 0x6e, 0xd5, 0x60, 0x61, 0xa2, 0xef, 0xdd, 0xe8, 0x07, 0x55,
      0x53, 0xc3, 0x26, 0xe9, 0xa1, 0x5d, 0x44, 0x14, 0x32, 0xc5, 0x2c, 0x72,
      0x09, 0xa6, 0xea, 0x6c, 0xb6, 0xae, 0x8f, 0xb1, 0xfb, 0x12, 0x8d, 0x8a,
      0xa3, 0x1c, 0xea, 0x24, 0xe5, 0x64, 0x8b, 0xaa, 0x08, 0x7e, 0xff, 0x83,
      0x76, 0xbc, 0x01, 0xb6, 0x08, 0x4e, 0x04, 0x76, 0xd3, 0xd5, 0xc5, 0x53,
      0x3d, 0x9c, 0x2c, 0x36, 0x80, 0x3e, 0x93, 0x9b, 0x8f, 0x52, 0x5c, 0x2e,
      0xd7, 0x70, 0xba, 0x08, 0xe2, 0x21, 0xcb, 0x94, 0x6d, 0x21, 0xd6, 0x11,
      0xc0, 0xfc, 0xfc, 0x15, 0x00, 0x00},
     {},
     priv_key_3,
     false},

    // Comment: truncated ciphertext
    // tcID: 29
    {SEC_OID_SHA512,
     CKG_MGF1_SHA1,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xd3, 0xf1, 0xfd, 0x66, 0x16, 0x3e, 0xf8, 0xa8, 0xfe, 0x02, 0xf9, 0x88,
      0x02, 0x21, 0x9f, 0x37, 0x09, 0x38, 0xf2, 0x1b, 0xaa, 0xab, 0x87, 0x1d,
      0x6e, 0xd2, 0x0d, 0xe4, 0x44, 0x9d, 0x5c, 0x61, 0x5f, 0x39, 0x5f, 0x89,
      0xb5, 0xe4, 0x55, 0xd3, 0x01, 0x08, 0x82, 0x85, 0xcf, 0x7a, 0xc4, 0x2b,
      0x51, 0xee, 0xac, 0xc1, 0xc7, 0xd4, 0x22, 0x0c, 0xf4, 0xc4, 0x56, 0x17,
      0x8b, 0x9a, 0x2d, 0x6b, 0xa9, 0x3b, 0x0b, 0x1c, 0x33, 0x4b, 0x6a, 0xa6,
      0xf1, 0x9c, 0xb7, 0x5f, 0x37, 0x4d, 0x88, 0xd9, 0xd2, 0x84, 0xfe, 0xda,
      0x4e, 0xea, 0x32, 0xc5, 0xa4, 0xd9, 0xba, 0xa0, 0xe1, 0x2f, 0xec, 0x0f,
      0x72, 0x30, 0x83, 0x22, 0xee, 0xea, 0xc9, 0xb0, 0x76, 0x9f, 0x16, 0x14,
      0x91, 0xdd, 0xbe, 0xa0, 0x89, 0x83, 0xea, 0x56, 0x50, 0x58, 0xd9, 0x88,
      0x38, 0xb8, 0x6d, 0xf1, 0x81, 0x08, 0x8d, 0xc9, 0x04, 0x80, 0x91, 0x45,
      0x0b, 0xed, 0xf4, 0xa6, 0x71, 0xfe, 0x0a, 0x57, 0xf9, 0xd4, 0xed, 0x67,
      0xcc, 0x41, 0xca, 0x6e, 0xb6, 0xa8, 0x32, 0x4c, 0xe1, 0x4d, 0x62, 0x02,
      0xde, 0x07, 0xd5, 0x5e, 0x80, 0xd5, 0x66, 0x60, 0xcc, 0xc3, 0x58, 0xb1,
      0xcf, 0x6e, 0xd5, 0x60, 0x61, 0xa2, 0xef, 0xdd, 0xe8, 0x07, 0x55, 0x53,
      0xc3, 0x26, 0xe9, 0xa1, 0x5d, 0x44, 0x14, 0x32, 0xc5, 0x2c, 0x72, 0x09,
      0xa6, 0xea, 0x6c, 0xb6, 0xae, 0x8f, 0xb1, 0xfb, 0x12, 0x8d, 0x8a, 0xa3,
      0x1c, 0xea, 0x24, 0xe5, 0x64, 0x8b, 0xaa, 0x08, 0x7e, 0xff, 0x83, 0x76,
      0xbc, 0x01, 0xb6, 0x08, 0x4e, 0x04, 0x76, 0xd3, 0xd5, 0xc5, 0x53, 0x3d,
      0x9c, 0x2c, 0x36, 0x80, 0x3e, 0x93, 0x9b, 0x8f, 0x52, 0x5c, 0x2e, 0xd7,
      0x70, 0xba, 0x08, 0xe2, 0x21, 0xcb, 0x94, 0x6d, 0x21, 0xd6, 0x11, 0xc0,
      0xfc, 0xfc, 0x15},
     {},
     priv_key_3,
     false}};

#endif  // rsa_oaep_2048_sha512_mgf1sha1_vectors_h__
