from TwistedQuotes import quoteproto  # Protocol and Factory
from TwistedQuotes import quoters  # "give me a quote" code

from twisted.application import internet  # services that run TCP/SSL/etc.
from twisted.python import usage  # twisted command-line processing


class Options(usage.Options):
    optParameters = [
        ["port", "p", 8007, "Port number to listen on for QOTD protocol."],
        [
            "static",
            "s",
            "An apple a day keeps the doctor away.",
            "A static quote to display.",
        ],
        ["file", "f", None, "A fortune-format text file to read quotes from."],
    ]


def makeService(config):
    """Return a service that will be attached to the application."""
    if config["file"]:  # If I was given a "file" option...
        # Read quotes from a file, selecting a random one each time,
        quoter = quoters.FortuneQuoter([config["file"]])
    else:  # otherwise,
        # read a single quote from the command line (or use the default).
        quoter = quoters.StaticQuoter(config["static"])
    port = int(config["port"])  # TCP port to listen on
    factory = quoteproto.QOTDFactory(quoter)  # here we create a QOTDFactory
    # Finally, set up our factory, with its custom quoter, to create QOTD
    # protocol instances when events arrive on the specified port.
    return internet.TCPServer(port, factory)
