## Presentations

* Variant calling and bcbio training for the [Harvard Chan Bioinformatics Core In Depth NGS Data Analysis Course](https://hbctraining.github.io/In-depth-NGS-Data-Analysis-Course/) (10 October 2018): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/ngscourse2018_teaching/ngscourse2018_teaching.pdf)
* Building a diverse set of validations; lightning talk at [the GCCBOSC2018 Bioinformatics Community Conference](https://gccbosc2018.sched.com/): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bosc2018_bcbio_validate/chapman_bcbio_validate.pdf)
* bcbio training at [the GCCBOSC2018 Bioinformatics Community Conference](https://gccbosc2018.sched.com/), focusing on bcbio CWL integration with examples of variant calling analyses on Personal Genome Project examples (26 June 2018): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bosc2018_bcbio_training/bosc2018_bcbio_training.pdf); [video](https://www.youtube.com/watch?v=ukWhAetvNKE)
* Description of bcbio and Common Workflow integration with a focus on parallelization strategies. From a bcbio discussion with [Peter Park's lab at Harvard Medical School](https://compbio.hms.harvard.edu/index) (26 January 2018): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/park2018_bcbio/park2018_bcbio.pdf)
* In depth description of bcbio and Common Workflow Language integration, including motivation and practical examples of running on clusters, DNAnexus, SevenBridges and Arvados. From the [Boston Bioinformatics Interest Group meeting](https://gist.github.com/chapmanb/8ee026fd85d07518570ac5a0cd7239f5) (2 November 2017): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/big2017_bcbio_cwl/big2017_bcbio_cwl.pdf); [video](https://youtu.be/nJEDS9Qol8M)
* bcbio practical interoperability with the Common Workflow Language at [BOSC 2017](https://www.open-bio.org/wiki/BOSC_2017) (22 July 2017): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bosc2017_bcbio_interoperate/chapmanb_bcbio_interoperate.pdf); [video](https://youtu.be/S7bu17GQHqk)
* [Teaching](contents/teaching:teaching) variant calling, bcbio and GATK4 validation at the [Summer 2017 NGS Data Analysis Course at Harvard Chan School](https://bioinformatics.sph.harvard.edu/training/) (6 July 2017): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/ngscourse2017_teaching/ngscourse2017_teaching.pdf)
* Training course for the [Cancer Genomics Cloud](https://www.cancergenomicscloud.org/), describing how bcbio uses the Common Workflow Language to run in multiple infrastructures (1 May 2017): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/cgc2017_bcbio_cwl/cgc2017_bcbiocwl.pdf)
* [MIT Bioinformatics Interest Group](https://openwetware.org/wiki/BioMicroCenter:BIG_meeting#2016-2017_academic_year) about how Common Workflow Language [enables interoperability with multiple workflow engines](https://gist.github.com/chapmanb/f1ccdd2e2e23b0383b6e6857b59a431b) (3 November 2016): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/big2016_bcbio_cwl/big2016_bcbiocwl.pdf) and [video](https://youtu.be/375QSYmaidk)
* [Broad Institute](https://www.broadinstitute.org/) software engineering seminar about bcbio validation and integration with Common Workflow Language and Workflow Definition Language (28 September 2016): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/broad_engineering2016_bcbio/broad2016_bcbio.pdf)
* Materials from [teaching](contents/teaching:teaching) at the [Summer 2016 NGS Data Analysis Course at Harvard Chan School](https://bioinformatics.sph.harvard.edu/training/) (11 August 2016): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/ngscourse2016b_teaching/ngscourse2016b_teaching.pdf)
* [Bioinformatics Open Source Conference (BOSC) 2016](https://www.open-bio.org/wiki/BOSC_2016) lightning talk on bcbio and common workflow language (8 July 2016): [slides](https://f1000research.com/slides/5-1639) and [video](https://youtu.be/kMoAWjHhOVc).
* Materials from [teaching](contents/teaching:teaching) from the [Spring 2016 NGS Data Analysis Course at Harvard Chan School](https://wiki.harvard.edu/confluence/display/hbctraining/NGS+Data+Analysis+Course+Application%2C+Spring+2016) (28 April 2016): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/ngscourse2016_teaching/ngscourse2016_teaching.pdf)
* Statistical Genetics and Network Science Meeting at [Channing Division of Network Medicine](https://www.brighamandwomens.org/research/departments/channing-division-of-network-medicine/overview) (23 March 2016): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/cdnm2016_bcbio/cdnm2016_bcbio.pdf)
* Presentation at Curoverse Brown Bag Seminar on bcbio and in progress integration work with [Common Workflow Language](https://www.commonwl.org/) and [Arvados](https://arvados.org/) (11 January 2016): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/curoverse2016bb_bcbio/curoverse2016bb_bcbio.pdf)
* Materials from [teaching](contents/teaching:teaching) oriented example at Cold Spring Harbor Laboratory's [Advanced Sequencing Technology and Applications course](https://meetings.cshl.edu/courses.aspx?course=C-SEQTEC&year=15). (18 November 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/cshl2015_bcbio/cshl2015_bcbio.pdf)
* Supporting the common workflow language and Docker in bcbio Bio in Docker symposium (9 November 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bioindocker2015_bcbio/chapman_bioindocker.pdf)
* Validation on human build 38, HLA typing, low frequency cancer calling and structural variation for [Boston Bioinformatics Interest Group (BIG) meeting](https://openwetware.org/wiki/BioMicroCenter:BIG_meeting) (5 November 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/big2015_bcbio/big2015_bcbio.pdf)
* Presentation on Research Scientist Careers for [Iowa State Bioinformatics Course](https://bcbio.las.iastate.edu/) (23 September 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/2015_iowast_career/chapman_career.pdf)
* Prioritization of structural variants based on known biological information at [BOSC 2015](https://www.open-bio.org/wiki/BOSC_2015) (10 July 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bosc2015_bcbio_prioritize/bosc2015_bcbio_prioritize.pdf); [video](https://www.youtube.com/watch?v=JZnF_6UnajY&feature=youtu.be)
* Overview of variant calling for [NGS Data Analysis Course at Harvard Medical School](https://wiki.harvard.edu/confluence/display/hbctraining/NGS+Data+Analysis+Course+Application%2C+Spring+2015) (19 May 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/ngscourse2015_teaching/variant_ngscourse.pdf)
* [NGS Glasgow](https://biotexcel.com/event/ngs-2015-glasgow/) (23 April 2015)
* [Boston Computational Biology and Bioinformatics meetup](https://www.meetup.com/Boston-Computational-Biology-and-Bioinformatics-Meetup/events/220328870/) (1 April 2015): [slides](https://github.com/chapmanb/bcbb/blob/master/talks/bcbb2015_bcbio/chapman_bcbio.pdf)
* [Program in Genetic Epidemiology and Statistical Genetics seminar series](https://www.hsph.harvard.edu/program-molecular-genetic-epidemiology/journal-club/) at Harvard Chan School (6 February 2015): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/pgsg2015_bcbio/chapman_bcbio.pdf)
* Talk at Good Start Genetics (23 January 2015): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/gsg2015_bcbio_nextgen/chapman_bcbio.pdf)
* Boston area [Bioinformatics Interest Group](https://openwetware.org/wiki/BioMicroCenter:BIG_meeting) (15 October 2014): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/big2014_bcbio_val/chapman_bcbio.pdf)
* University of Georgia [Institute of Bioinformatics](https://iob.uga.edu/) (12 September 2014): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/uga2014_bcbio_open/chapman_bcbio.pdf)
* Intel Life Sciences discussion (7 August 2014): [slides](https://github.com/chapmanb/bcbb/raw/master/talks/intel2014_bcbio/chapman_bcbio.pdf)
* Bioinformatics Open Source Conference (BOSC) 2014: [slides](https://github.com/chapmanb/bcbb/raw/master/talks/bosc2014_bcbio/chapman_bcbio.pdf), [conference website](https://www.open-bio.org/wiki/BOSC_2014)
* Galaxy Community Conference 2014: [slides](https://github.com/chapmanb/bcbb/raw/master/talks/gcc2014_bcbio/chapman_bcbio.pdf), [conference website](https://wiki.galaxyproject.org/Events/GCC2014)
* [bcbio hackathon at Biogen](https://github.com/chapmanb/bcbb/raw/master/talks/biogen2014_bcbio_nextgen/chapman_bcbio.pdf) (3 June 2014)
* [Harvard ABCD group slides](https://github.com/chapmanb/bcbb/raw/master/talks/abcd2014_bcbio_nextgen/chapman_bcbio.pdf) (17 April 2014)
* [BIG meeting](https://github.com/roryk/spliced-blog/blob/master/talks/BIG-meeting-feb-2014.pdf) (February 2014)
* [Novartis slides](https://github.com/chapmanb/bcbb/raw/master/talks/novartis2014_bcbio_nextgen/chapman_bcbio.pdf) (21 January 2014)
* Mt Sinai: Strategies for accelerating the genomic sequencing pipeline: [Mt Sinai workshop slides](https://github.com/chapmanb/bcbb/raw/master/talks/mtsinai2013_bcbio_nextgen/chapman_mtsinai_bcbio.pdf), [Mt Sinai workshop website](https://www.hpcwire.com/event/strategies-accelerating-genomic-sequencing-pipeline/)
* Genome Informatics 2013
* Bioinformatics Open Source Conference 2013: [BOSC 2013 Slides](https://chapmanb.github.io/bcbb/talks/bosc2013_bcbio_nextgen/chapmanb_bosc2013_bcbio.html#/), [BOSC 2013 Video](https://www.youtube.com/watch?v=dT5UEU0xF1Q), [BOSC 2013 Conference website](https://www.open-bio.org/wiki/BOSC_2013)
* Arvados Summit 2013: [Arvados Summit Slides](https://github.com/chapmanb/bcbb/raw/master/talks/arvados2013_bcbio_nextgen/chapman_arvadossum_bcbio.pdf), [Arvados Summit website](https://dev.arvados.org/projects/arvados/wiki/Arvados_Summit_-_Fall_2013)
* Scientific Python 2013: [SciPy 2013 Video](https://www.youtube.com/watch?v=qNMPh0pIpBE), [SciPy 2013 Conference website](https://conference.scipy.org/scipy2013/)

Feel free to reuse any images or text from these talks. The [slides are on GitHub](https://github.com/chapmanb/bcbb/tree/master/talks).

### Abstract

__Community Development of Validated Variant Calling Pipelines__

*Brad Chapman, Rory Kirchner, Oliver Hofmann and Winston Hide Harvard School of Public Health, Bioinformatics Core, Boston, MA, 02115*

Translational research relies on accurate identification of genomic variants. However, rapidly changing best practice approaches in alignment and variant calling, coupled with large data sizes, make it a challenge to create reliable and reproducible variant calls. Coordinated community development can help overcome these challenges by sharing testing and updates across multiple groups. We describe bcbio-nextgen, a distributed multi-architecture pipeline that automates variant calling, validation and organization of results for query and visualization. It creates an easily installable, reliable infrastructure from best-practice open source tools with the following goals:

* __Quantifiable:__ Validates variant calls against known reference materials developed by the [Genome in a Bottle](https://www.nist.gov/programs-projects/genome-bottle) consortium. The [bcbio.variation](https://github.com/chapmanb/bcbio.variation) toolkit automates scoring and assessment of calls to identify regressions in variant identification as calling pipelines evolve. Incorporation of multiple variant calling approaches from [Broad's GATK best practices](https://gatkforums.broadinstitute.org/gatk/discussion/1186/best-practice-variant-detection-with-the-gatk-v4-for-release-2-0) and the [Marth lab's gkno software](https://github.com/gkno/gkno_launcher) enables informed comparisons between current and future algorithms.
* __Scalable:__ bcbio-nextgen handles large population studies with hundreds of whole genome samples by parallelizing on a wide variety of schedulers and multicore machines, setting up different ad hoc cluster configurations for each workflow step. Work in progress includes integration with virtual environments, including [Amazon Web Services](https://aws.amazon.com/) and [OpenStack](https://www.openstack.org/).
* __Accessible:__ Results automatically feed into tools for query and investigation of variants. The [GEMINI framework](https://github.com/arq5x/gemini#readme) provides a queryable database associating variants with a wide variety of genome annotations. The [o8](https://github.com/chapmanb/o8#readme) web-based tool visualizes the work of variant prioritization and assessment.
* __Community developed:__ bcbio-nextgen is widely used in multiple sequencing centers and research laboratories. We actively encourage contributors to the code base and make it easy to get started with a fully automated installer and updater that prepares all third party software and reference genomes.

### Links from the presentation

* [HugeSeq](https://github.com/StanfordBioinformatics/HugeSeq)
* [Genome Comparison & Analytic Testing](https://www.mybiosoftware.com/gcat-genome-comparison-and-analytic-testing-platform.html) at Bioplanet
* [Peter Block's "Community" book](https://www.amazon.com/dp/1605092770)
* [CloudBioLinux](https://cloudbiolinux.org/) and [Homebrew Science](https://github.com/Homebrew/homebrew-science) as installation frameworks; [Conda](https://docs.conda.io/en/latest/) as Python environment
* [bcbio documentation at Read the Docs](https://bcbio-nextgen.readthedocs.io/en/latest/)
* [Arvados framework](https://arvados.org/) for meta data tracking, NGS processing and data provenance
* Notes on [improved scaling for NGS workflows](https://bcb.io/2013/05/22/scaling-variant-detection-pipelines-for-whole-genome-sequencing-analysis/)
* Genomic Reference Materials from [Genome in a Bottle](https://www.nist.gov/programs-projects/genome-bottle)
* Comparison of [aligners and callers](https://bcb.io/2013/05/06/framework-for-evaluating-variant-detection-methods-comparison-of-aligners-and-callers/) using NIST reference materials
* Callers and [minimal BAM preparation workflows](https://bcb.io/2013/10/21/updated-comparison-of-variant-detection-methods-ensemble-freebayes-and-minimal-bam-preparation-pipelines/)
* [Coverage assessment](https://github.com/chapmanb/bcbio.coverage)
