# ./play.it role-playing games collection

The codebase is maintained at [https://git.dotslashplay.it/games-rpg/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-rpg/]: https://git.dotslashplay.it/games-rpg/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only role-playing games. These games revolve around character development. Common features include world exploration, tactical or action-based battles, and a deep story. Both turn-based and real-time games are included.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for ./play.it, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-rpg play.it-rpg.git
cd play.it-rpg.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-rpg
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- A House of Many Doors
- Akalabeth: World of Doom
- Anima: Gate of Memories
- Arcanum: Of Steamworks and Magick Obscura
- Assassin's Creed
- Asura
- Baldur's Gate 3
- Batman: Arkham series:
    - Batman: Arkham Asylum
    - Batman: Arkham City
    - Batman: Arkham Origins
    - Batman: Arkham Knight
- Book of Demons
- Brütal Legend
- Cat Quest series:
    - Cat Quest
    - Cat Quest 2
- Children of Morta
- CrossCode
- Crypt of the NecroDancer
- Darksiders 2
- Deltarune
- Dex
- Din's Curse
- Divinity series:
    - Divine Divinity
    - Divinity: Original Sin
    - Divinity: Original Sin 2
- Dragon Age: Origins
- Dust: An Elysian Tail
- Earthlock
- Eschalon: Book 1
- Everspace
- Evoland series:
    - Evoland
    - Evoland 2
- Fallout series:
    - Fallout
    - Fallout 2
    - Fallout: New Vegas
- Gamedec
- Ghost of a Tale
- Hand of Fate
- Haven
- Hellblade: Senua's Sacrifice
- Horizon Zero Dawn
- Jade Empire
- Kingdom Come: Deliverance
- Knights of Pen and Paper
- Legend of Grimrock
- Lords of Xulima
- Minit
- Monster Sanctuary
- Neverwinter Nights
- Pier Solar and the Great Architects
- Rebel Galaxy
- Slay the Spire
- Sovereign Syndicate
- SteamWorld series:
    - SteamWorld Dig
    - SteamWorld Dig 2
    - SteamWorld Heist
    - SteamWorld Quest
- Stories: The Path of Destinies
- Sunless Skies
- System Shock 2
- The Bard's Tale 4
- The Binding of Isaac
- The Elder Scrolls series:
    - The Elder Scrolls: Arena
    - The Elder Scrolls 2: Daggerfall
    - The Elder Scrolls 5: Skyrim
- The Incredible Adventures of Van Helsing
- The Lamplighters League
- The Temple of Elemental Evil
- The Warlock of Firetop Mountain
- The Witcher series:
    - The Witcher 2
    - The Witcher 3
- Typing Chronicles series:
    - Epistory - Typing Chronicles
    - Nanotale - Typing Chronicles
- Ultima 4
- Undertale
- unEpic
- Vambrace: Cold Soul
- Vampire: The Masquerade - Redemption
- Victor Vran
- Warhammer 40k: Rogue Trader
- Ys Chronicles: Ancient Ys Vanished: Omen

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.

### Fediverse

./play.it has an account on the Fediverse, you can follow it for news about the development or use it to contact us: [@playit@fediverse.dotslashplay.it]

[@playit@fediverse.dotslashplay.it]: https://fediverse.dotslashplay.it/snac/playit
