/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Oct 29 08:18:05 EDT 2017 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_r2cf.native -fma -compact -variables 4 -pipeline-latency 4 -n 64 -name r2cfII_64 -dft-II -include rdft/scalar/r2cfII.h */

/*
 * This function contains 434 FP additions, 320 FP multiplications,
 * (or, 114 additions, 0 multiplications, 320 fused multiply/add),
 * 118 stack variables, 31 constants, and 128 memory accesses
 */
#include "rdft/scalar/r2cfII.h"

static void r2cfII_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP472964775, +0.472964775891319928124438237972992463904131113);
     DK(KP357805721, +0.357805721314524104672487743774474392487532769);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP741650546, +0.741650546272035369581266691172079863842265220);
     DK(KP148335987, +0.148335987538347428753676511486911367000625355);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP906347169, +0.906347169019147157946142717268914412664134293);
     DK(KP049126849, +0.049126849769467254105343321271313617079695752);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP599376933, +0.599376933681923766271389869014404232837890546);
     DK(KP250486960, +0.250486960191305461595702160124721208578685568);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E Tm, T35, T3Z, T5h, Tv, T34, T3W, T5g, Td, T33, T6z, T6N, T3T, T5f, T65;
	       E T6j, T2b, T3n, T4O, T5C, T2C, T3q, T4D, T5z, TK, T3b, T4e, T5l, TR, T3c;
	       E T4b, T5k, T15, T38, T47, T5o, T1c, T39, T44, T5n, T1s, T3g, T4v, T5v, T1T;
	       E T3j, T4k, T5s, T2u, T3r, T4R, T5A, T2F, T3o, T4K, T5D, T1L, T3k, T4y, T5t;
	       E T1W, T3h, T4r, T5w;
	       {
		    E Te, Tj, Th, Tk, Tf, Tg;
		    Te = R0[WS(rs, 14)];
		    Tj = R0[WS(rs, 30)];
		    Tf = R0[WS(rs, 6)];
		    Tg = R0[WS(rs, 22)];
		    Th = Tf + Tg;
		    Tk = Tg - Tf;
		    {
			 E Ti, Tl, T3X, T3Y;
			 Ti = FNMS(KP707106781, Th, Te);
			 Tl = FNMS(KP707106781, Tk, Tj);
			 Tm = FNMS(KP668178637, Tl, Ti);
			 T35 = FMA(KP668178637, Ti, Tl);
			 T3X = FMA(KP707106781, Th, Te);
			 T3Y = FMA(KP707106781, Tk, Tj);
			 T3Z = FMA(KP198912367, T3Y, T3X);
			 T5h = FNMS(KP198912367, T3X, T3Y);
		    }
	       }
	       {
		    E Tn, Ts, Tq, Tt, To, Tp;
		    Tn = R0[WS(rs, 18)];
		    Ts = R0[WS(rs, 2)];
		    To = R0[WS(rs, 10)];
		    Tp = R0[WS(rs, 26)];
		    Tq = To + Tp;
		    Tt = To - Tp;
		    {
			 E Tr, Tu, T3U, T3V;
			 Tr = FNMS(KP707106781, Tq, Tn);
			 Tu = FNMS(KP707106781, Tt, Ts);
			 Tv = FNMS(KP668178637, Tu, Tr);
			 T34 = FMA(KP668178637, Tr, Tu);
			 T3U = FMA(KP707106781, Tq, Tn);
			 T3V = FMA(KP707106781, Tt, Ts);
			 T3W = FMA(KP198912367, T3V, T3U);
			 T5g = FNMS(KP198912367, T3U, T3V);
		    }
	       }
	       {
		    E T1, T61, T4, T62, T8, T3Q, Tb, T3R, T2, T3;
		    T1 = R0[0];
		    T61 = R0[WS(rs, 16)];
		    T2 = R0[WS(rs, 8)];
		    T3 = R0[WS(rs, 24)];
		    T4 = T2 - T3;
		    T62 = T2 + T3;
		    {
			 E T6, T7, T9, Ta;
			 T6 = R0[WS(rs, 20)];
			 T7 = R0[WS(rs, 4)];
			 T8 = FMA(KP414213562, T7, T6);
			 T3Q = FNMS(KP414213562, T6, T7);
			 T9 = R0[WS(rs, 12)];
			 Ta = R0[WS(rs, 28)];
			 Tb = FMA(KP414213562, Ta, T9);
			 T3R = FMS(KP414213562, T9, Ta);
		    }
		    {
			 E T5, Tc, T6x, T6y;
			 T5 = FNMS(KP707106781, T4, T1);
			 Tc = T8 - Tb;
			 Td = FNMS(KP923879532, Tc, T5);
			 T33 = FMA(KP923879532, Tc, T5);
			 T6x = FNMS(KP707106781, T62, T61);
			 T6y = T3R - T3Q;
			 T6z = FMA(KP923879532, T6y, T6x);
			 T6N = FNMS(KP923879532, T6y, T6x);
		    }
		    {
			 E T3P, T3S, T63, T64;
			 T3P = FMA(KP707106781, T4, T1);
			 T3S = T3Q + T3R;
			 T3T = FNMS(KP923879532, T3S, T3P);
			 T5f = FMA(KP923879532, T3S, T3P);
			 T63 = FMA(KP707106781, T62, T61);
			 T64 = T8 + Tb;
			 T65 = FMA(KP923879532, T64, T63);
			 T6j = FNMS(KP923879532, T64, T63);
		    }
	       }
	       {
		    E T1Z, T2w, T22, T2x, T26, T2A, T29, T2z, T20, T21;
		    T1Z = R1[WS(rs, 31)];
		    T2w = R1[WS(rs, 15)];
		    T20 = R1[WS(rs, 7)];
		    T21 = R1[WS(rs, 23)];
		    T22 = T20 - T21;
		    T2x = T20 + T21;
		    {
			 E T24, T25, T27, T28;
			 T24 = R1[WS(rs, 19)];
			 T25 = R1[WS(rs, 3)];
			 T26 = FMA(KP414213562, T25, T24);
			 T2A = FNMS(KP414213562, T24, T25);
			 T27 = R1[WS(rs, 11)];
			 T28 = R1[WS(rs, 27)];
			 T29 = FMA(KP414213562, T28, T27);
			 T2z = FMS(KP414213562, T27, T28);
		    }
		    {
			 E T23, T2a, T4M, T4N;
			 T23 = FMA(KP707106781, T22, T1Z);
			 T2a = T26 - T29;
			 T2b = FMA(KP923879532, T2a, T23);
			 T3n = FNMS(KP923879532, T2a, T23);
			 T4M = FMA(KP707106781, T2x, T2w);
			 T4N = T26 + T29;
			 T4O = FNMS(KP923879532, T4N, T4M);
			 T5C = FMA(KP923879532, T4N, T4M);
		    }
		    {
			 E T2y, T2B, T4B, T4C;
			 T2y = FNMS(KP707106781, T2x, T2w);
			 T2B = T2z - T2A;
			 T2C = FNMS(KP923879532, T2B, T2y);
			 T3q = FMA(KP923879532, T2B, T2y);
			 T4B = FMS(KP707106781, T22, T1Z);
			 T4C = T2A + T2z;
			 T4D = FNMS(KP923879532, T4C, T4B);
			 T5z = FMA(KP923879532, T4C, T4B);
		    }
	       }
	       {
		    E Ty, TL, TB, TM, TF, TP, TI, TO, Tz, TA;
		    Ty = R0[WS(rs, 17)];
		    TL = R0[WS(rs, 1)];
		    Tz = R0[WS(rs, 9)];
		    TA = R0[WS(rs, 25)];
		    TB = Tz + TA;
		    TM = Tz - TA;
		    {
			 E TD, TE, TG, TH;
			 TD = R0[WS(rs, 29)];
			 TE = R0[WS(rs, 13)];
			 TF = FMS(KP414213562, TE, TD);
			 TP = FMA(KP414213562, TD, TE);
			 TG = R0[WS(rs, 5)];
			 TH = R0[WS(rs, 21)];
			 TI = FNMS(KP414213562, TH, TG);
			 TO = FMA(KP414213562, TG, TH);
		    }
		    {
			 E TC, TJ, T4c, T4d;
			 TC = FNMS(KP707106781, TB, Ty);
			 TJ = TF - TI;
			 TK = FNMS(KP923879532, TJ, TC);
			 T3b = FMA(KP923879532, TJ, TC);
			 T4c = FMA(KP707106781, TM, TL);
			 T4d = TI + TF;
			 T4e = FNMS(KP923879532, T4d, T4c);
			 T5l = FMA(KP923879532, T4d, T4c);
		    }
		    {
			 E TN, TQ, T49, T4a;
			 TN = FNMS(KP707106781, TM, TL);
			 TQ = TO - TP;
			 TR = FNMS(KP923879532, TQ, TN);
			 T3c = FMA(KP923879532, TQ, TN);
			 T49 = FMA(KP707106781, TB, Ty);
			 T4a = TO + TP;
			 T4b = FNMS(KP923879532, T4a, T49);
			 T5k = FMA(KP923879532, T4a, T49);
		    }
	       }
	       {
		    E TT, T16, TW, T17, T10, T1a, T13, T19, TU, TV;
		    TT = R0[WS(rs, 15)];
		    T16 = R0[WS(rs, 31)];
		    TU = R0[WS(rs, 7)];
		    TV = R0[WS(rs, 23)];
		    TW = TU + TV;
		    T17 = TV - TU;
		    {
			 E TY, TZ, T11, T12;
			 TY = R0[WS(rs, 3)];
			 TZ = R0[WS(rs, 19)];
			 T10 = FMS(KP414213562, TZ, TY);
			 T1a = FMA(KP414213562, TY, TZ);
			 T11 = R0[WS(rs, 27)];
			 T12 = R0[WS(rs, 11)];
			 T13 = FNMS(KP414213562, T12, T11);
			 T19 = FMA(KP414213562, T11, T12);
		    }
		    {
			 E TX, T14, T45, T46;
			 TX = FNMS(KP707106781, TW, TT);
			 T14 = T10 - T13;
			 T15 = FNMS(KP923879532, T14, TX);
			 T38 = FMA(KP923879532, T14, TX);
			 T45 = FMA(KP707106781, T17, T16);
			 T46 = T10 + T13;
			 T47 = FNMS(KP923879532, T46, T45);
			 T5o = FMA(KP923879532, T46, T45);
		    }
		    {
			 E T18, T1b, T42, T43;
			 T18 = FNMS(KP707106781, T17, T16);
			 T1b = T19 - T1a;
			 T1c = FNMS(KP923879532, T1b, T18);
			 T39 = FMA(KP923879532, T1b, T18);
			 T42 = FMA(KP707106781, TW, TT);
			 T43 = T1a + T19;
			 T44 = FNMS(KP923879532, T43, T42);
			 T5n = FMA(KP923879532, T43, T42);
		    }
	       }
	       {
		    E T1g, T1N, T1j, T1O, T1n, T1R, T1q, T1Q, T1h, T1i;
		    T1g = R1[0];
		    T1N = R1[WS(rs, 16)];
		    T1h = R1[WS(rs, 8)];
		    T1i = R1[WS(rs, 24)];
		    T1j = T1h - T1i;
		    T1O = T1h + T1i;
		    {
			 E T1l, T1m, T1o, T1p;
			 T1l = R1[WS(rs, 20)];
			 T1m = R1[WS(rs, 4)];
			 T1n = FMA(KP414213562, T1m, T1l);
			 T1R = FNMS(KP414213562, T1l, T1m);
			 T1o = R1[WS(rs, 12)];
			 T1p = R1[WS(rs, 28)];
			 T1q = FMA(KP414213562, T1p, T1o);
			 T1Q = FMS(KP414213562, T1o, T1p);
		    }
		    {
			 E T1k, T1r, T4t, T4u;
			 T1k = FNMS(KP707106781, T1j, T1g);
			 T1r = T1n - T1q;
			 T1s = FNMS(KP923879532, T1r, T1k);
			 T3g = FMA(KP923879532, T1r, T1k);
			 T4t = FMA(KP707106781, T1O, T1N);
			 T4u = T1n + T1q;
			 T4v = FNMS(KP923879532, T4u, T4t);
			 T5v = FMA(KP923879532, T4u, T4t);
		    }
		    {
			 E T1P, T1S, T4i, T4j;
			 T1P = FNMS(KP707106781, T1O, T1N);
			 T1S = T1Q - T1R;
			 T1T = FNMS(KP923879532, T1S, T1P);
			 T3j = FMA(KP923879532, T1S, T1P);
			 T4i = FMA(KP707106781, T1j, T1g);
			 T4j = T1R + T1Q;
			 T4k = FNMS(KP923879532, T4j, T4i);
			 T5s = FMA(KP923879532, T4j, T4i);
		    }
	       }
	       {
		    E T2g, T4I, T2j, T4H, T2p, T4F, T2s, T4E;
		    {
			 E T2c, T2h, T2f, T2i, T2d, T2e;
			 T2c = R1[WS(rs, 13)];
			 T2h = R1[WS(rs, 29)];
			 T2d = R1[WS(rs, 5)];
			 T2e = R1[WS(rs, 21)];
			 T2f = T2d + T2e;
			 T2i = T2d - T2e;
			 T2g = FNMS(KP707106781, T2f, T2c);
			 T4I = FMS(KP707106781, T2i, T2h);
			 T2j = FMA(KP707106781, T2i, T2h);
			 T4H = FMA(KP707106781, T2f, T2c);
		    }
		    {
			 E T2l, T2q, T2o, T2r, T2m, T2n;
			 T2l = R1[WS(rs, 17)];
			 T2q = R1[WS(rs, 1)];
			 T2m = R1[WS(rs, 9)];
			 T2n = R1[WS(rs, 25)];
			 T2o = T2m + T2n;
			 T2r = T2m - T2n;
			 T2p = FNMS(KP707106781, T2o, T2l);
			 T4F = FMA(KP707106781, T2r, T2q);
			 T2s = FNMS(KP707106781, T2r, T2q);
			 T4E = FMA(KP707106781, T2o, T2l);
		    }
		    {
			 E T2k, T2t, T4P, T4Q;
			 T2k = FNMS(KP668178637, T2j, T2g);
			 T2t = FNMS(KP668178637, T2s, T2p);
			 T2u = T2k - T2t;
			 T3r = T2t + T2k;
			 T4P = FMA(KP198912367, T4H, T4I);
			 T4Q = FNMS(KP198912367, T4E, T4F);
			 T4R = T4P - T4Q;
			 T5A = T4Q + T4P;
		    }
		    {
			 E T2D, T2E, T4G, T4J;
			 T2D = FMA(KP668178637, T2p, T2s);
			 T2E = FMA(KP668178637, T2g, T2j);
			 T2F = T2D + T2E;
			 T3o = T2D - T2E;
			 T4G = FMA(KP198912367, T4F, T4E);
			 T4J = FNMS(KP198912367, T4I, T4H);
			 T4K = T4G - T4J;
			 T5D = T4G + T4J;
		    }
	       }
	       {
		    E T1x, T4p, T1A, T4o, T1G, T4m, T1J, T4l;
		    {
			 E T1t, T1y, T1w, T1z, T1u, T1v;
			 T1t = R1[WS(rs, 14)];
			 T1y = R1[WS(rs, 30)];
			 T1u = R1[WS(rs, 6)];
			 T1v = R1[WS(rs, 22)];
			 T1w = T1u + T1v;
			 T1z = T1u - T1v;
			 T1x = FNMS(KP707106781, T1w, T1t);
			 T4p = FMS(KP707106781, T1z, T1y);
			 T1A = FMA(KP707106781, T1z, T1y);
			 T4o = FMA(KP707106781, T1w, T1t);
		    }
		    {
			 E T1C, T1H, T1F, T1I, T1D, T1E;
			 T1C = R1[WS(rs, 18)];
			 T1H = R1[WS(rs, 2)];
			 T1D = R1[WS(rs, 10)];
			 T1E = R1[WS(rs, 26)];
			 T1F = T1D + T1E;
			 T1I = T1D - T1E;
			 T1G = FNMS(KP707106781, T1F, T1C);
			 T4m = FMA(KP707106781, T1I, T1H);
			 T1J = FNMS(KP707106781, T1I, T1H);
			 T4l = FMA(KP707106781, T1F, T1C);
		    }
		    {
			 E T1B, T1K, T4w, T4x;
			 T1B = FNMS(KP668178637, T1A, T1x);
			 T1K = FNMS(KP668178637, T1J, T1G);
			 T1L = T1B - T1K;
			 T3k = T1K + T1B;
			 T4w = FMA(KP198912367, T4o, T4p);
			 T4x = FNMS(KP198912367, T4l, T4m);
			 T4y = T4w - T4x;
			 T5t = T4x + T4w;
		    }
		    {
			 E T1U, T1V, T4n, T4q;
			 T1U = FMA(KP668178637, T1G, T1J);
			 T1V = FMA(KP668178637, T1x, T1A);
			 T1W = T1U + T1V;
			 T3h = T1U - T1V;
			 T4n = FMA(KP198912367, T4m, T4l);
			 T4q = FNMS(KP198912367, T4p, T4o);
			 T4r = T4n - T4q;
			 T5w = T4n + T4q;
		    }
	       }
	       {
		    E Tx, T2N, T6P, T6V, T1e, T6Q, T2X, T31, T1Y, T2L, T2Q, T6W, T2U, T30, T2H;
		    E T2K, Tw, T6O;
		    Tw = Tm - Tv;
		    Tx = FNMS(KP831469612, Tw, Td);
		    T2N = FMA(KP831469612, Tw, Td);
		    T6O = T34 + T35;
		    T6P = FMA(KP831469612, T6O, T6N);
		    T6V = FNMS(KP831469612, T6O, T6N);
		    {
			 E TS, T1d, T2V, T2W;
			 TS = FMA(KP534511135, TR, TK);
			 T1d = FMA(KP534511135, T1c, T15);
			 T1e = TS - T1d;
			 T6Q = TS + T1d;
			 T2V = FNMS(KP831469612, T2u, T2b);
			 T2W = FMA(KP831469612, T2F, T2C);
			 T2X = FNMS(KP250486960, T2W, T2V);
			 T31 = FMA(KP250486960, T2V, T2W);
		    }
		    {
			 E T1M, T1X, T2O, T2P;
			 T1M = FNMS(KP831469612, T1L, T1s);
			 T1X = FNMS(KP831469612, T1W, T1T);
			 T1Y = FMA(KP599376933, T1X, T1M);
			 T2L = FNMS(KP599376933, T1M, T1X);
			 T2O = FNMS(KP534511135, TK, TR);
			 T2P = FNMS(KP534511135, T15, T1c);
			 T2Q = T2O - T2P;
			 T6W = T2O + T2P;
		    }
		    {
			 E T2S, T2T, T2v, T2G;
			 T2S = FMA(KP831469612, T1L, T1s);
			 T2T = FMA(KP831469612, T1W, T1T);
			 T2U = FNMS(KP250486960, T2T, T2S);
			 T30 = FMA(KP250486960, T2S, T2T);
			 T2v = FMA(KP831469612, T2u, T2b);
			 T2G = FNMS(KP831469612, T2F, T2C);
			 T2H = FMA(KP599376933, T2G, T2v);
			 T2K = FNMS(KP599376933, T2v, T2G);
		    }
		    {
			 E T1f, T2I, T6X, T6Y;
			 T1f = FMA(KP881921264, T1e, Tx);
			 T2I = T1Y - T2H;
			 Cr[WS(csr, 26)] = FNMS(KP857728610, T2I, T1f);
			 Cr[WS(csr, 5)] = FMA(KP857728610, T2I, T1f);
			 T6X = FNMS(KP881921264, T6W, T6V);
			 T6Y = T2L + T2K;
			 Ci[WS(csi, 26)] = FMS(KP857728610, T6Y, T6X);
			 Ci[WS(csi, 5)] = FMA(KP857728610, T6Y, T6X);
		    }
		    {
			 E T2J, T2M, T6Z, T70;
			 T2J = FNMS(KP881921264, T1e, Tx);
			 T2M = T2K - T2L;
			 Cr[WS(csr, 21)] = FNMS(KP857728610, T2M, T2J);
			 Cr[WS(csr, 10)] = FMA(KP857728610, T2M, T2J);
			 T6Z = FMA(KP881921264, T6W, T6V);
			 T70 = T1Y + T2H;
			 Ci[WS(csi, 10)] = -(FMA(KP857728610, T70, T6Z));
			 Ci[WS(csi, 21)] = FNMS(KP857728610, T70, T6Z);
		    }
		    {
			 E T2R, T2Y, T6R, T6S;
			 T2R = FMA(KP881921264, T2Q, T2N);
			 T2Y = T2U - T2X;
			 Cr[WS(csr, 29)] = FNMS(KP970031253, T2Y, T2R);
			 Cr[WS(csr, 2)] = FMA(KP970031253, T2Y, T2R);
			 T6R = FMA(KP881921264, T6Q, T6P);
			 T6S = T30 + T31;
			 Ci[WS(csi, 2)] = -(FMA(KP970031253, T6S, T6R));
			 Ci[WS(csi, 29)] = FNMS(KP970031253, T6S, T6R);
		    }
		    {
			 E T2Z, T32, T6T, T6U;
			 T2Z = FNMS(KP881921264, T2Q, T2N);
			 T32 = T30 - T31;
			 Cr[WS(csr, 18)] = FNMS(KP970031253, T32, T2Z);
			 Cr[WS(csr, 13)] = FMA(KP970031253, T32, T2Z);
			 T6T = FNMS(KP881921264, T6Q, T6P);
			 T6U = T2U + T2X;
			 Ci[WS(csi, 18)] = -(FMA(KP970031253, T6U, T6T));
			 Ci[WS(csi, 13)] = FNMS(KP970031253, T6U, T6T);
		    }
	       }
	       {
		    E T5j, T5L, T67, T6d, T5q, T68, T5V, T5Z, T5y, T5J, T5O, T6e, T5S, T5Y, T5F;
		    E T5I, T5i, T66;
		    T5i = T5g - T5h;
		    T5j = FNMS(KP980785280, T5i, T5f);
		    T5L = FMA(KP980785280, T5i, T5f);
		    T66 = T3W + T3Z;
		    T67 = FMA(KP980785280, T66, T65);
		    T6d = FNMS(KP980785280, T66, T65);
		    {
			 E T5m, T5p, T5T, T5U;
			 T5m = FMA(KP098491403, T5l, T5k);
			 T5p = FMA(KP098491403, T5o, T5n);
			 T5q = T5m - T5p;
			 T68 = T5m + T5p;
			 T5T = FMA(KP980785280, T5A, T5z);
			 T5U = FMA(KP980785280, T5D, T5C);
			 T5V = FMA(KP049126849, T5U, T5T);
			 T5Z = FNMS(KP049126849, T5T, T5U);
		    }
		    {
			 E T5u, T5x, T5M, T5N;
			 T5u = FNMS(KP980785280, T5t, T5s);
			 T5x = FNMS(KP980785280, T5w, T5v);
			 T5y = FMA(KP906347169, T5x, T5u);
			 T5J = FNMS(KP906347169, T5u, T5x);
			 T5M = FNMS(KP098491403, T5k, T5l);
			 T5N = FNMS(KP098491403, T5n, T5o);
			 T5O = T5M - T5N;
			 T6e = T5M + T5N;
		    }
		    {
			 E T5Q, T5R, T5B, T5E;
			 T5Q = FMA(KP980785280, T5t, T5s);
			 T5R = FMA(KP980785280, T5w, T5v);
			 T5S = FNMS(KP049126849, T5R, T5Q);
			 T5Y = FMA(KP049126849, T5Q, T5R);
			 T5B = FNMS(KP980785280, T5A, T5z);
			 T5E = FNMS(KP980785280, T5D, T5C);
			 T5F = FNMS(KP906347169, T5E, T5B);
			 T5I = FMA(KP906347169, T5B, T5E);
		    }
		    {
			 E T5r, T5G, T6f, T6g;
			 T5r = FMA(KP995184726, T5q, T5j);
			 T5G = T5y + T5F;
			 Cr[WS(csr, 24)] = FNMS(KP740951125, T5G, T5r);
			 Cr[WS(csr, 7)] = FMA(KP740951125, T5G, T5r);
			 T6f = FNMS(KP995184726, T6e, T6d);
			 T6g = T5J + T5I;
			 Ci[WS(csi, 24)] = FMS(KP740951125, T6g, T6f);
			 Ci[WS(csi, 7)] = FMA(KP740951125, T6g, T6f);
		    }
		    {
			 E T5H, T5K, T6h, T6i;
			 T5H = FNMS(KP995184726, T5q, T5j);
			 T5K = T5I - T5J;
			 Cr[WS(csr, 23)] = FNMS(KP740951125, T5K, T5H);
			 Cr[WS(csr, 8)] = FMA(KP740951125, T5K, T5H);
			 T6h = FMA(KP995184726, T6e, T6d);
			 T6i = T5F - T5y;
			 Ci[WS(csi, 8)] = FMS(KP740951125, T6i, T6h);
			 Ci[WS(csi, 23)] = FMA(KP740951125, T6i, T6h);
		    }
		    {
			 E T5P, T5W, T69, T6a;
			 T5P = FMA(KP995184726, T5O, T5L);
			 T5W = T5S + T5V;
			 Cr[WS(csr, 31)] = FNMS(KP998795456, T5W, T5P);
			 Cr[0] = FMA(KP998795456, T5W, T5P);
			 T69 = FMA(KP995184726, T68, T67);
			 T6a = T5Y + T5Z;
			 Ci[0] = -(FMA(KP998795456, T6a, T69));
			 Ci[WS(csi, 31)] = FNMS(KP998795456, T6a, T69);
		    }
		    {
			 E T5X, T60, T6b, T6c;
			 T5X = FNMS(KP995184726, T5O, T5L);
			 T60 = T5Y - T5Z;
			 Cr[WS(csr, 16)] = FNMS(KP998795456, T60, T5X);
			 Cr[WS(csr, 15)] = FMA(KP998795456, T60, T5X);
			 T6b = FNMS(KP995184726, T68, T67);
			 T6c = T5V - T5S;
			 Ci[WS(csi, 16)] = FMS(KP998795456, T6c, T6b);
			 Ci[WS(csi, 15)] = FMA(KP998795456, T6c, T6b);
		    }
	       }
	       {
		    E T37, T3z, T6B, T6H, T3e, T6C, T3J, T3M, T3m, T3w, T3C, T6I, T3G, T3N, T3t;
		    E T3x, T36, T6A;
		    T36 = T34 - T35;
		    T37 = FNMS(KP831469612, T36, T33);
		    T3z = FMA(KP831469612, T36, T33);
		    T6A = Tv + Tm;
		    T6B = FMA(KP831469612, T6A, T6z);
		    T6H = FNMS(KP831469612, T6A, T6z);
		    {
			 E T3a, T3d, T3H, T3I;
			 T3a = FNMS(KP303346683, T39, T38);
			 T3d = FNMS(KP303346683, T3c, T3b);
			 T3e = T3a - T3d;
			 T6C = T3d + T3a;
			 T3H = FNMS(KP831469612, T3o, T3n);
			 T3I = FMA(KP831469612, T3r, T3q);
			 T3J = FMA(KP148335987, T3I, T3H);
			 T3M = FNMS(KP148335987, T3H, T3I);
		    }
		    {
			 E T3i, T3l, T3A, T3B;
			 T3i = FNMS(KP831469612, T3h, T3g);
			 T3l = FNMS(KP831469612, T3k, T3j);
			 T3m = FNMS(KP741650546, T3l, T3i);
			 T3w = FMA(KP741650546, T3i, T3l);
			 T3A = FMA(KP303346683, T3b, T3c);
			 T3B = FMA(KP303346683, T38, T39);
			 T3C = T3A - T3B;
			 T6I = T3A + T3B;
		    }
		    {
			 E T3E, T3F, T3p, T3s;
			 T3E = FMA(KP831469612, T3h, T3g);
			 T3F = FMA(KP831469612, T3k, T3j);
			 T3G = FMA(KP148335987, T3F, T3E);
			 T3N = FNMS(KP148335987, T3E, T3F);
			 T3p = FMA(KP831469612, T3o, T3n);
			 T3s = FNMS(KP831469612, T3r, T3q);
			 T3t = FNMS(KP741650546, T3s, T3p);
			 T3x = FMA(KP741650546, T3p, T3s);
		    }
		    {
			 E T3f, T3u, T6J, T6K;
			 T3f = FMA(KP956940335, T3e, T37);
			 T3u = T3m - T3t;
			 Cr[WS(csr, 25)] = FNMS(KP803207531, T3u, T3f);
			 Cr[WS(csr, 6)] = FMA(KP803207531, T3u, T3f);
			 T6J = FMA(KP956940335, T6I, T6H);
			 T6K = T3w + T3x;
			 Ci[WS(csi, 6)] = -(FMA(KP803207531, T6K, T6J));
			 Ci[WS(csi, 25)] = FNMS(KP803207531, T6K, T6J);
		    }
		    {
			 E T3v, T3y, T6L, T6M;
			 T3v = FNMS(KP956940335, T3e, T37);
			 T3y = T3w - T3x;
			 Cr[WS(csr, 22)] = FNMS(KP803207531, T3y, T3v);
			 Cr[WS(csr, 9)] = FMA(KP803207531, T3y, T3v);
			 T6L = FNMS(KP956940335, T6I, T6H);
			 T6M = T3m + T3t;
			 Ci[WS(csi, 22)] = -(FMA(KP803207531, T6M, T6L));
			 Ci[WS(csi, 9)] = FNMS(KP803207531, T6M, T6L);
		    }
		    {
			 E T3D, T3K, T6D, T6E;
			 T3D = FMA(KP956940335, T3C, T3z);
			 T3K = T3G - T3J;
			 Cr[WS(csr, 30)] = FNMS(KP989176509, T3K, T3D);
			 Cr[WS(csr, 1)] = FMA(KP989176509, T3K, T3D);
			 T6D = FMA(KP956940335, T6C, T6B);
			 T6E = T3N + T3M;
			 Ci[WS(csi, 30)] = FMS(KP989176509, T6E, T6D);
			 Ci[WS(csi, 1)] = FMA(KP989176509, T6E, T6D);
		    }
		    {
			 E T3L, T3O, T6F, T6G;
			 T3L = FNMS(KP956940335, T3C, T3z);
			 T3O = T3M - T3N;
			 Cr[WS(csr, 17)] = FNMS(KP989176509, T3O, T3L);
			 Cr[WS(csr, 14)] = FMA(KP989176509, T3O, T3L);
			 T6F = FNMS(KP956940335, T6C, T6B);
			 T6G = T3G + T3J;
			 Ci[WS(csi, 14)] = -(FMA(KP989176509, T6G, T6F));
			 Ci[WS(csi, 17)] = FNMS(KP989176509, T6G, T6F);
		    }
	       }
	       {
		    E T41, T4Z, T6l, T6r, T4g, T6m, T59, T5c, T4A, T4W, T52, T6s, T56, T5d, T4T;
		    E T4X, T40, T6k;
		    T40 = T3W - T3Z;
		    T41 = FNMS(KP980785280, T40, T3T);
		    T4Z = FMA(KP980785280, T40, T3T);
		    T6k = T5g + T5h;
		    T6l = FNMS(KP980785280, T6k, T6j);
		    T6r = FMA(KP980785280, T6k, T6j);
		    {
			 E T48, T4f, T57, T58;
			 T48 = FNMS(KP820678790, T47, T44);
			 T4f = FNMS(KP820678790, T4e, T4b);
			 T4g = T48 - T4f;
			 T6m = T4f + T48;
			 T57 = FMA(KP980785280, T4K, T4D);
			 T58 = FMA(KP980785280, T4R, T4O);
			 T59 = FNMS(KP357805721, T58, T57);
			 T5c = FMA(KP357805721, T57, T58);
		    }
		    {
			 E T4s, T4z, T50, T51;
			 T4s = FNMS(KP980785280, T4r, T4k);
			 T4z = FNMS(KP980785280, T4y, T4v);
			 T4A = FNMS(KP472964775, T4z, T4s);
			 T4W = FMA(KP472964775, T4s, T4z);
			 T50 = FMA(KP820678790, T4b, T4e);
			 T51 = FMA(KP820678790, T44, T47);
			 T52 = T50 - T51;
			 T6s = T50 + T51;
		    }
		    {
			 E T54, T55, T4L, T4S;
			 T54 = FMA(KP980785280, T4r, T4k);
			 T55 = FMA(KP980785280, T4y, T4v);
			 T56 = FMA(KP357805721, T55, T54);
			 T5d = FNMS(KP357805721, T54, T55);
			 T4L = FNMS(KP980785280, T4K, T4D);
			 T4S = FNMS(KP980785280, T4R, T4O);
			 T4T = FMA(KP472964775, T4S, T4L);
			 T4X = FNMS(KP472964775, T4L, T4S);
		    }
		    {
			 E T4h, T4U, T6t, T6u;
			 T4h = FMA(KP773010453, T4g, T41);
			 T4U = T4A + T4T;
			 Cr[WS(csr, 27)] = FNMS(KP903989293, T4U, T4h);
			 Cr[WS(csr, 4)] = FMA(KP903989293, T4U, T4h);
			 T6t = FMA(KP773010453, T6s, T6r);
			 T6u = T4W + T4X;
			 Ci[WS(csi, 4)] = -(FMA(KP903989293, T6u, T6t));
			 Ci[WS(csi, 27)] = FNMS(KP903989293, T6u, T6t);
		    }
		    {
			 E T4V, T4Y, T6v, T6w;
			 T4V = FNMS(KP773010453, T4g, T41);
			 T4Y = T4W - T4X;
			 Cr[WS(csr, 20)] = FNMS(KP903989293, T4Y, T4V);
			 Cr[WS(csr, 11)] = FMA(KP903989293, T4Y, T4V);
			 T6v = FNMS(KP773010453, T6s, T6r);
			 T6w = T4T - T4A;
			 Ci[WS(csi, 20)] = FMS(KP903989293, T6w, T6v);
			 Ci[WS(csi, 11)] = FMA(KP903989293, T6w, T6v);
		    }
		    {
			 E T53, T5a, T6n, T6o;
			 T53 = FMA(KP773010453, T52, T4Z);
			 T5a = T56 + T59;
			 Cr[WS(csr, 28)] = FNMS(KP941544065, T5a, T53);
			 Cr[WS(csr, 3)] = FMA(KP941544065, T5a, T53);
			 T6n = FMA(KP773010453, T6m, T6l);
			 T6o = T5d + T5c;
			 Ci[WS(csi, 28)] = FMS(KP941544065, T6o, T6n);
			 Ci[WS(csi, 3)] = FMA(KP941544065, T6o, T6n);
		    }
		    {
			 E T5b, T5e, T6p, T6q;
			 T5b = FNMS(KP773010453, T52, T4Z);
			 T5e = T5c - T5d;
			 Cr[WS(csr, 19)] = FNMS(KP941544065, T5e, T5b);
			 Cr[WS(csr, 12)] = FMA(KP941544065, T5e, T5b);
			 T6p = FNMS(KP773010453, T6m, T6l);
			 T6q = T59 - T56;
			 Ci[WS(csi, 12)] = FMS(KP941544065, T6q, T6p);
			 Ci[WS(csi, 19)] = FMA(KP941544065, T6q, T6p);
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cfII_64", {114, 0, 320, 0}, &GENUS };

void X(codelet_r2cfII_64) (planner *p) {
     X(kr2c_register) (p, r2cfII_64, &desc);
}

#else

/* Generated by: ../../../genfft/gen_r2cf.native -compact -variables 4 -pipeline-latency 4 -n 64 -name r2cfII_64 -dft-II -include rdft/scalar/r2cfII.h */

/*
 * This function contains 434 FP additions, 206 FP multiplications,
 * (or, 342 additions, 114 multiplications, 92 fused multiply/add),
 * 118 stack variables, 31 constants, and 128 memory accesses
 */
#include "rdft/scalar/r2cfII.h"

static void r2cfII_64(R *R0, R *R1, R *Cr, R *Ci, stride rs, stride csr, stride csi, INT v, INT ivs, INT ovs)
{
     DK(KP242980179, +0.242980179903263889948274162077471118320990783);
     DK(KP970031253, +0.970031253194543992603984207286100251456865962);
     DK(KP857728610, +0.857728610000272069902269984284770137042490799);
     DK(KP514102744, +0.514102744193221726593693838968815772608049120);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP427555093, +0.427555093430282094320966856888798534304578629);
     DK(KP903989293, +0.903989293123443331586200297230537048710132025);
     DK(KP336889853, +0.336889853392220050689253212619147570477766780);
     DK(KP941544065, +0.941544065183020778412509402599502357185589796);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP595699304, +0.595699304492433343467036528829969889511926338);
     DK(KP803207531, +0.803207531480644909806676512963141923879569427);
     DK(KP146730474, +0.146730474455361751658850129646717819706215317);
     DK(KP989176509, +0.989176509964780973451673738016243063983689533);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP049067674, +0.049067674327418014254954976942682658314745363);
     DK(KP998795456, +0.998795456205172392714771604759100694443203615);
     DK(KP671558954, +0.671558954847018400625376850427421803228750632);
     DK(KP740951125, +0.740951125354959091175616897495162729728955309);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - 1, R0 = R0 + ivs, R1 = R1 + ivs, Cr = Cr + ovs, Ci = Ci + ovs, MAKE_VOLATILE_STRIDE(256, rs), MAKE_VOLATILE_STRIDE(256, csr), MAKE_VOLATILE_STRIDE(256, csi)) {
	       E Tm, T34, T3Z, T5g, Tv, T35, T3W, T5h, Td, T33, T6B, T6Q, T3T, T5f, T68;
	       E T6m, T2b, T3n, T4O, T5D, T2F, T3r, T4K, T5z, TK, T3c, T47, T5n, TR, T3b;
	       E T44, T5o, T15, T38, T4e, T5l, T1c, T39, T4b, T5k, T1s, T3g, T4v, T5w, T1W;
	       E T3k, T4k, T5s, T2u, T3q, T4R, T5A, T2y, T3o, T4H, T5C, T1L, T3j, T4y, T5t;
	       E T1P, T3h, T4r, T5v;
	       {
		    E Te, Tk, Th, Tj, Tf, Tg;
		    Te = R0[WS(rs, 2)];
		    Tk = R0[WS(rs, 18)];
		    Tf = R0[WS(rs, 10)];
		    Tg = R0[WS(rs, 26)];
		    Th = KP707106781 * (Tf - Tg);
		    Tj = KP707106781 * (Tf + Tg);
		    {
			 E Ti, Tl, T3X, T3Y;
			 Ti = Te + Th;
			 Tl = Tj + Tk;
			 Tm = FNMS(KP195090322, Tl, KP980785280 * Ti);
			 T34 = FMA(KP195090322, Ti, KP980785280 * Tl);
			 T3X = Tk - Tj;
			 T3Y = Te - Th;
			 T3Z = FNMS(KP555570233, T3Y, KP831469612 * T3X);
			 T5g = FMA(KP831469612, T3Y, KP555570233 * T3X);
		    }
	       }
	       {
		    E Tq, Tt, Tp, Ts, Tn, To;
		    Tq = R0[WS(rs, 30)];
		    Tt = R0[WS(rs, 14)];
		    Tn = R0[WS(rs, 6)];
		    To = R0[WS(rs, 22)];
		    Tp = KP707106781 * (Tn - To);
		    Ts = KP707106781 * (Tn + To);
		    {
			 E Tr, Tu, T3U, T3V;
			 Tr = Tp - Tq;
			 Tu = Ts + Tt;
			 Tv = FMA(KP980785280, Tr, KP195090322 * Tu);
			 T35 = FNMS(KP980785280, Tu, KP195090322 * Tr);
			 T3U = Tt - Ts;
			 T3V = Tp + Tq;
			 T3W = FNMS(KP555570233, T3V, KP831469612 * T3U);
			 T5h = FMA(KP831469612, T3V, KP555570233 * T3U);
		    }
	       }
	       {
		    E T1, T66, T4, T65, T8, T3Q, Tb, T3R, T2, T3;
		    T1 = R0[0];
		    T66 = R0[WS(rs, 16)];
		    T2 = R0[WS(rs, 8)];
		    T3 = R0[WS(rs, 24)];
		    T4 = KP707106781 * (T2 - T3);
		    T65 = KP707106781 * (T2 + T3);
		    {
			 E T6, T7, T9, Ta;
			 T6 = R0[WS(rs, 4)];
			 T7 = R0[WS(rs, 20)];
			 T8 = FNMS(KP382683432, T7, KP923879532 * T6);
			 T3Q = FMA(KP382683432, T6, KP923879532 * T7);
			 T9 = R0[WS(rs, 12)];
			 Ta = R0[WS(rs, 28)];
			 Tb = FNMS(KP923879532, Ta, KP382683432 * T9);
			 T3R = FMA(KP923879532, T9, KP382683432 * Ta);
		    }
		    {
			 E T5, Tc, T6z, T6A;
			 T5 = T1 + T4;
			 Tc = T8 + Tb;
			 Td = T5 + Tc;
			 T33 = T5 - Tc;
			 T6z = Tb - T8;
			 T6A = T66 - T65;
			 T6B = T6z - T6A;
			 T6Q = T6z + T6A;
		    }
		    {
			 E T3P, T3S, T64, T67;
			 T3P = T1 - T4;
			 T3S = T3Q - T3R;
			 T3T = T3P - T3S;
			 T5f = T3P + T3S;
			 T64 = T3Q + T3R;
			 T67 = T65 + T66;
			 T68 = T64 + T67;
			 T6m = T67 - T64;
		    }
	       }
	       {
		    E T22, T2D, T21, T2C, T26, T2z, T29, T2A, T1Z, T20;
		    T22 = R1[WS(rs, 31)];
		    T2D = R1[WS(rs, 15)];
		    T1Z = R1[WS(rs, 7)];
		    T20 = R1[WS(rs, 23)];
		    T21 = KP707106781 * (T1Z - T20);
		    T2C = KP707106781 * (T1Z + T20);
		    {
			 E T24, T25, T27, T28;
			 T24 = R1[WS(rs, 3)];
			 T25 = R1[WS(rs, 19)];
			 T26 = FNMS(KP382683432, T25, KP923879532 * T24);
			 T2z = FMA(KP382683432, T24, KP923879532 * T25);
			 T27 = R1[WS(rs, 11)];
			 T28 = R1[WS(rs, 27)];
			 T29 = FNMS(KP923879532, T28, KP382683432 * T27);
			 T2A = FMA(KP923879532, T27, KP382683432 * T28);
		    }
		    {
			 E T23, T2a, T4M, T4N;
			 T23 = T21 - T22;
			 T2a = T26 + T29;
			 T2b = T23 + T2a;
			 T3n = T23 - T2a;
			 T4M = T29 - T26;
			 T4N = T2D - T2C;
			 T4O = T4M - T4N;
			 T5D = T4M + T4N;
		    }
		    {
			 E T2B, T2E, T4I, T4J;
			 T2B = T2z + T2A;
			 T2E = T2C + T2D;
			 T2F = T2B + T2E;
			 T3r = T2E - T2B;
			 T4I = T21 + T22;
			 T4J = T2z - T2A;
			 T4K = T4I + T4J;
			 T5z = T4J - T4I;
		    }
	       }
	       {
		    E Ty, TP, TB, TO, TF, TL, TI, TM, Tz, TA;
		    Ty = R0[WS(rs, 1)];
		    TP = R0[WS(rs, 17)];
		    Tz = R0[WS(rs, 9)];
		    TA = R0[WS(rs, 25)];
		    TB = KP707106781 * (Tz - TA);
		    TO = KP707106781 * (Tz + TA);
		    {
			 E TD, TE, TG, TH;
			 TD = R0[WS(rs, 5)];
			 TE = R0[WS(rs, 21)];
			 TF = FNMS(KP382683432, TE, KP923879532 * TD);
			 TL = FMA(KP382683432, TD, KP923879532 * TE);
			 TG = R0[WS(rs, 13)];
			 TH = R0[WS(rs, 29)];
			 TI = FNMS(KP923879532, TH, KP382683432 * TG);
			 TM = FMA(KP923879532, TG, KP382683432 * TH);
		    }
		    {
			 E TC, TJ, T45, T46;
			 TC = Ty + TB;
			 TJ = TF + TI;
			 TK = TC + TJ;
			 T3c = TC - TJ;
			 T45 = TI - TF;
			 T46 = TP - TO;
			 T47 = T45 - T46;
			 T5n = T45 + T46;
		    }
		    {
			 E TN, TQ, T42, T43;
			 TN = TL + TM;
			 TQ = TO + TP;
			 TR = TN + TQ;
			 T3b = TQ - TN;
			 T42 = Ty - TB;
			 T43 = TL - TM;
			 T44 = T42 - T43;
			 T5o = T42 + T43;
		    }
	       }
	       {
		    E TW, T1a, TV, T19, T10, T16, T13, T17, TT, TU;
		    TW = R0[WS(rs, 31)];
		    T1a = R0[WS(rs, 15)];
		    TT = R0[WS(rs, 7)];
		    TU = R0[WS(rs, 23)];
		    TV = KP707106781 * (TT - TU);
		    T19 = KP707106781 * (TT + TU);
		    {
			 E TY, TZ, T11, T12;
			 TY = R0[WS(rs, 3)];
			 TZ = R0[WS(rs, 19)];
			 T10 = FNMS(KP382683432, TZ, KP923879532 * TY);
			 T16 = FMA(KP382683432, TY, KP923879532 * TZ);
			 T11 = R0[WS(rs, 11)];
			 T12 = R0[WS(rs, 27)];
			 T13 = FNMS(KP923879532, T12, KP382683432 * T11);
			 T17 = FMA(KP923879532, T11, KP382683432 * T12);
		    }
		    {
			 E TX, T14, T4c, T4d;
			 TX = TV - TW;
			 T14 = T10 + T13;
			 T15 = TX + T14;
			 T38 = TX - T14;
			 T4c = T13 - T10;
			 T4d = T1a - T19;
			 T4e = T4c - T4d;
			 T5l = T4c + T4d;
		    }
		    {
			 E T18, T1b, T49, T4a;
			 T18 = T16 + T17;
			 T1b = T19 + T1a;
			 T1c = T18 + T1b;
			 T39 = T1b - T18;
			 T49 = TV + TW;
			 T4a = T16 - T17;
			 T4b = T49 + T4a;
			 T5k = T4a - T49;
		    }
	       }
	       {
		    E T1g, T1U, T1j, T1T, T1n, T1Q, T1q, T1R, T1h, T1i;
		    T1g = R1[0];
		    T1U = R1[WS(rs, 16)];
		    T1h = R1[WS(rs, 8)];
		    T1i = R1[WS(rs, 24)];
		    T1j = KP707106781 * (T1h - T1i);
		    T1T = KP707106781 * (T1h + T1i);
		    {
			 E T1l, T1m, T1o, T1p;
			 T1l = R1[WS(rs, 4)];
			 T1m = R1[WS(rs, 20)];
			 T1n = FNMS(KP382683432, T1m, KP923879532 * T1l);
			 T1Q = FMA(KP382683432, T1l, KP923879532 * T1m);
			 T1o = R1[WS(rs, 12)];
			 T1p = R1[WS(rs, 28)];
			 T1q = FNMS(KP923879532, T1p, KP382683432 * T1o);
			 T1R = FMA(KP923879532, T1o, KP382683432 * T1p);
		    }
		    {
			 E T1k, T1r, T4t, T4u;
			 T1k = T1g + T1j;
			 T1r = T1n + T1q;
			 T1s = T1k + T1r;
			 T3g = T1k - T1r;
			 T4t = T1q - T1n;
			 T4u = T1U - T1T;
			 T4v = T4t - T4u;
			 T5w = T4t + T4u;
		    }
		    {
			 E T1S, T1V, T4i, T4j;
			 T1S = T1Q + T1R;
			 T1V = T1T + T1U;
			 T1W = T1S + T1V;
			 T3k = T1V - T1S;
			 T4i = T1g - T1j;
			 T4j = T1Q - T1R;
			 T4k = T4i - T4j;
			 T5s = T4i + T4j;
		    }
	       }
	       {
		    E T2g, T4F, T2j, T4E, T2p, T4C, T2s, T4B;
		    {
			 E T2c, T2i, T2f, T2h, T2d, T2e;
			 T2c = R1[WS(rs, 1)];
			 T2i = R1[WS(rs, 17)];
			 T2d = R1[WS(rs, 9)];
			 T2e = R1[WS(rs, 25)];
			 T2f = KP707106781 * (T2d - T2e);
			 T2h = KP707106781 * (T2d + T2e);
			 T2g = T2c + T2f;
			 T4F = T2c - T2f;
			 T2j = T2h + T2i;
			 T4E = T2i - T2h;
		    }
		    {
			 E T2o, T2r, T2n, T2q, T2l, T2m;
			 T2o = R1[WS(rs, 29)];
			 T2r = R1[WS(rs, 13)];
			 T2l = R1[WS(rs, 5)];
			 T2m = R1[WS(rs, 21)];
			 T2n = KP707106781 * (T2l - T2m);
			 T2q = KP707106781 * (T2l + T2m);
			 T2p = T2n - T2o;
			 T4C = T2n + T2o;
			 T2s = T2q + T2r;
			 T4B = T2r - T2q;
		    }
		    {
			 E T2k, T2t, T4P, T4Q;
			 T2k = FNMS(KP195090322, T2j, KP980785280 * T2g);
			 T2t = FMA(KP980785280, T2p, KP195090322 * T2s);
			 T2u = T2k + T2t;
			 T3q = T2t - T2k;
			 T4P = FMA(KP831469612, T4F, KP555570233 * T4E);
			 T4Q = FMA(KP831469612, T4C, KP555570233 * T4B);
			 T4R = T4P + T4Q;
			 T5A = T4P - T4Q;
		    }
		    {
			 E T2w, T2x, T4D, T4G;
			 T2w = FNMS(KP980785280, T2s, KP195090322 * T2p);
			 T2x = FMA(KP195090322, T2g, KP980785280 * T2j);
			 T2y = T2w - T2x;
			 T3o = T2x + T2w;
			 T4D = FNMS(KP555570233, T4C, KP831469612 * T4B);
			 T4G = FNMS(KP555570233, T4F, KP831469612 * T4E);
			 T4H = T4D - T4G;
			 T5C = T4G + T4D;
		    }
	       }
	       {
		    E T1x, T4p, T1A, T4o, T1G, T4m, T1J, T4l;
		    {
			 E T1t, T1z, T1w, T1y, T1u, T1v;
			 T1t = R1[WS(rs, 2)];
			 T1z = R1[WS(rs, 18)];
			 T1u = R1[WS(rs, 10)];
			 T1v = R1[WS(rs, 26)];
			 T1w = KP707106781 * (T1u - T1v);
			 T1y = KP707106781 * (T1u + T1v);
			 T1x = T1t + T1w;
			 T4p = T1t - T1w;
			 T1A = T1y + T1z;
			 T4o = T1z - T1y;
		    }
		    {
			 E T1F, T1I, T1E, T1H, T1C, T1D;
			 T1F = R1[WS(rs, 30)];
			 T1I = R1[WS(rs, 14)];
			 T1C = R1[WS(rs, 6)];
			 T1D = R1[WS(rs, 22)];
			 T1E = KP707106781 * (T1C - T1D);
			 T1H = KP707106781 * (T1C + T1D);
			 T1G = T1E - T1F;
			 T4m = T1E + T1F;
			 T1J = T1H + T1I;
			 T4l = T1I - T1H;
		    }
		    {
			 E T1B, T1K, T4w, T4x;
			 T1B = FNMS(KP195090322, T1A, KP980785280 * T1x);
			 T1K = FMA(KP980785280, T1G, KP195090322 * T1J);
			 T1L = T1B + T1K;
			 T3j = T1K - T1B;
			 T4w = FMA(KP831469612, T4p, KP555570233 * T4o);
			 T4x = FMA(KP831469612, T4m, KP555570233 * T4l);
			 T4y = T4w + T4x;
			 T5t = T4w - T4x;
		    }
		    {
			 E T1N, T1O, T4n, T4q;
			 T1N = FNMS(KP980785280, T1J, KP195090322 * T1G);
			 T1O = FMA(KP195090322, T1x, KP980785280 * T1A);
			 T1P = T1N - T1O;
			 T3h = T1O + T1N;
			 T4n = FNMS(KP555570233, T4m, KP831469612 * T4l);
			 T4q = FNMS(KP555570233, T4p, KP831469612 * T4o);
			 T4r = T4n - T4q;
			 T5v = T4q + T4n;
		    }
	       }
	       {
		    E Tx, T2N, T69, T6f, T1e, T6e, T2X, T30, T1Y, T2L, T2Q, T62, T2U, T31, T2H;
		    E T2K, Tw, T63;
		    Tw = Tm + Tv;
		    Tx = Td + Tw;
		    T2N = Td - Tw;
		    T63 = T35 - T34;
		    T69 = T63 - T68;
		    T6f = T63 + T68;
		    {
			 E TS, T1d, T2V, T2W;
			 TS = FNMS(KP098017140, TR, KP995184726 * TK);
			 T1d = FMA(KP995184726, T15, KP098017140 * T1c);
			 T1e = TS + T1d;
			 T6e = T1d - TS;
			 T2V = T2b - T2u;
			 T2W = T2y + T2F;
			 T2X = FNMS(KP671558954, T2W, KP740951125 * T2V);
			 T30 = FMA(KP671558954, T2V, KP740951125 * T2W);
		    }
		    {
			 E T1M, T1X, T2O, T2P;
			 T1M = T1s + T1L;
			 T1X = T1P - T1W;
			 T1Y = FMA(KP998795456, T1M, KP049067674 * T1X);
			 T2L = FNMS(KP049067674, T1M, KP998795456 * T1X);
			 T2O = FMA(KP098017140, TK, KP995184726 * TR);
			 T2P = FNMS(KP995184726, T1c, KP098017140 * T15);
			 T2Q = T2O + T2P;
			 T62 = T2P - T2O;
		    }
		    {
			 E T2S, T2T, T2v, T2G;
			 T2S = T1s - T1L;
			 T2T = T1P + T1W;
			 T2U = FMA(KP740951125, T2S, KP671558954 * T2T);
			 T31 = FNMS(KP671558954, T2S, KP740951125 * T2T);
			 T2v = T2b + T2u;
			 T2G = T2y - T2F;
			 T2H = FNMS(KP049067674, T2G, KP998795456 * T2v);
			 T2K = FMA(KP049067674, T2v, KP998795456 * T2G);
		    }
		    {
			 E T1f, T2I, T6b, T6c;
			 T1f = Tx + T1e;
			 T2I = T1Y + T2H;
			 Cr[WS(csr, 31)] = T1f - T2I;
			 Cr[0] = T1f + T2I;
			 T6b = T2L + T2K;
			 T6c = T62 + T69;
			 Ci[WS(csi, 31)] = T6b - T6c;
			 Ci[0] = T6b + T6c;
		    }
		    {
			 E T2J, T2M, T61, T6a;
			 T2J = Tx - T1e;
			 T2M = T2K - T2L;
			 Cr[WS(csr, 16)] = T2J - T2M;
			 Cr[WS(csr, 15)] = T2J + T2M;
			 T61 = T2H - T1Y;
			 T6a = T62 - T69;
			 Ci[WS(csi, 16)] = T61 - T6a;
			 Ci[WS(csi, 15)] = T61 + T6a;
		    }
		    {
			 E T2R, T2Y, T6h, T6i;
			 T2R = T2N + T2Q;
			 T2Y = T2U + T2X;
			 Cr[WS(csr, 24)] = T2R - T2Y;
			 Cr[WS(csr, 7)] = T2R + T2Y;
			 T6h = T31 + T30;
			 T6i = T6e + T6f;
			 Ci[WS(csi, 24)] = T6h - T6i;
			 Ci[WS(csi, 7)] = T6h + T6i;
		    }
		    {
			 E T2Z, T32, T6d, T6g;
			 T2Z = T2N - T2Q;
			 T32 = T30 - T31;
			 Cr[WS(csr, 23)] = T2Z - T32;
			 Cr[WS(csr, 8)] = T2Z + T32;
			 T6d = T2X - T2U;
			 T6g = T6e - T6f;
			 Ci[WS(csi, 23)] = T6d - T6g;
			 Ci[WS(csi, 8)] = T6d + T6g;
		    }
	       }
	       {
		    E T5j, T5L, T6R, T6X, T5q, T6W, T5V, T5Y, T5y, T5J, T5O, T6O, T5S, T5Z, T5F;
		    E T5I, T5i, T6P;
		    T5i = T5g - T5h;
		    T5j = T5f - T5i;
		    T5L = T5f + T5i;
		    T6P = T3Z + T3W;
		    T6R = T6P - T6Q;
		    T6X = T6P + T6Q;
		    {
			 E T5m, T5p, T5T, T5U;
			 T5m = FMA(KP290284677, T5k, KP956940335 * T5l);
			 T5p = FNMS(KP290284677, T5o, KP956940335 * T5n);
			 T5q = T5m - T5p;
			 T6W = T5p + T5m;
			 T5T = T5z + T5A;
			 T5U = T5C + T5D;
			 T5V = FNMS(KP146730474, T5U, KP989176509 * T5T);
			 T5Y = FMA(KP146730474, T5T, KP989176509 * T5U);
		    }
		    {
			 E T5u, T5x, T5M, T5N;
			 T5u = T5s - T5t;
			 T5x = T5v - T5w;
			 T5y = FMA(KP803207531, T5u, KP595699304 * T5x);
			 T5J = FNMS(KP595699304, T5u, KP803207531 * T5x);
			 T5M = FMA(KP956940335, T5o, KP290284677 * T5n);
			 T5N = FNMS(KP290284677, T5l, KP956940335 * T5k);
			 T5O = T5M + T5N;
			 T6O = T5N - T5M;
		    }
		    {
			 E T5Q, T5R, T5B, T5E;
			 T5Q = T5s + T5t;
			 T5R = T5v + T5w;
			 T5S = FMA(KP989176509, T5Q, KP146730474 * T5R);
			 T5Z = FNMS(KP146730474, T5Q, KP989176509 * T5R);
			 T5B = T5z - T5A;
			 T5E = T5C - T5D;
			 T5F = FNMS(KP595699304, T5E, KP803207531 * T5B);
			 T5I = FMA(KP595699304, T5B, KP803207531 * T5E);
		    }
		    {
			 E T5r, T5G, T6T, T6U;
			 T5r = T5j + T5q;
			 T5G = T5y + T5F;
			 Cr[WS(csr, 25)] = T5r - T5G;
			 Cr[WS(csr, 6)] = T5r + T5G;
			 T6T = T5J + T5I;
			 T6U = T6O + T6R;
			 Ci[WS(csi, 25)] = T6T - T6U;
			 Ci[WS(csi, 6)] = T6T + T6U;
		    }
		    {
			 E T5H, T5K, T6N, T6S;
			 T5H = T5j - T5q;
			 T5K = T5I - T5J;
			 Cr[WS(csr, 22)] = T5H - T5K;
			 Cr[WS(csr, 9)] = T5H + T5K;
			 T6N = T5F - T5y;
			 T6S = T6O - T6R;
			 Ci[WS(csi, 22)] = T6N - T6S;
			 Ci[WS(csi, 9)] = T6N + T6S;
		    }
		    {
			 E T5P, T5W, T6Z, T70;
			 T5P = T5L + T5O;
			 T5W = T5S + T5V;
			 Cr[WS(csr, 30)] = T5P - T5W;
			 Cr[WS(csr, 1)] = T5P + T5W;
			 T6Z = T5Z + T5Y;
			 T70 = T6W + T6X;
			 Ci[WS(csi, 30)] = T6Z - T70;
			 Ci[WS(csi, 1)] = T6Z + T70;
		    }
		    {
			 E T5X, T60, T6V, T6Y;
			 T5X = T5L - T5O;
			 T60 = T5Y - T5Z;
			 Cr[WS(csr, 17)] = T5X - T60;
			 Cr[WS(csr, 14)] = T5X + T60;
			 T6V = T5V - T5S;
			 T6Y = T6W - T6X;
			 Ci[WS(csi, 17)] = T6V - T6Y;
			 Ci[WS(csi, 14)] = T6V + T6Y;
		    }
	       }
	       {
		    E T37, T3z, T6n, T6t, T3e, T6s, T3J, T3M, T3m, T3x, T3C, T6k, T3G, T3N, T3t;
		    E T3w, T36, T6l;
		    T36 = T34 + T35;
		    T37 = T33 - T36;
		    T3z = T33 + T36;
		    T6l = Tv - Tm;
		    T6n = T6l - T6m;
		    T6t = T6l + T6m;
		    {
			 E T3a, T3d, T3H, T3I;
			 T3a = FMA(KP634393284, T38, KP773010453 * T39);
			 T3d = FNMS(KP634393284, T3c, KP773010453 * T3b);
			 T3e = T3a - T3d;
			 T6s = T3d + T3a;
			 T3H = T3n + T3o;
			 T3I = T3q + T3r;
			 T3J = FNMS(KP336889853, T3I, KP941544065 * T3H);
			 T3M = FMA(KP336889853, T3H, KP941544065 * T3I);
		    }
		    {
			 E T3i, T3l, T3A, T3B;
			 T3i = T3g - T3h;
			 T3l = T3j - T3k;
			 T3m = FMA(KP903989293, T3i, KP427555093 * T3l);
			 T3x = FNMS(KP427555093, T3i, KP903989293 * T3l);
			 T3A = FMA(KP773010453, T3c, KP634393284 * T3b);
			 T3B = FNMS(KP634393284, T39, KP773010453 * T38);
			 T3C = T3A + T3B;
			 T6k = T3B - T3A;
		    }
		    {
			 E T3E, T3F, T3p, T3s;
			 T3E = T3g + T3h;
			 T3F = T3j + T3k;
			 T3G = FMA(KP941544065, T3E, KP336889853 * T3F);
			 T3N = FNMS(KP336889853, T3E, KP941544065 * T3F);
			 T3p = T3n - T3o;
			 T3s = T3q - T3r;
			 T3t = FNMS(KP427555093, T3s, KP903989293 * T3p);
			 T3w = FMA(KP427555093, T3p, KP903989293 * T3s);
		    }
		    {
			 E T3f, T3u, T6p, T6q;
			 T3f = T37 + T3e;
			 T3u = T3m + T3t;
			 Cr[WS(csr, 27)] = T3f - T3u;
			 Cr[WS(csr, 4)] = T3f + T3u;
			 T6p = T3x + T3w;
			 T6q = T6k + T6n;
			 Ci[WS(csi, 27)] = T6p - T6q;
			 Ci[WS(csi, 4)] = T6p + T6q;
		    }
		    {
			 E T3v, T3y, T6j, T6o;
			 T3v = T37 - T3e;
			 T3y = T3w - T3x;
			 Cr[WS(csr, 20)] = T3v - T3y;
			 Cr[WS(csr, 11)] = T3v + T3y;
			 T6j = T3t - T3m;
			 T6o = T6k - T6n;
			 Ci[WS(csi, 20)] = T6j - T6o;
			 Ci[WS(csi, 11)] = T6j + T6o;
		    }
		    {
			 E T3D, T3K, T6v, T6w;
			 T3D = T3z + T3C;
			 T3K = T3G + T3J;
			 Cr[WS(csr, 28)] = T3D - T3K;
			 Cr[WS(csr, 3)] = T3D + T3K;
			 T6v = T3N + T3M;
			 T6w = T6s + T6t;
			 Ci[WS(csi, 28)] = T6v - T6w;
			 Ci[WS(csi, 3)] = T6v + T6w;
		    }
		    {
			 E T3L, T3O, T6r, T6u;
			 T3L = T3z - T3C;
			 T3O = T3M - T3N;
			 Cr[WS(csr, 19)] = T3L - T3O;
			 Cr[WS(csr, 12)] = T3L + T3O;
			 T6r = T3J - T3G;
			 T6u = T6s - T6t;
			 Ci[WS(csi, 19)] = T6r - T6u;
			 Ci[WS(csi, 12)] = T6r + T6u;
		    }
	       }
	       {
		    E T41, T4Z, T6D, T6J, T4g, T6I, T59, T5d, T4A, T4X, T52, T6y, T56, T5c, T4T;
		    E T4W, T40, T6C;
		    T40 = T3W - T3Z;
		    T41 = T3T + T40;
		    T4Z = T3T - T40;
		    T6C = T5g + T5h;
		    T6D = T6B - T6C;
		    T6J = T6C + T6B;
		    {
			 E T48, T4f, T57, T58;
			 T48 = FMA(KP881921264, T44, KP471396736 * T47);
			 T4f = FMA(KP881921264, T4b, KP471396736 * T4e);
			 T4g = T48 - T4f;
			 T6I = T48 + T4f;
			 T57 = T4K + T4H;
			 T58 = T4R + T4O;
			 T59 = FMA(KP514102744, T57, KP857728610 * T58);
			 T5d = FNMS(KP857728610, T57, KP514102744 * T58);
		    }
		    {
			 E T4s, T4z, T50, T51;
			 T4s = T4k + T4r;
			 T4z = T4v - T4y;
			 T4A = FMA(KP970031253, T4s, KP242980179 * T4z);
			 T4X = FNMS(KP242980179, T4s, KP970031253 * T4z);
			 T50 = FNMS(KP471396736, T4b, KP881921264 * T4e);
			 T51 = FNMS(KP471396736, T44, KP881921264 * T47);
			 T52 = T50 - T51;
			 T6y = T51 + T50;
		    }
		    {
			 E T54, T55, T4L, T4S;
			 T54 = T4k - T4r;
			 T55 = T4y + T4v;
			 T56 = FMA(KP514102744, T54, KP857728610 * T55);
			 T5c = FNMS(KP514102744, T55, KP857728610 * T54);
			 T4L = T4H - T4K;
			 T4S = T4O - T4R;
			 T4T = FNMS(KP242980179, T4S, KP970031253 * T4L);
			 T4W = FMA(KP242980179, T4L, KP970031253 * T4S);
		    }
		    {
			 E T4h, T4U, T6F, T6G;
			 T4h = T41 + T4g;
			 T4U = T4A + T4T;
			 Cr[WS(csr, 29)] = T4h - T4U;
			 Cr[WS(csr, 2)] = T4h + T4U;
			 T6F = T4X + T4W;
			 T6G = T6y + T6D;
			 Ci[WS(csi, 29)] = T6F - T6G;
			 Ci[WS(csi, 2)] = T6F + T6G;
		    }
		    {
			 E T4V, T4Y, T6x, T6E;
			 T4V = T41 - T4g;
			 T4Y = T4W - T4X;
			 Cr[WS(csr, 18)] = T4V - T4Y;
			 Cr[WS(csr, 13)] = T4V + T4Y;
			 T6x = T4T - T4A;
			 T6E = T6y - T6D;
			 Ci[WS(csi, 18)] = T6x - T6E;
			 Ci[WS(csi, 13)] = T6x + T6E;
		    }
		    {
			 E T53, T5a, T6L, T6M;
			 T53 = T4Z - T52;
			 T5a = T56 - T59;
			 Cr[WS(csr, 21)] = T53 - T5a;
			 Cr[WS(csr, 10)] = T53 + T5a;
			 T6L = T5d - T5c;
			 T6M = T6J - T6I;
			 Ci[WS(csi, 21)] = T6L - T6M;
			 Ci[WS(csi, 10)] = T6L + T6M;
		    }
		    {
			 E T5b, T5e, T6H, T6K;
			 T5b = T4Z + T52;
			 T5e = T5c + T5d;
			 Cr[WS(csr, 26)] = T5b - T5e;
			 Cr[WS(csr, 5)] = T5b + T5e;
			 T6H = T56 + T59;
			 T6K = T6I + T6J;
			 Ci[WS(csi, 5)] = -(T6H + T6K);
			 Ci[WS(csi, 26)] = T6K - T6H;
		    }
	       }
	  }
     }
}

static const kr2c_desc desc = { 64, "r2cfII_64", {342, 114, 92, 0}, &GENUS };

void X(codelet_r2cfII_64) (planner *p) {
     X(kr2c_register) (p, r2cfII_64, &desc);
}

#endif
