/* sudoku-saver.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from sudoku-saver.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU_SAVER (sudoku_saver_get_type ())
#define SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SAVER, SudokuSaver))
#define SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SAVER, SudokuSaverClass))
#define IS_SUDOKU_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SAVER))
#define IS_SUDOKU_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SAVER))
#define SUDOKU_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SAVER, SudokuSaverClass))

typedef struct _SudokuSaver SudokuSaver;
typedef struct _SudokuSaverClass SudokuSaverClass;
typedef struct _SudokuSaverPrivate SudokuSaverPrivate;
enum  {
	SUDOKU_SAVER_0_PROPERTY,
	SUDOKU_SAVER_NUM_PROPERTIES
};
static GParamSpec* sudoku_saver_properties[SUDOKU_SAVER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SUDOKU_GAME (sudoku_game_get_type ())
#define SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME, SudokuGame))
#define SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME, SudokuGameClass))
#define IS_SUDOKU_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME))
#define IS_SUDOKU_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME))
#define SUDOKU_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME, SudokuGameClass))

typedef struct _SudokuGame SudokuGame;
typedef struct _SudokuGameClass SudokuGameClass;
typedef struct _SudokuGamePrivate SudokuGamePrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;

#define TYPE_GAME_MODE (game_mode_get_type ())

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

struct _SudokuSaver {
	GObject parent_instance;
	SudokuSaverPrivate * priv;
};

struct _SudokuSaverClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAME_MODE_PLAY,
	GAME_MODE_CREATE
} GameMode;

struct _SudokuGame {
	GObject parent_instance;
	SudokuGamePrivate * priv;
	SudokuBoard* board;
	GameMode mode;
	GTimer* timer;
};

struct _SudokuGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};


static gpointer sudoku_saver_parent_class = NULL;
static gchar* sudoku_saver__savegame_file;
static gchar* sudoku_saver__savegame_file = NULL;
static gchar* sudoku_saver__finishgame_dir;
static gchar* sudoku_saver__finishgame_dir = NULL;

GType sudoku_saver_get_type (void) G_GNUC_CONST;
SudokuSaver* sudoku_saver_new (void);
SudokuSaver* sudoku_saver_construct (GType object_type);
const gchar* sudoku_saver_get_savegame_file (void);
static void sudoku_saver_set_savegame_file (const gchar* value);
const gchar* sudoku_saver_get_finishgame_dir (void);
static void sudoku_saver_set_finishgame_dir (const gchar* value);
GType sudoku_game_get_type (void) G_GNUC_CONST;
SudokuGame* sudoku_saver_get_savedgame (SudokuSaver* self);
static SudokuGame* sudoku_saver_parse_json_to_game (SudokuSaver* self,
                                             const gchar* file_path);
void sudoku_saver_save_game (SudokuSaver* self,
                             SudokuGame* game);
static void sudoku_saver_create_file_for_game (SudokuSaver* self,
                                        SudokuGame* game,
                                        const gchar* file_name);
void sudoku_saver_add_game_to_finished (SudokuSaver* self,
                                        SudokuGame* game,
                                        gboolean delete_savegame);
GType sudoku_board_get_type (void) G_GNUC_CONST;
GType game_mode_get_type (void) G_GNUC_CONST;
gchar* sudoku_board_to_string (SudokuBoard* self,
                               gboolean get_original_state);
static gchar* sudoku_saver_serialize_game_to_json (SudokuSaver* self,
                                            SudokuGame* game);
gint* sudoku_board_get_cells (SudokuBoard* self,
                              int* result_length1,
                              int* result_length2);
GType difficulty_category_get_type (void) G_GNUC_CONST;
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
gdouble sudoku_game_get_total_time_played (SudokuGame* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                          gint row,
                                          gint column,
                                          gint digit);
static void _vala_array_add1 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void _vala_JsonNode_free (JsonNode* self);
SudokuBoard* sudoku_board_new (gint block_rows,
                               gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type,
                                     gint block_rows,
                                     gint block_cols);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
void sudoku_board_insert (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val,
                          gboolean is_fixed);
void sudoku_board_enable_earmark (SudokuBoard* self,
                                  gint row,
                                  gint column,
                                  gint digit);
void sudoku_board_set_previous_played_time (SudokuBoard* self,
                                            gdouble value);
DifficultyCategory difficulty_category_from_string (const gchar* input);
void sudoku_board_set_difficulty_category (SudokuBoard* self,
                                           DifficultyCategory value);
SudokuGame* sudoku_game_new (SudokuBoard* board);
SudokuGame* sudoku_game_construct (GType object_type,
                                   SudokuBoard* board);
static void sudoku_saver_finalize (GObject * obj);
static void _vala_sudoku_saver_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_saver_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);


SudokuSaver*
sudoku_saver_construct (GType object_type)
{
	SudokuSaver * self = NULL;
	GError * _inner_error_ = NULL;
	self = (SudokuSaver*) g_object_new (object_type, NULL);
	{
		gchar* config_dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* sudoku_data_dir = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GFile* file = NULL;
		const gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp0_ = g_get_user_data_dir ();
		_tmp1_ = g_strdup (_tmp0_);
		config_dir = _tmp1_;
		_tmp2_ = config_dir;
		_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, _tmp2_, "gnome-sudoku", NULL);
		sudoku_data_dir = _tmp3_;
		_tmp4_ = sudoku_saver_get_savegame_file ();
		_tmp5_ = _tmp4_;
		_tmp6_ = sudoku_data_dir;
		_tmp7_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, "savefile", NULL);
		_tmp8_ = _tmp7_;
		sudoku_saver_set_savegame_file (_tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = sudoku_saver_get_finishgame_dir ();
		_tmp10_ = _tmp9_;
		_tmp11_ = sudoku_data_dir;
		_tmp12_ = g_build_path (G_DIR_SEPARATOR_S, _tmp11_, "finished", NULL);
		_tmp13_ = _tmp12_;
		sudoku_saver_set_finishgame_dir (_tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = sudoku_data_dir;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		if (!g_file_query_exists (_tmp16_, NULL)) {
			GFile* _tmp17_;
			_tmp17_ = file;
			g_file_make_directory (_tmp17_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (sudoku_data_dir);
				_g_free0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_tmp18_ = sudoku_saver_get_finishgame_dir ();
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_new_for_path (_tmp19_);
		_g_object_unref0 (file);
		file = _tmp20_;
		_tmp21_ = file;
		if (!g_file_query_exists (_tmp21_, NULL)) {
			GFile* _tmp22_;
			_tmp22_ = file;
			g_file_make_directory (_tmp22_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (sudoku_data_dir);
				_g_free0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (file);
		_g_free0 (sudoku_data_dir);
		_g_free0 (config_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("sudoku-saver.vala:48: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


SudokuSaver*
sudoku_saver_new (void)
{
	return sudoku_saver_construct (TYPE_SUDOKU_SAVER);
}


SudokuGame*
sudoku_saver_get_savedgame (SudokuSaver* self)
{
	SudokuGame* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	SudokuGame* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp4_ = sudoku_saver_get_savegame_file ();
	_tmp5_ = _tmp4_;
	_tmp6_ = sudoku_saver_parse_json_to_game (self, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (file);
	return result;
}


void
sudoku_saver_save_game (SudokuSaver* self,
                        SudokuGame* game)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = sudoku_saver_get_savegame_file ();
	_tmp1_ = _tmp0_;
	sudoku_saver_create_file_for_game (self, game, _tmp1_);
}


void
sudoku_saver_add_game_to_finished (SudokuSaver* self,
                                   SudokuGame* game,
                                   gboolean delete_savegame)
{
	gchar* file_name = NULL;
	SudokuBoard* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* file_path = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = game->board;
	_tmp1_ = sudoku_board_to_string (_tmp0_, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".save", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file_name = _tmp4_;
	_tmp5_ = sudoku_saver_get_finishgame_dir ();
	_tmp6_ = _tmp5_;
	_tmp7_ = file_name;
	_tmp8_ = g_build_path (G_DIR_SEPARATOR_S, _tmp6_, _tmp7_, NULL);
	file_path = _tmp8_;
	_tmp9_ = file_path;
	sudoku_saver_create_file_for_game (self, game, _tmp9_);
	if (delete_savegame) {
		GFile* file = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp10_ = sudoku_saver_get_savegame_file ();
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		file = _tmp12_;
		_tmp13_ = file;
		if (g_file_query_exists (_tmp13_, NULL)) {
			{
				GFile* _tmp14_;
				_tmp14_ = file;
				g_file_delete (_tmp14_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFile* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GError* _tmp18_;
				const gchar* _tmp19_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp15_ = file;
				_tmp16_ = g_file_get_uri (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->message;
				g_warning ("sudoku-saver.vala:84: Failed to delete %s: %s", _tmp17_, _tmp19_);
				_g_free0 (_tmp17_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (file_path);
				_g_free0 (file_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (file);
	}
	_g_free0 (file_path);
	_g_free0 (file_name);
}


static void
sudoku_saver_create_file_for_game (SudokuSaver* self,
                                   SudokuGame* game,
                                   const gchar* file_name)
{
	gchar* json_str = NULL;
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = sudoku_saver_serialize_game_to_json (self, game);
	json_str = _tmp0_;
	{
		g_file_set_contents (file_name, json_str, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("sudoku-saver.vala:100: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (json_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (json_str);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_vala_array_add1 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}


static gchar*
sudoku_saver_serialize_game_to_json (SudokuSaver* self,
                                     SudokuGame* game)
{
	gchar* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoard* _tmp1_;
	gint* board_cells = NULL;
	SudokuBoard* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint* _tmp5_;
	gint board_cells_length1;
	gint board_cells_length2;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp6_;
	JsonBuilder* _tmp7_;
	JsonBuilder* _tmp8_;
	JsonBuilder* _tmp9_;
	SudokuBoard* _tmp10_;
	DifficultyCategory _tmp11_;
	DifficultyCategory _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	JsonBuilder* _tmp15_;
	GameMode _tmp16_;
	JsonBuilder* _tmp19_;
	JsonBuilder* _tmp20_;
	JsonBuilder* _tmp80_;
	JsonBuilder* _tmp81_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp82_;
	JsonNode* root = NULL;
	JsonBuilder* _tmp83_;
	JsonNode* _tmp84_;
	gchar* _tmp85_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = game->board;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	board = _tmp1_;
	_tmp2_ = board;
	_tmp5_ = sudoku_board_get_cells (_tmp2_, &_tmp3_, &_tmp4_);
	board_cells = _tmp5_;
	board_cells_length1 = _tmp3_;
	board_cells_length2 = _tmp4_;
	_tmp6_ = json_builder_new ();
	builder = _tmp6_;
	_tmp7_ = builder;
	json_builder_begin_object (_tmp7_);
	_tmp8_ = builder;
	json_builder_set_member_name (_tmp8_, "difficulty_category");
	_tmp9_ = builder;
	_tmp10_ = board;
	_tmp11_ = sudoku_board_get_difficulty_category (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = difficulty_category_to_untranslated_string (_tmp12_);
	_tmp14_ = _tmp13_;
	json_builder_add_string_value (_tmp9_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = builder;
	json_builder_set_member_name (_tmp15_, "time_elapsed");
	_tmp16_ = game->mode;
	if (_tmp16_ == GAME_MODE_CREATE) {
		JsonBuilder* _tmp17_;
		_tmp17_ = builder;
		json_builder_add_double_value (_tmp17_, (gdouble) 0);
	} else {
		JsonBuilder* _tmp18_;
		_tmp18_ = builder;
		json_builder_add_double_value (_tmp18_, sudoku_game_get_total_time_played (game));
	}
	_tmp19_ = builder;
	json_builder_set_member_name (_tmp19_, "cells");
	_tmp20_ = builder;
	json_builder_begin_array (_tmp20_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp23_;
				SudokuBoard* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = board;
				_tmp25_ = sudoku_board_get_rows (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!(_tmp23_ < _tmp26_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gint _tmp29_;
							SudokuBoard* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gint* earmarks = NULL;
							gint* _tmp33_;
							gint earmarks_length1;
							gint _earmarks_size_;
							gboolean _tmp46_ = FALSE;
							gint* _tmp47_;
							gint _tmp47__length1;
							gint _tmp47__length2;
							gint _tmp48_;
							gint _tmp49_;
							gint _tmp50_;
							JsonBuilder* _tmp52_;
							JsonBuilder* _tmp53_;
							JsonBuilder* _tmp54_;
							JsonBuilder* _tmp55_;
							gint _tmp56_;
							JsonBuilder* _tmp57_;
							gint _tmp58_;
							JsonBuilder* _tmp59_;
							JsonBuilder* _tmp60_;
							JsonBuilder* _tmp61_;
							gint* _tmp62_;
							gint _tmp62__length1;
							gint _tmp62__length2;
							gint _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							JsonBuilder* _tmp66_;
							JsonBuilder* _tmp67_;
							SudokuBoard* _tmp68_;
							gboolean* _tmp69_;
							gint _tmp69__length1;
							gint _tmp69__length2;
							gint _tmp70_;
							gint _tmp71_;
							gboolean _tmp72_;
							JsonBuilder* _tmp73_;
							JsonBuilder* _tmp74_;
							gint* _tmp75_;
							gint _tmp75__length1;
							JsonBuilder* _tmp78_;
							JsonBuilder* _tmp79_;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = j;
								j = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = j;
							_tmp30_ = board;
							_tmp31_ = sudoku_board_get_cols (_tmp30_);
							_tmp32_ = _tmp31_;
							if (!(_tmp29_ < _tmp32_)) {
								break;
							}
							_tmp33_ = g_new0 (gint, 0);
							earmarks = _tmp33_;
							earmarks_length1 = 0;
							_earmarks_size_ = earmarks_length1;
							{
								gint k = 0;
								k = 1;
								{
									gboolean _tmp34_ = FALSE;
									_tmp34_ = TRUE;
									while (TRUE) {
										gint _tmp36_;
										SudokuBoard* _tmp37_;
										gint _tmp38_;
										gint _tmp39_;
										SudokuBoard* _tmp40_;
										gint _tmp41_;
										gint _tmp42_;
										gint _tmp43_;
										if (!_tmp34_) {
											gint _tmp35_;
											_tmp35_ = k;
											k = _tmp35_ + 1;
										}
										_tmp34_ = FALSE;
										_tmp36_ = k;
										_tmp37_ = board;
										_tmp38_ = sudoku_board_get_max_val (_tmp37_);
										_tmp39_ = _tmp38_;
										if (!(_tmp36_ <= _tmp39_)) {
											break;
										}
										_tmp40_ = board;
										_tmp41_ = i;
										_tmp42_ = j;
										_tmp43_ = k;
										if (sudoku_board_is_earmark_enabled (_tmp40_, _tmp41_, _tmp42_, _tmp43_)) {
											gint* _tmp44_;
											gint _tmp44__length1;
											gint _tmp45_;
											_tmp44_ = earmarks;
											_tmp44__length1 = earmarks_length1;
											_tmp45_ = k;
											_vala_array_add1 (&earmarks, &earmarks_length1, &_earmarks_size_, _tmp45_);
										}
									}
								}
							}
							_tmp47_ = board_cells;
							_tmp47__length1 = board_cells_length1;
							_tmp47__length2 = board_cells_length2;
							_tmp48_ = i;
							_tmp49_ = j;
							_tmp50_ = _tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_];
							if (_tmp50_ == 0) {
								gint* _tmp51_;
								gint _tmp51__length1;
								_tmp51_ = earmarks;
								_tmp51__length1 = earmarks_length1;
								_tmp46_ = _tmp51__length1 == 0;
							} else {
								_tmp46_ = FALSE;
							}
							if (_tmp46_) {
								earmarks = (g_free (earmarks), NULL);
								continue;
							}
							_tmp52_ = builder;
							json_builder_begin_object (_tmp52_);
							_tmp53_ = builder;
							json_builder_set_member_name (_tmp53_, "position");
							_tmp54_ = builder;
							json_builder_begin_array (_tmp54_);
							_tmp55_ = builder;
							_tmp56_ = i;
							json_builder_add_int_value (_tmp55_, (gint64) _tmp56_);
							_tmp57_ = builder;
							_tmp58_ = j;
							json_builder_add_int_value (_tmp57_, (gint64) _tmp58_);
							_tmp59_ = builder;
							json_builder_end_array (_tmp59_);
							_tmp60_ = builder;
							json_builder_set_member_name (_tmp60_, "value");
							_tmp61_ = builder;
							_tmp62_ = board_cells;
							_tmp62__length1 = board_cells_length1;
							_tmp62__length2 = board_cells_length2;
							_tmp63_ = i;
							_tmp64_ = j;
							_tmp65_ = _tmp62_[(_tmp63_ * _tmp62__length2) + _tmp64_];
							json_builder_add_int_value (_tmp61_, (gint64) _tmp65_);
							_tmp66_ = builder;
							json_builder_set_member_name (_tmp66_, "fixed");
							_tmp67_ = builder;
							_tmp68_ = board;
							_tmp69_ = _tmp68_->is_fixed;
							_tmp69__length1 = _tmp68_->is_fixed_length1;
							_tmp69__length2 = _tmp68_->is_fixed_length2;
							_tmp70_ = i;
							_tmp71_ = j;
							_tmp72_ = _tmp69_[(_tmp70_ * _tmp69__length2) + _tmp71_];
							json_builder_add_boolean_value (_tmp67_, _tmp72_);
							_tmp73_ = builder;
							json_builder_set_member_name (_tmp73_, "earmarks");
							_tmp74_ = builder;
							json_builder_begin_array (_tmp74_);
							_tmp75_ = earmarks;
							_tmp75__length1 = earmarks_length1;
							{
								gint* k_collection = NULL;
								gint k_collection_length1 = 0;
								gint _k_collection_size_ = 0;
								gint k_it = 0;
								k_collection = _tmp75_;
								k_collection_length1 = _tmp75__length1;
								for (k_it = 0; k_it < _tmp75__length1; k_it = k_it + 1) {
									gint k = 0;
									k = k_collection[k_it];
									{
										JsonBuilder* _tmp76_;
										gint _tmp77_;
										_tmp76_ = builder;
										_tmp77_ = k;
										json_builder_add_int_value (_tmp76_, (gint64) _tmp77_);
									}
								}
							}
							_tmp78_ = builder;
							json_builder_end_array (_tmp78_);
							_tmp79_ = builder;
							json_builder_end_object (_tmp79_);
							earmarks = (g_free (earmarks), NULL);
						}
					}
				}
			}
		}
	}
	_tmp80_ = builder;
	json_builder_end_array (_tmp80_);
	_tmp81_ = builder;
	json_builder_end_object (_tmp81_);
	_tmp82_ = json_generator_new ();
	generator = _tmp82_;
	json_generator_set_pretty (generator, TRUE);
	_tmp83_ = builder;
	_tmp84_ = json_builder_get_root (_tmp83_);
	root = _tmp84_;
	json_generator_set_root (generator, root);
	_tmp85_ = json_generator_to_data (generator, NULL);
	result = _tmp85_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	board_cells = (g_free (board_cells), NULL);
	_g_object_unref0 (board);
	return result;
}


static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static SudokuGame*
sudoku_saver_parse_json_to_game (SudokuSaver* self,
                                 const gchar* file_path)
{
	SudokuGame* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp2_;
	JsonNode* node = NULL;
	JsonParser* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* _tmp5_;
	JsonReader* reader = NULL;
	JsonNode* _tmp6_;
	JsonReader* _tmp7_;
	JsonReader* _tmp8_;
	JsonReader* _tmp9_;
	JsonReader* _tmp58_;
	JsonReader* _tmp59_;
	JsonReader* _tmp60_;
	SudokuBoard* _tmp61_;
	JsonReader* _tmp62_;
	JsonReader* _tmp63_;
	JsonReader* _tmp64_;
	JsonReader* _tmp65_;
	SudokuBoard* _tmp66_;
	JsonReader* _tmp67_;
	const gchar* _tmp68_;
	JsonReader* _tmp69_;
	SudokuBoard* _tmp70_;
	SudokuGame* _tmp71_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_path != NULL, NULL);
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_;
		_tmp1_ = parser;
		json_parser_load_from_file (_tmp1_, file_path, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = sudoku_board_new (3, 3);
	board = _tmp2_;
	_tmp3_ = parser;
	_tmp4_ = json_parser_get_root (_tmp3_);
	_tmp5_ = __vala_JsonNode_copy0 (_tmp4_);
	node = _tmp5_;
	_tmp6_ = node;
	_tmp7_ = json_reader_new (_tmp6_);
	reader = _tmp7_;
	_tmp8_ = reader;
	json_reader_read_member (_tmp8_, "cells");
	_tmp9_ = reader;
	g_return_val_if_fail (json_reader_is_array (_tmp9_), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				JsonReader* _tmp13_;
				JsonReader* _tmp14_;
				gint _tmp15_;
				JsonReader* _tmp16_;
				JsonReader* _tmp17_;
				JsonReader* _tmp18_;
				JsonReader* _tmp19_;
				JsonReader* _tmp20_;
				gint row = 0;
				JsonReader* _tmp21_;
				JsonReader* _tmp22_;
				JsonReader* _tmp23_;
				JsonReader* _tmp24_;
				gint col = 0;
				JsonReader* _tmp25_;
				JsonReader* _tmp26_;
				JsonReader* _tmp27_;
				JsonReader* _tmp28_;
				JsonReader* _tmp29_;
				gint val = 0;
				JsonReader* _tmp30_;
				JsonReader* _tmp31_;
				JsonReader* _tmp32_;
				JsonReader* _tmp33_;
				gboolean is_fixed = FALSE;
				JsonReader* _tmp34_;
				JsonReader* _tmp35_;
				gint _tmp36_;
				JsonReader* _tmp42_;
				JsonReader* _tmp43_;
				JsonReader* _tmp56_;
				JsonReader* _tmp57_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = reader;
				if (!(_tmp12_ < json_reader_count_elements (_tmp13_))) {
					break;
				}
				_tmp14_ = reader;
				_tmp15_ = i;
				json_reader_read_element (_tmp14_, (guint) _tmp15_);
				_tmp16_ = reader;
				json_reader_read_member (_tmp16_, "position");
				_tmp17_ = reader;
				g_return_val_if_fail (json_reader_is_array (_tmp17_), NULL);
				_tmp18_ = reader;
				g_return_val_if_fail (json_reader_count_elements (_tmp18_) == 2, NULL);
				_tmp19_ = reader;
				json_reader_read_element (_tmp19_, (guint) 0);
				_tmp20_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp20_), NULL);
				_tmp21_ = reader;
				row = (gint) json_reader_get_int_value (_tmp21_);
				_tmp22_ = reader;
				json_reader_end_element (_tmp22_);
				_tmp23_ = reader;
				json_reader_read_element (_tmp23_, (guint) 1);
				_tmp24_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp24_), NULL);
				_tmp25_ = reader;
				col = (gint) json_reader_get_int_value (_tmp25_);
				_tmp26_ = reader;
				json_reader_end_element (_tmp26_);
				_tmp27_ = reader;
				json_reader_end_member (_tmp27_);
				_tmp28_ = reader;
				json_reader_read_member (_tmp28_, "value");
				_tmp29_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp29_), NULL);
				_tmp30_ = reader;
				val = (gint) json_reader_get_int_value (_tmp30_);
				_tmp31_ = reader;
				json_reader_end_member (_tmp31_);
				_tmp32_ = reader;
				json_reader_read_member (_tmp32_, "fixed");
				_tmp33_ = reader;
				g_return_val_if_fail (json_reader_is_value (_tmp33_), NULL);
				_tmp34_ = reader;
				is_fixed = json_reader_get_boolean_value (_tmp34_);
				_tmp35_ = reader;
				json_reader_end_member (_tmp35_);
				_tmp36_ = val;
				if (_tmp36_ != 0) {
					SudokuBoard* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gboolean _tmp41_;
					_tmp37_ = board;
					_tmp38_ = row;
					_tmp39_ = col;
					_tmp40_ = val;
					_tmp41_ = is_fixed;
					sudoku_board_insert (_tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_);
				}
				_tmp42_ = reader;
				json_reader_read_member (_tmp42_, "earmarks");
				_tmp43_ = reader;
				g_return_val_if_fail (json_reader_is_array (_tmp43_), NULL);
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp44_ = FALSE;
						_tmp44_ = TRUE;
						while (TRUE) {
							gint _tmp46_;
							JsonReader* _tmp47_;
							JsonReader* _tmp48_;
							gint _tmp49_;
							JsonReader* _tmp50_;
							SudokuBoard* _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
							JsonReader* _tmp54_;
							JsonReader* _tmp55_;
							if (!_tmp44_) {
								gint _tmp45_;
								_tmp45_ = k;
								k = _tmp45_ + 1;
							}
							_tmp44_ = FALSE;
							_tmp46_ = k;
							_tmp47_ = reader;
							if (!(_tmp46_ < json_reader_count_elements (_tmp47_))) {
								break;
							}
							_tmp48_ = reader;
							_tmp49_ = k;
							json_reader_read_element (_tmp48_, (guint) _tmp49_);
							_tmp50_ = reader;
							g_return_val_if_fail (json_reader_is_value (_tmp50_), NULL);
							_tmp51_ = board;
							_tmp52_ = row;
							_tmp53_ = col;
							_tmp54_ = reader;
							sudoku_board_enable_earmark (_tmp51_, _tmp52_, _tmp53_, (gint) json_reader_get_int_value (_tmp54_));
							_tmp55_ = reader;
							json_reader_end_element (_tmp55_);
						}
					}
				}
				_tmp56_ = reader;
				json_reader_end_member (_tmp56_);
				_tmp57_ = reader;
				json_reader_end_element (_tmp57_);
			}
		}
	}
	_tmp58_ = reader;
	json_reader_end_member (_tmp58_);
	_tmp59_ = reader;
	json_reader_read_member (_tmp59_, "time_elapsed");
	_tmp60_ = reader;
	g_return_val_if_fail (json_reader_is_value (_tmp60_), NULL);
	_tmp61_ = board;
	_tmp62_ = reader;
	sudoku_board_set_previous_played_time (_tmp61_, json_reader_get_double_value (_tmp62_));
	_tmp63_ = reader;
	json_reader_end_member (_tmp63_);
	_tmp64_ = reader;
	json_reader_read_member (_tmp64_, "difficulty_category");
	_tmp65_ = reader;
	g_return_val_if_fail (json_reader_is_value (_tmp65_), NULL);
	_tmp66_ = board;
	_tmp67_ = reader;
	_tmp68_ = json_reader_get_string_value (_tmp67_);
	sudoku_board_set_difficulty_category (_tmp66_, difficulty_category_from_string (_tmp68_));
	_tmp69_ = reader;
	json_reader_end_member (_tmp69_);
	_tmp70_ = board;
	_tmp71_ = sudoku_game_new (_tmp70_);
	result = _tmp71_;
	_g_object_unref0 (reader);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (board);
	_g_object_unref0 (parser);
	return result;
}


const gchar*
sudoku_saver_get_savegame_file (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = sudoku_saver__savegame_file;
	result = _tmp0_;
	return result;
}


static void
sudoku_saver_set_savegame_file (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (sudoku_saver__savegame_file);
	sudoku_saver__savegame_file = _tmp0_;
}


const gchar*
sudoku_saver_get_finishgame_dir (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = sudoku_saver__finishgame_dir;
	result = _tmp0_;
	return result;
}


static void
sudoku_saver_set_finishgame_dir (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (sudoku_saver__finishgame_dir);
	sudoku_saver__finishgame_dir = _tmp0_;
}


static void
sudoku_saver_class_init (SudokuSaverClass * klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	sudoku_saver_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_saver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_saver_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_saver_finalize;
	_tmp0_ = g_strdup ("");
	sudoku_saver__savegame_file = _tmp0_;
	_tmp1_ = g_strdup ("");
	sudoku_saver__finishgame_dir = _tmp1_;
}


static void
sudoku_saver_instance_init (SudokuSaver * self)
{
}


static void
sudoku_saver_finalize (GObject * obj)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_SAVER, SudokuSaver);
	G_OBJECT_CLASS (sudoku_saver_parent_class)->finalize (obj);
}


GType
sudoku_saver_get_type (void)
{
	static volatile gsize sudoku_saver_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_saver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuSaver), 0, (GInstanceInitFunc) sudoku_saver_instance_init, NULL };
		GType sudoku_saver_type_id;
		sudoku_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuSaver", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_saver_type_id__volatile, sudoku_saver_type_id);
	}
	return sudoku_saver_type_id__volatile;
}


static void
_vala_sudoku_saver_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_sudoku_saver_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_SAVER, SudokuSaver);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



