// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Converter, Initable};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GCharsetConverter")]
    pub struct CharsetConverter(Object<ffi::GCharsetConverter, ffi::GCharsetConverterClass>) @implements Converter, Initable;

    match fn {
        type_ => || ffi::g_charset_converter_get_type(),
    }
}

impl CharsetConverter {
    #[doc(alias = "g_charset_converter_new")]
    pub fn new(to_charset: &str, from_charset: &str) -> Result<CharsetConverter, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::g_charset_converter_new(
                to_charset.to_glib_none().0,
                from_charset.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`CharsetConverter`] objects.
    ///
    /// This method returns an instance of [`CharsetConverterBuilder`](crate::builders::CharsetConverterBuilder) which can be used to create [`CharsetConverter`] objects.
    pub fn builder() -> CharsetConverterBuilder {
        CharsetConverterBuilder::new()
    }

    #[doc(alias = "g_charset_converter_get_num_fallbacks")]
    #[doc(alias = "get_num_fallbacks")]
    pub fn num_fallbacks(&self) -> u32 {
        unsafe { ffi::g_charset_converter_get_num_fallbacks(self.to_glib_none().0) }
    }

    #[doc(alias = "g_charset_converter_get_use_fallback")]
    #[doc(alias = "get_use_fallback")]
    pub fn uses_fallback(&self) -> bool {
        unsafe {
            from_glib(ffi::g_charset_converter_get_use_fallback(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_charset_converter_set_use_fallback")]
    pub fn set_use_fallback(&self, use_fallback: bool) {
        unsafe {
            ffi::g_charset_converter_set_use_fallback(
                self.to_glib_none().0,
                use_fallback.into_glib(),
            );
        }
    }

    #[doc(alias = "from-charset")]
    pub fn from_charset(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "from-charset")
    }

    #[doc(alias = "to-charset")]
    pub fn to_charset(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "to-charset")
    }

    #[doc(alias = "use-fallback")]
    pub fn connect_use_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_fallback_trampoline<F: Fn(&CharsetConverter) + 'static>(
            this: *mut ffi::GCharsetConverter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-fallback\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_use_fallback_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for CharsetConverter {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`CharsetConverter`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CharsetConverterBuilder {
    builder: glib::object::ObjectBuilder<'static, CharsetConverter>,
}

impl CharsetConverterBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn from_charset(self, from_charset: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("from-charset", from_charset.into()),
        }
    }

    pub fn to_charset(self, to_charset: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("to-charset", to_charset.into()),
        }
    }

    pub fn use_fallback(self, use_fallback: bool) -> Self {
        Self {
            builder: self.builder.property("use-fallback", use_fallback),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`CharsetConverter`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> CharsetConverter {
        self.builder.build()
    }
}
