﻿// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

namespace System.Reactive.Joins
{
    /// <summary>
    /// Abstract base class for join patterns.
    /// </summary>
    public abstract class Pattern
    {
        internal Pattern()
        {
        }
    }

    /* The following code is generated by a tool checked in to $/.../Source/Tools/CodeGenerators. */

    #region Joins auto-generated code (8/4/2012 1:00:26 AM)

    /// <summary>
    /// Represents a join pattern over one observable sequence.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    public class Pattern<TSource1> : Pattern
    {
        internal Pattern(IObservable<TSource1> first)
        {
            First = first;
        }

        internal IObservable<TSource1> First { get; private set; }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over two observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    public class Pattern<TSource1, TSource2> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second)
        {
            First = first;
            Second = second;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all three observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource3">The type of the elements in the third observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the two previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3> And<TSource3>(IObservable<TSource3> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3>(First, Second, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over three observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third)
        {
            First = first;
            Second = second;
            Third = third;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all four observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource4">The type of the elements in the fourth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the three previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4> And<TSource4>(IObservable<TSource4> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4>(First, Second, Third, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over four observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }

#if !NO_LARGEARITY
        /// <summary>
        /// Creates a pattern that matches when all five observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource5">The type of the elements in the fifth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the four previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5> And<TSource5>(IObservable<TSource5> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5>(First, Second, Third, Fourth, other);
        }
#endif

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TResult>(this, selector);
        }

    }

#if !NO_LARGEARITY
    /// <summary>
    /// Represents a join pattern over five observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all six observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource6">The type of the elements in the sixth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the five previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6> And<TSource6>(IObservable<TSource6> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6>(First, Second, Third, Fourth, Fifth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over six observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all seven observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource7">The type of the elements in the seventh observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the six previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7> And<TSource7>(IObservable<TSource7> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7>(First, Second, Third, Fourth, Fifth, Sixth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over seven observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all eight observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource8">The type of the elements in the eighth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the seven previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8> And<TSource8>(IObservable<TSource8> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over eight observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all nine observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource9">The type of the elements in the ninth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the eight previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9> And<TSource9>(IObservable<TSource9> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over nine observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all ten observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource10">The type of the elements in the tenth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the nine previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10> And<TSource10>(IObservable<TSource10> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over ten observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all eleven observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource11">The type of the elements in the eleventh observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the ten previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11> And<TSource11>(IObservable<TSource11> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over eleven observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all twelve observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource12">The type of the elements in the twelfth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the eleven previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12> And<TSource12>(IObservable<TSource12> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, Eleventh, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over twelve observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    /// <typeparam name="TSource12">The type of the elements in the twelfth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh, IObservable<TSource12> twelfth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
            Twelfth = twelfth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }
        internal IObservable<TSource12> Twelfth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all thirteen observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource13">The type of the elements in the thirteenth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the twelve previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13> And<TSource13>(IObservable<TSource13> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, Eleventh, Twelfth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over thirteen observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    /// <typeparam name="TSource12">The type of the elements in the twelfth source sequence.</typeparam>
    /// <typeparam name="TSource13">The type of the elements in the thirteenth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh, IObservable<TSource12> twelfth, IObservable<TSource13> thirteenth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
            Twelfth = twelfth;
            Thirteenth = thirteenth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }
        internal IObservable<TSource12> Twelfth { get; private set; }
        internal IObservable<TSource13> Thirteenth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all fourteen observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource14">The type of the elements in the fourteenth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the thirteen previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14> And<TSource14>(IObservable<TSource14> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, Eleventh, Twelfth, Thirteenth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over fourteen observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    /// <typeparam name="TSource12">The type of the elements in the twelfth source sequence.</typeparam>
    /// <typeparam name="TSource13">The type of the elements in the thirteenth source sequence.</typeparam>
    /// <typeparam name="TSource14">The type of the elements in the fourteenth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh, IObservable<TSource12> twelfth, IObservable<TSource13> thirteenth, IObservable<TSource14> fourteenth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
            Twelfth = twelfth;
            Thirteenth = thirteenth;
            Fourteenth = fourteenth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }
        internal IObservable<TSource12> Twelfth { get; private set; }
        internal IObservable<TSource13> Thirteenth { get; private set; }
        internal IObservable<TSource14> Fourteenth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all fifteen observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource15">The type of the elements in the fifteenth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the fourteen previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15> And<TSource15>(IObservable<TSource15> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, Eleventh, Twelfth, Thirteenth, Fourteenth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over fifteen observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    /// <typeparam name="TSource12">The type of the elements in the twelfth source sequence.</typeparam>
    /// <typeparam name="TSource13">The type of the elements in the thirteenth source sequence.</typeparam>
    /// <typeparam name="TSource14">The type of the elements in the fourteenth source sequence.</typeparam>
    /// <typeparam name="TSource15">The type of the elements in the fifteenth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh, IObservable<TSource12> twelfth, IObservable<TSource13> thirteenth, IObservable<TSource14> fourteenth, IObservable<TSource15> fifteenth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
            Twelfth = twelfth;
            Thirteenth = thirteenth;
            Fourteenth = fourteenth;
            Fifteenth = fifteenth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }
        internal IObservable<TSource12> Twelfth { get; private set; }
        internal IObservable<TSource13> Thirteenth { get; private set; }
        internal IObservable<TSource14> Fourteenth { get; private set; }
        internal IObservable<TSource15> Fifteenth { get; private set; }

        /// <summary>
        /// Creates a pattern that matches when all sixteen observable sequences have an available element.
        /// </summary>
        /// <typeparam name="TSource16">The type of the elements in the sixteenth observable sequence.</typeparam>
        /// <param name="other">Observable sequence to match with the fifteen previous sequences.</param>
        /// <returns>Pattern object that matches when all observable sequences have an available element.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="other"/> is null.</exception>
        public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TSource16> And<TSource16>(IObservable<TSource16> other)
        {
            if (other == null)
                throw new ArgumentNullException("other");

            return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TSource16>(First, Second, Third, Fourth, Fifth, Sixth, Seventh, Eighth, Ninth, Tenth, Eleventh, Twelfth, Thirteenth, Fourteenth, Fifteenth, other);
        }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TResult>(this, selector);
        }

    }

    /// <summary>
    /// Represents a join pattern over sixteen observable sequences.
    /// </summary>
    /// <typeparam name="TSource1">The type of the elements in the first source sequence.</typeparam>
    /// <typeparam name="TSource2">The type of the elements in the second source sequence.</typeparam>
    /// <typeparam name="TSource3">The type of the elements in the third source sequence.</typeparam>
    /// <typeparam name="TSource4">The type of the elements in the fourth source sequence.</typeparam>
    /// <typeparam name="TSource5">The type of the elements in the fifth source sequence.</typeparam>
    /// <typeparam name="TSource6">The type of the elements in the sixth source sequence.</typeparam>
    /// <typeparam name="TSource7">The type of the elements in the seventh source sequence.</typeparam>
    /// <typeparam name="TSource8">The type of the elements in the eighth source sequence.</typeparam>
    /// <typeparam name="TSource9">The type of the elements in the ninth source sequence.</typeparam>
    /// <typeparam name="TSource10">The type of the elements in the tenth source sequence.</typeparam>
    /// <typeparam name="TSource11">The type of the elements in the eleventh source sequence.</typeparam>
    /// <typeparam name="TSource12">The type of the elements in the twelfth source sequence.</typeparam>
    /// <typeparam name="TSource13">The type of the elements in the thirteenth source sequence.</typeparam>
    /// <typeparam name="TSource14">The type of the elements in the fourteenth source sequence.</typeparam>
    /// <typeparam name="TSource15">The type of the elements in the fifteenth source sequence.</typeparam>
    /// <typeparam name="TSource16">The type of the elements in the sixteenth source sequence.</typeparam>
    public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TSource16> : Pattern
    {
        internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<TSource10> tenth, IObservable<TSource11> eleventh, IObservable<TSource12> twelfth, IObservable<TSource13> thirteenth, IObservable<TSource14> fourteenth, IObservable<TSource15> fifteenth, IObservable<TSource16> sixteenth)
        {
            First = first;
            Second = second;
            Third = third;
            Fourth = fourth;
            Fifth = fifth;
            Sixth = sixth;
            Seventh = seventh;
            Eighth = eighth;
            Ninth = ninth;
            Tenth = tenth;
            Eleventh = eleventh;
            Twelfth = twelfth;
            Thirteenth = thirteenth;
            Fourteenth = fourteenth;
            Fifteenth = fifteenth;
            Sixteenth = sixteenth;
        }

        internal IObservable<TSource1> First { get; private set; }
        internal IObservable<TSource2> Second { get; private set; }
        internal IObservable<TSource3> Third { get; private set; }
        internal IObservable<TSource4> Fourth { get; private set; }
        internal IObservable<TSource5> Fifth { get; private set; }
        internal IObservable<TSource6> Sixth { get; private set; }
        internal IObservable<TSource7> Seventh { get; private set; }
        internal IObservable<TSource8> Eighth { get; private set; }
        internal IObservable<TSource9> Ninth { get; private set; }
        internal IObservable<TSource10> Tenth { get; private set; }
        internal IObservable<TSource11> Eleventh { get; private set; }
        internal IObservable<TSource12> Twelfth { get; private set; }
        internal IObservable<TSource13> Thirteenth { get; private set; }
        internal IObservable<TSource14> Fourteenth { get; private set; }
        internal IObservable<TSource15> Fifteenth { get; private set; }
        internal IObservable<TSource16> Sixteenth { get; private set; }

        /// <summary>
        /// Matches when all observable sequences have an available element and projects the elements by invoking the selector function.
        /// </summary>
        /// <typeparam name="TResult">The type of the elements in the result sequence, returned by the selector function.</typeparam>
        /// <param name="selector">Selector that will be invoked for elements in the source sequences.</param>
        /// <returns>Plan that produces the projected results, to be fed (with other plans) to the When operator.</returns>
        /// <exception cref="ArgumentNullException"><paramref name="selector"/> is null.</exception>
        public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TSource16, TResult> selector)
        {
            if (selector == null)
                throw new ArgumentNullException("selector");

            return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, TSource10, TSource11, TSource12, TSource13, TSource14, TSource15, TSource16, TResult>(this, selector);
        }

    }

#endif

    #endregion
}