DACS.README(7)          DACS Miscellaneous Information          DACS.README(7)



[1mNAME[0m
       dacs.readme - [1mDACS [22mREADME

[1mDESCRIPTION[0m
       This file is part of the [1mDACS [22msuite.

       After reviewing this document, it will be beneficial to look at these
       important documents:

       +o   for a brief description of this release, and possibly last minute
           updates, please refer to [34m[1mREADME[0m[1m[22m[1]

       +o   for a technical overview of the system, including a description of
           command line flags common to most [1mDACS [22mprograms, please see
           [34m[1mdacs(1)[0m[1m[22m[2]

       +o   for information about licensing, please refer to [34m[1mLICENSE[0m[1m[22m[3]

       +o   for information about installation, please refer to
           [34m[1mdacs.install(7)[0m[1m[22m[4]

       +o   for the Quick Start tutorial, please refer to [34m[1mdacs.quick(7)[0m[1m[22m[5]

       +o   for important release notes, please visit
           [34m[1mhttps://dacs.dss.ca/download.html[0m


           [1mNO WARRANTY[0m
           This software is provided by Dss "as is" and any express or implied
           warranties, including, but not limited to, the implied warranties
           of merchantability, fitness for a particular purpose, or
           non-infringement, are disclaimed. in no event shall dss be liable
           for any direct, indirect, incidental, special, exemplary, or
           consequential damages (including, but not limited to, procurement
           of substitute goods or services; loss of use, data, or profits; or
           business interruption) however caused and on any theory of
           liability, whether in contract, strict liability, or tort
           (including negligence or otherwise) arising in any way out of the
           use of this software, even if advised of the possibility of such
           damage.

   [1mDACS At a Glance[0m
       [1mDACS [22mis:

       +o   a light-weight, open source single sign-on system;

       +o   a flexible and powerful attribute- and role-based access control
           system;

       +o   a set of feature-rich authentication methods;

       +o   an [34m[1mApache[0m[1m[22m[6] 2.2 and 2.4 module and suite of CGI programs;

       +o   able to apply coarse-grained access control to web service requests
           made using standard web browsers;

       +o   able to provide fine-grained access control functionality to almost
           any program or script;

       +o   a collection of web services that can provide access control and
           identity management functionality to your middleware;

       +o   a C/C++ toolkit for building new authentication and access control
           functionality into programs, whether web-based or not;

       +o   for Unix-type platforms, such as GNU/Linux, macOS, and FreeBSD.


       [4mFor[24m [4mdevelopers[24m, [1mDACS [22mmakes access control functionality available
       through the command line, allowing scripts (Perl, PHP, shell, etc.) to
       make data-driven access control decisions rather than program-driven
       ones. This can be used completely independently of the web
       functionality and without dealing with run-time configuration of [1mDACS[22m.
       Please see [34m[1mdacscheck(1)[0m[1m[22m[7].  [1mDACS [22malso provides web services from which
       single sign-on systems can be constructed.

       [4mFor[24m [4mweb[24m [4msites[24m, [1mDACS [22mcan help manage access to web resources in many
       situations, whether you have just one web server, several web servers
       at one site, or many web servers spread across the Internet. You may
       find it to be useful simply as a universal authentication mechanism for
       a single [1mApache [22mserver or as a full-fledged, single sign-on
       multi-server identity management and access control system.

           [1mTip[0m
           If you are interested in [34m[1mdacscheck(1)[0m[1m[22m[7] or the general-purpose
           [1mDACS [22mutilities (e.g., [34m[1mdacshttp(1)[0m[1m[22m[8], [34m[1msslclient(1)[0m[1m[22m[9]) but are not
           interested in web services or [1mApache[22m, refer to the instructions in
           [34m[1mdacs.install(7)[0m[1m[22m[4].

       The [1mDACS [22mhome page is at [34m[1mhttps://dacs.dss.ca[0m[1m[22m.  [1mDACS [22mwas hosted as a
       [34m[1mSourceForge[0m[1m[22m[10] project at [34m[1mhttp://sourceforge.net/projects/dacs[0m[1m[22m, but
       that has not been used since 2013.

   [1mSupported Platforms[0m
       [1mDACS [22mis currently developed and tested:

       +o   with [34m[1mApache[0m[1m[22m[6] 2.2.31 and 2.4.25 (2.0.X releases, which were once
           supported, are now deprecated and untested)

       +o   on platforms:

           +o    [34m[1mFreeBSD[0m[1m[22m[11] 10.3 and 11.1 (amd64)

           +o    [34m[1mCentOS[0m[1m[22m[12] 7.3 (x86_64, Linux 3.10, built from [34m[1mRed Hat[0m
               [1m[34mEnterprise Linux[0m[1m[22m[13] 7)

           +o    [34m[1mmacOS Sierra[0m[1m[22m[14] 10.13.3 (Intel Core i7, x86_64)

           +o   using [1mGCC [22m5.4 (and newer), and on some platforms, recent
               Clang/LLVM compilers

           +o   using recent [1mFirefox[22m, [1mSafari[22m, [1mChrome[22m, and [1mInternet Explorer[0m
               browsers


           [1mImportant[0m
           [1mDACS [22m1.4.40 is the final version to officially support the Apache
           2.2 series. Future releases of [1mDACS [22mwill not be maintained, tested,
           or documented with Apache 2.2 series servers.

       FreeBSD 10.3 is the primary development platform. For this reason,
       references to Unix manual pages throughout the [1mDACS [22mdocumentation cite
       the FreeBSD documentation. This should not matter much if you are using
       a different platform, but keep this in mind.

       Most [1mDACS [22minstallations are on Linux or FreeBSD platforms. Support for
       macOS is comparatively recent.

           [1mNote[0m
           +o   When building [1mDACS [22mfor use with [1mApache [22m2.2, you will probably
               need to specify the [1m--with-apache-apr [22mflag, and perhaps other
               [1mApache[22m-related flags, to [1mconfigure[22m.

           +o   [1mApache [22m1.3 and 2.0 are [4mnot[24m supported (please refer to the
               [34m[1mFAQ[0m[1m[22m[15]).

           +o   [1mDACS [22mhas not been tested with [1mApache [22m2.1.

   [1mOther Platforms[0m
       [1mDACS [4m[22mis[24m [4mnot[24m [4mofficially[24m [4msupported[24m [4mon[24m [4mplatforms[24m [4mother[24m [4mthan[24m [4mthose[0m
       [4mdescribed[24m [4mabove[24m. Recent releases have built and worked correctly on
       other platforms, but because we do not have ready access to them, or
       due to lack of interest, we no longer test on them.

       Up to and including version 1.4.25, [1mDACS [22mwas tested and used on [34m[1mSolaris[0m
       [1m[34m10[0m[1m[22m[16] ([34m[1mOpenSolaris[0m[1m[22m[17] 2008.11, SunOS 5.11, [34m[1mx86[0m[1m[22m[18]).  Solaris is no
       longer supported. Early versions of [1mDACS [22mwere used on Solaris 8 (SPARC)
       and Solaris 10 (SPARC) platforms. A wide variety of build, install, and
       run-time problems were encountered with third-party packages on the
       OpenSolaris and SPARC platforms. Depending on which third-party
       software your [1mDACS [22mconfiguration requires, or if you are prepared to
       try older versions of third-party software or devote extra effort, you
       may have some success running [1mDACS [22mon these platforms, but in general
       we cannot recommend using these platforms for [1mDACS [22min production
       settings and they are no longer officially supported. Comments specific
       to Solaris remain in the [1mDACS [22mdocumentation but will likely be removed
       in a future release, as will configuration and build capabilities.

       Earlier releases of [1mDACS [22mcompiled and (mostly) installed cleanly on
       WinXP/[34m[1mCygwin[0m[1m[22m[19] 1.7.5 and later with [1mGCC [22m4.3, but starting with [1mDACS[0m
       1.4.26, [34m[1mCygwin[0m[1m[22m[19] is no longer used for testing [1mDACS[22m. Comments
       specific to Cygwin that remain in the [1mDACS [22mdocumentation will likely be
       removed in a future release, as will configuration and build
       capabilities. Regarding Cygwin and earlier versions of [1mDACS[22m:

       +o    [1mmod_auth_dacs [22mdoes not build as a shared module

       +o   there were problems building [1mExpat [22m2.0.0 from source (2.0.1 is ok)

       +o   only limited testing has been performed on this platform

       +o   you can't execute src/config.nice; copy it to some other filename
           and execute that instead

       +o   when doing "make install", try the username and group
           "Administrators" or "Administrator" when prompted if you don't know
           what else to use (the install procedure should use those names as
           defaults


       We expect that [1mDACS [22mwill also run on other varieties of Unix and with
       other browsers. No testing is done with very old browsers, however. We
       would appreciate reports of problems encountered while building or
       running [1mDACS [22mon unofficial platforms so that we can address portability
       issues and support these platforms better.

   [1mWarnings[0m
       [4mPlease[24m [4mread[24m [4mthis[24m [4msection[24m [4mcarefully[24m!

           [1mSecurity[0m
            1. After obtaining a [1mDACS [22mrelease, please verify [4mall[24m checksums for
               the file you downloaded. Do not use a download if any checksum
               for it does not match. Checksums are posted at
               [34m[1mhttps://dacs.dss.ca/download.html [0m[1m[22mimmediately after a new
               release is distributed.

               [1mOpenSSL's dgst [22mcommand can be used to compute checksums; for
               example,

                   % openssl dgst -md5 dacs-1.4.32.tgz
                   % openssl dgst -sha1 dacs-1.4.32.tgz


            2. Improper installation, configuration, or use of [1mDACS [22mmay leave
               your system open to various kinds of attacks and exploits.

               Many other systems and software components, including [1mApache[0m
               and [1mOpenSSL[22m, can also compromise system security if not
               properly installed, configured, and administered; they give
               similar admonishments. Please take appropriate care.

               A [1mDACS [22madministrator ought to have some experience with [1mApache[0m
               configuration (including its authentication and access control
               directives, and building [1mhttpd[22m), and basic knowledge of
               security issues on the installation platform.

            3. The security of [1mDACS [22mdepends on the security of the underlying
               operating system, third party software, build, installation,
               and configuration parameters, human factors, and more. In
               particular, ensure that file ownership and modes are
               appropriate for run-time accessible [1mDACS [22mconfiguration and data
               files (dacs.conf, site.conf, encryption keys, access control
               rules, group files, etc.).

            4. Users of your [1mDACS[22m-wrapped services are responsible for
               maintaining the secrecy of information used to sign on (such as
               passwords) and authentication and authorization information
               sent to them by [1mDACS [22m(such as HTTP cookies). Spyware, and
               browser modifications or improper settings, may compromise
               security - [1mDACS [22mcannot prevent improper use or intentional
               misuse.

            5. After access is granted to a resource, [1mDACS [22mdoes nothing to
               stop a user from redistributing whatever is returned by the web
               server. Therefore, strictly speaking, [1mDACS [22mis neither a
               copyright enforcement system nor is it a [34m[1mDigital Rights[0m
               [1m[34mManagement (DRM) system[0m[1m[22m[20], although it may be possible to
               apply [1mDACS [22min those domains.  [1mDACS [22mdoes have the ability to
               force a user to view and acknowledge a copyright notice or
               license, however.

            6. Making routine backup copies of your current [1mDACS [22mconfiguration
               and data files is [4mstrongly[24m [4mencouraged[24m. A procedure should be
               established for periodically creating copies of your [1mDACS[0m
               installation and keeping them in a secure, off-site location.
               This is especially important for encryption keys and account
               files, which cannot be recreated if lost.

            7. Please review Section 15 ("Security Considerations") of [34m[1mRFC[0m
               [1m[34m2616[0m[1m[22m[21].

            8. Be sure to check for new releases of [1mDACS [22mregularly. New
               releases may address important bugs and security issues, so
               keeping your installation current is important. You can
               [34m[1msubscribe to email notifications[0m[1m[22m[22].

               You should likewise stay alert to new releases of third-party
               packages that your install of [1mDACS [22muses.

            9. Note that, because of the enormous number of combinations of
               platforms, versions, third-party packages, build options,
               run-time options, and so on, not every possible [1mDACS [22mdeployment
               that can be created and enabled is actually built or tested.
               This is presumably true for nearly every large software package
               but it's worth emphasizing. Therefore, make sure you test
               carefully before putting your [1mDACS [22mdeployment into production
               and after making changes to it.

           10. Reiterating, test carefully after making changes to your [1mDACS[0m
               configuration. In particular, make sure that new access control
               rules and user authentication work as you expect.

           11. [4mFor[24m [1mDACS [4m[22mto[24m [4mbe[24m [4ma[24m [4msecure[24m [4msystem,[24m [4mall[24m [4mcommunication[24m [4mbetween[24m [1mDACS[0m
               [4mand[24m [4mits[24m [4musers,[24m [4mcomponents,[24m [4mand[24m [4mmiddleware[24m [4mmust[24m [4mtake[24m [4mplace[24m [4mover[0m
               [4ma[24m [4msecure[24m [4mconnection[24m [4m(typically[24m [4musing[24m [4mSSL/TLS[24m [4mand[24m [4mthe[24m [34m[1mHTTPS[0m[1m[22m[23]
               [4mmethod)[24m [4mto[24m [4msafeguard[24m [4maccount[24m [4mnames,[24m [4mpasswords,[24m [1mDACS[0m
               [4mcredentials,[24m [4mand[24m [4mso[24m [4mon[24m.  [1mDACS [22mdoes not [4mrequire[24m secure network
               connections, however, and can function without them in
               situations where a lower standard of security is acceptable.
               See [34m[1mSECURE_MODE[0m[1m[22m[24].

               Note that if a client connects from an insecure subnet, various
               [34m[1mman-in-the-middle attacks[0m[1m[22m[25] are possible, even when it
               appears that SSL/TLS is being used (for example, see
               [34m[1msslstrip[0m[1m[22m[26]).

           12. In the event of an emergency situation that might be related to
               [1mDACS[22m, you may, of course, stop all [1mApache [22mprocesses. It is
               sufficient to make dacs.conf inaccessible to [1mApache[22m, however,
               whether by renaming the file, changing its ownership, or
               changing its permissions. (Or, you may make the [1mDACS [22mweb
               services unavailable using the same methods.) All [1mDACS [22mweb
               services must be able to read dacs.conf, so this will
               effectively turn [1mDACS [22moff. More selective ways of limiting
               access are available, such as through the revocation list.

           13. [1mDACS [22mdepends mainly on [34m[1mOpenSSL[0m[1m[22m[27], a third-party package that
               you need to obtain separately, for cryptographic functionality.
               Some library functions provided by your operating system (such
               as [34m[1mcrypt(3)[0m[1m[22m[28]) are also used.

           14. It is strongly recommended that the Network Time Protocol (NTP,
               [34m[1mRFC 1305[0m[1m[22m[29]) or equivalent be used on any host that runs [1mDACS[0m
               commands or web services. A sudden, large change to a system's
               clock while [1mDACS [22mis operational may have undesirable effects
               and should be avoided. In particular, setting the system's
               clock backward must be avoided as it may make the system more
               vulnerable to attack, such as by effectively extending the
               lifetime of sensitive data or the validity period of certain
               operations.

           15. System administrators should take appropriate steps to ensure
               that Domain Name System (DNS, [34m[1mRFC 1035[0m[1m[22m[30]) lookups are secure.

           16. If you are deploying [1mDACS [22mas part of a publicly accessible web
               site, consider including a notification on your site that it
               may issue cookies. This is commonly mentioned in a site's
               "Privacy" or "Security" page.  [1mDACS [22mmay not function as
               expected if a user's browser has disabled cookies or will not
               accept them; in particular, the single sign-on feature
               generally requires that users' browsers accept cookies.

           17. The [1mDACS [22mdistribution may include code, features, or
               functionality that is not described in the distribution's
               documentation, or is described as untested, partially
               implemented, or deprecated, or is accompanied by a warning.
               Such code, features, or functionality is subject to change or
               removal without notice and should not be used.

           18. Weaknesses that render cryptographic algorithms unsuitable in
               certain contexts are inevitably discovered and publicly
               announced.  [1mDACS [22madministrators should revise the configuration
               of cryptographic digests and ciphers appropriately over time to
               maintain the security of their system.


           [1mImportant[0m
           [1mDACS [22mMAY INCLUDE ITS OWN CRYPTOGRAPHIC FUNCTIONS and may therefore
           fall under certain import, export, and/or use restrictions in other
           parts of the world, even though [1mDACS [22mis developed, maintained, and
           officially distributed from Canada.

           Export and/or import and/or use of strong cryptography software,
           providing cryptography hooks, or merely communicating technical
           details about cryptographic software is illegal in some parts of
           the world. YOU ARE STRONGLY ADVISED to pay close attention to any
           laws that may apply when you import, export, or use [1mDACS[22m, or even
           communicate about it. We are not liable for any violations you make
           - it is your responsibility. For additional information, see the
           [34m[1mCrypto Law Survey[0m[1m[22m[31].

   [1mRelease Information[0m
       Information about [1mDACS [22mreleases, including the latest release, is
       provided in the [34m[1mVersion Guide[0m[1m[22m[32] and on the [34m[1mDownload and Release[0m
       [1m[34mInformation [0m[1m[22mpage.

       To programmatically determine the latest version of [1mDACS [22mand obtain a
       direct link for downloading, you may invoke
       [34m[1mhttps://dacs.dss.ca/cgi-bin/dacs/latest_dacs[0m[1m[22m, which returns a simple
       text document comprised of name/value pairs.

   [1mRoadmap[0m
       Stability, backward compatibility, portability across supported
       platforms, and keeping up to date with respect to third-party support
       packages are now the primary goals of [1mDACS [22m1.4 releases. A top priority
       is to fix all known bugs between releases and improve the
       documentation.

       Please consult the [1mDACS [34mweb site [0m[1m[22mfor information on upcoming releases.

   [1mUpgrading[0m
           [1mSecurity[0m
           Because [1mDACS [22mis security software, we strongly recommend that you
           upgrade to the newest release as soon as you are able.

       Upgrading is neither a difficult nor a time consuming procedure most
       times. Sometimes an incompatible change in [1mDACS [22mwill require you to
       change a [1mDACS [22mconfiguration file, but this should not be difficult to
       do and we will try to advise you of such changes.

       The [1mDACS [22m1.4 releases contain a great many changes and improvements,
       some incompatible with earlier releases of [1mDACS[22m. If you are upgrading
       from [1mDACS [22m1.3.2 or another older release, you will need to become
       familiar with these changes. You must manually convert your old [1mDACS[0m
       configuration files to the new format, for example. You should not find
       upgrading to be a difficult or time consuming task.

           [1mImportant[0m
           Making backup copies of your [1mDACS [22minstallation immediately prior to
           upgrading is strongly recommended.

       Some features available in earlier versions of [1mDACS [22mare not available
       in this release, but will be provided as soon as possible.

       Note that [1mDACS [22m1.4 may not interoperate with prior releases.

       We aim to avoid making any backward incompatible changes within the
       [1mDACS [22m1.4.x releases.

   [1mAdd-on Features[0m
       Some features of [1mDACS [22mmay be implemented by third parties or as custom
       extensions. They may be included with the open source [1mDACS [22mdistribution
       (and therefore fall under the open source [34m[1mLICENSE[0m[1m[22m[3]), or are provided
       separately. The [34m[1mdacsversion[0m[1m[22m[33] command and [34m[1mdacs_version[0m[1m[22m[34] web
       service indicate whether add-ons are enabled (present) in a particular
       installation of [1mDACS[22m; look for +addons or addons="enabled" from the
       former, and ENABLE_ADDONS=1 from the latter.

       While add-ons may provide new capabilities, they should not alter the
       syntax or semantics of capabilities shared with the base [1mDACS[0m
       distribution.

   [1mAdministration[0m
       Once installed and configured, [1mDACS [22mrequires very little
       administration.

           [1mTip[0m
           At higher logging levels, [1mDACS [22mlog files can become large quite
           quickly. You should therefore arrange for them to be rotated
           regularly (e.g., using [34m[1mnewsyslog(8)[0m[1m[22m[35]). A built-in log rotation
           feature is being considered for [1mDACS[22m.

       If you're creating [1mDACS [22mlog files that have names based on their date
       of creation, to expire/rotate/compress them you might periodically run
       the [34m[1mfind(1)[0m[1m[22m[36] command to identify old logs. For example, the command

           % find /usr/local/dacs/logs -type f -a -mtime 2 -a -exec gzip {} \;

       will compress any files in the log directory that haven't been modified
       for at least 24 hours.

       There are also [1mApache [22mmodules available to do the rotation:

       +o    [34m[1mhttp://httpd.apache.org/modules[0m

       +o    [34m[1mhttp://modules.apache.org[0m


   [1mRelated Software[0m
       A variety of other software and resources for [1mDACS [22mcan be found in the
       [34m[1mdacs-contrib[0m[1m[22m[37] project at [34m[1mSourceForge[0m[1m[22m[10].

       [1mThe DACS Java Library (DJL)[0m
           The [1mDJL [22mis being developed to support the use of [1mDACS [22min Java
           client applications. It implements Java wrapper classes for
           selected [1mDACS [22mservices, and provides an HTTP client through which
           [1mDACS [22mservices may be accessed and [1mDACS [22mcredentials obtained and
           managed.

       [1mThe FedAdmin Web Application[0m
           [1mFedAdmin [22mis an administrator console for managing the configuration
           of [1mDACS [22mfederations and jurisdictions. It is deployed in a servlet
           container such as Tomcat, but must be accessed via an Apache+[1mDACS[0m
           proxy and deployed under a dedicated FEDADMIN [1mDACS [22mapplication
           jurisdiction.

           [1mFedAdmin [22mimplements partial coverage of the most common [1mDACS[0m
           configuration tasks, including viewing federation and jurisdiction
           configuration directives, adding and deleting local [1mDACS [22musers, and
           creating, editing, and deleting ACL rules.

   [1mSupport[0m
       An array of technical support is available from [34m[1mDSS[0m[1m[22m[38]. Please see the
       [34m[1msupport page[0m[1m[22m[39] for details.  [1mDACS [22mdevelopment, maintenance, and free
       support is made possible in part by customers that purchase technical
       support packages or contract for customizations (most of which then
       become available to all free of charge).

   [1mKnown Problems[0m
       There are a few defects in the [1mDACS [22m1.4 releases that administrators
       should be aware of. These are not likely to be addressed in the near
       future.

        1. If the HTTP data stream is compressed or encrypted (other than via
           SSL/TLS), [1mDACS [22mwill not be able to access POST arguments and you
           should use the [1mmod_auth_dacs [22mmodule directive
           "SetDACSAuthPostBuffer 0".

        2. In general, [1mDACS [22mdoes not support IPv6 addresses.

        3. The group management service and group distribution utilities have
           not be tested with this release of [1mDACS[22m.

        4. The man pages are generated from DocBook XML. The docbook-xsl used
           to create [nt]roff source is incomplete and/or buggy. As a result,
           the quality of the formatting is sometimes poor. You will find the
           HTML version of the documentation more readable.

        5. Support for internationalization is poor.

        6. Some configuration directives have global scope (i.e., they apply
           in several contexts) when it might be preferable to have
           context-specific versions of them. For example, the algorithm
           specified by [34m[1mPASSWORD_DIGEST[0m[1m[22m[40] is used for more than one purpose
           within [1mDACS[22m. On the other hand, this reduces the number of
           directives, and therefore helps to contain the complexity of [1mDACS[22m.

   [1mBugs, Suggestions, and Feedback[0m
       Please see the [34m[1msupport page[0m[1m[22m[39] for details.

       Some elements of [1mDACS [22mare less well-travelled than others and users may
       therefore experience problems with them. Please [34m[1mlet us know[0m[1m[22m[41] if you
       encounter bugs.

[1mSEE ALSO[0m
       [34m[1mdacs(1)[0m[1m[22m[2], [34m[1mdacs.install(7)[0m[1m[22m[4], [34m[1mdacs.quick(7)[0m[1m[22m[5]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[38])

[1mCOPYING[0m
       Copyright (C) 2003-2018 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[3] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. README
           http://dacs.dss.ca/man/../misc/README

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        5. dacs.quick(7)
           http://dacs.dss.ca/man/dacs.quick.7.html

        6. Apache
           http://httpd.apache.org

        7. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        8. dacshttp(1)
           http://dacs.dss.ca/man/dacshttp.1.html

        9. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       10. SourceForge
           http://www.sourceforge.net

       11. FreeBSD
           https://www.freebsd.org

       12. CentOS
           http://www.centos.org

       13. Red Hat Enterprise Linux
           http://www.redhat.com/rhel

       14. macOS Sierra
           http://www.apple.com/macosx

       15. FAQ
           https://dacs.dss.ca/faq.html

       16. Solaris 10
           http://www.sun.com/software/solaris/10/index.jsp

       17. OpenSolaris
           http://www.opensolaris.com

       18. x86
           http://www.solaris-x86.org/

       19. Cygwin
           http://cygwin.com/

       20. Digital Rights Management (DRM) system
           http://en.wikipedia.org/wiki/Digital_rights_management

       21. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       22. subscribe to email notifications
           http://freshmeat.net/projects/dacs/

       23. HTTPS
           http://www.rfc-editor.org/rfc/rfc2818.txt

       24. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       25. man-in-the-middle attacks
           http://en.wikipedia.org/wiki/Man-in-the-middle_attack

       26. sslstrip
           http://www.thoughtcrime.org/software/sslstrip

       27. OpenSSL
           http://www.openssl.org

       28. crypt(3)
           https://www.freebsd.org/cgi/man.cgi?query=crypt&apropos=0&sektion=3&manpath=FreeBSD+10.3-RELEASE&format=html

       29. RFC 1305
           http://www.rfc-editor.org/rfc/rfc1305.txt

       30. RFC 1035
           http://www.rfc-editor.org/rfc/rfc1035.txt

       31. Crypto Law Survey
            http://www.cryptolaw.org

       32. Version Guide
           https://dacs.dss.ca/versions.html

       33. dacsversion
           http://dacs.dss.ca/man/dacsversion.1.html

       34. dacs_version
           http://dacs.dss.ca/man/dacs_version.8.html

       35. newsyslog(8)
           https://www.freebsd.org/cgi/man.cgi?query=newsyslog&apropos=0&sektion=8&manpath=FreeBSD+10.3-RELEASE&format=html

       36. find(1)
           https://www.freebsd.org/cgi/man.cgi?query=find&apropos=0&sektion=1&manpath=FreeBSD+10.3-RELEASE&format=html

       37. dacs-contrib
           http://sourceforge.net/projects/dacs-contrib

       38. DSS
           http://www.dss.ca

       39. support page
           https://dacs.dss.ca/support.html

       40. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       41. let us know
           http://www.dss.ca/contactus.html



DACS 1.4.40                       02/01/2018                    DACS.README(7)
