/* vfs-volume-impl-gio.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-volume-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: VFS Volume implementation (GIO).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO (desktop_agnostic_vfs_volume_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIOClass))

typedef struct _DesktopAgnosticVFSVolumeGIO DesktopAgnosticVFSVolumeGIO;
typedef struct _DesktopAgnosticVFSVolumeGIOClass DesktopAgnosticVFSVolumeGIOClass;
typedef struct _DesktopAgnosticVFSVolumeGIOPrivate DesktopAgnosticVFSVolumeGIOPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO (desktop_agnostic_vfs_volume_monitor_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_VOLUME_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIOClass))

typedef struct _DesktopAgnosticVFSVolumeMonitorGIO DesktopAgnosticVFSVolumeMonitorGIO;
typedef struct _DesktopAgnosticVFSVolumeMonitorGIOClass DesktopAgnosticVFSVolumeMonitorGIOClass;
typedef struct _DesktopAgnosticVFSVolumeMonitorGIOPrivate DesktopAgnosticVFSVolumeMonitorGIOPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

struct _DesktopAgnosticVFSVolumeGIO {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeGIOPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeGIOClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeGIOPrivate {
	GVolume* vol;
	DesktopAgnosticVFSFile* _uri;
	char* _icon;
	DesktopAgnosticVFSVolumeCallback _mount_callback;
	gpointer _mount_callback_target;
	GDestroyNotify _mount_callback_target_destroy_notify;
	GAsyncResult* async_result;
	DesktopAgnosticVFSVolumeCallback _unmount_callback;
	gpointer _unmount_callback_target;
	GDestroyNotify _unmount_callback_target_destroy_notify;
	DesktopAgnosticVFSVolumeCallback _eject_callback;
	gpointer _eject_callback_target;
	GDestroyNotify _eject_callback_target_destroy_notify;
};

struct _DesktopAgnosticVFSVolumeMonitorGIO {
	GObject parent_instance;
	DesktopAgnosticVFSVolumeMonitorGIOPrivate * priv;
};

struct _DesktopAgnosticVFSVolumeMonitorGIOClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSVolumeMonitorGIOPrivate {
	GVolumeMonitor* monitor;
	GHashTable* _volumes;
};


static gpointer desktop_agnostic_vfs_volume_gio_parent_class = NULL;
static DesktopAgnosticVFSVolumeIface* desktop_agnostic_vfs_volume_gio_desktop_agnostic_vfs_volume_parent_iface = NULL;
static gpointer desktop_agnostic_vfs_volume_monitor_gio_parent_class = NULL;
static DesktopAgnosticVFSVolumeMonitorIface* desktop_agnostic_vfs_volume_monitor_gio_desktop_agnostic_vfs_volume_monitor_parent_iface = NULL;

GType desktop_agnostic_vfs_volume_gio_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, DesktopAgnosticVFSVolumeGIOPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_NAME,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_URI,
	DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_ICON
};
static gboolean desktop_agnostic_vfs_volume_gio_real_is_mounted (DesktopAgnosticVFSVolume* base);
static void desktop_agnostic_vfs_volume_gio_on_mount (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res);
static void desktop_agnostic_vfs_volume_gio_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static void _desktop_agnostic_vfs_volume_gio_on_mount_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean desktop_agnostic_vfs_volume_gio_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error);
static void desktop_agnostic_vfs_volume_gio_on_unmount (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res);
static void desktop_agnostic_vfs_volume_gio_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static void _desktop_agnostic_vfs_volume_gio_on_unmount_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean desktop_agnostic_vfs_volume_gio_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error);
static gboolean desktop_agnostic_vfs_volume_gio_real_can_eject (DesktopAgnosticVFSVolume* base);
static void desktop_agnostic_vfs_volume_gio_on_eject (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res);
static void desktop_agnostic_vfs_volume_gio_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target);
static void _desktop_agnostic_vfs_volume_gio_on_eject_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean desktop_agnostic_vfs_volume_gio_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error);
DesktopAgnosticVFSVolumeGIO* desktop_agnostic_vfs_volume_gio_new (void);
DesktopAgnosticVFSVolumeGIO* desktop_agnostic_vfs_volume_gio_construct (GType object_type);
static void desktop_agnostic_vfs_volume_gio_set_implementation (DesktopAgnosticVFSVolumeGIO* self, GVolume* value);
static void desktop_agnostic_vfs_volume_gio_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_vfs_volume_gio_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_agnostic_vfs_volume_monitor_gio_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO, DesktopAgnosticVFSVolumeMonitorGIOPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_IMPLEMENTATION,
	DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_VOLUMES
};
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_create_volume (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolume* vol);
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_check_volume (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolume* gvol);
static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_get_volume_from_mount (DesktopAgnosticVFSVolumeMonitorGIO* self, GMount* mount);
static void desktop_agnostic_vfs_volume_monitor_gio_on_mount_added (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GMount* mount);
static void desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GMount* mount);
static void desktop_agnostic_vfs_volume_monitor_gio_on_volume_added (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GVolume* gvol);
static void desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GVolume* gvol);
DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_new (void);
DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_construct (GType object_type);
static void _desktop_agnostic_vfs_volume_monitor_gio_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gio_on_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _g_list_free_g_object_unref (GList* self);
static GObject * desktop_agnostic_vfs_volume_monitor_gio_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void desktop_agnostic_vfs_volume_monitor_gio_finalize (GObject* obj);
static void desktop_agnostic_vfs_volume_monitor_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);



static gboolean desktop_agnostic_vfs_volume_gio_real_is_mounted (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeGIO * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	result = g_volume_get_mount (self->priv->vol) != NULL;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void desktop_agnostic_vfs_volume_gio_on_mount (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	DesktopAgnosticVFSVolumeCallback _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	self->priv->async_result = (_tmp0_ = _g_object_ref0 (res), _g_object_unref0 (self->priv->async_result), _tmp0_);
	self->priv->_mount_callback (self->priv->_mount_callback_target);
	self->priv->_mount_callback = (_tmp1_ = NULL, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp1_);
}


static void _desktop_agnostic_vfs_volume_gio_on_mount_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	desktop_agnostic_vfs_volume_gio_on_mount (self, source_object, res);
	g_object_unref (self);
}


static void desktop_agnostic_vfs_volume_gio_real_mount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	if (self->priv->_mount_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_mount_callback = (_tmp0_ = callback, ((self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL), self->priv->_mount_callback = NULL, self->priv->_mount_callback_target = NULL, self->priv->_mount_callback_target_destroy_notify = NULL), self->priv->_mount_callback_target = callback_target, self->priv->_mount_callback_target_destroy_notify = NULL, _tmp0_);
		g_volume_mount (self->priv->vol, G_MOUNT_MOUNT_NONE, NULL, NULL, _desktop_agnostic_vfs_volume_gio_on_mount_gasync_ready_callback, g_object_ref (self));
	}
}


static gboolean desktop_agnostic_vfs_volume_gio_real_mount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGIO * self;
	gboolean result = FALSE;
	gboolean _result_;
	GAsyncResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = g_volume_mount_finish (self->priv->vol, self->priv->async_result, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_MOUNT, err->message);
			{
				_g_error_free0 (err);
				goto __finally6;
			}
			_g_error_free0 (err);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	self->priv->async_result = (_tmp1_ = NULL, _g_object_unref0 (self->priv->async_result), _tmp1_);
	result = _result_;
	return result;
}


static void desktop_agnostic_vfs_volume_gio_on_unmount (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	DesktopAgnosticVFSVolumeCallback _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	self->priv->async_result = (_tmp0_ = _g_object_ref0 (res), _g_object_unref0 (self->priv->async_result), _tmp0_);
	self->priv->_unmount_callback (self->priv->_unmount_callback_target);
	self->priv->_unmount_callback = (_tmp1_ = NULL, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp1_);
}


static void _desktop_agnostic_vfs_volume_gio_on_unmount_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	desktop_agnostic_vfs_volume_gio_on_unmount (self, source_object, res);
	g_object_unref (self);
}


static void desktop_agnostic_vfs_volume_gio_real_unmount (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	if (self->priv->_unmount_callback == NULL) {
		GMount* mount;
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		mount = NULL;
		self->priv->_unmount_callback = (_tmp0_ = callback, ((self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL), self->priv->_unmount_callback = NULL, self->priv->_unmount_callback_target = NULL, self->priv->_unmount_callback_target_destroy_notify = NULL), self->priv->_unmount_callback_target = callback_target, self->priv->_unmount_callback_target_destroy_notify = NULL, _tmp0_);
		mount = g_volume_get_mount (self->priv->vol);
		if (mount != NULL) {
			g_mount_unmount (mount, G_MOUNT_UNMOUNT_NONE, NULL, _desktop_agnostic_vfs_volume_gio_on_unmount_gasync_ready_callback, g_object_ref (self));
		}
	}
}


static gboolean desktop_agnostic_vfs_volume_gio_real_unmount_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGIO * self;
	gboolean result = FALSE;
	gboolean _result_;
	GAsyncResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = g_mount_unmount_finish (g_volume_get_mount (self->priv->vol), self->priv->async_result, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_UNMOUNT, err->message);
			{
				_g_error_free0 (err);
				goto __finally7;
			}
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	self->priv->async_result = (_tmp1_ = NULL, _g_object_unref0 (self->priv->async_result), _tmp1_);
	result = _result_;
	return result;
}


static gboolean desktop_agnostic_vfs_volume_gio_real_can_eject (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSVolumeGIO * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	result = g_volume_can_eject (self->priv->vol);
	return result;
}


static void desktop_agnostic_vfs_volume_gio_on_eject (DesktopAgnosticVFSVolumeGIO* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	DesktopAgnosticVFSVolumeCallback _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	self->priv->async_result = (_tmp0_ = _g_object_ref0 (res), _g_object_unref0 (self->priv->async_result), _tmp0_);
	self->priv->_eject_callback (self->priv->_eject_callback_target);
	self->priv->_eject_callback = (_tmp1_ = NULL, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp1_);
}


static void _desktop_agnostic_vfs_volume_gio_on_eject_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	desktop_agnostic_vfs_volume_gio_on_eject (self, source_object, res);
	g_object_unref (self);
}


static void desktop_agnostic_vfs_volume_gio_real_eject (DesktopAgnosticVFSVolume* base, DesktopAgnosticVFSVolumeCallback callback, void* callback_target) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	if (self->priv->_eject_callback == NULL) {
		DesktopAgnosticVFSVolumeCallback _tmp0_;
		self->priv->_eject_callback = (_tmp0_ = callback, ((self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL), self->priv->_eject_callback = NULL, self->priv->_eject_callback_target = NULL, self->priv->_eject_callback_target_destroy_notify = NULL), self->priv->_eject_callback_target = callback_target, self->priv->_eject_callback_target_destroy_notify = NULL, _tmp0_);
		g_volume_eject (self->priv->vol, G_MOUNT_UNMOUNT_NONE, NULL, _desktop_agnostic_vfs_volume_gio_on_eject_gasync_ready_callback, g_object_ref (self));
	}
}


static gboolean desktop_agnostic_vfs_volume_gio_real_eject_finish (DesktopAgnosticVFSVolume* base, GError** error) {
	DesktopAgnosticVFSVolumeGIO * self;
	gboolean result = FALSE;
	gboolean _result_;
	GAsyncResult* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	_result_ = FALSE;
	{
		gboolean _tmp0_;
		_tmp0_ = g_volume_eject_finish (self->priv->vol, self->priv->async_result, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_result_ = _tmp0_;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR, DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR_EJECT, err->message);
			{
				_g_error_free0 (err);
				goto __finally8;
			}
			_g_error_free0 (err);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DESKTOP_AGNOSTIC_VFS_VOLUME_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	self->priv->async_result = (_tmp1_ = NULL, _g_object_unref0 (self->priv->async_result), _tmp1_);
	result = _result_;
	return result;
}


DesktopAgnosticVFSVolumeGIO* desktop_agnostic_vfs_volume_gio_construct (GType object_type) {
	DesktopAgnosticVFSVolumeGIO * self = NULL;
	self = (DesktopAgnosticVFSVolumeGIO*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeGIO* desktop_agnostic_vfs_volume_gio_new (void) {
	return desktop_agnostic_vfs_volume_gio_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO);
}


static void desktop_agnostic_vfs_volume_gio_set_implementation (DesktopAgnosticVFSVolumeGIO* self, GVolume* value) {
	GVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->vol = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->vol), _tmp0_);
	g_object_notify ((GObject *) self, "implementation");
}


static const char* desktop_agnostic_vfs_volume_gio_real_get_name (DesktopAgnosticVFSVolume* base) {
	const char* result;
	DesktopAgnosticVFSVolumeGIO* self;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	result = g_volume_get_name (self->priv->vol);
	return result;
}


static DesktopAgnosticVFSFile* desktop_agnostic_vfs_volume_gio_real_get_uri (DesktopAgnosticVFSVolume* base) {
	DesktopAgnosticVFSFile* result;
	DesktopAgnosticVFSVolumeGIO* self;
	GError * _inner_error_ = NULL;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	if (self->priv->_uri == NULL) {
		GMount* mount;
		mount = _g_object_ref0 (g_volume_get_mount (self->priv->vol));
		if (mount != NULL) {
			GFile* file;
			char* _tmp0_;
			DesktopAgnosticVFSFile* _tmp1_;
			DesktopAgnosticVFSFile* _tmp2_;
			DesktopAgnosticVFSFile* _tmp3_;
			file = _g_object_ref0 (g_mount_get_root (mount));
			_tmp2_ = (_tmp1_ = desktop_agnostic_vfs_file_new_for_uri (_tmp0_ = g_file_get_uri (file), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_object_unref0 (mount);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			self->priv->_uri = (_tmp3_ = _tmp2_, _g_object_unref0 (self->priv->_uri), _tmp3_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (mount);
	}
	result = self->priv->_uri;
	return result;
}


static char* desktop_agnostic_vfs_volume_gio_real_get_icon (DesktopAgnosticVFSVolume* base) {
	char* result;
	DesktopAgnosticVFSVolumeGIO* self;
	self = (DesktopAgnosticVFSVolumeGIO*) base;
	if (self->priv->_icon == NULL) {
		GIcon* icon;
		icon = _g_object_ref0 (g_volume_get_icon (self->priv->vol));
		if (G_IS_THEMED_ICON (icon)) {
			gint icon_names_length1;
			gint _icon_names_size_;
			char** _tmp1_;
			char** _tmp0_;
			char** icon_names;
			icon_names = (_tmp1_ = (char**) (_tmp0_ = g_themed_icon_get_names (G_THEMED_ICON (icon))), icon_names_length1 = _vala_array_length (_tmp0_), _icon_names_size_ = icon_names_length1, _tmp1_);
			if (icon_names_length1 > 0) {
				char* _tmp2_;
				self->priv->_icon = (_tmp2_ = g_strdup (icon_names[0]), _g_free0 (self->priv->_icon), _tmp2_);
			} else {
				char* _tmp3_;
				self->priv->_icon = (_tmp3_ = g_strdup ("drive-harddisk"), _g_free0 (self->priv->_icon), _tmp3_);
			}
		} else {
			if (G_IS_FILE_ICON (icon)) {
				char* path;
				char* _tmp4_;
				path = g_file_get_path (g_file_icon_get_file (G_FILE_ICON (icon)));
				self->priv->_icon = (_tmp4_ = g_strdup (path), _g_free0 (self->priv->_icon), _tmp4_);
				_g_free0 (path);
			} else {
				char* _tmp5_;
				g_warning ("vfs-volume-impl-gio.vala:90: Unknown icon type: %s", g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) icon)));
				self->priv->_icon = (_tmp5_ = g_strdup ("drive-harddisk"), _g_free0 (self->priv->_icon), _tmp5_);
			}
		}
		_g_object_unref0 (icon);
	}
	result = g_strdup (self->priv->_icon);
	return result;
}


static void desktop_agnostic_vfs_volume_gio_class_init (DesktopAgnosticVFSVolumeGIOClass * klass) {
	desktop_agnostic_vfs_volume_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeGIOPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_gio_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_vfs_volume_gio_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_gio_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_IMPLEMENTATION, g_param_spec_object ("implementation", "implementation", "implementation", G_TYPE_VOLUME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_NAME, "name");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_ICON, "icon");
}


static void desktop_agnostic_vfs_volume_gio_desktop_agnostic_vfs_volume_interface_init (DesktopAgnosticVFSVolumeIface * iface) {
	desktop_agnostic_vfs_volume_gio_desktop_agnostic_vfs_volume_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_mounted = desktop_agnostic_vfs_volume_gio_real_is_mounted;
	iface->mount = desktop_agnostic_vfs_volume_gio_real_mount;
	iface->mount_finish = desktop_agnostic_vfs_volume_gio_real_mount_finish;
	iface->unmount = desktop_agnostic_vfs_volume_gio_real_unmount;
	iface->unmount_finish = desktop_agnostic_vfs_volume_gio_real_unmount_finish;
	iface->can_eject = desktop_agnostic_vfs_volume_gio_real_can_eject;
	iface->eject = desktop_agnostic_vfs_volume_gio_real_eject;
	iface->eject_finish = desktop_agnostic_vfs_volume_gio_real_eject_finish;
	iface->get_name = desktop_agnostic_vfs_volume_gio_real_get_name;
	iface->get_uri = desktop_agnostic_vfs_volume_gio_real_get_uri;
	iface->get_icon = desktop_agnostic_vfs_volume_gio_real_get_icon;
}


static void desktop_agnostic_vfs_volume_gio_instance_init (DesktopAgnosticVFSVolumeGIO * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_gio_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GIO (obj);
	_g_object_unref0 (self->priv->vol);
	_g_object_unref0 (self->priv->_uri);
	_g_free0 (self->priv->_icon);
	(self->priv->_mount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_mount_callback_target_destroy_notify (self->priv->_mount_callback_target), NULL);
	self->priv->_mount_callback = NULL;
	self->priv->_mount_callback_target = NULL;
	self->priv->_mount_callback_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->async_result);
	(self->priv->_unmount_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_unmount_callback_target_destroy_notify (self->priv->_unmount_callback_target), NULL);
	self->priv->_unmount_callback = NULL;
	self->priv->_unmount_callback_target = NULL;
	self->priv->_unmount_callback_target_destroy_notify = NULL;
	(self->priv->_eject_callback_target_destroy_notify == NULL) ? NULL : (self->priv->_eject_callback_target_destroy_notify (self->priv->_eject_callback_target), NULL);
	self->priv->_eject_callback = NULL;
	self->priv->_eject_callback_target = NULL;
	self->priv->_eject_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_gio_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_gio_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_gio_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeGIOClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeGIO), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_gio_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_gio_desktop_agnostic_vfs_volume_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_gio_type_id;
		desktop_agnostic_vfs_volume_gio_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeGIO", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_gio_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME, &desktop_agnostic_vfs_volume_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_gio_type_id__volatile, desktop_agnostic_vfs_volume_gio_type_id);
	}
	return desktop_agnostic_vfs_volume_gio_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_NAME:
		g_value_set_string (value, desktop_agnostic_vfs_volume_get_name ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_URI:
		g_value_set_object (value, desktop_agnostic_vfs_volume_get_uri ((DesktopAgnosticVFSVolume*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_ICON:
		g_value_take_string (value, desktop_agnostic_vfs_volume_get_icon ((DesktopAgnosticVFSVolume*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_vfs_volume_gio_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_GIO_IMPLEMENTATION:
		desktop_agnostic_vfs_volume_gio_set_implementation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_create_volume (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolume* vol) {
	DesktopAgnosticVFSVolume* result = NULL;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vol != NULL, NULL);
	result = DESKTOP_AGNOSTIC_VFS_VOLUME ((_tmp0_ = g_object_new (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_GIO, "implementation", vol, NULL), G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_));
	return result;
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_check_volume (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolume* gvol) {
	DesktopAgnosticVFSVolume* result = NULL;
	DesktopAgnosticVFSVolume* vol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gvol != NULL, NULL);
	vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, gvol));
	if (vol == NULL) {
		DesktopAgnosticVFSVolume* _tmp0_;
		vol = (_tmp0_ = desktop_agnostic_vfs_volume_monitor_gio_create_volume (self, gvol), _g_object_unref0 (vol), _tmp0_);
		g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (gvol), _g_object_ref0 (vol));
	}
	result = vol;
	return result;
}


static DesktopAgnosticVFSVolume* desktop_agnostic_vfs_volume_monitor_gio_get_volume_from_mount (DesktopAgnosticVFSVolumeMonitorGIO* self, GMount* mount) {
	DesktopAgnosticVFSVolume* result = NULL;
	GVolume* gvol;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mount != NULL, NULL);
	gvol = _g_object_ref0 (g_mount_get_volume (mount));
	if (gvol == NULL) {
		result = NULL;
		_g_object_unref0 (gvol);
		return result;
	} else {
		result = desktop_agnostic_vfs_volume_monitor_gio_check_volume (self, gvol);
		_g_object_unref0 (gvol);
		return result;
	}
	_g_object_unref0 (gvol);
}


static void desktop_agnostic_vfs_volume_monitor_gio_on_mount_added (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GMount* mount) {
	DesktopAgnosticVFSVolume* volume;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (mount != NULL);
	volume = desktop_agnostic_vfs_volume_monitor_gio_get_volume_from_mount (self, mount);
	if (volume != NULL) {
		g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-mounted", volume);
	}
	_g_object_unref0 (volume);
}


static void desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GMount* mount) {
	DesktopAgnosticVFSVolume* volume;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (mount != NULL);
	volume = desktop_agnostic_vfs_volume_monitor_gio_get_volume_from_mount (self, mount);
	if (volume != NULL) {
		g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-unmounted", volume);
	}
	_g_object_unref0 (volume);
}


static void desktop_agnostic_vfs_volume_monitor_gio_on_volume_added (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GVolume* gvol) {
	DesktopAgnosticVFSVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (gvol != NULL);
	_tmp0_ = desktop_agnostic_vfs_volume_monitor_gio_check_volume (self, gvol);
	_g_object_unref0 (_tmp0_);
}


static void desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed (DesktopAgnosticVFSVolumeMonitorGIO* self, GVolumeMonitor* vmonitor, GVolume* gvol) {
	DesktopAgnosticVFSVolume* vol;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vmonitor != NULL);
	g_return_if_fail (gvol != NULL);
	vol = _g_object_ref0 ((DesktopAgnosticVFSVolume*) g_hash_table_lookup (self->priv->_volumes, gvol));
	if (vol != NULL) {
		g_hash_table_remove (self->priv->_volumes, gvol);
		g_signal_emit_by_name ((DesktopAgnosticVFSVolumeMonitor*) self, "volume-unmounted", vol);
	}
	_g_object_unref0 (vol);
}


DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_construct (GType object_type) {
	DesktopAgnosticVFSVolumeMonitorGIO * self = NULL;
	self = (DesktopAgnosticVFSVolumeMonitorGIO*) g_object_new (object_type, NULL);
	return self;
}


DesktopAgnosticVFSVolumeMonitorGIO* desktop_agnostic_vfs_volume_monitor_gio_new (void) {
	return desktop_agnostic_vfs_volume_monitor_gio_construct (DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR_GIO);
}


static void* desktop_agnostic_vfs_volume_monitor_gio_real_get_implementation (DesktopAgnosticVFSVolumeMonitor* base) {
	void* result;
	DesktopAgnosticVFSVolumeMonitorGIO* self;
	self = (DesktopAgnosticVFSVolumeMonitorGIO*) base;
	result = (void*) self->priv->monitor;
	return result;
}


static GList* desktop_agnostic_vfs_volume_monitor_gio_real_get_volumes (DesktopAgnosticVFSVolumeMonitor* base) {
	GList* result;
	DesktopAgnosticVFSVolumeMonitorGIO* self;
	self = (DesktopAgnosticVFSVolumeMonitorGIO*) base;
	result = g_hash_table_get_values (self->priv->_volumes);
	return result;
}


static void _desktop_agnostic_vfs_volume_monitor_gio_on_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gio_on_mount_added (self, _sender, mount);
}


static void _desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed (self, _sender, mount);
}


static void _desktop_agnostic_vfs_volume_monitor_gio_on_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gio_on_volume_added (self, _sender, volume);
}


static void _desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed (self, _sender, volume);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static GObject * desktop_agnostic_vfs_volume_monitor_gio_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DesktopAgnosticVFSVolumeMonitorGIO * self;
	parent_class = G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_gio_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO (obj);
	{
		GVolumeMonitor* _tmp0_;
		GHashTable* _tmp1_;
		GList* vols;
		self->priv->monitor = (_tmp0_ = g_volume_monitor_get (), _g_object_unref0 (self->priv->monitor), _tmp0_);
		self->priv->_volumes = (_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->priv->_volumes), _tmp1_);
		vols = g_volume_monitor_get_volumes (self->priv->monitor);
		{
			GList* gvol_collection;
			GList* gvol_it;
			gvol_collection = vols;
			for (gvol_it = gvol_collection; gvol_it != NULL; gvol_it = gvol_it->next) {
				GVolume* gvol;
				gvol = (GVolume*) gvol_it->data;
				{
					DesktopAgnosticVFSVolume* vol;
					vol = desktop_agnostic_vfs_volume_monitor_gio_create_volume (self, gvol);
					g_hash_table_insert (self->priv->_volumes, _g_object_ref0 (gvol), _g_object_ref0 (vol));
					_g_object_unref0 (vol);
				}
			}
		}
		g_signal_connect_object (self->priv->monitor, "mount-added", (GCallback) _desktop_agnostic_vfs_volume_monitor_gio_on_mount_added_g_volume_monitor_mount_added, self, 0);
		g_signal_connect_object (self->priv->monitor, "mount-removed", (GCallback) _desktop_agnostic_vfs_volume_monitor_gio_on_mount_removed_g_volume_monitor_mount_removed, self, 0);
		g_signal_connect_object (self->priv->monitor, "volume-added", (GCallback) _desktop_agnostic_vfs_volume_monitor_gio_on_volume_added_g_volume_monitor_volume_added, self, 0);
		g_signal_connect_object (self->priv->monitor, "volume-removed", (GCallback) _desktop_agnostic_vfs_volume_monitor_gio_on_volume_removed_g_volume_monitor_volume_removed, self, 0);
		__g_list_free_g_object_unref0 (vols);
	}
	return obj;
}


static void desktop_agnostic_vfs_volume_monitor_gio_class_init (DesktopAgnosticVFSVolumeMonitorGIOClass * klass) {
	desktop_agnostic_vfs_volume_monitor_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSVolumeMonitorGIOPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_volume_monitor_gio_get_property;
	G_OBJECT_CLASS (klass)->constructor = desktop_agnostic_vfs_volume_monitor_gio_constructor;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_volume_monitor_gio_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_IMPLEMENTATION, "implementation");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_VOLUMES, "volumes");
}


static void desktop_agnostic_vfs_volume_monitor_gio_desktop_agnostic_vfs_volume_monitor_interface_init (DesktopAgnosticVFSVolumeMonitorIface * iface) {
	desktop_agnostic_vfs_volume_monitor_gio_desktop_agnostic_vfs_volume_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_implementation = desktop_agnostic_vfs_volume_monitor_gio_real_get_implementation;
	iface->get_volumes = desktop_agnostic_vfs_volume_monitor_gio_real_get_volumes;
}


static void desktop_agnostic_vfs_volume_monitor_gio_instance_init (DesktopAgnosticVFSVolumeMonitorGIO * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_volume_monitor_gio_finalize (GObject* obj) {
	DesktopAgnosticVFSVolumeMonitorGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO (obj);
	_g_object_unref0 (self->priv->monitor);
	_g_hash_table_unref0 (self->priv->_volumes);
	G_OBJECT_CLASS (desktop_agnostic_vfs_volume_monitor_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_volume_monitor_gio_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_volume_monitor_gio_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_volume_monitor_gio_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSVolumeMonitorGIOClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_volume_monitor_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSVolumeMonitorGIO), 0, (GInstanceInitFunc) desktop_agnostic_vfs_volume_monitor_gio_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_volume_monitor_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_volume_monitor_gio_desktop_agnostic_vfs_volume_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_volume_monitor_gio_type_id;
		desktop_agnostic_vfs_volume_monitor_gio_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSVolumeMonitorGIO", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_volume_monitor_gio_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_VOLUME_MONITOR, &desktop_agnostic_vfs_volume_monitor_info);
		g_once_init_leave (&desktop_agnostic_vfs_volume_monitor_gio_type_id__volatile, desktop_agnostic_vfs_volume_monitor_gio_type_id);
	}
	return desktop_agnostic_vfs_volume_monitor_gio_type_id__volatile;
}


static void desktop_agnostic_vfs_volume_monitor_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSVolumeMonitorGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_IMPLEMENTATION:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_implementation ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		case DESKTOP_AGNOSTIC_VFS_VOLUME_MONITOR_GIO_VOLUMES:
		g_value_set_pointer (value, desktop_agnostic_vfs_volume_monitor_get_volumes ((DesktopAgnosticVFSVolumeMonitor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




