/* Generated lookup tables.

   Copyright (C) 2010-2015 Free Software Foundation, Inc.

   This file is part of the Decimal Floating Point C Library.

   Author(s): Ryan S. Arnold <rsa@us.ibm.com>

   The Decimal Floating Point C Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License version 2.1.

   The Decimal Floating Point C Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU Lesser General Public License version 2.1 for more details.

   You should have received a copy of the GNU Lesser General Public
   License version 2.1 along with the Decimal Floating Point C Library;
   if not, write to the Free Software Foundation, Inc., 51 Franklin
   Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Please see dfp/COPYING.txt for more information.  */


#ifndef _DDLOGTBLS_H
#define _DDLOGTBLS_H 1
const _Decimal128 __LN_10 = 2.302585092994045684017991454684364e+00DL;
const _Decimal128 __LN2digits [] = {
	HUGE_VAL_D128, /* ln(0.00DL) */
	-4.605170185988091368035982909368728DL, /* ln(0.01DL) */
	-3.912023005428146058618750787910552DL, /* ln(0.02DL) */
	-3.506557897319981676640737672446203DL, /* ln(0.03DL) */
	-3.218875824868200749201518666452375DL, /* ln(0.04DL) */
	-2.995732273553990993435223576142541DL, /* ln(0.05DL) */
	-2.813410716760036367223505550988026DL, /* ln(0.06DL) */
	-2.659260036932778062930630165925549DL, /* ln(0.07DL) */
	-2.525728644308255439784286544994199DL, /* ln(0.08DL) */
	-2.407945608651871985245492435523677DL, /* ln(0.09DL) */
	-2.302585092994045684017991454684364DL, /* ln(0.10DL) */
	-2.207274913189720823974039331403599DL, /* ln(0.11DL) */
	-2.120263536200091057806273429529850DL, /* ln(0.12DL) */
	-2.040220828526554631982495467803410DL, /* ln(0.13DL) */
	-1.966112856372832753513398044467372DL, /* ln(0.14DL) */
	-1.897119984885881302039978339220015DL, /* ln(0.15DL) */
	-1.832581463748310130367054423536022DL, /* ln(0.16DL) */
	-1.771956841931875287786448291495602DL, /* ln(0.17DL) */
	-1.714798428091926675828260314065500DL, /* ln(0.18DL) */
	-1.660731206821650908026955477480875DL, /* ln(0.19DL) */
	-1.609437912434100374600759333226188DL, /* ln(0.20DL) */
	-1.560647748264668371535384929003023DL, /* ln(0.21DL) */
	-1.514127732629775514556807209945423DL, /* ln(0.22DL) */
	-1.469675970058941677229230077558532DL, /* ln(0.23DL) */
	-1.427116355640145748389041308071673DL, /* ln(0.24DL) */
	-1.386294361119890618834464242916353DL, /* ln(0.25DL) */
	-1.347073647966609322565263346345233DL, /* ln(0.26DL) */
	-1.309333319983762293850247198601151DL, /* ln(0.27DL) */
	-1.272965675812887444096165923009196DL, /* ln(0.28DL) */
	-1.237874356001617340852710877006817DL, /* ln(0.29DL) */
	-1.203972804325935992622746217761839DL, /* ln(0.30DL) */
	-1.171182981502945122106818584826371DL, /* ln(0.31DL) */
	-1.139434283188364820949822302077846DL, /* ln(0.32DL) */
	-1.108662624521611132578794094481073DL, /* ln(0.33DL) */
	-1.078809661371929978369216170037425DL, /* ln(0.34DL) */
	-1.049822124498677688329870832699361DL, /* ln(0.35DL) */
	-1.021651247531981366411028192607324DL, /* ln(0.36DL) */
	-0.9942522733438669236678872383372813DL, /* ln(0.37DL) */
	-0.9675840262617055986097233560226983DL, /* ln(0.38DL) */
	-0.9416085398584449405872502308808841DL, /* ln(0.39DL) */
	-0.9162907318741550651835272117680111DL, /* ln(0.40DL) */
	-0.8915981192837835641692195363313208DL, /* ln(0.41DL) */
	-0.8675005677047230621181528075448464DL, /* ln(0.42DL) */
	-0.8439700702945289445631403960228814DL, /* ln(0.43DL) */
	-0.8209805520698302051395750884872460DL, /* ln(0.44DL) */
	-0.7985076962177716106447331022974894DL, /* ln(0.45DL) */
	-0.7765287894989963678119979561003557DL, /* ln(0.46DL) */
	-0.7550225842780327812150322395965547DL, /* ln(0.47DL) */
	-0.7339691750802004389718091866134964DL, /* ln(0.48DL) */
	-0.7133498878974647578252974224823690DL, /* ln(0.49DL) */
	-0.6931471805599453094172321214581766DL, /* ln(0.50DL) */
	-0.6733445532637655963912030545730762DL, /* ln(0.51DL) */
	-0.6539264674066640131480312248870567DL, /* ln(0.52DL) */
	-0.6348782724359695338915137703396706DL, /* ln(0.53DL) */
	-0.6161861394238169844330150771429747DL, /* ln(0.54DL) */
	-0.5978370007556204493732799981974115DL, /* ln(0.55DL) */
	-0.5798184952529421346789338015510190DL, /* ln(0.56DL) */
	-0.5621189181535412166317102405583492DL, /* ln(0.57DL) */
	-0.5447271754416720314354787555486402DL, /* ln(0.58DL) */
	-0.5276327420823719174199325356490308DL, /* ln(0.59DL) */
	-0.5108256237659906832055140963036619DL, /* ln(0.60DL) */
	-0.4942963218147801192845938059431137DL, /* ln(0.61DL) */
	-0.4780358009429998126895864633681946DL, /* ln(0.62DL) */
	-0.4620354595965586801401396920804973DL, /* ln(0.63DL) */
	-0.4462871026284195115325901806196690DL, /* ln(0.64DL) */
	-0.4307829160924542573817361345772222DL, /* ln(0.65DL) */
	-0.4155154439616658231615619730228968DL, /* ln(0.66DL) */
	-0.4004775665971253083659109130050057DL, /* ln(0.67DL) */
	-0.3856624808119846689519840485792487DL, /* ln(0.68DL) */
	-0.3710636813908319858339848406360066DL, /* ln(0.69DL) */
	-0.3566749439387323789126387112411845DL, /* ln(0.70DL) */
	-0.3424903089467759467065283768556943DL, /* ln(0.71DL) */
	-0.3285040669720360569937960711491473DL, /* ln(0.72DL) */
	-0.3147107448397002389438740519301858DL, /* ln(0.73DL) */
	-0.3011050927839216142506551168791047DL, /* ln(0.74DL) */
	-0.2876820724517809274392190059938274DL, /* ln(0.75DL) */
	-0.2744368457017602891924912345645217DL, /* ln(0.76DL) */
	-0.2613647641344075188686865879604194DL, /* ln(0.77DL) */
	-0.2484613592984996311700181094227075DL, /* ln(0.78DL) */
	-0.2357223335210698738630373678873175DL, /* ln(0.79DL) */
	-0.2231435513142097557662950903098345DL, /* ln(0.80DL) */
	-0.2107210313156526024550019616786256DL, /* ln(0.81DL) */
	-0.1984509387238382547519874148731443DL, /* ln(0.82DL) */
	-0.1863295781914934445605106860773580DL, /* ln(0.83DL) */
	-0.1743533871447777527009206860866698DL, /* ln(0.84DL) */
	-0.1625189294977749131856889582694142DL, /* ln(0.85DL) */
	-0.1508228897345836351459082745647048DL, /* ln(0.86DL) */
	-0.1392620673335076494574656400842911DL, /* ln(0.87DL) */
	-0.1278333715098848957223429670290694DL, /* ln(0.88DL) */
	-0.1165338162559515297181673686988792DL, /* ln(0.89DL) */
	-0.1053605156578263012275009808393128DL, /* ln(0.90DL) */
	-0.09431067947124132687714272436023008DL, /* ln(0.91DL) */
	-0.08338160893905105839476583464217916DL, /* ln(0.92DL) */
	-0.07257069283483543071157334790384550DL, /* ln(0.93DL) */
	-0.06187540371808747179780011813837814DL, /* ln(0.94DL) */
	-0.05129329438755053342619614425468724DL, /* ln(0.95DL) */
	-0.04082199452025512955457706515531987DL, /* ln(0.96DL) */
	-0.03045920748470854591926128766476670DL, /* ln(0.97DL) */
	-0.02020270731751944840804530102419239DL, /* ln(0.98DL) */
	-0.01005033585350144118354885755854771DL, /* ln(0.99DL) */
	0.0DL}; /* ln(1.00DL) */
const _Decimal64 __factorialDD [] = {
	1.0DD, /* 0.0! */
	1.0DD, /* 1.0! */
	2.0DD, /* 2.0DD! */
	6.0DD, /* 3.0DD! */
	24.0DD, /* 4.0DD! */
	120.0DD, /* 5.0DD! */
	720.0DD, /* 6.0DD! */
	5040.0DD, /* 7.0DD! */
	40320.0DD, /* 8.0DD! */
	362880.0DD, /* 9.0DD! */
	3628800.0DD, /* 10.0DD! */
	39916800.0DD, /* 11.0DD! */
	479001600.0DD, /* 12.0DD! */
	6227020800.0DD, /* 13.0DD! */
	87178291200.0DD, /* 14.0DD! */
	1307674368000.0DD, /* 15.0DD! */
	20922789888000.0DD, /* 16.0DD! */
	355687428096000.0DD, /* 17.0DD! */
	6402373705728000.0DD, /* 18.0DD! */
	1.216451004088320e+17DD, /* 19.0DD! */
	2.432902008176640e+18DD}; /* 20.0DD! */
const _Decimal64 __oneOverfactDD [] = {
	1.0DD, /* 1.0/0.0! */
	1.0DD, /* 1.0/1.0! */
	0.5DD, /* 1.0DD/2.0DD! */
	0.1666666666666667DD, /* 1.0DD/3.0DD! */
	0.04166666666666667DD, /* 1.0DD/4.0DD! */
	0.008333333333333333DD, /* 1.0DD/5.0DD! */
	0.001388888888888889DD, /* 1.0DD/6.0DD! */
	0.0001984126984126984DD, /* 1.0DD/7.0DD! */
	2.48015873015873e-05DD, /* 1.0DD/8.0DD! */
	2.755731922398589e-06DD, /* 1.0DD/9.0DD! */
	2.755731922398589e-07DD, /* 1.0DD/10.0DD! */
	2.505210838544172e-08DD, /* 1.0DD/11.0DD! */
	2.08767569878681e-09DD, /* 1.0DD/12.0DD! */
	1.605904383682161e-10DD, /* 1.0DD/13.0DD! */
	1.147074559772972e-11DD, /* 1.0DD/14.0DD! */
	7.647163731819816e-13DD, /* 1.0DD/15.0DD! */
	4.779477332387385e-14DD, /* 1.0DD/16.0DD! */
	2.811457254345521e-15DD, /* 1.0DD/17.0DD! */
	1.561920696858623e-16DD, /* 1.0DD/18.0DD! */
	8.22063524662433e-18DD, /* 1.0DD/19.0DD! */
	4.110317623312165e-19DD}; /* 1.0DD/20.0DD! */

/* Note, this table starts at e^0. */
#define EXPINT_MAX (sizeof (__expIntXDL) / sizeof (__expIntXDL[0]) - 1)
const _Decimal128 __expIntXDL [] = {
	1.0DL, /* exp(0.0DL) */
	2.718281828459045235360287471352662DL, /* exp(1.0DL) */
	7.389056098930650227230427460575008DL, /* exp(2.0DL) */
	20.08553692318766974092852965458172DL, /* exp(3.0DL) */
	54.59815003314423907811026120286088DL, /* exp(4.0DL) */
	148.4131591025766034211155800405523DL, /* exp(5.0DL) */
	403.4287934927351226083871805433883DL, /* exp(6.0DL) */
	1096.633158428458599263720238288121DL, /* exp(7.0DL) */
	2980.957987041728274743592099452889DL, /* exp(8.0DL) */
	8103.083927575384007709996689432760DL, /* exp(9.0DL) */
	22026.46579480671651695790064528424DL, /* exp(10.0DL) */
	59874.14171519781845532648579225778DL, /* exp(11.0DL) */
	162754.7914190039208080052048984868DL, /* exp(12.0DL) */
	442413.3920089205033261027759490883DL, /* exp(13.0DL) */
	1202604.284164776777749236770767859DL, /* exp(14.0DL) */
	3269017.372472110639301855046091721DL, /* exp(15.0DL) */
	8886110.520507872636763023740781450DL, /* exp(16.0DL) */
	24154952.75357529821477543518038582DL, /* exp(17.0DL) */
	65659969.13733051113878650325906003DL, /* exp(18.0DL) */
	178482300.9631872608449100337887227DL, /* exp(19.0DL) */
	485165195.4097902779691068305415406DL, /* exp(20.0DL) */
	1318815734.483214697209998883745303DL, /* exp(21.0DL) */
	3584912846.131591561681159945978421DL, /* exp(22.0DL) */
	9744803446.248902600034632684822975DL, /* exp(23.0DL) */
	26489122129.84347229413916215281188DL, /* exp(24.0DL) */
	72004899337.38587252416135146612616DL, /* exp(25.0DL) */
	195729609428.8387642697763978760953DL, /* exp(26.0DL) */
	532048240601.7986166837473043411974DL, /* exp(27.0DL) */
	1446257064291.475173677047422996929DL, /* exp(28.0DL) */
	3931334297144.042074388620580843528DL, /* exp(29.0DL) */
	10686474581524.46214699046865074140DL, /* exp(30.0DL) */
	29048849665247.42523108568211167983DL, /* exp(31.0DL) */
	78962960182680.69516097802263510822DL, /* exp(32.0DL) */
	214643579785916.0646242977615312609DL, /* exp(33.0DL) */
	583461742527454.8814029027346103910DL, /* exp(34.0DL) */
	1586013452313430.728129644625974660DL, /* exp(35.0DL) */
	4311231547115195.227113422292856925DL, /* exp(36.0DL) */
	11719142372802611.30877293979119019DL, /* exp(37.0DL) */
	31855931757113756.22032867170129865DL, /* exp(38.0DL) */
	86593400423993746.95360693271926493DL, /* exp(39.0DL) */
	235385266837019985.4078999107490348DL, /* exp(40.0DL) */
	639843493530054949.2226634035155708DL, /* exp(41.0DL) */
	1739274941520501047.394681303611235DL, /* exp(42.0DL) */
	4727839468229346561.474457562744280DL, /* exp(43.0DL) */
	12851600114359308275.80929963214310DL, /* exp(44.0DL) */
	34934271057485095348.03479723340610DL, /* exp(45.0DL) */
	94961194206024488745.13364911711832DL, /* exp(46.0DL) */
	258131288619006739623.2858002152734DL, /* exp(47.0DL) */
	701673591209763173865.4715998861174DL, /* exp(48.0DL) */
	1907346572495099690525.099840953848DL, /* exp(49.0DL) */
	5184705528587072464087.453322933485DL, /* exp(50.0DL) */
	14093490824269387964492.14331237017DL, /* exp(51.0DL) */
	38310080007165768493035.69548786199DL, /* exp(52.0DL) */
	104137594330290877971834.7293349380DL, /* exp(53.0DL) */
	283075330327469390044206.3548014075DL, /* exp(54.0DL) */
	769478526514201713818274.5590129394DL, /* exp(55.0DL) */
	2091659496012996153907071.157214674DL, /* exp(56.0DL) */
	5685719999335932222640348.820633253DL, /* exp(57.0DL) */
	15455389355901039303530766.91117462DL, /* exp(58.0DL) */
	42012104037905142549565934.30719162DL, /* exp(59.0DL) */
	114200738981568428366295718.3144766DL, /* exp(60.0DL) */
	310429793570191990870734214.1107100DL, /* exp(61.0DL) */
	843835666874145448907332948.0373118DL, /* exp(62.0DL) */
	2293783159469609879099352840.268614DL, /* exp(63.0DL) */
	6235149080811616882909238708.928470DL, /* exp(64.0DL) */
	16948892444103337141417836114.37197DL, /* exp(65.0DL) */
	46071866343312915426773184428.06009DL, /* exp(66.0DL) */
	125236317084221378051352196074.4366DL, /* exp(67.0DL) */
	340427604993174052137690718700.4351DL, /* exp(68.0DL) */
	925378172558778760024239791668.7346DL, /* exp(69.0DL) */
	2515438670919167006265781174252.113DL, /* exp(70.0DL) */
	6837671229762743866755892826677.711DL, /* exp(71.0DL) */
	18586717452841279803403701812545.41DL, /* exp(72.0DL) */
	50523936302761041945570383321857.65DL, /* exp(73.0DL) */
	137338297954017618778418852980853.9DL, /* exp(74.0DL) */
	373324199679900164025490831726470.0DL, /* exp(75.0DL) */
	1014800388113888727832461784131717.0DL, /* exp(76.0DL) */
	2758513454523170206286469819902662.0DL, /* exp(77.0DL) */
	7498416996990120434675630591224060.0DL, /* exp(78.0DL) */
	2.038281066512668766832313753717263e+34DL, /* exp(79.0DL) */
	5.540622384393510052571173395831661e+34DL, /* exp(80.0DL) */
	1.506097314585030548352594130167675e+35DL, /* exp(81.0DL) */
	4.093996962127454696660914229327829e+35DL, /* exp(82.0DL) */
	1.112863754791759412087071478183941e+36DL, /* exp(83.0DL) */
	3.025077322201142338266566396443429e+36DL, /* exp(84.0DL) */
	8.223012714622913510304328016407775e+36DL, /* exp(85.0DL) */
	2.235246603734715047443065732332715e+37DL, /* exp(86.0DL) */
	6.076030225056872149522328938130276e+37DL, /* exp(87.0DL) */
	1.651636254994001855528329796264859e+38DL, /* exp(88.0DL) */
	4.489612819174345246284245579645316e+38DL, /* exp(89.0DL) */
	1.220403294317840802002710035136370e+39DL, /* exp(90.0DL) */
	3.317400098335742625755516107852592e+39DL, /* exp(91.0DL) */
	9.017628405034298931400995982170905e+39DL, /* exp(92.0DL) */
	2.451245542920085785552772943110915e+40DL, /* exp(93.0DL) */
	6.663176216410895834244814050240873e+40DL, /* exp(94.0DL) */
	1.811239082889023282193798758098816e+41DL, /* exp(95.0DL) */
	4.923458286012058399754862059113304e+41DL, /* exp(96.0DL) */
	1.338334719204269500461736408706115e+42DL, /* exp(97.0DL) */
	3.637970947608804579287743826760186e+42DL, /* exp(98.0DL) */
	9.889030319346946770560030967138037e+42DL, /* exp(99.0DL) */
	2.688117141816135448412625551580014e+43DL, /* exp(100.0DL) */
	7.307059979368067272647682634061514e+43DL, /* exp(101.0DL) */
	1.986264836137654325874046890613771e+44DL, /* exp(102.0DL) */
	5.399227610580168869761684237193682e+44DL, /* exp(103.0DL) */
	1.467662230155442328510702112087047e+45DL, /* exp(104.0DL) */
	3.989519570547215850763757278730095e+45DL, /* exp(105.0DL) */
	1.084463855290023081336100102856874e+46DL, /* exp(106.0DL) */
	2.947878391455509377387820248707928e+46DL, /* exp(107.0DL) */
	8.013164264000591141056105836293556e+46DL, /* exp(108.0DL) */
	2.178203880729020635553939331393682e+47DL, /* exp(109.0DL) */
	5.920972027664670298955228815588040e+47DL, /* exp(110.0DL) */
	1.609487066961518054926233299337351e+48DL, /* exp(111.0DL) */
	4.375039447261341073462574675087939e+48DL, /* exp(112.0DL) */
	1.189259022828200881968195409638927e+49DL, /* exp(113.0DL) */
	3.232741191084859311426235420582919e+49DL, /* exp(114.0DL) */
	8.787501635837023113106973803049638e+49DL, /* exp(115.0DL) */
	2.388690601424991425462639294944161e+50DL, /* exp(116.0DL) */
	6.493134255664462136224950708771209e+50DL, /* exp(117.0DL) */
	1.765016885691765583291178205644718e+51DL, /* exp(118.0DL) */
	4.797813327299302186003488289501133e+51DL, /* exp(119.0DL) */
	1.304180878393632279733879028098649e+52DL, /* exp(120.0DL) */
	3.545131182761166475189407421247819e+52DL, /* exp(121.0DL) */
	9.636665673603201271763873014194224e+52DL, /* exp(122.0DL) */
	2.619517318749062676188981025374639e+53DL, /* exp(123.0DL) */
	7.120586326889337708833068068270194e+53DL, /* exp(124.0DL) */
	1.935576042035722568720624490527487e+54DL, /* exp(125.0DL) */
	5.261441182666385745176776704161635e+54DL, /* exp(126.0DL) */
	1.430207995834810446358367107290526e+55DL, /* exp(127.0DL) */
	3.887708405994595092222673688357478e+55DL, /* exp(128.0DL) */
	1.056788711436258812564883496042735e+56DL, /* exp(129.0DL) */
	2.872649550817831933267333224962154e+56DL, /* exp(130.0DL) */
	7.808671073519151171721496316178984e+56DL, /* exp(131.0DL) */
	2.122616868356089389087011829556459e+57DL, /* exp(132.0DL) */
	5.769870862033003179413083148549333e+57DL, /* exp(133.0DL) */
	1.568413511681963940672521233331738e+58DL, /* exp(134.0DL) */
	4.263389948314721044893686688076599e+58DL, /* exp(135.0DL) */
	1.158909542413885428348049567600546e+59DL, /* exp(136.0DL) */
	3.150242749971451918411164291133698e+59DL, /* exp(137.0DL) */
	8.563247622482249193195490908623758e+59DL, /* exp(138.0DL) */
	2.327732040478862025474175038514098e+60DL, /* exp(139.0DL) */
	6.327431707155585364343024512351145e+60DL, /* exp(140.0DL) */
	1.719974263037662264183378392554783e+61DL, /* exp(141.0DL) */
	4.675374784632515402720773410063707e+61DL, /* exp(142.0DL) */
	1.270898631830218879555516649914609e+62DL, /* exp(143.0DL) */
	3.454660656717546323125851786688987e+62DL, /* exp(144.0DL) */
	9.390741286647697813154050401690990e+62DL, /* exp(145.0DL) */
	2.552668139525455104766875580865435e+63DL, /* exp(146.0DL) */
	6.938871417758403301622803744045249e+63DL, /* exp(147.0DL) */
	1.886180808490652005219614818181222e+64DL, /* exp(148.0DL) */
	5.127171016908329766825888768465816e+64DL, /* exp(149.0DL) */
	1.393709580666379697318341937141457e+65DL, /* exp(150.0DL) */
	3.788495427274695804249475044194939e+65DL, /* exp(151.0DL) */
	1.029819827716099194399387877391374e+66DL, /* exp(152.0DL) */
	2.799340524267497068373922891089509e+66DL, /* exp(153.0DL) */
	7.609396478785354221820071817478727e+66DL, /* exp(154.0DL) */
	2.068448417382247309127034796628242e+67DL, /* exp(155.0DL) */
	5.622625746075033580789765081966631e+67DL, /* exp(156.0DL) */
	1.528388139378174566610041404084110e+68DL, /* exp(157.0DL) */
	4.154589706104022437390577106831935e+68DL, /* exp(158.0DL) */
	1.129334570280556947872702202187131e+69DL, /* exp(159.0DL) */
	3.069849640644242466736457030165496e+69DL, /* exp(160.0DL) */
	8.344716494264974360965835809202325e+69DL, /* exp(161.0DL) */
	2.268329121000240471305839031261140e+70DL, /* exp(162.0DL) */
	6.165957830579432532004967054378165e+70DL, /* exp(163.0DL) */
	1.676081112590882772586107349772233e+71DL, /* exp(164.0DL) */
	4.556060831379215688011286441179669e+71DL, /* exp(165.0DL) */
	1.238465736729213219826985646784684e+72DL, /* exp(166.0DL) */
	3.366498907320164247795577890175299e+72DL, /* exp(167.0DL) */
	9.151092805295633936008943833619897e+72DL, /* exp(168.0DL) */
	2.487524928317742944660399447996433e+73DL, /* exp(169.0DL) */
	6.761793810485009722629773981761472e+73DL, /* exp(170.0DL) */
	1.838046124282824702661966133225901e+74DL, /* exp(171.0DL) */
	4.996327379507578237479999229144082e+74DL, /* exp(172.0DL) */
	1.358142592474784978909325501195412e+75DL, /* exp(173.0DL) */
	3.691814329580466442392001432233471e+75DL, /* exp(174.0DL) */
	1.003539180614329457194673346475574e+76DL, /* exp(175.0DL) */
	2.727902318810611519255759319952712e+76DL, /* exp(176.0DL) */
	7.415207303034178428338693757660901e+76DL, /* exp(177.0DL) */
	2.015662326609461206632931840914131e+77DL, /* exp(178.0DL) */
	5.479138274731979437986556445096614e+77DL, /* exp(179.0DL) */
	1.489384200781838359564441023032289e+78DL, /* exp(180.0DL) */
	4.048566008579269326227142668956968e+78DL, /* exp(181.0DL) */
	1.100514341243799484328097603121074e+79DL, /* exp(182.0DL) */
	2.991508135761596920718470160144712e+79DL, /* exp(183.0DL) */
	8.131762205128143406112671204492571e+79DL, /* exp(184.0DL) */
	2.210442143554988732756103709321049e+80DL, /* exp(185.0DL) */
	6.008604711685586125034163217853965e+80DL, /* exp(186.0DL) */
	1.633308100216832937727194388108838e+81DL, /* exp(187.0DL) */
	4.439791729094382135615588198841497e+81DL, /* exp(188.0DL) */
	1.206860517934002309536447331447343e+82DL, /* exp(189.0DL) */
	3.280587015384670151825008413705914e+82DL, /* exp(190.0DL) */
	8.917560070598843142077080332491209e+82DL, /* exp(191.0DL) */
	2.424044149410079585237809735246149e+83DL, /* exp(192.0DL) */
	6.589235162723882173675393093453464e+83DL, /* exp(193.0DL) */
	1.791139820627570890043182762414423e+84DL, /* exp(194.0DL) */
	4.868822826641319706709336201865967e+84DL, /* exp(195.0DL) */
	1.323483261564570355306938300562604e+85DL, /* exp(196.0DL) */
	3.597600500180681130758662848849109e+85DL, /* exp(197.0DL) */
	9.779292065696317602741493974881592e+85DL, /* exp(198.0DL) */
	2.658287191737601973400328347238974e+86DL, /* exp(199.0DL) */
	7.225973768125749258177477042189306e+86DL, /* exp(200.0DL) */
	1.964223318681795865648486413742023e+87DL, /* exp(201.0DL) */
	5.339312554208245971622259980208268e+87DL, /* exp(202.0DL) */
	1.451375629256752594052365491439013e+88DL, /* exp(203.0DL) */
	3.945247999276942790032757321114382e+88DL, /* exp(204.0DL) */
	1.072429594519891802192445120936997e+89DL, /* exp(205.0DL) */
	2.915165879085123966049615522455638e+89DL, /* exp(206.0DL) */
	7.924242436060930749118868880226406e+89DL, /* exp(207.0DL) */
	2.154032421824846569020981598875600e+90DL, /* exp(208.0DL) */
	5.855267190158109347508158747532035e+90DL, /* exp(209.0DL) */
	1.591626640377924159157186340777442e+91DL, /* exp(210.0DL) */
	4.326489974230630919937147247796921e+91DL, /* exp(211.0DL) */
	1.176061853430500122733564724127810e+92DL, /* exp(212.0DL) */
	3.196867565323993534884678511593018e+92DL, /* exp(213.0DL) */
	8.689987010810321382206327468404931e+92DL, /* exp(214.0DL) */
	2.362183378103083330074656746951513e+93DL, /* exp(215.0DL) */
	6.421080152185613551677154136222645e+93DL, /* exp(216.0DL) */
	1.745430549676519405028186247908160e+94DL, /* exp(217.0DL) */
	4.744572146022965554458784288916120e+94DL, /* exp(218.0DL) */
	1.289708424834716297481023414701692e+95DL, /* exp(219.0DL) */
	3.505790975238747722402506089127548e+95DL, /* exp(220.0DL) */
	9.529727902367202538635563498630489e+95DL, /* exp(221.0DL) */
	2.590448618716390103183017128713071e+96DL, /* exp(222.0DL) */
	7.041569407813596999108837294967126e+96DL, /* exp(223.0DL) */
	1.914097016509282082010847732006445e+97DL, /* exp(224.0DL) */
	5.203055137884854592302020535807898e+97DL, /* exp(225.0DL) */
	1.414337023378287226503983716837055e+98DL, /* exp(226.0DL) */
	3.844566629966054009345753170667500e+98DL, /* exp(227.0DL) */
	1.045061560853675486398217750709896e+99DL, /* exp(228.0DL) */
	2.840771850489592771853401334776990e+99DL, /* exp(229.0DL) */
	7.722018499983835717562125214027702e+99DL, /* exp(230.0DL) */
	2.099062256753063472456803931261947e+100DL, /* exp(231.0DL) */
	5.705842789336087248197014832689535e+100DL, /* exp(232.0DL) */
	1.551008877029635809755605451888125e+101DL, /* exp(233.0DL) */
	4.216079246208328874118691759609435e+101DL, /* exp(234.0DL) */
	1.146049160231140937063786504289561e+102DL, /* exp(235.0DL) */
	3.115284606777059095420146431240044e+102DL, /* exp(236.0DL) */
	8.468221537080261941894957767724472e+102DL, /* exp(237.0DL) */
	2.301901272361080096270511976626041e+103DL, /* exp(238.0DL) */
	6.257216399565879491491760484687697e+103DL, /* exp(239.0DL) */
	1.700887763567586268539890286071456e+104DL, /* exp(240.0DL) */
	4.623492299954114627342627486156878e+104DL, /* exp(241.0DL) */
	1.256795510298558713635336961328797e+105DL, /* exp(242.0DL) */
	3.416324397733484996690746761911685e+105DL, /* exp(243.0DL) */
	9.286532530480224090839757024909060e+105DL, /* exp(244.0DL) */
	2.524341262699818777063279323441880e+106DL, /* exp(245.0DL) */
	6.861870983226278429650018966343927e+106DL, /* exp(246.0DL) */
	1.865249920293439464789305714127697e+107DL, /* exp(247.0DL) */
	5.070274963868339013421674936745641e+107DL, /* exp(248.0DL) */
	1.378243629957414808885790181914938e+108DL, /* exp(249.0DL) */
	3.746454614502673260349954812202920e+108DL, /* exp(250.0DL) */
	1.018391949974915412131180980115459e+109DL, /* exp(251.0DL) */
	2.768276331865785592998577160396332e+109DL, /* exp(252.0DL) */
	7.524955249064026372695879140572184e+109DL, /* exp(253.0DL) */
	2.045494911349825175079419025332923e+110DL, /* exp(254.0DL) */
	5.560231647727675417404154047338170e+110DL, /* exp(255.0DL) */
	1.511427665004103542520089665707287e+111DL, /* exp(256.0DL) */
	4.108486356810939873274643501419966e+111DL, /* exp(257.0DL) */
	1.116802380619108297575989418836874e+112DL, /* exp(258.0DL) */
	3.035783617216724286527056406009668e+112DL, /* exp(259.0DL) */
	8.252115441813891570820918707846944e+112DL, /* exp(260.0DL) */
	2.243157545182898709013259885403898e+113DL, /* exp(261.0DL) */
	6.097534393441473280354092573194560e+113DL, /* exp(262.0DL) */
	1.657481694009600331028886805596982e+114DL, /* exp(263.0DL) */
	4.505502369829812111710612511284523e+114DL, /* exp(264.0DL) */
	1.224722521998754311169212305099962e+115DL, /* exp(265.0DL) */
	3.329140976453747121049890265064740e+115DL, /* exp(266.0DL) */
	9.049543420672622984741020586915559e+115DL, /* exp(267.0DL) */
	2.459920943626550038596244273961357e+116DL, /* exp(268.0DL) */
	6.686758400505878376783619550171546e+116DL, /* exp(269.0DL) */
	1.817649385139099978254665044531334e+117DL, /* exp(270.0DL) */
	4.940883294133372012968511104760232e+117DL, /* exp(271.0DL) */
	1.343071327497961308585925029761342e+118DL, /* exp(272.0DL) */
	3.650846383862075425813175768321853e+118DL, /* exp(273.0DL) */
	9.924029383747695725897538647368045e+118DL, /* exp(274.0DL) */
	2.697630873893497823276541791257137e+119DL, /* exp(275.0DL) */
	7.332920984394789339791797649312974e+119DL, /* exp(276.0DL) */
	1.993294586140636987940405781793673e+120DL, /* exp(277.0DL) */
	5.418336452271886559100375698876231e+120DL, /* exp(278.0DL) */
	1.472856551868792008087437247897063e+121DL, /* exp(279.0DL) */
	4.003639200871784538400260785305545e+121DL, /* exp(280.0DL) */
	1.088301968743606516792665866534688e+122DL, /* exp(281.0DL) */
	2.958311465511949419164853541312494e+122DL, /* exp(282.0DL) */
	8.041524299623179605925946091442732e+122DL, /* exp(283.0DL) */
	2.185912937677753978514469372345811e+123DL, /* exp(284.0DL) */
	5.941927417082968078603966504162533e+123DL, /* exp(285.0DL) */
	1.615183332387922236604183385718783e+124DL, /* exp(286.0DL) */
	4.390523502060015075404295319039588e+124DL, /* exp(287.0DL) */
	1.193468025307210843923555893375492e+125DL, /* exp(288.0DL) */
	3.244182446039491164974072332126533e+125DL, /* exp(289.0DL) */
	8.818602191274965898609482242773347e+125DL, /* exp(290.0DL) */
	2.397144608895185727195240960392316e+126DL, /* exp(291.0DL) */
	6.516114630548348330102723702830198e+126DL, /* exp(292.0DL) */
	1.771263599237570031534705841604641e+127DL, /* exp(293.0DL) */
	4.814793655218451387395298079782470e+127DL, /* exp(294.0DL) */
	1.308796610076022186332899984750243e+128DL, /* exp(295.0DL) */
	3.557678042318449655544645980637689e+128DL, /* exp(296.0DL) */
	9.670771573941991842072070104579637e+128DL, /* exp(297.0DL) */
	2.628788263662479636370453338953771e+129DL, /* exp(298.0DL) */
	7.145787367980123848171155588996861e+129DL, /* exp(299.0DL) */
	1.942426395241255936584208836017699e+130DL, /* exp(300.0DL) */
	5.280062373303513270087532378038526e+130DL, /* exp(301.0DL) */
	1.435269760248127992550590452903856e+131DL, /* exp(302.0DL) */
	3.901467708219256838066994684078047e+131DL, /* exp(303.0DL) */
	1.060528877557216226495232041821616e+132DL, /* exp(304.0DL) */
	2.882816376419848626953355204155918e+132DL, /* exp(305.0DL) */
	7.836307370806225343172196949344846e+132DL, /* exp(306.0DL) */
	2.130129192828223962100534606173057e+133DL, /* exp(307.0DL) */
	5.790291477135094778361695172898998e+133DL, /* exp(308.0DL) */
	1.573964410377761135100442978373886e+134DL, /* exp(309.0DL) */
	4.278478855371123572078762559314068e+134DL, /* exp(310.0DL) */
	1.163011132600158073507199921010664e+135DL, /* exp(311.0DL) */
	3.161392028042582800233183836456089e+135DL, /* exp(312.0DL) */
	8.593554502463441183638161736499838e+135DL, /* exp(313.0DL) */
	2.335970304591878365299521443432813e+136DL, /* exp(314.0DL) */
	6.349825630792043955046056134266398e+136DL, /* exp(315.0DL) */
	1.726061562606550753116266296636711e+137DL, /* exp(316.0DL) */
	4.691921780435011562208730704150653e+137DL, /* exp(317.0DL) */
	1.275396571630770220251373313489760e+138DL, /* exp(318.0DL) */
	3.466887324742887734754816324854361e+138DL, /* exp(319.0DL) */
	9.423976816163584609582297533804707e+138DL, /* exp(320.0DL) */
	2.561702493119680037517373932936033e+139DL, /* exp(321.0DL) */
	6.963429336965458599034994515731783e+139DL, /* exp(322.0DL) */
	1.892856343043182383234520340542839e+140DL, /* exp(323.0DL) */
	5.145317001177723577131599201722597e+140DL, /* exp(324.0DL) */
	1.398642170596279385193289912251344e+141DL, /* exp(325.0DL) */
	3.801903596848382201568124647481586e+141DL, /* exp(326.0DL) */
	1.033464546086604114115365543361185e+142DL, /* exp(327.0DL) */
	2.809247895983891453424674296054281e+142DL, /* exp(328.0DL) */
	7.636327507289818180166118335081688e+142DL, /* exp(329.0DL) */
	2.075769029922787004644168141919403e+143DL, /* exp(330.0DL) */
	5.642525234117172040733295233660915e+143DL, /* exp(331.0DL) */
	1.533797381052232870519667063383699e+144DL, /* exp(332.0DL) */
	4.169293549452358510538002660315104e+144DL, /* exp(333.0DL) */
	1.133331489298785982963108539898353e+145DL, /* exp(334.0DL) */
	3.080714392981316820196121871645118e+145DL, /* exp(335.0DL) */
	8.374249953113351519453795208709646e+145DL, /* exp(336.0DL) */
	2.276357147452203500020023477143653e+146DL, /* exp(337.0DL) */
	6.187780269002192175178696821538595e+146DL, /* exp(338.0DL) */
	1.682013066372608173189389845168449e+147DL, /* exp(339.0DL) */
	4.572185553551338758077087969419296e+147DL, /* exp(340.0DL) */
	1.242848890656156500469391700684018e+148DL, /* exp(341.0DL) */
	3.378413554991113073078548479226100e+148DL, /* exp(342.0DL) */
	9.183480175552066013537935348151565e+148DL, /* exp(343.0DL) */
	2.496328728321706373106940389410625e+149DL, /* exp(344.0DL) */
	6.785725020057171180597468784050053e+149DL, /* exp(345.0DL) */
	1.844551301494129868022574114528400e+150DL, /* exp(346.0DL) */
	5.014010284511974955246298929888265e+150DL, /* exp(347.0DL) */
	1.362949304409566890038982913575933e+151DL, /* exp(348.0DL) */
	3.704880327287421330770271193329711e+151DL, /* exp(349.0DL) */
	1.007090887028079759823375862957009e+152DL, /* exp(350.0DL) */
	2.737556857815130410127492651946378e+152DL, /* exp(351.0DL) */
	7.441451060972311209407666002648342e+152DL, /* exp(352.0DL) */
	2.022796119640831622539965665246037e+153DL, /* exp(353.0DL) */
	5.498529934697141407184545638353895e+153DL, /* exp(354.0DL) */
	1.494655400472534013870473442859227e+154DL, /* exp(355.0DL) */
	4.062894614912666263108447007703347e+154DL, /* exp(356.0DL) */
	1.104409260266121092478298771074541e+155DL, /* exp(357.0DL) */
	3.002095623363293218544209572921559e+155DL, /* exp(358.0DL) */
	8.160541980284869890205249363477304e+155DL, /* exp(359.0DL) */
	2.218265297538555399989665903558670e+156DL, /* exp(360.0DL) */
	6.029870249000352388763324493423036e+156DL, /* exp(361.0DL) */
	1.639088672582347627161609834531880e+157DL, /* exp(362.0DL) */
	4.455504953913653233974268168963676e+157DL, /* exp(363.0DL) */
	1.211131815283273938722390511523583e+158DL, /* exp(364.0DL) */
	3.292197605353140509174102360167548e+158DL, /* exp(365.0DL) */
	8.949120926327824993420536927303175e+158DL, /* exp(366.0DL) */
	2.432623279471950477227309535201063e+159DL, /* exp(367.0DL) */
	6.612555656075052543831039207709918e+159DL, /* exp(368.0DL) */
	1.797478987958289530151706000979968e+160DL, /* exp(369.0DL) */
	4.886054470003973416856524852609962e+160DL, /* exp(370.0DL) */
	1.328167307867289205100231902804380e+161DL, /* exp(371.0DL) */
	3.610333058129022556282304462831987e+161DL, /* exp(372.0DL) */
	9.813902746597095882542159047202632e+161DL, /* exp(373.0DL) */
	2.667695350233919987120260891628822e+162DL, /* exp(374.0DL) */
	7.251547794405553090112673549867557e+162DL, /* exp(375.0DL) */
	1.971175059773488349115179760489633e+163DL, /* exp(376.0DL) */
	5.358209345693945694819562705760926e+163DL, /* exp(377.0DL) */
	1.456512309747928310205062027767040e+164DL, /* exp(378.0DL) */
	3.959210944514705822310560742686318e+164DL, /* exp(379.0DL) */
	1.076225116551049803541837343424381e+165DL, /* exp(380.0DL) */
	2.925483177651936727218575960974259e+165DL, /* exp(381.0DL) */
	7.952287761273884428431842997922460e+165DL, /* exp(382.0DL) */
	2.161655931614806197980514918359209e+166DL, /* exp(383.0DL) */
	5.875990038289236239608284190826147e+166DL, /* exp(384.0DL) */
	1.597259694528800030822743979435256e+167DL, /* exp(385.0DL) */
	4.341802002967682598837778729247605e+167DL, /* exp(386.0DL) */
	1.180224148743413720203261526035075e+168DL, /* exp(387.0DL) */
	3.208181857037766822452217552625736e+168DL, /* exp(388.0DL) */
	8.720742444377756058815671175404579e+168DL, /* exp(389.0DL) */
	2.370543571722357032999137386012008e+169DL, /* exp(390.0DL) */
	6.443805514583284515942657384226011e+169DL, /* exp(391.0DL) */
	1.751607943641592951129850402000189e+170DL, /* exp(392.0DL) */
	4.761364043785457544777068604957221e+170DL, /* exp(393.0DL) */
	1.294272935890028705274850735971419e+171DL, /* exp(394.0DL) */
	3.518198602696203860423082985485178e+171DL, /* exp(395.0DL) */
	9.563455330619095063990428284178055e+171DL, /* exp(396.0DL) */
	2.599616684250167670535131669841815e+172DL, /* exp(397.0DL) */
	7.066490793756186237436887792483189e+172DL, /* exp(398.0DL) */
	1.920871351564057584139949852666935e+173DL, /* exp(399.0DL) */
	5.221469689764143950588763006649649e+173DL, /* exp(400.0DL) */
	1.419342617553556088952595304761593e+174DL, /* exp(401.0DL) */
	3.858173245653327799310350012971924e+174DL, /* exp(402.0DL) */
	1.048760222470629699020425144346453e+175DL, /* exp(403.0DL) */
	2.850825855152578357724868730105249e+175DL, /* exp(404.0DL) */
	7.749348118162471942799302224427976e+175DL, /* exp(405.0DL) */
	2.106491217200434556446189142703003e+176DL, /* exp(406.0DL) */
	5.726036797524517045075068123598170e+176DL, /* exp(407.0DL) */
	1.556498177579871997750512324010936e+177DL, /* exp(408.0DL) */
	4.231000712144986142316285393091558e+177DL, /* exp(409.0DL) */
	1.150105235202099544968631947814397e+178DL, /* exp(410.0DL) */
	3.126310161665483428917747618858063e+178DL, /* exp(411.0DL) */
	8.498192102582143603633233273858886e+178DL, /* exp(412.0DL) */
	2.310048116720320742890940914625761e+179DL, /* exp(413.0DL) */
	6.279361818546887415165373333420796e+179DL, /* exp(414.0DL) */
	1.706907512567554855051318463039938e+180DL, /* exp(415.0DL) */
	4.639855674272613745723989048870604e+180DL, /* exp(416.0DL) */
	1.261243536604783670309876943451105e+181DL, /* exp(417.0DL) */
	3.428415386814204104981865890924109e+181DL, /* exp(418.0DL) */
	9.319399246386439579008167656003250e+181DL, /* exp(419.0DL) */
	2.533275362360717919371182124925657e+182DL, /* exp(420.0DL) */
	6.886156383988142686207946843675239e+182DL, /* exp(421.0DL) */
	1.871851376652221570940575120188230e+183DL, /* exp(422.0DL) */
	5.088219582729781827872175380623096e+183DL, /* exp(423.0DL) */
	1.383121483094383153302857465179987e+184DL, /* exp(424.0DL) */
	3.759713994046786261231426611578472e+184DL, /* exp(425.0DL) */
	1.021996223022055807099002130897546e+185DL, /* exp(426.0DL) */
	2.778073761794632040373575342429542e+185DL, /* exp(427.0DL) */
	7.551587424805210467125308242295084e+185DL, /* exp(428.0DL) */
	2.052734287286784027926561180001698e+186DL, /* exp(429.0DL) */
	5.579910311786494341713109506348113e+186DL, /* exp(430.0DL) */
	1.516776880496047302726689430200619e+187DL, /* exp(431.0DL) */
	4.123027032079202208926725386245407e+187DL, /* exp(432.0DL) */
	1.120754945954632433560060190129295e+188DL, /* exp(433.0DL) */
	3.046527803744076674512679471700871e+188DL, /* exp(434.0DL) */
	8.281321168812768059667846719239344e+188DL, /* exp(435.0DL) */
	2.251096484881696877600571550111928e+189DL, /* exp(436.0DL) */
	6.119114668961948467907208237768858e+189DL, /* exp(437.0DL) */
	1.663347821089645057719483053444463e+190DL, /* exp(438.0DL) */
	4.521448156474929211386999357759814e+190DL, /* exp(439.0DL) */
	1.229057036206544984605802280424419e+191DL, /* exp(440.0DL) */
	3.340923407659982062775142884958155e+191DL, /* exp(441.0DL) */
	9.081571389315600216037596266916383e+191DL, /* exp(442.0DL) */
	2.468627048143016150001750467926167e+192DL, /* exp(443.0DL) */
	6.710424046209653429991863024228781e+192DL, /* exp(444.0DL) */
	1.824082374606632138258439437597837e+193DL, /* exp(445.0DL) */
	4.958369972505633112676552999612121e+193DL, /* exp(446.0DL) */
	1.347824699503903822885598093098193e+194DL, /* exp(447.0DL) */
	3.663767388609734883217830085985113e+194DL, /* exp(448.0DL) */
	9.959152316158691480158431249145986e+194DL, /* exp(449.0DL) */
	2.707178276786998323373310485814752e+195DL, /* exp(450.0DL) */
	7.358873516189169058322082659934047e+195DL, /* exp(451.0DL) */
	2.000349215698553788688243281159668e+196DL, /* exp(452.0DL) */
	5.437512923605681866194912742254270e+196DL, /* exp(453.0DL) */
	1.478069257224854165421793387461143e+197DL, /* exp(454.0DL) */
	4.017808803118279437877755383682614e+197DL, /* exp(455.0DL) */
	1.092153665973920471826922283630383e+198DL, /* exp(456.0DL) */
	2.968781464101837877130907914264117e+198DL, /* exp(457.0DL) */
	8.069984706534065228728930759424896e+198DL, /* exp(458.0DL) */
	2.193649278371395040318536641341395e+199DL, /* exp(459.0DL) */
	5.962956971409260822395127288810348e+199DL, /* exp(460.0DL) */
	1.620899757926497623081284104932651e+200DL, /* exp(461.0DL) */
	4.406062357725263759379850038557442e+200DL, /* exp(462.0DL) */
	1.197691924206200182564330974252429e+201DL, /* exp(463.0DL) */
	3.255664193661862052431253530725589e+201DL, /* exp(464.0DL) */
	8.849812817195809529800229688135934e+201DL, /* exp(465.0DL) */
	2.405628536624731937016932793996026e+202DL, /* exp(466.0DL) */
	6.539176337129533597548692943530939e+202DL, /* exp(467.0DL) */
	1.777532421030859060107212665651268e+203DL, /* exp(468.0DL) */
	4.831834079584996998891248221490661e+203DL, /* exp(469.0DL) */
	1.313428677666503353580556912107501e+204DL, /* exp(470.0DL) */
	3.570269307477848686807457768952824e+204DL, /* exp(471.0DL) */
	9.704998181222095712433155396791069e+204DL, /* exp(472.0DL) */
	2.638092020124410678145401874749836e+205DL, /* exp(473.0DL) */
	7.171077600106999417891908990001638e+205DL, /* exp(474.0DL) */
	1.949300993084055637799015726409861e+206DL, /* exp(475.0DL) */
	5.298749467697559449928326786096158e+206DL, /* exp(476.0DL) */
	1.440349439159931454920427073875767e+207DL, /* exp(477.0DL) */
	3.915275707099618806936026895522707e+207DL, /* exp(478.0DL) */
	1.064282280801603304708720273641843e+208DL, /* exp(479.0DL) */
	2.893019184253945246534816702118053e+208DL, /* exp(480.0DL) */
	7.864041477940909773300251372520698e+208DL, /* exp(481.0DL) */
	2.137668104773498866567412075545327e+209DL, /* exp(482.0DL) */
	5.810784364482288383246723426978378e+209DL, /* exp(483.0DL) */
	1.579534954706614601625671846157738e+210DL, /* exp(484.0DL) */
	4.293621164794871538041621948303868e+210DL, /* exp(485.0DL) */
	1.167127239054905898759412509410571e+211DL, /* exp(486.0DL) */
	3.172580765422526796995080546191440e+211DL, /* exp(487.0DL) */
	8.623968643966743418277677243565088e+211DL, /* exp(488.0DL) */
	2.344237725409539218615226602961952e+212DL, /* exp(489.0DL) */
	6.372298810568915474216176683121907e+212DL, /* exp(490.0DL) */
	1.732170406228067068251352333408775e+213DL, /* exp(491.0DL) */
	4.708527339044277307003974590883498e+213DL, /* exp(492.0DL) */
	1.279910430452668093157360961475030e+214DL, /* exp(493.0DL) */
	3.479157265154682276532297319760293e+214DL, /* exp(494.0DL) */
	9.457329972221241007049799869879439e+214DL, /* exp(495.0DL) */
	2.570768820923008648805009142884219e+215DL, /* exp(496.0DL) */
	6.988074171084099775590981488496373e+215DL, /* exp(497.0DL) */
	1.899555503518191363230828929983843e+216DL, /* exp(498.0DL) */
	5.163527207362871553289347179917635e+216DL, /* exp(499.0DL) */
	1.403592217852837410739770332840912e+217DL, /* exp(500.0DL) */
	3.815359220355897431846613368265267e+217DL, /* exp(501.0DL) */
	1.037122163773710615291283344833936e+218DL, /* exp(502.0DL) */
	2.819190331678203457443868041149361e+218DL, /* exp(503.0DL) */
	7.663353849568289091387105632648610e+218DL, /* exp(504.0DL) */
	2.083115551433315195369244084979054e+219DL, /* exp(505.0DL) */
	5.662495150041624317958867141543712e+219DL, /* exp(506.0DL) */
	1.539225767009562224598782635629893e+220DL, /* exp(507.0DL) */
	4.184049432358029151851648927429493e+220DL, /* exp(508.0DL) */
	1.137342554135321378980845851741469e+221DL, /* exp(509.0DL) */
	3.091617597639242037871853535963997e+221DL, /* exp(510.0DL) */
	8.403887936206959658993059652628077e+221DL, /* exp(511.0DL) */
	2.284413586539756640378751517122403e+222DL, /* exp(512.0DL) */
	6.209679940975975047577272304764810e+222DL, /* exp(513.0DL) */
	1.687966014410162954642810721076269e+223DL, /* exp(514.0DL) */
	4.588367344027584854489420260908572e+223DL, /* exp(515.0DL) */
	1.247247557356507640804521511751116e+224DL, /* exp(516.0DL) */
	3.390370370752125486061343822971314e+224DL, /* exp(517.0DL) */
	9.215982170561458765936672745568764e+224DL, /* exp(518.0DL) */
	2.505163686563976262517856075647746e+225DL, /* exp(519.0DL) */
	6.809740926502327887940451611871241e+225DL, /* exp(520.0DL) */
	1.851079501702514062383499313500584e+226DL, /* exp(521.0DL) */
	5.031755772510968263221158771737896e+226DL, /* exp(522.0DL) */
	1.367773028166047047346657916452796e+227DL, /* exp(523.0DL) */
	3.717992567920167547029412002398600e+227DL, /* exp(524.0DL) */
	1.010655163572317397121409894131465e+228DL, /* exp(525.0DL) */
	2.747245565976934381873532297306132e+228DL, /* exp(526.0DL) */
	7.467787700309785784821623443995710e+228DL, /* exp(527.0DL) */
	2.029955160454205303196270276480854e+229DL, /* exp(528.0DL) */
	5.517990225249331746261182601797754e+229DL, /* exp(529.0DL) */
	1.499945255890989237667062477851581e+230DL, /* exp(530.0DL) */
	4.077273932771828716711974820084340e+230DL, /* exp(531.0DL) */
	1.108317964110340884306433009332212e+231DL, /* exp(532.0DL) */
	3.012720581995863893384693306677705e+231DL, /* exp(533.0DL) */
	8.189423612263915821186014819241439e+231DL, /* exp(534.0DL) */
	2.226116139077043620640842633613762e+232DL, /* exp(535.0DL) */
	6.051211048892536372953284172187696e+232DL, /* exp(536.0DL) */
	1.644889703437518074758158943467301e+233DL, /* exp(537.0DL) */
	4.471273790673593297092837895112485e+233DL, /* exp(538.0DL) */
	1.215418229525322146855011085035967e+234DL, /* exp(539.0DL) */
	3.303849287296548204875559387097202e+234DL, /* exp(540.0DL) */
	8.980793481625574506121216074127441e+234DL, /* exp(541.0DL) */
	2.441232772624624153754432382496990e+235DL, /* exp(542.0DL) */
	6.635958684864207975159269263875368e+235DL, /* exp(543.0DL) */
	1.803840590747136040282275111336768e+236DL, /* exp(544.0DL) */
	4.903347099264769269875143479995337e+236DL, /* exp(545.0DL) */
	1.332867931855879259014960921483314e+237DL, /* exp(546.0DL) */
	3.623110678899625578225435150399782e+237DL, /* exp(547.0DL) */
	9.848635920948766939626042406624255e+237DL, /* exp(548.0DL) */
	2.677136805902404708530235246447660e+238DL, /* exp(549.0DL) */
	7.277212331783396755856532665739865e+238DL, /* exp(550.0DL) */
	1.978151404332488388116926108277413e+239DL, /* exp(551.0DL) */
	5.377173016337744632419341697026827e+239DL, /* exp(552.0DL) */
	1.461667169879120399766778310399173e+240DL, /* exp(553.0DL) */
	3.973223307137573289325695033361800e+240DL, /* exp(554.0DL) */
	1.080034071620201739655617026903353e+241DL, /* exp(555.0DL) */
	2.935836991001829401203875825325156e+241DL, /* exp(556.0DL) */
	7.980432343958154358562489927847075e+241DL, /* exp(557.0DL) */
	2.169306422382827602890853416049801e+242DL, /* exp(558.0DL) */
	5.896786228322742509426315390702816e+242DL, /* exp(559.0DL) */
	1.602912685075726150454638702193788e+243DL, /* exp(560.0DL) */
	4.357168424447842629467815384115014e+243DL, /* exp(561.0DL) */
	1.184401175171209895839117272848773e+244DL, /* exp(562.0DL) */
	3.219536192073438364850714410685088e+244DL, /* exp(563.0DL) */
	8.751606726979457897693046120404434e+244DL, /* exp(564.0DL) */
	2.378933353576820110235705073981676e+245DL, /* exp(565.0DL) */
	6.466611306143006928877783259904363e+245DL, /* exp(566.0DL) */
	1.757807200519634761305847926330476e+246DL, /* exp(567.0DL) */
	4.778215371106988348935347740794150e+246DL, /* exp(568.0DL) */
	1.298853601574381967235062972107544e+247DL, /* exp(569.0DL) */
	3.530650142988227249099232301413323e+247DL, /* exp(570.0DL) */
	9.597302126331227875023735925726759e+247DL, /* exp(571.0DL) */
	2.608817197223753285500958233820604e+248DL, /* exp(572.0DL) */
	7.091500380984785710244093969315418e+248DL, /* exp(573.0DL) */
	1.927669662214133920207732330925958e+249DL, /* exp(574.0DL) */
	5.239949414068466053847053734169716e+249DL, /* exp(575.0DL) */
	1.424365927430693263406437508712142e+250DL, /* exp(576.0DL) */
	3.871828017611068619756333191738026e+250DL, /* exp(577.0DL) */
	1.052471974319077600436351056214937e+251DL, /* exp(578.0DL) */
	2.860915442753963560149385355110176e+251DL, /* exp(579.0DL) */
	7.776974460795963023293133416439138e+251DL, /* exp(580.0DL) */
	2.113946470080605596467762082192512e+252DL, /* exp(581.0DL) */
	5.746302275955252943010619149104434e+252DL, /* exp(582.0DL) */
	1.562006905756201809684652029738012e+253DL, /* exp(583.0DL) */
	4.245974987844623805253754053684570e+253DL, /* exp(584.0DL) */
	1.154175665354965636494651964287860e+254DL, /* exp(585.0DL) */
	3.137374737984031099197852644697323e+254DL, /* exp(586.0DL) */
	8.528268739328450016147688013915050e+254DL, /* exp(587.0DL) */
	2.318223794233185573296137735139557e+255DL, /* exp(588.0DL) */
	6.301585614165449125684244573161119e+255DL, /* exp(589.0DL) */
	1.712948566546487259520355035835174e+256DL, /* exp(590.0DL) */
	4.656276961528285912678100380088271e+256DL, /* exp(591.0DL) */
	1.265707305279483645812871129507303e+257DL, /* exp(592.0DL) */
	3.440549168089085763485571675208101e+257DL, /* exp(593.0DL) */
	9.352382283536447018650431059979411e+257DL, /* exp(594.0DL) */
	2.542241081413943403300761495150903e+258DL, /* exp(595.0DL) */
	6.910527735169594554573190583467196e+258DL, /* exp(596.0DL) */
	1.878476196757375020647877911959506e+259DL, /* exp(597.0DL) */
	5.106227710838430591467438208104426e+259DL, /* exp(598.0DL) */
	1.388016599834613402215027842278337e+260DL, /* exp(599.0DL) */
	3.773020300929939823401431193483135e+260DL, /* exp(600.0DL) */
	1.025613252242493391514516645079104e+261DL, /* exp(601.0DL) */
	2.787905866597552912328285255652010e+261DL, /* exp(602.0DL) */
	7.578313856626495175545054862949550e+261DL, /* exp(603.0DL) */
	2.059999284682718808696302995082404e+262DL, /* exp(604.0DL) */
	5.599658622191666139792171291558017e+262DL, /* exp(605.0DL) */
	1.522145027827762021100120336211546e+263DL, /* exp(606.0DL) */
	4.137619169423493238416696018145167e+263DL, /* exp(607.0DL) */
	1.124721500132768927172822089404576e+264DL, /* exp(608.0DL) */
	3.057310015888103407800160209739006e+264DL, /* exp(609.0DL) */
	8.310630260154466370620767610925627e+264DL, /* exp(610.0DL) */
	2.259063521921975363206047978936929e+265DL, /* exp(611.0DL) */
	6.140771320975197609781213157045819e+265DL, /* exp(612.0DL) */
	1.669234709452932671770806976793472e+266DL, /* exp(613.0DL) */
	4.537450378139020943054455738228414e+266DL, /* exp(614.0DL) */
	1.233406891042992406398480210225887e+267DL, /* exp(615.0DL) */
	3.352747539018331781648810576495882e+267DL, /* exp(616.0DL) */
	9.113712710724315024083120382834683e+267DL, /* exp(617.0DL) */
	2.477363965135813264401301521582167e+268DL, /* exp(618.0DL) */
	6.734173448907928873072281631157755e+268DL, /* exp(619.0DL) */
	1.830538131585779973659984071493435e+269DL, /* exp(620.0DL) */
	4.975918539390998333056028597620767e+269DL, /* exp(621.0DL) */
	1.352594894551902465257285293765718e+270DL, /* exp(622.0DL) */
	3.676734123126914915853981239838730e+270DL, /* exp(623.0DL) */
	9.994399554971194634376021138137170e+270DL, /* exp(624.0DL) */
	2.716759469663736693407194678125877e+271DL, /* exp(625.0DL) */
	7.384917898680968214434664479009658e+271DL, /* exp(626.0DL) */
	2.007428812864643244165976038645452e+272DL, /* exp(627.0DL) */
	5.456757263935072986189812313850169e+272DL, /* exp(628.0DL) */
	1.483300411286660709274049565156564e+273DL, /* exp(629.0DL) */
	4.032028554146357891230336377029199e+273DL, /* exp(630.0DL) */
	1.096018995056404220473333839077488e+274DL, /* exp(631.0DL) */
	2.979288517907767725080181759267345e+274DL, /* exp(632.0DL) */
	8.098545839965365786039531189385352e+274DL, /* exp(633.0DL) */
	2.201412999372044884674717205317365e+275DL, /* exp(634.0DL) */
	5.984060953126553169633576189715827e+275DL, /* exp(635.0DL) */
	1.626636414927522393392903634887462e+276DL, /* exp(636.0DL) */
	4.421656208207251754959015960656940e+276DL, /* exp(637.0DL) */
	1.201930772246289711810497611562084e+277DL, /* exp(638.0DL) */
	3.267186577262836658270402974456316e+277DL, /* exp(639.0DL) */
	8.881133903158873299234272672967127e+277DL, /* exp(640.0DL) */
	2.414142490506831928910472323441926e+278DL, /* exp(641.0DL) */
	6.562319663255584349955503981011063e+278DL, /* exp(642.0DL) */
	1.783823429316713583233384122083389e+279DL, /* exp(643.0DL) */
	4.848934813091120635935959450934223e+279DL, /* exp(644.0DL) */
	1.318077138980805015534262735851842e+280DL, /* exp(645.0DL) */
	3.582905135398809745024502084539878e+280DL, /* exp(646.0DL) */
	9.739345922647179593882146700607238e+280DL, /* exp(647.0DL) */
	2.647428704260852228681909004375106e+281DL, /* exp(648.0DL) */
	7.196457338933150317666337445002583e+281DL, /* exp(649.0DL) */
	1.956199921370271886821566849827147e+282DL, /* exp(650.0DL) */
	5.317502699093823182683530149803012e+282DL, /* exp(651.0DL) */
	1.445447095972866590256825223241052e+283DL, /* exp(652.0DL) */
	3.929132574981940835735158434038403e+283DL, /* exp(653.0DL) */
	1.068048968017990678959437158369329e+284DL, /* exp(654.0DL) */
	2.903258101667740029588950654122071e+284DL, /* exp(655.0DL) */
	7.891873741089921014851556006624308e+284DL, /* exp(656.0DL) */
	2.145233698289783624753859799313684e+285DL, /* exp(657.0DL) */
	5.831349779859112813154641712075748e+285DL, /* exp(658.0DL) */
	1.585125214197968009236380889475074e+286DL, /* exp(659.0DL) */
	4.308817065586588211059622644869701e+286DL, /* exp(660.0DL) */
	1.171257913153824883863901946336209e+287DL, /* exp(661.0DL) */
	3.183809101764904714912751772693689e+287DL, /* exp(662.0DL) */
	8.654490426610055613160749879342242e+287DL, /* exp(663.0DL) */
	2.352534406122688441013083174382482e+288DL, /* exp(664.0DL) */
	6.394851526987995637863277529865170e+288DL, /* exp(665.0DL) */
	1.738300870150504624084731424404936e+289DL, /* exp(666.0DL) */
	4.725191667724663076744727468708714e+289DL, /* exp(667.0DL) */
	1.284440264636204247017089930798463e+290DL, /* exp(668.0DL) */
	3.491470631101721219149135067460521e+290DL, /* exp(669.0DL) */
	9.490801171122243367142720526726012e+290DL, /* exp(670.0DL) */
	2.579867236097941956885309166553365e+291DL, /* exp(671.0DL) */
	7.012806227721897012192969479137924e+291DL, /* exp(672.0DL) */
	1.906278373532085777127233131597929e+292DL, /* exp(673.0DL) */
	5.181801862756732947542478176037853e+292DL, /* exp(674.0DL) */
	1.408559784220685861163313619793030e+293DL, /* exp(675.0DL) */
	3.828862465745284175763386828853108e+293DL, /* exp(676.0DL) */
	1.040792726430429952342378704515152e+294DL, /* exp(677.0DL) */
	2.829167955448183987744726075009629e+294DL, /* exp(678.0DL) */
	7.690475842953428199469558510214363e+294DL, /* exp(679.0DL) */
	2.090488073610356201828202177433601e+295DL, /* exp(680.0DL) */
	5.682535743105386205805042279863698e+295DL, /* exp(681.0DL) */
	1.544673365005238856979877261448928e+296DL, /* exp(682.0DL) */
	4.198857538998426858121488429544030e+296DL, /* exp(683.0DL) */
	1.141367814854769059625262650135429e+297DL, /* exp(684.0DL) */
	3.102559390707726651118664429334005e+297DL, /* exp(685.0DL) */
	8.433630813475780520653859864366691e+297DL, /* exp(686.0DL) */
	2.292498538820348974912352830338758e+298DL, /* exp(687.0DL) */
	6.231657119844267706438578811036121e+298DL, /* exp(688.0DL) */
	1.693940031006010360564275039893585e+299DL, /* exp(689.0DL) */
	4.604606404782989622120963349708575e+299DL, /* exp(690.0DL) */
	1.251661791732773560414909608460945e+300DL, /* exp(691.0DL) */
	3.402369503843688383092159087116573e+300DL, /* exp(692.0DL) */
	9.248599196001515793928708938024616e+300DL, /* exp(693.0DL) */
	2.514029913319185603777288352959536e+301DL, /* exp(694.0DL) */
	6.833841829578010843769419754835242e+301DL, /* exp(695.0DL) */
	1.857630806390522231607897627268625e+302DL, /* exp(696.0DL) */
	5.049564064997079424341813227011041e+302DL, /* exp(697.0DL) */
	1.372613823952135019694448602262587e+303DL, /* exp(698.0DL) */
	3.731151215140771601712733760653182e+303DL, /* exp(699.0DL) */
	1.014232054735004509455329595231268e+304DL, /* exp(700.0DL) */
	2.756968564226842505826254726602022e+304DL, /* exp(701.0DL) */
	7.494217549770650136851917092620455e+304DL, /* exp(702.0DL) */
	2.037139538406042869372594433878036e+305DL, /* exp(703.0DL) */
	5.537519389284593616073850538300673e+305DL, /* exp(704.0DL) */
	1.505253833063194063830465824095254e+306DL, /* exp(705.0DL) */
	4.091704141634005599423296108553077e+306DL, /* exp(706.0DL) */
	1.112240501563433293848363821483406e+307DL, /* exp(707.0DL) */
	3.023383144276055014775621985096731e+307DL, /* exp(708.0DL) */
	8.218407461554972189241372386597816e+307DL, /* exp(709.0DL) */
	2.233994766161711031253644458116810e+308DL, /* exp(710.0DL) */
	6.072627377729993058870274802931239e+308DL, /* exp(711.0DL) */
	1.650711265188634268635859219882103e+309DL, /* exp(712.0DL) */
	4.487098436194904665811320991414945e+309DL, /* exp(713.0DL) */
	1.219719814161560797699519459504529e+310DL, /* exp(714.0DL) */
	3.315542206646814341669187723053315e+310DL, /* exp(715.0DL) */
	9.012578131817040091646289944365234e+310DL, /* exp(716.0DL) */
	2.449872736328562975159249769074200e+311DL, /* exp(717.0DL) */
	6.659444541199170579579700734839518e+311DL, /* exp(718.0DL) */
	1.810224708397248900192728326006270e+312DL, /* exp(719.0DL) */
	4.920700930263815717908101983834722e+312DL, /* exp(720.0DL) */
	1.337585192201764982860090659029994e+313DL, /* exp(721.0DL) */
	3.635933521977957171804010465462696e+313DL, /* exp(722.0DL) */
	9.883492022277777556027845935179594e+313DL, /* exp(723.0DL) */
	2.686611676587762382032477144990756e+314DL, /* exp(724.0DL) */
	7.302967700594403819661802237302293e+314DL, /* exp(725.0DL) */
	1.985152439434910522842840163468744e+315DL, /* exp(726.0DL) */
	5.396203802837062631836118637081575e+315DL, /* exp(727.0DL) */
	1.466840273991358384174339327079969e+316DL, /* exp(728.0DL) */
	3.987285262042596563546861047334350e+316DL, /* exp(729.0DL) */
	1.083856507269295270218762885555664e+317DL, /* exp(730.0DL) */
	2.946227448367214400878225512361948e+317DL, /* exp(731.0DL) */
	8.008676535403858849347854789488034e+317DL, /* exp(732.0DL) */
	2.176983989619465295637813934827586e+318DL, /* exp(733.0DL) */
	5.917656019828867276099362352692636e+318DL, /* exp(734.0DL) */
	1.608585682577208938684831976797157e+319DL, /* exp(735.0DL) */
	4.372589230469016858241988532693547e+319DL, /* exp(736.0DL) */
	1.188592984849964869521935757602547e+320DL, /* exp(737.0DL) */
	3.230930712151556757737907741524966e+320DL, /* exp(738.0DL) */
	8.782580243851818865661945584396214e+320DL, /* exp(739.0DL) */
	2.387352828384580956238600899756351e+321DL, /* exp(740.0DL) */
	6.489497811518111949732100007150520e+321DL, /* exp(741.0DL) */
	1.764028397687442585608481908129751e+322DL, /* exp(742.0DL) */
	4.795126338319501235251533562592617e+322DL, /* exp(743.0DL) */
	1.303450479061926016436398558519613e+323DL, /* exp(744.0DL) */
	3.543145751530270709100952804291556e+323DL, /* exp(745.0DL) */
	9.631268711966602235896809976117011e+323DL, /* exp(746.0DL) */
	2.618050272474496901344534952692922e+324DL, /* exp(747.0DL) */
	7.116598481659677023880278303144470e+324DL, /* exp(748.0DL) */
	1.934492033313473195934101346006087e+325DL, /* exp(749.0DL) */
	5.258494541454804166807735549286840e+325DL, /* exp(750.0DL) */
	1.429407015708767371435505583554978e+326DL, /* exp(751.0DL) */
	3.885531116273015366004138350574444e+326DL, /* exp(752.0DL) */
	1.056196862727712730194308509475448e+327DL, /* exp(753.0DL) */
	2.871040739228194163929095858500196e+327DL, /* exp(754.0DL) */
	7.804297870209624512932094469324608e+327DL, /* exp(755.0DL) */
	2.121428108447245061685883072308586e+328DL, /* exp(756.0DL) */
	5.766639477574391013185570062882344e+328DL, /* exp(757.0DL) */
	1.567535130316502898552990500196127e+329DL, /* exp(758.0DL) */
	4.261002260210531250477579537542399e+329DL, /* exp(759.0DL) */
	1.158260501495320733780838097543570e+330DL, /* exp(760.0DL) */
	3.148478473836591142185522040052992e+330DL, /* exp(761.0DL) */
	8.558451822724473185317785446579883e+330DL, /* exp(762.0DL) */
	2.326428406945412944180484968414935e+331DL, /* exp(763.0DL) */
	6.323888063810640869736906367024209e+331DL, /* exp(764.0DL) */
	1.719011000906552019388401599159601e+332DL, /* exp(765.0DL) */
	4.672756366685475689938267252485588e+332DL, /* exp(766.0DL) */
	1.270186872037743970562137024901372e+333DL, /* exp(767.0DL) */
	3.452725893007433996921737545743740e+333DL, /* exp(768.0DL) */
	9.385482053612137472931923385909968e+333DL, /* exp(769.0DL) */
	2.551238531766235587117882706264335e+334DL, /* exp(770.0DL) */
	6.934985340964692832704317313855231e+334DL, /* exp(771.0DL) */
	1.885124463297418049480527073185397e+335DL, /* exp(772.0DL) */
	5.124299572964981846159920452385392e+335DL, /* exp(773.0DL) */
	1.392929041277115553629473402158305e+336DL, /* exp(974.0DL) */
	3.786373701236462561280390085789673e+336DL, /* exp(775.0DL) */
	1.029243082782629411817691553637979e+337DL, /* exp(776.0DL) */
	2.797772768995190337381259359131943e+337DL, /* exp(777.0DL) */
	7.605134878117171972732666762336810e+337DL, /* exp(778.0DL) */
	2.067289994216600435830214794233100e+338DL, /* exp(779.0DL) */
	5.619476825434189682607279641036338e+338DL, /* exp(780.0DL) */
	1.527532174002448008606957458439105e+339DL, /* exp(781.0DL) */
	4.152262950977394815646445394711523e+339DL, /* exp(782.0DL) */
	1.128702092662558368976236259107382e+340DL, /* exp(783.0DL) */
	3.068130388228329868155355092030060e+340DL, /* exp(784.0DL) */
	8.340043081664064831576661484892520e+340DL, /* exp(785.0DL) */
	2.267058755745300447162613736782219e+341DL, /* exp(786.0DL) */
	6.162504619791423322029108992107036e+341DL, /* exp(787.0DL) */
	1.675142432577394355012813183678504e+342DL, /* exp(788.0DL) */
	4.553509234555812431045605262925491e+342DL, /* exp(789.0DL) */
	1.237772140801352130137968719139589e+343DL, /* exp(790.0DL) */
	3.364613518113166256879695073686605e+343DL, /* exp(791.0DL) */
	9.145967786074678487937518358486807e+343DL, /* exp(792.0DL) */
	2.486131803655860291965933147405355e+344DL, /* exp(793.0DL) */
	6.758006905031835956303670857496097e+344DL, /* exp(794.0DL) */
	1.837016736654879231178405757986544e+345DL, /* exp(795.0DL) */
	4.993529213824093501885397663400206e+345DL, /* exp(796.0DL) */
	1.357381972181741554798631247078373e+346DL, /* exp(797.0DL) */
	3.689746749259529308695564251354971e+346DL, /* exp(798.0DL) */
	1.002977154012801164059425092238661e+347DL, /* exp(799.0DL) */
	2.726374572112566567364779546367270e+347DL, /* exp(800.0DL) */
	7.411054456946394527643734255031975e+347DL, /* exp(801.0DL) */
	2.014533466003780185206947161220956e+348DL, /* exp(802.0DL) */
	5.476069713460693445797399842131595e+348DL, /* exp(803.0DL) */
	1.488550079347513369645468095661906e+349DL, /* exp(804.0DL) */
	4.046298631441615511213976592495992e+349DL, /* exp(805.0DL) */
	1.099898004236644699470400827438392e+350DL, /* exp(806.0DL) */
	2.989832758074841236490032825474100e+350DL, /* exp(807.0DL) */
	8.127208056406429679254269659776141e+350DL, /* exp(808.0DL) */
	2.209204197583555291455186381500514e+351DL, /* exp(809.0DL) */
	6.005239625646824521234554982136528e+351DL, /* exp(810.0DL) */
	1.632393374993796247932666212255357e+352DL, /* exp(811.0DL) */
	4.437305248142568354514550335867051e+352DL, /* exp(812.0DL) */
	1.206184622335189814332380803085358e+353DL, /* exp(813.0DL) */
	3.278749740660482701078221353658401e+353DL, /* exp(814.0DL) */
	8.912565840102197290438257902201843e+353DL, /* exp(815.0DL) */
	2.422686576809462744120292600053280e+354DL, /* exp(816.0DL) */
	6.585544897792811525640914217004867e+354DL, /* exp(817.0DL) */
	1.790136702617137988676169463619492e+355DL, /* exp(818.0DL) */
	4.866096069181759959966874278606174e+355DL, /* exp(819.0DL) */
	1.322742052039276714359927254015698e+356DL, /* exp(820.0DL) */
	3.595585683796994671507456303747256e+356DL, /* exp(821.0DL) */
	9.773815226932861133048219422303157e+356DL, /* exp(822.0DL) */
	2.656798432608791590522782184502560e+357DL, /* exp(823.0DL) */
	7.221926901238951475359041420051346e+357DL, /* exp(824.0DL) */
	1.963123266209738361537629812032583e+358DL, /* exp(825.0DL) */
	5.336322301563100606580738879236068e+358DL, /* exp(826.0DL) */
	1.450562794313972570108358416386998e+359DL, /* exp(827.0DL) */
	3.943038484822447303136740477606212e+359DL, /* exp(828.0DL) */
	1.071828986220754533990420066011544e+360DL, /* exp(829.0DL) */
	2.913533256459557435440451773626653e+360DL, /* exp(830.0DL) */
	7.919804507645122153121565572979161e+360DL, /* exp(831.0DL) */
	2.152826067807977114589000590698994e+361DL, /* exp(832.0DL) */
	5.851987979955364533013829044052101e+361DL, /* exp(833.0DL) */
	1.590735258627342286079138111639773e+362DL, /* exp(834.0DL) */
	4.324066747415804201377394599833634e+362DL, /* exp(835.0DL) */
	1.175403206454438875839130486743495e+363DL, /* exp(836.0DL) */
	3.195077177217596747680371113061627e+363DL, /* exp(837.0DL) */
	8.685120231354813795861588571062056e+363DL, /* exp(838.0DL) */
	2.360860450287380922234892268978168e+364DL, /* exp(839.0DL) */
	6.417484061543826679679953837133422e+364DL, /* exp(840.0DL) */
	1.744453030892013317040787485731125e+365DL, /* exp(841.0DL) */
	4.741914974474065282186766441410415e+365DL, /* exp(842.0DL) */
	1.288986130721068898936989817415551e+366DL, /* exp(843.0DL) */
	3.503827576274817066469387283511598e+366DL, /* exp(844.0DL) */
	9.524390830641534520220942573435094e+366DL, /* exp(845.0DL) */
	2.588997852207483509886649384554193e+367DL, /* exp(846.0DL) */
	7.037625815575099238948400387904897e+367DL, /* exp(847.0DL) */
	1.913025036997206022941837310382119e+368DL, /* exp(848.0DL) */
	5.200141195456697847293452548102919e+368DL, /* exp(849.0DL) */
	1.413544931703123795815965756251118e+369DL, /* exp(850.0DL) */
	3.842413501558983570866924089658815e+369DL, /* exp(851.0DL) */
	1.044476279871347632101279988319276e+370DL, /* exp(852.0DL) */
	2.839180891830788305933519109095650e+370DL, /* exp(853.0DL) */
	7.717693825971777963654884672708470e+370DL, /* exp(854.0DL) */
	2.097886688474964905823576978118637e+371DL, /* exp(855.0DL) */
	5.702647263447619025108165020564636e+371DL, /* exp(856.0DL) */
	1.550140243034136448104461225796107e+372DL, /* exp(857.0DL) */
	4.213718054202781183259880383059111e+372DL, /* exp(858.0DL) */
	1.145407321698922631344907889538815e+373DL, /* exp(859.0DL) */
	3.113539908758125249535484762623464e+373DL, /* exp(860.0DL) */
	8.463478956159245573379795255424772e+373DL, /* exp(861.0DL) */
	2.300612105207320560570469899879770e+374DL, /* exp(862.0DL) */
	6.253712079917968677677102550660032e+374DL, /* exp(863.0DL) */
	1.699935190725583472080427393935978e+375DL, /* exp(864.0DL) */
	4.620902938507414836577231776192770e+375DL, /* exp(865.0DL) */
	1.256091648881771067050965908374898e+376DL, /* exp(866.0DL) */
	3.414411104034477698615834349236418e+376DL, /* exp(867.0DL) */
	9.281331658985707362486969070681960e+376DL, /* exp(868.0DL) */
	2.522927519252249231103011832368825e+377DL, /* exp(869.0DL) */
	6.858028030102647089906384408884850e+377DL, /* exp(870.0DL) */
	1.864205297329080765037552524479372e+378DL, /* exp(871.0DL) */
	5.067435384246731739018239329665377e+378DL, /* exp(872.0DL) */
	1.377471752188827042319870828033714e+379DL, /* exp(873.0DL) */
	3.744356433190529618458759523623273e+379DL, /* exp(874.0DL) */
	1.017821605161554170369897256012423e+380DL, /* exp(875.0DL) */
	2.766725973923669863850278968760077e+380DL, /* exp(876.0DL) */
	7.520740939242366025852659043295359e+380DL, /* exp(877.0DL) */
	2.044349343169053595033812265286127e+381DL, /* exp(878.0DL) */
	5.557117670558623144732170233962540e+381DL, /* exp(879.0DL) */
	1.510581198248816429203206789026766e+382DL, /* exp(880.0DL) */
	4.106185421611648223691878540343077e+382DL, /* exp(881.0DL) */
	1.116176921585038669288681280743735e+383DL, /* exp(882.0DL) */
	3.034083443289967269077449220617243e+383DL, /* exp(883.0DL) */
	8.247493889923568110575810990828503e+383DL, /* exp(884.0DL) */
	2.241901277130624027773101880668667e+384DL, /* exp(885.0DL) */
	6.094119502823301376410746524099709e+384DL}; /* exp(886.0DL) */

#endif /*_DDLOGTBLS_H  */
