/*
 * ExtensionFileFilter.java - 0.9.0     01/07/2001 - 12:35:59
 *
 * Copyright (C) 2001,,2003 2002 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
 
 
package net.sourceforge.groboutils.util.io.v1;
 
import java.io.IOException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FileFilter;



/**
 * Allows files with the given extention(s) to be accepted. You can also
 * specify whether directories are allowed or not. This filter is
 * case insensitive or sensitive, depending on the settings.
 * <P>
 * The extension strings passed in are the end-of-name Strings, meaning
 * that each file must match at least one given string at the end. So,
 * if you want to match all "DOC" files, pass in ".doc" to match.
 * <P>
 * By default, directories are allowed, independent of their names. If
 * directories are not allowed, then the directory names must match the
 * extension list.
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    January 7, 2001
 * @version  $Date: 2003/02/10 22:52:45 $
 */
public class ExtensionFileFilter extends ExtensionFilenameFilter
         implements FileFilter
{
    //--------------------------------------------------------------
    // Private fields
    
    //--------------------------------------------------------------
    // Constructors
    
    /**
     * Default Constructor.
     */
    public ExtensionFileFilter()
    {
        super();
    }
    
    /**
     * Specify a single "end string" to match.
     */
    public ExtensionFileFilter( String extension )
    {
        super( extension );
    }
    
    /**
     * <P>
     * Slow, but it works.
     */
    public ExtensionFileFilter( String exts[] )
    {
        super( exts );
    }
    
    
    /**
     * 
     */
    public ExtensionFileFilter( boolean caseInsensitive )
    {
        super( caseInsensitive );
    }
     
    
    /**
     * 
     */
    public ExtensionFileFilter( String extension, boolean caseInsensitive )
    {
        super( extension, caseInsensitive );
    }

    
    /**
     * 
     */
    public ExtensionFileFilter( String exts[], boolean caseInsensitive )
    {
        super( exts, caseInsensitive );
    }

    
    //--------------------------------------------------------------
    // Public methods
    
    
    /**
     * Accepts some files.
     */
    public boolean accept( File pathname )
    {
        if (pathname == null)
        {
            throw new IllegalArgumentException( "no null args" );
        }
        return matches( pathname.getName(), pathname );
    }
    

    
    //--------------------------------------------------------------
    // Protected methods
    
    
}
