/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <utils/optional.h>

#include "clangtoolsdiagnostic.h"

namespace Utils { class FilePath; }

namespace ClangTools {
namespace Internal {

enum class OutputFileFormat { Serialized, Yaml };

using AcceptDiagsFromFilePath = std::function<bool(const Utils::FilePath &)>;

// Reads diagnostics generated by "clang -serialize-diagnostics path/to/file"
Diagnostics readSerializedDiagnostics(const Utils::FilePath &logFilePath,
                                      const Utils::FilePath &mainFilePath,
                                      const AcceptDiagsFromFilePath &acceptFromFilePath,
                                      QString *errorMessage);

// Reads diagnostics generated by "clang-tidy/clazy-standalone -export-fixes=path/to/file"
Diagnostics readExportedDiagnostics(const Utils::FilePath &logFilePath,
                                    const AcceptDiagsFromFilePath &acceptFromFilePath,
                                    QString *errorMessage);

// Exposed for tests
struct LineColumnInfo {
    int line = 1; // 1-based
    int column = 1; // 1-based
    int lineStartOffset = 0; // for optimiation/caching purposes
};
using OptionalLineColumnInfo = Utils::optional<LineColumnInfo>;
OptionalLineColumnInfo byteOffsetInUtf8TextToLineColumn(const char *text,
                                                        int offset,
                                                        int startLine = 1);

} // namespace Internal
} // namespace ClangTools
