from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


IPython = _Mock()

executables = _Mock()

guisupport = _Mock()

main = _Mock()

os = _Mock()

print_process_id = _Mock()

sip = _Mock()

sys = _Mock()

PYSIDE = _Mock()

QTCONSOLE = _Mock()

class ExampleWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QApplication(_Mock):
  pass
  CodecForTr = 0
  CustomColor = 1
  DefaultCodec = 0
  GuiClient = 1
  GuiServer = 2
  ManyColor = 2
  NormalColor = 0
  Tty = 0
  UnicodeUTF8 = 1

class QIPythonWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  _local_kernel = False
  _payload_source_edit = 'edit_magic'
  _payload_source_exit = 'ask_exit'
  _payload_source_next_input = 'set_next_input'
  _payload_source_page = 'page'
  _payload_source_plot = 'IPython.kernel.zmq.pylab.backend_payload.add_plot_payload'
  _retrying_history_request = False
  _svg_warning_displayed = False
  _temp_buffer_filled = False

class QPushButton(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QVBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class QWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QtInProcessKernelManager(_Mock):
  pass
  client_class = 'IPython.qt.inprocess.QtInProcessKernelClient'

class RichIPythonWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  _local_kernel = False
  _payload_source_edit = 'edit_magic'
  _payload_source_exit = 'ask_exit'
  _payload_source_next_input = 'set_next_input'
  _payload_source_page = 'page'
  _payload_source_plot = 'IPython.kernel.zmq.pylab.backend_payload.add_plot_payload'
  _retrying_history_request = False
  _svg_warning_displayed = False
  _temp_buffer_filled = False

