// @HEADER
//
// ***********************************************************************
//
//        MueLu: A package for multigrid based preconditioning
//                  Copyright 2012 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact
//                    Jonathan Hu       (jhu@sandia.gov)
//                    Andrey Prokopenko (aprokop@sandia.gov)
//                    Ray Tuminaro      (rstumin@sandia.gov)
//
// ***********************************************************************
//
// @HEADER
#ifndef MUELU_NOFACTORY_HPP
#define MUELU_NOFACTORY_HPP

#include <algorithm>                    // for swap
#include "Teuchos_RCPDecl.hpp"          // for RCP
#include "Teuchos_RCP.hpp"              // for RCP::RCP<T>, RCP::operator=, etc
#include "MueLu_config.hpp"             // for HAVE_MUELU_DEBUG
#include "MueLu_Exceptions.hpp"
#include "MueLu_FactoryBase.hpp"
#include "MueLu_Level_fwd.hpp"

namespace MueLu {

  /*!
    @class NoFactory class.
    @brief NoFactory that is used for data stored in level class for that no generating factory is available/necessary.

    This should be used as the "generating" factory for user-data.  Uses Singleton pattern.
  */
  class NoFactory : public FactoryBase {

    //! Constructor.
    NoFactory() { }

  public:

    //! Destructor.
    virtual ~NoFactory() { }

    //! Implementation of FactoryBase interface
    //@{

    //!
    void CallBuild(Level& requestedLevel) const;

    //!
    void CallDeclareInput(Level& requestedLevel) const { }

    //@}

    //! Static Get() functions
    //@{

    //!
    static const RCP<const NoFactory> getRCP() {
      if (noFactory_.is_null())
        noFactory_ = rcp(new NoFactory());

      return noFactory_;
    }

    //!
    static const NoFactory* get();

    //@}
#ifdef HAVE_MUELU_DEBUG
    void ResetDebugData() const { }
#endif

  private:
    static RCP<const NoFactory> noFactory_; // static NoFactory instance for user defined "factories"

  }; // class NoFactory

} // namespace MueLu

#endif // MUELU_NOFACTORY_HPP
