target=loiinvar loirevers

\language{fr}
\format{html}
\author{Sophie Lemaire}
\email{sophie.lemaire@math.u-psud.fr}

#if #TARGET(loiinvar)
\title{Calcul de la loi invariante}
\integer{d=random(3,4)}
\integer{v=randint(2,4,7,9,11)}
/* creation d'une matrice stochastique irreductible */
/*comme realisations de multinomiales avec comme parametre */
/*la loi uniforme*/
\real{k=1/\d}
\text{p=wims(values \k for x=1 to \d-1)}
\real{s=1-(\d-1)*\k} pour que la somme soit exactement 1
\text{p=\p,\s}
\matrix{A=slib(stat/multinomial \d,\v,[\p])}
\matrix{P=pari(A=Mat([\A]);for(i=1,\d-1, A[i,i+1]=A[i,i+1]+1);
A[\d,1]=A[\d,1]+1;Q=matrix(\d,\d,i,j,A[i,j]/(\v+1));print(Q))}
/* permutation des indices */
\matrix{s=shuffle(\d)}
\matrix{PP=pari(s=[\s];P=[\P];Q=matrix(\d,\d,i,j,0);
for(i=1,\d,for(j=1,\d,Q[s[i],s[j]]=P[i,j]));print(Q))}

#elif #TARGET(loirevers)

\title{Loi rversible}
\integer{d=random(3,4)}
\integer{r=randint(0,1)}

/*Creation d'une loi de prob a coef strict positif*/
\text{p=slib(stat/posdiscretelaw \d,10,Q)}
\text{A=slib(matrix/triangular \d,\d,4)}
\text{B=pari(A=Mat([\A]);  
if(\r, v=abs(A[1,2])+2; B=matrix(\d,\d,i,j,abs(A[i,j])+v), 
B=matrix(\d,\d,i,j,abs(A[i,j]+A[j,i])+1));print(B))}
/*Creation d'une matrice stochastique ayant d etats*/ 
\matrix{PP=pari(B=Mat([\B]);p=Mat([\p]);d=\d;
T=matrix(d,d,i,j,B[i,j]*p[1,j]);
s=vector(d,i,0);m=0;
for(i=1,d, for(j=1,i-1,s[i]=s[i]+T[i,j]);
for(j=i+1,d,s[i]=s[i]+T[i,j]);m=max(m,s[i]));
u=(RANDOM(floor(50/m-1))+1)/50;TT=matrix(d,d,i,j,T[i,j]*u);
for(i=1,d,TT[i,i]=1-u*s[i]); print(TT))}

#endif

/*Calcul de la mesure invariante*/ 
\matrix{mu=pari(P=[\PP];v=matker(mattranspose(P)-matid(\d));
s=sum(i=1,\d,v[i,1]);vv=mattranspose(v/s);print(vv))}

#if #TARGET(loirevers)
/*Verification*/ 
\integer{rev=pari(mu=Vec([\mu]);P=[\PP];s=0; for(i=1,(\d-1),
for(j=i+1,\d,if(mu[i]*P[i,j]-mu[j]*P[j,i],s=1;return(s))))
;print(s))}
\text{choix=oui,non}
\integer{rep=\rev+1}
\integer{t=10*\d}
\steps{reply1,reply2}

#endif

\text{pb1=wims(record 4 of fich_rem)}
\text{pb2=wims(record 5 of fich_rem)}
\text{NB=wims(record 6 of fich_rem)}
\statement{On considre une chane de Markov homogne \((X_n)_n\) dont les tats sont numrots de 1  \d et dont la  matrice de transition  est :
<p> <center>\(Q\) = \([\PP]) </center></p> 
#if #TARGET(loiinvar)
<p>Donner les coefficients d'une loi probabilit invariante pour cette chane.</p>
#elif #TARGET(loirevers)
<p>1- Cette chane de Markov admet-elle une loi de probabilit rversible ?<BR><center> \embed{reply1,4}</center> </p>
<p>2- Donner les coefficients d'une loi de probabilit invariante pour cette chane. <BR><center>\embed{reply2,\t}</center> </p>
#endif

<i>NB : \NB </i>}
#if #TARGET(loirevers)
\answer{reversibilit}{\rep;\choix}{type=radio}
#endif

\answer{loi invariante}{\mu}{type=vector}
#if #TARGET(loiinvar)
\matrix{reponse=\reply1}
#elif #TARGET(loirevers)
\matrix{reponse=\reply2}
#endif
\text{verif=wims(record 0 of progverif)}
\matrix{nv=pari(\verif;matstoch(Mat([\reponse]),1,\d))}
\matrix{loi1=pari(v=Mat([\reponse]);P=Mat([\PP]);print(v*P))}
\integer{ver=pari(v=Mat([\reponse]);u=Mat([\loi1]);print(u==v))}
\feedback{\nv[1]=1}{<font color=red> \pb1 </font>}
\feedback{\nv[1]=0 and \nv[2]=1}{<font color=red> \pb2 </font>}
\feedback{\ver=0 and \nv[1]=0 and \nv[2]=0}{<font color=red>Si la loi de \(X_0\) est donne par le vecteur \(v\)=\([\reponse]\), alors la loi de \(X_1\) est dcrite par le vecteur \(v*Q\) = \([\loi1]\). Donc, \(v\) n'est pas une loi de probabilit invariante.</font> }