# Karaoke Lyric Editor - free cross-platform lyrics editor and exporter for Karaoke formats

![Screenshot](https://github.com/gyunaev/karlyriceditor/blob/master/example/screenshots/4.jpeg "Screenshot")

**Karaoke Lyrics Editor** is a program which lets you edit and synchronize lyrics with karaoke songs in various formats. Currently supported formats include LRC, LRCv2 (supported by XBMC) and Ultrastar (without pitch). Export into the CD+G format is supported,
 as well as export into video. Unlike just regular lyrics available everywhere, lyrics suitable for karaoke players need to have timing  marks which tell the player when to show a specific line, and when and how highlight the words. It has many unique features which are missing even in the expensive commercial software.
 
It features full support for non-English languages, support for CDG, LRC and UltraStar specifics, and built-in karaoke testing window.

Unlike most lyrics editors for Linux, it is self-sufficient, and does not depend on KDE or some external players. Karaoke Lyrics Editor  is available for Linux and Windows, and uses the Qt toolkit and FFMpeg libraries.

Karaoke Lyric Editor is licensed under GNU GPL version 3, and is written by George Yunaev.

## Features

- Full internationalization support. The editor has been extensively tested with Russian and Chinese languages, and works with any other language supported by Qt. Besides traditional languages it has been successfully used to create Karaoke songs in Hindu, Thai, Tagalog, Vietnamese and Arabic.
- Exported lyrics are saved in UTF-8 encoding. For imported lyrics the application lets you to choose the text encoding.
- Supports most multimedia formats without depending on external player. The application is built using the FFMpeg library, and is able to play popular music formats, including MP3 and OGG.
- Has extensive built-in help system and detailed online tutorial;
- Supports exporting lyrics in LRC versions 1 and 2, and UltraStar formats;
- Supports the video and image backgrounds which could be changed at specified time. Since the lyrics formats are text-based and do have no support for backgrounds, this is only relevant for CD+G and video export. Remember that CD+G is limited to total 16 colors.
- Supports export into CD+G and AVI video formats;
- Supports importing lyrics from LRC, UltraStar, KaraFun, PowerKaraoke, Del and KOK formats;
- Supports standard text editing features, including unlimited undo;
- Supports adding and removing timing marks when the song is being played using mouse or a shortcut key;
- Supports placeholders the cursor will stop on while inserting timing marks;
- Flexible configuration of cursor movement when timing marks are inserted. The cursor could move to next word or end of line before moving to the next line;
- Provides extensive validator engine which detects most common formatting errors in the lyric file;
- Provides a preview window where the lyrics can be tested. A separate preview window is provided for CD+G and video lyrics.
- Allows editing format-specific tags, and properly exports them.
- Allows real-time testing of your changes in lyrics text or timing, with automatic music rewind a few seconds back just before the edited timestamp.
- Support for real-time testing of your lyric modifications

## Screenshots

![Screenshot](https://github.com/gyunaev/karlyriceditor/blob/master/example/screenshots/1.jpeg "Screenshot")
![Screenshot](https://github.com/gyunaev/karlyriceditor/blob/master/example/screenshots/2.jpeg "Screenshot")
![Screenshot](https://github.com/gyunaev/karlyriceditor/blob/master/example/screenshots/3.jpeg "Screenshot")
![Screenshot](https://github.com/gyunaev/karlyriceditor/blob/master/example/screenshots/5.jpeg "Screenshot")

## Licensing and Registration

This program is free software, and is distributed under GNU General Public License version 3. This means, in particular, that you can use the software, modify and distribute the modifications of the software as long as you abide the terms of the GPL. Please see  the GPL license FAQ for the details.

The software is available to you free of charge, and you are not required to pay anything to use it. However developing the software takes time and costs money. Therefore the software contains the registration component. The goal of the registration is to see how valuable the is the software  for the users. The users’ feedback would have the direct effect on the  speed of bugfixes, new features, and overall development of the software.

If you're willing to register your copy, you can do it here: http://www.ulduzsoft.com/linux/karaoke-lyrics-editor/kleregistration/
