/* ----- core/multsntrup761, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_multsntrup761_checksums[] = {
  "eda43ab4b93ce66fd26d8c0989b0297c8fe1e6984ba9b751f6193d35ef8a7a85",
  "67171a7876696cfda06721697664dad2f14395fdc559520f41f90fce0195ecba",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_multsntrup761_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_multsntrup761_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_multsntrup761_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_multsntrup761_CONSTBYTES

static void *storage_core_multsntrup761_h;
static unsigned char *test_core_multsntrup761_h;
static void *storage_core_multsntrup761_n;
static unsigned char *test_core_multsntrup761_n;
static void *storage_core_multsntrup761_k;
static unsigned char *test_core_multsntrup761_k;
static void *storage_core_multsntrup761_c;
static unsigned char *test_core_multsntrup761_c;
static void *storage_core_multsntrup761_h2;
static unsigned char *test_core_multsntrup761_h2;
static void *storage_core_multsntrup761_n2;
static unsigned char *test_core_multsntrup761_n2;
static void *storage_core_multsntrup761_k2;
static unsigned char *test_core_multsntrup761_k2;
static void *storage_core_multsntrup761_c2;
static unsigned char *test_core_multsntrup761_c2;

#define precomputed_core_multsntrup761_NUM 4

static const unsigned char precomputed_core_multsntrup761_h[precomputed_core_multsntrup761_NUM][crypto_core_OUTPUTBYTES] = {
  {39,255,41,4,112,0,100,5,154,5,217,8,13,3,144,0,213,6,90,6,158,252,32,1,151,251,65,1,8,254,184,247,103,251,194,3,70,249,244,1,70,0,41,7,114,254,203,4,176,253,177,2,86,250,61,8,67,6,189,2,174,5,110,254,63,247,245,4,67,249,7,255,80,247,175,248,220,248,142,0,72,253,68,247,20,8,157,6,253,254,36,4,223,5,210,250,150,8,113,250,68,5,242,7,200,252,89,249,14,3,114,253,123,255,97,253,109,8,77,2,238,251,210,253,104,251,195,5,65,250,173,249,24,247,65,6,189,8,226,6,229,4,231,5,3,248,155,8,158,1,60,248,25,253,192,2,113,255,226,3,34,5,243,254,198,252,152,250,43,5,134,254,88,0,180,2,249,4,55,6,226,247,65,4,242,254,27,0,237,253,241,7,144,254,239,248,113,4,193,8,160,250,250,1,84,254,130,6,18,254,9,252,239,1,11,250,164,251,128,8,44,7,184,6,98,248,72,5,38,1,12,4,195,249,184,255,118,6,208,252,29,254,211,248,175,5,175,251,114,251,94,3,179,255,80,2,140,0,5,253,88,3,154,249,194,3,113,6,54,0,226,8,37,5,131,254,151,6,58,5,170,250,51,252,55,5,116,1,93,1,149,1,143,5,228,252,113,249,109,247,26,8,34,252,137,249,228,253,191,247,48,248,220,250,163,253,32,255,150,255,249,252,197,5,13,253,122,255,203,1,136,5,155,1,181,249,213,255,248,1,172,255,168,3,132,248,250,2,145,250,252,0,36,247,175,5,183,255,154,8,43,2,50,5,51,8,130,253,114,247,249,247,157,3,112,248,110,249,248,249,20,0,111,255,234,2,168,3,82,6,11,4,101,251,24,247,31,251,122,247,110,4,206,0,120,248,215,248,83,1,43,7,223,7,128,8,136,2,26,251,107,3,226,250,119,4,60,248,25,254,142,0,85,5,171,7,77,247,155,5,222,255,30,248,61,0,169,250,213,1,81,253,64,250,237,249,70,1,121,255,157,0,143,1,238,249,253,251,234,7,213,3,57,3,247,8,40,7,240,253,40,8,148,250,115,4,12,8,123,255,220,6,225,3,234,252,31,8,217,8,172,255,3,1,139,251,202,3,199,7,237,0,238,6,72,250,138,248,138,8,54,253,55,255,209,254,115,248,151,7,79,0,41,247,189,253,158,8,1,1,158,250,36,251,179,1,55,6,226,247,121,247,169,253,141,252,139,5,102,255,150,254,240,6,207,250,50,2,252,0,141,254,195,251,64,2,217,6,40,247,80,0,37,250,187,3,119,7,176,248,22,5,37,1,52,8,151,1,127,7,215,3,122,255,229,254,230,8,128,4,0,2,211,5,229,1,60,250,162,5,254,247,187,4,87,254,91,253,131,247,168,254,237,250,205,252,45,0,131,6,227,3,35,247,170,2,95,2,130,255,218,2,121,3,122,255,171,5,172,5,245,253,130,251,221,2,233,3,167,7,59,7,50,7,154,255,24,7,232,2,95,255,159,252,254,5,90,8,74,253,43,8,1,1,42,4,179,2,87,5,42,5,22,6,250,252,142,248,45,8,110,255,213,8,97,249,147,252,119,7,42,5,168,7,244,253,39,247,205,250,218,1,159,255,10,247,115,249,115,249,72,250,178,254,43,2,127,248,198,0,177,247,67,251,2,2,220,252,230,250,102,6,247,8,110,255,176,247,225,8,190,1,204,0,221,250,106,1,22,5,160,248,209,5,172,1,11,6,0,0,207,251,24,6,78,7,231,248,173,2,128,249,52,2,137,248,184,3,35,255,217,6,45,3,205,248,15,4,150,8,145,254,35,248,231,8,213,251,221,4,218,3,34,3,8,250,187,252,243,8,252,3,67,254,19,7,254,4,57,247,85,0,33,0,65,4,51,2,93,252,0,5,42,8,207,253,174,5,125,248,167,247,107,255,76,2,81,251,33,247,179,5,165,252,215,251,213,253,200,5,84,7,207,1,174,251,52,252,32,8,95,255,243,248,55,3,14,2,69,254,78,8,64,248,211,5,160,249,111,255,236,252,64,1,72,2,76,253,112,5,204,248,46,0,252,7,64,249,156,254,117,252,42,5,212,247,139,8,190,247,101,8,20,247,78,8,227,253,125,253,235,2,198,251,198,6,57,0,105,5,150,252,232,249,134,4,1,255,186,7,185,254,64,252,171,7,143,7,152,1,91,253,106,5,229,5,127,1,53,254,97,5,229,8,184,252,206,254,48,254,233,1,147,253,203,3,139,249,197,3,216,7,40,254,162,3,163,249,10,253,110,3,168,0,220,8,33,247,179,3,185,255,185,254,24,0,61,4,136,252,195,1,197,251,129,0,9,247,75,255,137,252,181,250,15,5,174,255,248,251,30,249,116,251,118,5,204,2,238,7,237,255,93,7,218,4,183,1,57,251,222,253,226,250,246,250,128,249,227,247,37,247,162,248,145,251,26,250,77,5,162,0,135,254,83,0,55,0,116,250,22,0,20,7,104,248,121,249,222,247,152,8,103,4,207,6,244,2,202,0,7,250,96,255,145,1,30,254,177,7,217,7,69,7,91,255,104,254,240,248,122,0,129,250,132,251,208,5,93,8,128,3,208,3,201,3,174,247,30,6,102,252,162,251,161,7,122,2,134,250,106,248,91,250,227,251,190,255,76,250,221,249,189,247,235,248,90,252,179,252,217,5,62,7,109,6,227,250,230,247,130,247,133,8,236,255,77,2,239,252,182,255,81,250,26,2,209,248,172,4,184,252,114,251,127,1,220,255,177,249,247,251,229,253,110,254,113,254,168,248,41,4,59,252,179,6,228,247,93,7,30,247,208,248,236,253,168,4,101,0,234,3,222,0,133,253,112,252,39,254,222,0,242,8,76,8,153,251,115,4,206,247,68,2,231,254,195,247,239,8,108,4,158,251,59,249,194,5,111,8,245,253,134,6,1,255,154,254,10,248,228,254,113,2,241,3,28,247,253,2,102,251,82,255,74,1,88,252,219,255,95,249,154,251,126,250,208,0,154,4,223,248,33,5,189,249,204,255,1,252,12,6,41,250,206,3,78,255,88,2,183,249,40,4,137,4,99,1,210,3,185,7,68,253,162,248,7,254,230,6,145,249,75,252,182,4,244,252,234,254,19,1,115,252,67,6,230,251,137,252,130,248,221,252,251,252,75,250,151,2,205,250,171,249,208,247,68,4,18,4,11,254,37,7,226,1,204,255,231,2,31,253,39,3,219,2,85,250,114,252,194,251,106,6,1,0,147,4,44,4,193,6,140,255,10,255,141,7,181,254,234,252,196,253,59,2,254,254,200,255,209,248,201,251,151,2,101,251,148,1,225,7,115,253,129,2,64,7,176,3,173,5,183,4,32,254,74,6,248,4,144,251},
  {247,6,235,0,165,253,69,1,62,6,163,249,81,4,56,252,73,1,68,248,135,6,29,6,23,7,146,247,225,2,120,250,74,253,222,4,58,249,200,3,40,1,62,7,115,248,172,250,229,249,155,251,96,250,54,7,241,4,24,250,252,6,17,255,43,8,221,6,20,1,71,255,19,249,134,5,88,255,92,0,102,5,90,6,178,3,128,254,204,0,6,254,74,249,94,2,29,247,33,0,13,251,216,253,111,6,247,2,89,251,138,254,20,251,198,6,142,6,5,2,164,251,49,3,1,2,193,250,5,254,181,7,54,250,124,6,41,2,136,3,200,5,100,255,132,3,53,1,157,2,220,5,1,4,69,255,55,4,15,2,34,252,124,5,45,8,16,7,252,0,252,1,87,251,254,2,77,3,58,7,227,249,7,5,72,249,17,3,75,252,87,249,253,2,23,251,5,249,143,1,45,4,164,4,215,4,33,254,119,2,122,251,86,248,163,251,236,248,183,1,2,252,148,252,255,1,236,2,176,249,34,247,133,249,142,6,70,4,248,248,89,247,20,255,21,8,203,1,156,5,14,252,56,0,58,7,153,250,167,252,131,3,49,5,169,0,165,0,181,249,63,249,20,0,212,251,153,252,142,7,33,6,222,5,174,7,206,3,53,3,17,250,38,2,213,255,45,254,215,6,10,6,203,255,65,248,52,1,176,1,123,7,81,250,201,254,202,8,122,249,47,253,10,254,14,1,121,2,155,255,122,253,245,3,117,4,189,251,36,5,19,6,200,255,213,252,92,253,176,8,125,251,65,253,185,254,233,4,254,250,235,2,184,252,164,3,87,251,79,4,75,5,77,247,251,250,210,2,162,6,61,254,97,247,250,0,217,251,172,4,195,3,149,1,2,249,176,8,177,6,49,254,61,8,132,4,195,248,20,252,165,252,184,252,45,253,15,251,117,254,215,5,196,0,48,254,134,6,118,253,232,251,121,250,52,7,84,8,150,250,140,7,51,4,148,254,222,248,146,249,74,255,254,5,160,254,254,250,140,254,92,1,163,249,170,5,78,247,7,3,186,250,59,254,216,6,185,5,209,2,237,1,125,7,209,3,150,4,186,7,242,254,78,247,100,250,213,251,136,249,94,248,11,5,137,248,29,4,49,251,28,252,34,252,215,4,251,251,4,249,235,248,108,3,58,5,233,251,104,3,137,0,183,253,75,247,17,249,220,1,44,7,147,251,120,255,198,0,23,247,90,2,197,255,223,254,136,3,124,2,184,249,127,250,90,1,118,252,23,5,119,8,172,4,149,8,197,255,155,254,182,251,74,7,64,5,178,8,233,5,168,4,157,1,131,0,157,252,207,2,155,3,87,5,41,3,88,5,226,7,40,8,186,7,30,1,189,8,101,7,222,6,119,1,249,255,67,2,91,251,113,3,108,255,251,251,218,0,174,0,187,250,19,250,177,5,122,248,15,6,43,8,145,255,195,5,39,253,246,3,240,252,111,8,227,252,95,8,98,252,65,251,150,3,140,8,203,2,0,255,125,254,57,248,39,247,187,8,107,3,243,250,194,1,23,1,61,253,168,248,51,2,152,253,184,4,61,250,60,0,182,252,105,2,34,247,68,249,167,4,220,6,230,254,137,250,35,252,56,248,45,6,180,6,135,6,229,6,118,3,178,2,233,2,113,5,80,5,140,247,220,6,156,247,5,8,180,0,169,247,184,255,18,4,143,255,28,253,32,4,6,8,208,5,61,253,134,3,122,251,213,254,194,3,118,6,213,8,78,4,3,3,119,253,192,7,72,3,16,7,182,252,102,2,118,8,5,6,147,8,22,248,13,253,74,1,89,254,204,249,163,255,175,251,201,2,31,247,233,7,139,5,20,253,216,248,153,254,64,253,104,4,52,250,63,5,199,252,98,250,157,5,202,5,67,253,119,2,4,3,170,254,215,3,104,252,217,1,183,3,99,248,205,3,180,255,32,252,41,252,55,1,118,0,212,2,199,251,50,252,5,5,162,254,180,250,162,0,100,1,196,7,61,7,103,8,168,5,204,252,24,2,170,251,16,247,134,248,221,253,22,255,222,252,9,254,196,250,168,248,62,253,177,3,15,6,153,1,210,251,64,248,230,252,223,250,175,247,32,7,168,249,99,8,31,1,181,253,251,248,226,5,82,250,182,247,171,248,144,251,132,253,52,247,129,2,236,2,125,0,225,6,163,8,74,247,72,255,199,254,233,250,230,4,180,251,60,1,139,7,85,5,79,3,114,7,149,254,147,1,180,8,228,252,60,250,115,250,7,252,43,249,175,7,128,250,44,1,128,254,23,253,202,7,176,254,189,8,206,7,110,2,249,3,142,250,12,0,169,248,33,2,232,7,68,251,190,248,179,249,151,1,163,2,223,8,170,3,178,7,225,252,214,249,36,248,82,250,92,251,32,255,115,1,2,4,61,5,140,8,87,255,186,254,96,4,138,6,37,1,13,252,63,253,76,248,233,248,239,2,145,5,156,4,75,0,26,4,155,7,161,3,138,6,10,7,15,253,121,255,127,2,172,3,192,248,10,5,95,248,157,252,63,5,223,255,191,248,244,254,219,247,202,248,245,248,197,253,105,3,11,255,43,7,12,247,103,249,127,253,96,8,36,249,116,249,51,4,109,5,48,248,115,3,54,250,207,4,93,251,206,248,76,247,103,8,171,254,231,247,9,8,139,253,174,8,76,4,161,253,190,6,181,255,30,7,25,0,136,249,12,252,245,254,215,248,190,7,18,1,8,0,184,1,252,7,136,250,186,255,232,254,62,248,94,8,73,8,102,252,250,251,228,2,220,6,69,252,232,0,99,6,40,3,10,252,146,250,124,3,119,4,243,247,7,5,146,7,213,4,134,7,105,3,225,0,30,8,157,7,144,2,4,1,194,7,206,247,133,7,84,253,198,248,251,1,237,250,254,0,115,247,177,3,129,250,180,0,46,6,249,7,172,6,96,253,33,0,177,8,190,4,152,252,75,255,159,247,8,7,16,3,145,254,255,6,133,6,80,251,230,252,156,255,248,4,230,2,163,251,32,253,204,7,112,252,184,249,242,255,161,253,191,7,198,254,176,4,170,5,65,2,24,8,41,251,151,8,203,253,104,247,17,247,255,250,161,8,252,5,49,248,3,3,26,248,8,250,101,255,238,250,180,7,24,253,82,2,215,0,98,0,17,252,232,251,24,250,18,1,1,253,239,4,203,3,107,251,218,253,2,252,9,249,31,253,215,7,248,5,5,251,247,255,161,5,169,252,14,250,176,250,99,5,10,250,66,249,186,254,211,253,190,6,16,255,28,6,159,7,26,3,142,247,248,4,192,252,165,248,6,255,96,254,222,5,233,0,201,5,94,248,131,7,4,250,251,3,142,6,44,254,162,8,93,0,189,1,48,251,54,247},
  {233,247,146,249,54,2,134,249,160,1,57,3,81,2,120,248,25,2,72,254,50,248,204,6,127,5,197,4,116,249,38,254,117,254,138,252,114,1,84,4,207,2,253,250,50,249,247,247,87,252,56,3,158,252,221,248,171,249,140,1,45,3,236,249,185,8,248,4,124,253,175,248,65,252,215,248,197,8,82,5,129,252,177,248,10,6,91,255,22,255,190,4,203,6,49,1,175,7,85,4,149,6,125,253,124,4,12,1,194,252,142,253,44,250,198,255,31,252,6,0,99,8,206,252,219,250,51,254,137,8,118,249,99,251,178,252,89,2,247,252,115,247,78,7,197,252,62,8,73,254,68,7,112,247,251,254,223,3,14,0,223,0,54,253,64,253,149,1,211,4,173,254,10,250,123,255,194,6,114,249,224,2,118,1,149,6,210,7,121,4,107,7,89,254,183,5,5,8,26,4,16,5,81,251,237,249,7,250,51,1,11,255,195,253,11,2,131,2,7,0,107,255,56,8,151,252,190,2,141,254,212,7,152,254,70,253,121,4,202,247,251,247,47,1,205,252,188,252,202,6,135,8,172,247,109,250,59,250,232,252,152,249,102,4,109,247,226,1,49,250,209,248,78,5,97,253,235,252,220,247,15,251,164,248,66,250,244,6,164,6,73,249,241,252,220,255,5,8,235,247,156,6,190,254,128,252,67,252,43,1,139,8,236,5,175,253,152,0,167,250,232,251,35,250,221,3,242,251,238,1,144,0,62,250,7,1,63,251,94,249,213,7,76,252,133,247,154,248,107,249,157,253,60,6,193,4,138,250,21,4,39,253,185,0,234,248,13,254,34,0,194,253,43,6,95,248,168,1,178,2,108,3,5,1,206,247,173,253,184,7,110,250,139,3,23,1,64,251,140,254,19,251,199,6,221,2,144,4,82,248,200,1,200,7,98,250,125,250,91,0,127,250,147,0,210,249,152,255,54,254,217,8,183,247,120,248,40,8,170,0,64,247,163,7,106,247,80,2,207,6,12,249,22,247,149,2,204,250,33,251,173,247,111,1,202,253,169,248,88,5,213,2,8,6,205,1,176,2,145,254,210,250,183,253,30,248,20,249,44,249,153,248,111,3,88,2,5,248,5,252,152,252,183,247,80,5,237,248,211,1,97,252,30,6,66,247,219,252,53,7,148,252,149,248,102,6,162,4,100,248,99,249,73,249,250,254,11,254,17,253,24,4,85,4,224,5,230,0,161,254,68,8,103,2,32,4,217,249,74,4,0,5,79,253,105,2,113,5,219,250,45,253,90,2,123,249,85,250,50,248,96,3,218,252,129,253,211,4,68,7,172,2,76,250,203,247,238,5,72,2,204,253,67,1,156,249,31,254,161,250,113,7,61,7,139,0,71,252,39,2,164,4,194,251,73,248,254,3,65,254,86,2,181,6,4,7,43,249,17,248,190,7,91,251,250,255,73,247,183,1,54,252,251,254,64,5,99,247,9,4,77,251,130,1,101,1,130,7,69,249,8,254,206,5,86,6,253,4,119,248,80,247,71,247,229,6,155,8,229,4,187,252,173,254,128,247,216,252,17,3,87,4,24,248,17,7,202,8,36,253,10,6,173,250,254,5,125,3,11,7,206,247,82,253,75,250,128,0,60,8,129,3,232,7,199,252,39,4,74,3,42,254,91,4,97,7,122,5,248,250,253,252,229,250,102,248,117,251,212,255,77,4,144,2,82,2,47,252,249,6,73,254,53,7,180,252,80,249,189,248,84,249,142,4,192,248,32,1,69,3,148,251,182,5,66,3,152,251,36,1,229,248,1,250,164,255,39,0,4,1,36,255,10,249,231,247,194,248,41,8,71,8,37,251,147,251,131,248,190,5,41,1,229,4,166,247,61,8,82,248,139,247,36,254,198,5,160,8,190,8,225,249,176,248,222,252,64,7,84,253,179,2,23,2,73,0,45,253,100,1,159,249,223,5,38,5,192,250,211,1,70,1,207,6,141,250,217,252,22,2,54,251,146,251,199,250,39,252,97,249,0,1,69,0,144,250,176,0,213,253,108,248,92,3,21,252,207,6,141,2,10,5,4,2,8,2,102,252,95,7,72,1,165,253,153,2,239,254,32,1,180,250,65,249,79,8,143,247,96,250,190,4,16,5,101,255,181,4,211,254,242,2,54,250,126,255,178,252,126,248,153,6,236,7,212,8,192,6,143,253,150,4,8,3,203,0,35,5,15,1,122,250,38,0,132,255,89,247,29,250,126,3,98,6,67,3,37,247,156,0,139,1,196,2,30,255,133,0,89,253,120,253,108,0,65,251,14,8,72,254,99,7,135,5,226,251,132,6,167,247,118,254,101,255,134,252,190,3,130,255,210,0,160,2,229,251,177,6,113,255,98,253,76,250,181,247,164,1,122,254,81,8,51,253,37,250,98,7,198,249,100,250,150,250,215,254,181,252,129,253,51,255,111,254,239,6,58,8,248,2,158,248,78,251,203,6,216,255,212,2,226,6,16,1,26,6,42,4,165,1,122,7,59,253,131,251,243,253,167,248,7,3,37,0,162,253,183,253,191,0,51,255,58,254,181,0,196,248,186,250,157,7,227,7,110,5,14,0,105,247,129,3,66,3,0,255,85,255,189,2,48,252,187,1,191,7,2,2,13,249,219,1,211,254,83,255,59,7,42,254,32,253,237,3,163,4,208,4,194,0,109,4,52,4,236,255,69,1,182,8,239,4,112,1,59,254,8,255,93,249,183,0,233,251,24,251,47,5,225,3,58,255,219,252,214,8,59,8,253,4,77,255,131,251,128,6,136,1,110,8,126,248,43,252,14,249,17,3,165,248,250,1,134,0,215,8,206,253,180,249,105,255,211,8,254,248,221,255,171,252,197,249,209,5,247,3,10,249,104,0,38,4,147,5,185,3,251,247,125,0,78,254,52,3,225,0,234,0,133,2,116,248,122,252,219,247,137,249,21,7,179,248,210,254,75,252,184,0,113,7,150,7,107,8,27,255,150,2,96,249,169,1,90,255,178,5,0,1,210,247,58,249,235,5,3,0,160,8,223,251,98,0,152,6,75,249,200,253,152,1,208,254,212,5,15,253,206,255,5,1,248,1,164,0,247,6,212,254,8,8,197,250,63,247,207,8,177,8,75,3,181,3,130,247,233,254,64,4,183,6,107,248,173,6,173,250,69,2,117,248,82,255,136,1,107,4,228,254,225,2,10,6,132,7,72,3,239,0,199,1,232,252,92,5,28,251,182,253,196,1,139,255,225,7,31,247,127,249,53,3,73,4,174,3,100,249,84,249,246,253,98,7,91,2,22,1,235,2,119,250,185,4,196,4,50,247,26,0,14,3,117,248,229,249,95,251,143,247,65,249,45,3,96,2,244,254,107,250,187,251,28,253,136,254,149,0,132,1,233,254,19,3},
  {112,250,7,252,38,253,0,4,103,6,55,2,68,251,89,8,220,1,213,253,13,254,63,253,71,1,3,250,25,1,10,3,47,2,64,255,47,250,207,6,129,247,62,4,246,254,81,247,105,7,181,6,197,254,108,248,111,249,15,6,92,5,148,4,54,0,187,7,136,4,32,253,66,6,239,8,226,5,194,1,186,7,100,249,103,247,32,248,115,4,232,1,105,4,156,5,134,250,209,253,228,247,220,247,162,250,87,6,126,248,29,249,162,6,144,253,61,0,28,4,205,5,140,5,17,7,240,252,211,248,231,7,236,253,105,5,215,248,145,253,63,249,196,255,98,254,129,3,162,1,11,0,81,250,207,7,37,7,100,3,47,248,17,6,116,247,225,2,225,0,142,254,23,251,176,253,236,249,227,1,7,249,147,1,106,253,93,2,89,249,54,1,151,1,0,252,150,249,5,4,53,249,123,0,214,2,61,7,59,254,233,254,170,250,31,254,184,0,245,250,137,8,251,250,43,7,75,247,126,247,175,255,21,6,147,249,226,2,233,247,5,2,129,3,92,3,36,7,112,6,122,250,22,4,37,253,153,247,159,5,160,4,10,5,3,251,56,255,12,255,125,254,118,3,215,0,129,6,87,249,52,3,39,7,112,3,146,3,83,250,194,3,166,247,198,253,42,7,82,255,113,0,113,3,3,8,24,250,233,255,42,3,127,254,135,8,215,1,243,6,73,7,33,255,79,247,144,2,222,8,216,5,90,8,112,247,116,253,134,5,186,4,26,247,116,250,163,252,78,5,60,247,10,248,136,3,82,1,238,6,24,253,10,5,116,8,169,250,136,248,82,247,172,255,120,2,22,250,47,249,219,254,135,8,34,6,11,1,132,250,41,8,9,255,94,2,243,0,158,1,163,251,184,3,227,249,229,0,110,248,255,252,239,253,232,250,145,0,108,8,216,2,92,2,119,0,48,2,126,247,240,0,17,251,143,7,195,4,43,252,55,3,29,7,33,6,245,255,12,7,240,6,35,248,201,251,213,1,55,6,138,7,185,254,103,251,189,253,17,6,108,253,101,0,97,7,65,4,69,252,62,254,26,248,210,253,237,6,206,5,132,4,126,253,125,0,27,253,49,250,119,253,237,2,203,248,41,252,0,2,97,252,207,3,240,2,76,8,76,3,211,253,84,4,205,249,154,247,50,252,14,254,113,253,174,7,152,1,172,2,170,8,131,247,0,249,89,247,157,7,146,7,97,8,243,8,34,7,237,255,255,3,182,2,74,253,233,5,177,247,204,253,122,251,1,248,43,253,25,5,100,247,184,8,217,6,219,253,64,247,38,4,125,255,184,8,42,253,55,249,196,7,37,4,225,4,113,249,179,2,124,1,139,7,208,255,232,1,84,6,232,254,182,8,153,3,16,251,120,0,128,6,2,249,13,249,178,247,227,3,65,253,22,255,24,2,208,253,134,251,86,250,171,0,173,250,102,6,162,252,149,248,214,249,139,252,13,1,239,254,88,7,15,247,146,252,207,7,172,0,5,254,174,6,176,252,216,253,30,254,212,6,164,248,209,249,151,5,54,253,114,6,157,8,136,247,142,5,201,7,64,248,113,3,41,252,107,248,219,254,187,2,20,6,78,7,207,8,85,251,28,255,112,6,199,251,226,8,97,8,34,254,249,2,167,4,25,6,9,7,130,4,126,254,187,1,121,255,49,8,18,6,18,248,179,254,161,6,135,252,238,255,111,1,180,248,110,249,214,253,84,250,204,3,101,3,112,247,255,4,241,5,16,252,210,7,7,249,94,7,224,251,98,250,95,255,150,8,119,3,191,248,44,1,71,3,250,255,217,5,236,8,215,247,83,2,156,251,132,0,69,254,124,4,31,5,149,247,226,251,183,252,153,7,58,8,193,250,177,255,201,8,136,0,29,249,54,0,41,255,84,254,196,250,167,249,76,253,156,251,192,0,85,255,248,2,40,250,101,247,83,249,50,254,222,253,157,249,17,248,184,6,71,7,94,249,126,251,138,251,163,0,50,252,12,5,97,252,118,248,163,4,18,255,228,3,54,5,116,248,119,0,105,3,79,6,24,249,192,1,105,250,226,249,18,252,161,8,50,249,44,254,68,1,95,248,35,254,193,247,44,1,203,0,73,250,237,248,138,7,128,8,115,253,245,1,111,247,248,6,222,255,8,6,124,252,192,251,136,249,134,255,193,252,30,247,39,247,217,253,125,2,200,0,238,250,66,0,42,253,245,1,129,2,60,5,37,2,82,251,100,2,91,4,140,253,59,248,24,2,138,249,195,1,62,7,112,251,120,251,130,7,106,247,144,253,21,0,89,252,129,8,133,3,133,1,30,1,162,249,140,0,139,255,78,0,106,4,22,254,161,251,174,0,39,3,175,255,242,8,147,0,40,250,32,0,183,0,46,249,29,1,74,1,4,6,82,2,121,251,154,4,73,249,234,253,195,2,112,7,83,248,11,249,152,248,146,0,20,1,38,7,15,252,208,2,197,248,104,248,19,255,150,0,159,7,203,5,117,251,78,255,17,0,129,248,131,255,101,247,208,251,60,3,58,6,143,4,217,249,158,7,207,251,105,252,98,250,0,6,113,5,143,8,112,4,9,253,74,7,208,8,11,6,205,255,53,251,71,251,170,6,198,3,18,248,93,7,7,255,176,3,85,248,20,5,129,7,198,3,107,4,238,249,160,254,185,2,250,255,2,6,20,5,214,250,172,247,170,251,250,255,175,4,58,252,150,6,217,8,39,255,94,251,252,7,94,6,122,5,235,5,75,253,195,252,89,252,91,251,108,7,104,3,201,254,139,254,168,247,76,0,7,8,249,250,31,251,59,4,193,253,190,250,72,253,183,5,53,253,74,248,72,4,75,1,17,0,163,7,55,3,25,4,167,4,197,7,132,254,166,6,195,1,174,251,219,6,228,8,223,247,230,247,202,8,61,0,214,252,140,252,245,250,100,251,145,250,133,1,87,2,157,248,216,248,188,6,99,253,155,8,136,254,135,248,41,252,7,248,182,0,63,6,206,251,7,252,246,250,103,248,3,252,143,1,88,248,70,253,191,4,22,3,164,7,177,252,105,247,196,253,80,255,124,252,200,3,17,255,135,249,144,254,82,249,100,250,14,249,108,252,150,254,106,2,0,3,166,6,148,5,99,251,159,251,159,249,151,1,52,249,28,5,246,252,38,255,62,253,140,247,147,250,59,249,3,3,164,255,211,252,212,251,64,247,67,249,188,2,205,255,64,250,240,7,254,5,172,1,227,1,54,7,149,2,194,250,44,250,32,250,164,249,203,7,121,251,172,248,14,248,78,255,53,255,46,251,82,254,87,8,171,249,244,5,14,255,30,247,134,5,42,249,94,249,50,6,160,248,178,250,23,252,83,3,203,2,86,247,74,3},
} ;

static const unsigned char precomputed_core_multsntrup761_n[precomputed_core_multsntrup761_NUM][crypto_core_INPUTBYTES] = {
  {190,5,129,98,184,113,94,149,6,210,100,68,17,218,206,100,208,165,98,21,242,221,197,137,57,118,2,73,199,238,251,240,133,36,0,208,26,12,255,65,44,176,230,170,49,169,87,164,77,201,165,17,79,226,182,11,163,121,39,1,173,107,178,101,119,198,23,180,145,226,97,189,207,94,141,145,190,43,23,165,212,17,22,103,25,119,120,73,75,81,133,25,220,134,193,194,100,102,148,188,112,50,244,200,99,48,192,163,20,89,147,76,9,45,110,29,7,102,245,117,254,155,181,80,24,17,44,161,178,9,73,243,243,88,231,136,72,225,131,126,158,42,107,23,164,254,9,33,181,255,4,95,22,17,101,200,93,4,110,88,127,6,125,101,166,246,127,34,107,29,219,189,6,167,50,59,222,125,188,210,180,120,167,214,193,194,236,138,111,151,201,88,20,48,82,127,121,108,160,195,186,17,97,60,56,165,42,98,26,100,239,89,25,20,196,217,171,85,175,95,168,135,120,180,205,77,42,18,234,120,35,52,234,39,130,141,73,47,242,25,206,9,138,155,89,40,243,124,170,193,148,227,24,198,63,62,234,116,101,192,153,116,81,18,32,210,71,74,185,177,184,174,66,211,165,164,82,205,68,238,91,30,68,8,22,240,98,27,119,198,192,25,210,106,46,159,217,55,13,61,70,214,177,197,156,118,152,74,106,1,186,245,15,157,26,234,167,121,142,156,106,113,117,119,241,102,67,195,11,157,160,86,7,203,59,30,145,2,169,139,107,31,59,85,4,243,106,114,145,20,167,97,174,179,177,0,193,17,59,249,13,204,95,39,151,166,135,128,175,59,237,134,60,56,19,15,176,166,208,191,99,3,84,173,73,92,15,72,219,198,11,99,94,187,87,69,123,253,17,183,183,146,13,8,234,146,227,146,13,238,16,180,122,107,49,86,227,23,34,108,142,12,252,164,40,63,116,234,75,20,35,28,230,176,153,213,19,221,214,233,1,159,146,67,103,19,26,211,12,241,178,176,99,121,59,108,207,140,180,55,4,127,93,146,245,144,137,170,41,120,251,21,27,168,139,200,150,16,30,212,246,55,143,91,21,16,176,146,236,20,222,8,187,139,252,54,110,96,196,166,50,195,37,84,61,94,230,17,194,96,229,19,240,157,112,234,193,169,41,228,159,232,231,182,195,32,102,209,27,37,100,191,26,239,188,82,255,60,139,150,248,10,233,35,234,146,75,110,1,81,209,23,195,60,71,116,117,209,215,233,121,190,162,90,65,242,29,175,222,9,48,60,112,102,244,228,218,213,102,113,80,17,130,16,93,79,11,2,131,213,169,92,84,149,147,250,14,252,10,88,186,109,115,71,54,53,203,142,233,77,10,172,217,60,80,190,152,165,238,100,183,245,156,213,19,104,221,150,45,225,173,96,103,148,176,113,133,142,185,141,192,167,173,213,5,52,19,137,227,126,4,138,123,69,252,99,207,28,54,35,252,154,226,6,255,9,191,178,196,175,59,186,245,162,125,214,129,244,33,153,83,111,149,20,43,137,111,197,200,122,186,146,104,130,95,149,9,84,114,159,220,147,178,30,245,38,223,159,76,229,152,7,57,47,155,204,207,21,156,81,162,25,79,209,44,132,54,253,141,188,141,200,26,58,36,87,52,177,255,172,166,145,149,73,148,132,53,190,19,96,137,109,184,198,220,58,56,165,174,152,167,68,48,147,212,181,56,38,166,6,214,95,34,58,98,148,167,151,107,22,57,111,62,240,244,215,226,3,227,3,161,207,66,161,183,53,4,194,15,156,138,15,159,97,112,184,148,242,158,180,89,114,104,166,89,151,127,254,234,3,113,20,216,83,250,66,131,159,115,144,237,189,249,15,71,16,59,118,237,104,229,52,239,47,223,149,69,129,150,240,189,111,117,176,118,165,176,171,93,217,179,14,133,36,37,219,79,186,121,108,5,185,143,159,204,4,7,30,5,212,26,236,113,163,173,87,73,148,64,140,119,24,219,57,42,203,218,183,110,212,177,67,201,197,8,29,200,62,248,47,41,206,246,210,23,223,23,8,109,181,27,48,232,50,227,146,8,195,14,170,236,142,144,19,127,23,146,128,2,160,227,43,183,174,56,239,84,45,143,127,18,179,1,45,81,56,213,23,128,148,241,139,99,183,221,19,122,60,155,201,118,163,32,208,240,248,139,73,76,154,213,186,115,176,163,16,164,220,60,193,54,181,150,68,161,125,240,109,232,41,171,106,173,67,153,182,5,218,226,13,106,189,169,16,189,228,253,15,200,1,246,15,154,79,198,222,137,68,98,142,246,240,140,76,115,245,47,12,46,36,152,96,3,7,74,12,222,197,174,17,142,193,186,69,97,186,157,25,199,211,42,60,188,11,173,69,66,206,69,178,243,177,211,88,148,2,104,174,131,247,209,100,212,250,175,18,27,45,87,168,161,122,168,79,90,45,5,151,88,91,105,56,145,171,67,165,59,96,249,200,81,8,71,138,37,51,216,232,22,35,249,208,238,199,204,15,155,189,72,85,73,212,79,53,97,173,67,1,62,78,167,77,61,67,164,48,40,103,197,81,28,126,80,115,241,89,194,64,178,135,29,69,158,243,253,129,45,224,178,242,23,43,87,25,199,240,28,54,75,214,248,32,161,134,204,133,149,72,74,218,225,73,216,55,171,96,86,237,13,164,250,27,119,143,80,28,73,186,254,43,56,14,157,150,41,196,126,171,103,198,176,254,42,196,93,75,241,84,117,254,172,165,49,192,96,42,22,19,127,65,13,230,23,201,240,98,156,76,244,44,93,12,249,96,253,89,142,255,190,141,167,13,138,77,164,73,135,140,215,245,55,12,2,167,141,152,91,163,21,246,213,105,128,40,159,181,88,6,227,116,61,43,141,5,55,225,60,185,31,154,27,55,169,110,86,192,116,112,133,40,23,174,88,69,6,11,231,71,64,130,51,69,40,188,40,198,127,67,114,218,86,65,41,248,234,185,11,208,80,39,45,106,247,66,177,122,7,152,125,223,95,224,90,177,195,122,60,95,37,224,220,203,154,63,105,216,168,229,116,106,115,201,254,32,87,48,210,124,24,244,86,61,21,28,136,228,112,74,72,81,135,12,52,67,32,255,28,199,142,211,217,227,208,33,94,151,164,80,210,200,162,207,187,178,150,176,11,146,76,149,104,104,1,115,115,229,24,136,4,151,44,166,65,250,73,236,22,182,157,3,82,224,160,222,18,52,117,222,67,195,242,181,198,112,209,218,107,86,156,16,195,128,199,133,205,224,79,234,186,54,126,196,3,154,82,226,55,139,47,179,84,102,245,178,244,66,48,195,146,176,107,64,148,234,180,173,124,194,211,120,219,168,128,30,11,215,15,36,231,181,132,193,181,159,103,123,241,124,188,122,6,248},
  {122,255,172,82,113,55,178,5,218,48,206,92,253,95,240,120,28,178,156,74,153,130,201,2,241,227,92,215,102,151,4,80,159,152,0,176,109,134,116,22,48,70,131,145,122,182,104,128,150,199,220,98,110,125,163,192,92,68,30,214,163,88,241,19,182,166,245,193,124,175,197,238,78,8,19,179,239,74,216,124,55,253,205,54,154,230,165,219,139,62,148,36,199,20,253,250,116,130,243,237,188,216,62,12,90,135,200,47,142,229,86,38,205,86,230,173,241,25,192,39,79,231,43,91,143,138,166,132,34,217,26,48,98,68,112,55,179,68,119,248,196,86,38,42,161,217,77,188,197,73,114,53,66,19,229,187,47,54,167,75,102,228,151,198,116,134,58,58,136,38,63,45,233,83,101,143,40,94,2,62,50,219,75,34,200,209,116,112,77,17,178,61,180,48,176,134,199,105,249,20,57,172,230,251,123,21,173,110,250,163,86,45,183,214,57,138,162,39,62,177,157,215,53,101,134,136,45,167,230,142,229,165,178,156,123,7,207,68,90,239,155,67,247,12,232,72,101,244,79,26,146,1,15,49,99,79,234,124,44,40,159,78,214,116,203,8,138,227,201,16,194,243,114,175,20,218,19,140,8,245,151,240,202,59,224,140,121,79,35,82,23,188,191,162,55,255,72,156,17,101,67,122,144,183,253,188,47,122,224,213,46,96,230,152,15,196,121,10,240,199,77,219,8,21,13,69,169,133,51,41,224,205,83,7,236,125,41,65,110,206,133,182,82,254,37,247,94,236,160,50,154,245,215,160,35,5,72,93,21,150,139,107,247,146,78,18,57,101,17,141,163,128,110,9,47,0,136,29,232,188,68,16,21,188,28,93,39,164,58,210,252,49,69,70,209,195,86,241,235,74,114,104,3,180,200,210,86,7,234,204,147,193,163,197,152,181,22,209,207,246,18,168,70,234,99,230,56,17,44,137,66,42,67,220,54,6,38,203,174,31,33,173,87,70,30,57,59,221,140,168,198,189,144,242,99,123,181,166,234,123,26,97,135,66,216,61,91,119,182,96,57,187,154,17,2,170,163,18,228,26,191,167,18,148,240,187,164,26,255,173,244,197,51,166,87,193,220,34,79,111,107,214,211,133,251,10,48,12,192,116,160,204,222,202,236,244,150,125,151,162,142,154,190,5,80,21,141,69,176,28,138,132,100,37,111,45,122,175,222,25,246,241,139,169,110,92,247,190,108,11,153,89,70,82,83,169,203,66,154,167,54,143,113,115,19,40,27,145,161,94,167,54,76,159,249,252,93,50,4,64,35,73,149,33,101,246,99,115,22,41,190,47,80,143,119,165,87,179,20,88,15,75,220,210,219,216,252,169,192,46,6,84,13,43,138,67,52,222,49,12,168,29,99,207,107,9,246,55,98,133,113,151,217,21,190,240,92,179,128,143,199,168,255,113,0,202,2,178,161,62,31,101,120,101,193,149,147,31,133,140,254,140,208,80,81,203,75,96,92,237,93,202,85,222,233,54,199,121,26,96,155,19,170,173,134,146,70,61,167,142,99,199,62,122,68,196,209,52,191,139,147,154,49,73,91,60,165,166,251,21,230,161,200,207,19,19,82,115,160,245,234,164,1,132,105,145,219,242,8,87,230,129,85,83,3,159,32,237,241,79,131,9,199,210,119,74,233,183,168,52,65,90,66,198,120,196,162,107,125,122,219,84,165,248,218,246,249,40,168,81,95,198,81,222,109,3,49,176,248,223,76,169,40,65,43,234,26,21,146,242,56,25,4,7,153,241,223,15,250,40,3,238,228,119,41,1,81,237,224,67,16,76,205,241,225,176,250,250,113,252,54,50,108,64,117,201,80,107,10,32,9,227,179,59,74,249,238,224,220,182,122,194,84,236,86,43,85,43,160,94,107,14,124,42,194,163,63,248,139,156,171,127,85,10,126,64,144,241,4,155,82,27,116,209,212,169,42,5,4,66,25,150,173,115,8,226,2,94,62,169,227,3,0,4,85,215,199,165,14,207,238,0,89,170,202,167,135,246,31,86,18,193,86,199,184,232,103,64,223,204,90,99,109,200,119,69,176,214,11,7,32,35,119,27,190,236,209,39,78,161,28,12,147,57,142,135,73,62,187,120,90,36,243,198,95,16,83,146,62,62,121,145,111,254,155,53,18,142,123,156,178,162,194,51,133,185,206,114,33,239,35,122,123,49,36,20,73,117,50,237,235,79,73,159,180,65,150,238,133,101,228,61,220,68,33,103,160,94,204,79,14,227,59,95,34,22,153,190,185,18,23,178,92,150,206,181,102,0,174,53,214,178,168,196,8,205,172,205,87,5,240,29,3,147,24,173,211,93,26,134,106,200,154,115,49,185,205,30,189,24,72,174,250,71,19,196,125,63,207,134,17,87,230,188,87,99,99,67,216,161,97,45,13,226,161,148,162,15,14,198,32,213,5,106,205,254,59,150,244,124,145,116,85,125,159,65,35,182,30,126,61,101,115,27,97,160,89,59,15,137,204,11,28,79,26,5,157,117,131,237,242,67,99,206,108,139,99,115,235,54,200,168,160,136,59,66,85,32,249,192,209,83,138,39,225,225,118,44,9,169,27,92,224,156,73,139,250,134,88,20,226,195,45,141,190,8,233,176,192,144,62,111,217,158,53,97,107,215,33,107,20,251,127,16,246,95,234,181,155,37,203,255,2,59,98,189,139,147,246,0,7,130,57,81,79,180,86,117,93,245,179,233,158,135,96,203,237,17,108,88,97,30,230,171,143,183,148,8,253,32,141,142,20,11,62,166,93,203,186,60,53,208,40,108,115,178,220,212,22,74,38,140,233,11,235,170,35,39,38,96,136,104,193,136,34,102,109,48,58,252,69,113,199,201,24,31,163,120,145,6,13,244,238,216,236,132,83,119,3,254,31,145,114,113,31,63,233,170,3,52,251,38,224,222,2,124,232,143,186,56,225,65,99,148,82,49,237,244,125,216,109,49,142,72,141,30,233,224,238,179,89,47,228,108,1,242,216,238,229,225,136,155,83,187,38,22,153,228,117,183,202,28,72,100,100,60,140,251,237,22,52,104,242,200,115,67,34,149,228,165,158,196,46,100,106,173,202,239,20,138,196,158,51,206,69,52,212,233,254,163,24,161,28,194,137,212,182,138,65,251,153,186,245,224,198,63,113,153,76,156,218,147,243,48,100,78,78,225,91,227,73,77,51,242,135,174,107,43,26,252,178,155,22,105,78,107,80,111,99,27,97,110,7,45,54,188,227,63,122,224,98,89,96,15,137,1,232,83,217,58,187,115,117,132,91,171,138,172,230,27,131,2,57,126,233,135,3,56,177,142,47,248,137,7,92,22,61,164,16,238,167,203,218,12,104,251,120,199,114,227,23,39,122,232,181,94,37,239,159,207,59,125},
  {220,120,240,244,68,158,131,151,191,170,103,64,209,196,72,22,180,65,214,67,80,215,228,11,186,59,64,128,57,243,0,183,230,79,86,142,82,72,183,58,34,1,109,217,204,110,71,115,183,41,17,167,22,98,21,178,101,94,176,138,34,51,248,39,244,86,231,68,127,236,101,235,136,15,94,56,252,246,101,129,34,175,28,154,235,175,182,4,201,120,115,77,233,62,49,7,112,2,173,138,159,90,235,71,97,71,201,31,240,148,4,237,241,156,228,184,234,199,160,210,112,188,116,140,174,215,49,156,195,247,31,80,103,44,109,91,72,221,80,58,134,125,67,26,161,249,186,231,206,218,174,76,182,231,174,114,72,187,205,149,66,106,106,35,177,146,42,228,74,45,75,67,115,211,67,183,121,68,204,247,9,25,35,123,124,97,45,44,40,171,3,201,139,194,154,26,113,190,238,186,87,229,19,38,110,81,20,207,31,73,188,111,78,202,255,154,236,85,127,243,126,198,193,162,42,90,11,197,147,222,66,85,153,128,27,148,229,171,169,133,141,88,57,93,139,60,105,32,236,36,27,112,154,74,242,115,128,246,141,213,110,44,75,44,179,159,77,2,69,72,206,45,235,46,60,48,50,32,75,167,56,149,26,171,150,243,12,214,150,249,156,88,12,241,208,227,123,156,180,214,62,61,130,71,112,221,172,93,133,104,19,187,59,110,171,221,148,42,52,106,15,17,190,181,156,127,32,144,25,96,3,243,99,241,182,229,139,34,32,240,205,201,186,154,150,38,175,90,159,117,12,123,33,175,41,40,92,98,171,169,179,100,112,183,22,240,198,184,179,178,211,101,32,145,69,114,79,168,82,117,21,69,175,190,70,140,233,132,124,66,105,46,22,95,58,206,11,220,20,85,137,140,19,180,245,109,233,176,238,29,93,14,51,140,150,59,182,238,113,0,138,92,135,210,37,98,10,39,85,229,73,248,227,127,44,251,5,153,151,100,92,106,203,145,195,85,126,105,117,137,181,74,184,169,69,111,60,136,144,112,216,0,244,99,183,170,219,101,187,79,93,205,59,41,30,220,118,234,136,133,250,120,65,111,158,41,43,103,64,18,14,94,183,62,95,126,98,17,146,88,117,163,5,3,42,144,149,181,30,159,217,245,163,230,169,119,142,193,79,31,189,225,58,31,196,79,201,26,238,245,252,191,226,48,16,73,93,12,90,141,144,203,73,189,241,118,242,79,254,171,225,213,202,99,45,100,242,141,229,254,95,37,1,224,145,192,92,202,71,66,147,50,14,112,206,27,206,216,76,237,92,5,84,64,201,43,127,4,163,141,104,32,84,91,238,164,134,27,156,245,16,7,149,84,204,133,82,109,69,235,10,56,69,32,60,102,176,168,242,8,33,112,72,212,246,118,15,159,92,255,60,221,136,160,11,249,154,133,31,63,109,243,201,144,199,247,124,54,165,126,109,164,76,18,83,128,123,4,40,250,184,181,244,41,216,137,126,245,209,231,169,187,40,217,247,219,127,218,136,220,229,14,171,70,161,151,128,122,22,206,73,208,14,74,191,165,147,237,176,78,207,162,40,27,134,223,171,76,248,209,18,49,81,4,240,27,95,103,176,232,62,70,232,97,145,67,66,200,147,67,246,53,27,71,244,122,155,146,153,171,13,208,205,150,208,80,142,135,134,226,136,175,108,105,137,176,32,194,252,153,84,174,20,5,178,215,217,193,227,58,34,94,249,170,210,63,204,120,26,83,147,24,160,13,207,165,139,3,98,18,49,82,212,215,134,41,35,145,170,175,51,15,9,87,116,63,141,151,79,46,77,147,76,48,132,57,162,150,192,35,61,162,83,106,79,89,115,221,75,255,103,1,84,181,154,122,218,180,87,4,163,173,150,134,125,212,45,170,178,203,101,253,251,162,16,201,34,97,9,199,87,207,5,9,28,32,1,88,182,99,136,78,1,68,23,234,224,212,115,232,232,241,73,8,63,190,118,54,82,128,147,73,25,98,210,221,146,161,195,70,238,243,239,104,35,15,69,58,56,40,136,97,137,135,188,172,202,24,32,43,192,46,247,106,95,254,145,3,122,115,64,51,173,19,106,139,16,49,3,185,18,111,243,70,72,165,181,179,83,168,76,164,12,85,55,191,205,115,31,212,206,7,89,58,170,156,53,121,248,161,190,158,31,148,29,116,42,248,58,63,146,55,168,62,58,254,124,124,131,114,95,1,159,97,44,211,248,247,3,87,61,196,24,121,22,133,119,133,121,241,125,188,247,225,107,228,203,117,19,152,45,243,129,166,220,21,62,12,241,160,32,11,146,94,70,77,85,72,86,65,147,44,105,153,111,150,240,228,68,2,73,47,205,251,120,108,167,216,16,98,184,116,249,136,62,103,5,190,222,171,169,139,128,83,105,25,153,116,38,13,181,74,251,232,71,179,215,76,146,97,64,26,61,137,1,86,194,60,8,157,192,187,67,89,180,121,235,248,100,124,248,126,82,241,46,9,106,151,183,171,171,46,204,35,76,217,86,120,141,80,0,141,177,254,5,236,57,98,89,187,250,172,98,240,11,24,72,30,166,136,82,22,57,70,239,78,81,147,113,57,59,202,166,24,214,147,42,23,199,102,216,36,205,2,185,196,46,247,167,36,241,242,97,21,96,134,243,251,16,227,19,182,126,203,73,73,98,49,245,221,217,51,254,141,150,48,86,195,130,224,86,19,92,146,55,24,244,137,25,215,241,196,140,224,7,98,197,140,245,183,76,56,165,67,171,145,67,200,153,157,206,53,203,240,81,195,154,20,117,54,201,236,89,9,45,15,43,48,24,209,140,207,150,47,251,56,184,103,107,241,55,98,48,164,126,41,128,152,80,1,52,217,30,8,148,46,85,51,218,213,214,66,107,25,30,115,47,101,120,55,32,244,31,71,11,159,25,9,41,249,234,70,0,148,248,170,88,33,223,254,205,103,63,248,124,109,238,52,221,154,94,169,69,125,202,43,65,103,116,144,193,131,50,35,64,111,129,165,105,23,173,179,98,73,112,72,246,211,148,129,186,209,134,52,203,226,226,233,23,12,62,60,66,131,186,245,60,190,71,123,189,110,222,239,171,224,59,108,140,188,175,232,111,131,20,239,30,143,225,25,124,162,20,211,91,157,185,202,158,123,137,48,68,91,99,35,107,155,90,36,149,1,111,161,222,104,173,238,145,204,244,229,19,71,163,127,126,204,1,77,41,67,166,182,151,91,180,119,139,64,251,195,73,242,17,223,11,238,7,230,55,171,31,47,2,108,2,230,230,76,244,99,197,53,74,88,125,188,57,45,115,31,104,99,138,110,7,89,162,94,132,89,90,202,211,97,249,9,33,2,103,110,113,115,217,187,142,233,220,108,160,20,128,169,200,184,19,227,246,90,199,221},
  {232,123,162,57,118,248,128,229,117,159,46,134,66,242,14,240,197,183,113,252,63,155,143,85,197,179,108,145,106,1,232,80,159,91,169,19,75,12,12,171,107,182,231,76,119,238,50,17,27,111,230,227,61,157,105,48,238,209,6,204,61,52,139,2,46,222,111,168,184,25,241,88,163,148,60,167,109,144,34,104,9,160,251,103,236,159,166,2,174,116,129,112,8,38,45,245,162,228,153,243,193,200,243,80,190,217,166,35,176,174,223,198,96,141,151,196,89,246,139,191,186,170,161,186,46,169,50,233,135,119,193,107,234,248,55,55,218,35,118,239,130,96,226,217,98,142,127,113,45,221,231,184,159,47,254,15,204,163,140,151,51,211,91,87,35,196,42,12,169,197,229,79,185,212,248,8,19,152,62,180,125,33,83,83,69,248,102,89,226,77,160,142,67,185,253,255,73,75,225,28,51,161,90,231,244,178,103,241,139,218,56,248,236,1,78,174,251,185,152,180,118,21,32,201,1,37,1,241,225,213,117,44,50,187,158,22,106,81,139,69,49,110,236,213,61,116,17,7,170,42,82,197,92,36,155,180,169,188,60,130,17,124,142,126,161,242,230,224,2,213,150,87,164,126,39,231,49,94,234,125,61,163,94,50,244,194,216,77,150,170,140,238,0,57,192,177,81,40,87,185,208,104,199,105,45,131,155,208,182,209,187,124,96,251,141,66,67,64,224,252,142,62,144,174,249,58,104,122,96,244,112,150,66,186,252,136,219,214,128,0,95,84,42,111,40,245,120,172,249,166,10,89,98,122,87,10,43,203,139,21,160,184,166,108,136,28,132,117,114,238,17,10,111,29,140,203,207,250,209,132,117,138,120,120,26,170,45,37,246,2,141,52,107,178,199,7,243,88,242,55,179,200,253,174,43,124,73,196,210,19,35,128,18,138,53,234,131,78,165,140,100,136,156,139,155,128,174,125,44,83,132,252,157,88,191,211,209,9,250,3,109,76,182,162,140,176,92,136,68,71,127,40,114,251,10,255,225,168,148,146,162,132,60,4,235,7,189,176,254,9,122,228,218,164,237,187,1,251,211,33,22,153,190,200,24,124,118,202,52,203,27,233,146,14,154,147,155,42,58,163,30,41,138,124,243,7,239,32,162,21,42,124,48,139,189,12,9,135,138,24,232,250,250,137,250,136,86,250,157,70,68,232,126,210,64,30,149,222,43,99,212,141,212,129,7,95,22,247,177,80,70,230,137,14,1,158,228,3,33,63,244,104,115,181,133,236,202,209,140,189,4,168,149,33,174,146,91,183,95,196,246,246,109,240,40,241,55,105,41,144,120,123,148,130,212,244,66,18,62,211,211,119,7,35,15,240,43,112,56,120,132,174,126,237,227,217,177,94,99,178,117,76,250,134,98,15,229,62,173,138,38,26,4,235,46,66,183,108,22,232,141,170,18,21,71,168,215,149,67,97,82,6,185,110,13,21,236,222,197,138,97,10,2,80,29,15,139,215,194,170,215,248,45,169,41,5,53,252,163,221,196,236,195,130,2,192,236,81,40,202,228,216,220,37,215,212,25,171,187,120,149,63,255,248,148,50,66,57,89,154,4,67,29,252,124,5,0,182,179,144,132,151,203,95,251,103,162,123,75,54,65,173,131,72,220,122,13,252,226,106,4,146,105,194,231,12,5,84,37,132,16,196,106,115,222,145,182,112,119,172,5,192,66,130,6,178,131,94,236,135,59,194,74,41,130,137,238,25,218,155,77,224,111,70,199,35,30,189,12,183,114,229,230,235,152,139,74,220,242,186,80,229,125,218,136,103,241,180,42,65,243,93,162,131,55,123,23,67,43,117,108,254,254,77,249,241,217,120,93,243,234,172,62,205,172,81,81,86,21,142,126,115,0,13,225,207,55,75,51,66,131,139,165,26,202,80,206,120,156,255,40,162,12,119,197,245,5,78,13,54,61,63,121,131,136,21,129,55,194,22,135,195,12,114,202,90,219,94,65,98,32,45,43,245,189,8,125,108,44,99,78,22,223,86,201,86,14,234,125,11,73,215,166,65,183,91,239,90,103,250,3,3,196,244,177,155,24,62,127,32,202,93,129,15,55,39,240,33,164,209,91,226,51,214,209,132,238,96,65,109,141,198,98,241,34,153,17,180,203,140,221,10,42,108,96,141,32,60,169,113,180,233,55,32,230,205,232,122,156,41,15,17,164,43,139,174,73,204,32,171,38,36,51,237,186,190,117,166,138,77,58,176,245,221,144,180,32,114,92,123,93,54,22,187,84,191,60,61,110,195,22,234,69,159,199,168,20,25,72,109,39,87,115,153,169,23,58,217,217,199,162,73,174,242,248,147,20,130,175,232,232,130,153,19,10,194,185,215,241,247,163,189,88,114,110,33,60,200,3,191,106,203,207,209,49,194,227,146,163,101,116,161,73,172,149,19,172,82,145,154,255,10,59,60,197,36,60,7,219,169,112,115,187,134,86,23,252,164,76,240,146,43,13,114,36,253,138,235,239,101,219,44,152,126,77,96,169,4,43,201,227,248,109,74,33,26,242,241,156,33,159,106,113,234,238,196,73,116,125,72,167,254,8,47,100,218,124,63,233,130,213,88,222,231,157,115,102,213,116,220,12,244,184,245,143,236,94,233,64,223,106,82,148,105,173,227,238,17,9,37,203,239,215,242,177,138,251,62,5,119,218,116,148,189,213,109,45,49,149,253,6,193,98,93,177,74,216,0,250,174,76,102,239,213,252,51,147,40,57,87,157,155,237,70,106,128,243,14,134,68,119,19,2,201,246,34,109,44,30,127,145,224,234,209,1,79,43,248,93,192,132,143,228,59,46,5,206,158,10,108,6,74,164,150,38,101,11,79,185,162,63,101,63,44,228,213,164,3,253,151,51,94,140,140,76,117,214,85,26,67,205,218,205,113,216,91,41,104,45,191,46,152,203,69,118,255,122,97,9,202,53,29,14,121,129,123,48,86,109,79,234,195,167,183,192,93,93,126,24,91,10,225,116,90,228,34,35,19,135,131,174,198,22,80,15,224,235,148,129,103,184,135,14,81,43,176,17,193,14,227,195,15,42,108,226,42,87,26,255,46,185,246,240,122,141,14,10,49,16,3,60,111,219,222,155,95,147,50,69,240,126,142,175,146,2,57,185,245,13,7,6,194,81,115,221,51,187,9,200,208,219,168,220,169,195,156,234,29,5,18,137,223,179,211,210,87,115,86,87,26,223,128,155,127,253,250,95,180,42,76,115,45,211,214,245,50,184,3,142,48,120,148,97,224,215,65,230,249,13,131,171,158,183,134,188,209,101,156,222,59,222,227,47,74,27,187,248,74,132,245,57,238,89,87,239,51,135,188,230,250,135,211,93,224,21,194,89,138,205,247,138,144,2,154,242,88,50,202,23,123,106,213},
} ;

static const unsigned char precomputed_core_multsntrup761_k[precomputed_core_multsntrup761_NUM][crypto_core_KEYBYTES] = {
  {0,0,0,0,-1,0,0,1,1,-1,1,0,1,-1,-1,0,1,0,1,0,1,0,1,-1,1,0,0,-1,0,0,0,0,1,-1,1,1,0,0,0,-1,1,0,0,-1,-1,0,0,0,1,1,0,0,-1,0,1,-1,0,0,0,0,0,-1,0,1,1,0,0,1,1,1,0,0,0,0,-1,1,0,-1,0,-1,0,-1,0,0,1,0,-1,0,-1,1,0,1,0,-1,-1,0,-1,0,0,0,-1,-1,-1,0,0,0,0,1,0,1,1,0,0,0,-1,-1,1,0,-1,1,-1,0,0,1,0,1,0,0,0,0,0,-1,-1,0,0,0,-1,-1,1,0,0,-1,0,1,-1,0,-1,1,-1,-1,0,1,-1,0,-1,0,0,0,1,0,0,-1,-1,1,1,-1,0,0,1,0,-1,0,0,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,-1,0,0,0,1,-1,-1,0,-1,-1,-1,-1,0,0,0,0,1,0,0,-1,-1,-1,1,0,0,0,1,0,1,1,0,0,-1,1,0,1,0,-1,-1,-1,0,0,-1,1,-1,0,-1,0,-1,1,0,0,-1,1,0,-1,0,0,1,-1,-1,-1,0,1,0,1,-1,0,0,-1,-1,0,1,1,1,1,-1,0,0,0,-1,0,1,1,0,1,1,-1,0,-1,0,1,1,0,1,0,0,-1,0,-1,-1,0,0,0,0,1,0,1,1,1,0,0,0,0,-1,1,0,0,-1,0,1,1,0,0,1,1,-1,-1,-1,1,0,-1,0,1,0,0,-1,0,0,0,-1,0,0,0,0,-1,0,0,0,1,-1,1,0,0,0,1,1,0,1,0,1,1,1,0,0,1,0,1,-1,-1,0,-1,0,0,-1,0,-1,0,0,0,0,-1,0,0,1,-1,1,1,1,1,1,0,0,1,-1,-1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,-1,0,0,-1,0,1,-1,1,-1,-1,0,1,-1,-1,-1,0,1,-1,0,1,1,0,0,0,1,0,1,0,-1,1,0,-1,0,1,1,0,-1,1,-1,-1,1,1,0,1,1,1,-1,0,0,-1,1,0,-1,0,0,-1,0,1,0,0,1,1,0,0,0,-1,-1,1,0,-1,-1,1,0,1,0,0,0,0,-1,1,1,0,-1,1,-1,0,1,-1,0,-1,0,0,1,1,0,1,-1,0,1,1,1,1,0,1,-1,-1,-1,0,0,0,0,0,0,0,0,-1,-1,-1,0,1,0,0,1,0,-1,1,1,1,-1,-1,-1,-1,0,-1,0,0,0,1,-1,1,-1,1,0,-1,-1,1,0,1,0,0,0,0,-1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,-1,0,0,-1,0,1,-1,0,-1,0,1,-1,1,0,0,1,0,0,0,-1,0,1,1,0,0,0,1,0,1,1,-1,0,-1,0,0,1,0,-1,0,0,0,0,-1,1,1,0,0,0,1,1,0,0,1,-1,0,1,-1,1,1,1,1,0,1,1,-1,-1,-1,0,1,0,1,0,0,0,0,0,0,-1,1,0,0,0,-1,-1,1,0,0,0,0,0,0,0,-1,-1,0,0,1,0,0,1,1,0,1,1,0,-1,0,-1,0,0,0,1,-1,0,0,-1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,-1,-1,0,-1,0,0,-1,0,0,-1,0,1,-1,-1,1,0,0,0,0,0,0,-1,-1,0,1,0,-1,1,1,-1,-1,0,0,0,1,0,-1,-1,0,0,0,-1,-1,0,1,0,0,0,-1,0,0,0},
  {-1,1,-1,-1,0,0,-1,0,0,0,1,0,-1,0,0,0,0,0,0,0,1,0,0,-1,-1,-1,0,0,1,0,0,1,1,0,0,0,-1,1,1,0,0,1,-1,0,0,0,0,0,0,0,0,0,1,1,-1,-1,0,0,0,-1,1,0,0,-1,0,0,0,1,1,-1,-1,0,0,1,1,0,-1,-1,0,-1,-1,1,-1,1,0,0,0,0,-1,-1,1,1,1,1,0,0,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,0,1,0,0,1,0,-1,0,-1,0,0,0,0,0,-1,0,1,0,0,1,0,-1,0,0,1,0,1,-1,0,-1,-1,0,-1,0,0,-1,1,-1,0,0,1,1,-1,-1,0,-1,0,0,0,0,0,-1,-1,1,0,1,0,-1,0,0,-1,0,1,1,1,0,0,1,1,-1,0,1,-1,0,0,1,-1,0,-1,0,-1,0,1,0,0,-1,0,0,-1,0,0,0,-1,0,-1,-1,0,-1,-1,-1,1,-1,0,0,0,0,0,0,-1,1,0,0,-1,0,1,0,0,0,0,1,-1,-1,1,0,1,-1,1,1,0,1,1,-1,0,-1,-1,-1,0,1,0,-1,1,-1,1,1,1,1,1,0,-1,0,0,-1,0,-1,-1,0,0,-1,0,-1,-1,0,1,-1,0,0,1,-1,1,-1,0,0,0,-1,0,1,0,0,0,-1,0,-1,0,0,0,1,0,1,0,1,0,0,-1,0,-1,0,0,1,0,0,-1,-1,0,0,0,1,1,-1,1,-1,1,1,0,1,0,1,-1,1,-1,1,1,0,-1,0,1,0,-1,0,1,-1,0,1,-1,-1,0,0,-1,1,1,0,-1,-1,1,1,1,-1,1,1,1,1,0,-1,1,1,-1,-1,1,1,1,0,-1,1,0,0,-1,0,1,0,0,0,1,0,-1,-1,1,-1,0,0,0,0,0,1,0,0,-1,1,-1,1,0,1,-1,-1,1,1,0,-1,0,0,1,-1,0,1,0,0,-1,-1,-1,0,-1,0,1,-1,0,-1,1,0,1,0,0,1,1,-1,0,0,-1,1,0,0,1,0,0,-1,-1,0,0,0,0,1,0,0,1,1,0,1,-1,0,1,-1,-1,1,-1,-1,1,1,0,-1,0,0,0,0,-1,0,1,1,-1,0,0,1,1,0,0,-1,0,-1,1,-1,-1,-1,0,1,0,0,-1,-1,0,0,0,0,-1,0,0,-1,1,1,0,1,0,-1,0,0,1,0,-1,1,-1,-1,0,0,-1,0,0,-1,0,0,1,0,0,0,1,0,1,-1,0,-1,0,0,1,1,-1,0,0,1,-1,-1,1,-1,0,0,0,0,-1,1,1,-1,0,1,1,0,1,1,-1,0,1,-1,0,0,0,0,-1,0,1,-1,0,1,1,1,1,1,0,1,0,-1,1,1,-1,1,1,0,0,0,1,1,-1,0,0,0,-1,0,1,0,-1,1,1,0,0,-1,-1,0,1,1,-1,1,0,0,-1,0,-1,0,0,0,0,0,0,-1,0,0,1,-1,0,0,0,-1,1,-1,-1,-1,0,-1,-1,0,1,0,1,0,-1,0,0,1,1,1,-1,-1,1,0,-1,0,0,0,0,0,-1,1,0,1,1,-1,0,0,-1,0,-1,1,-1,0,1,0,0,0,-1,-1,0,1,-1,-1,-1,0,0,-1,1,0,0,0,0,1,-1,1,0,0,0,0,-1,0,-1,1,-1,1,1,0,-1,0,0,1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,-1,1,-1,0,0,-1,0,0,1,1,-1,0,-1,1,0,0,0,-1,0,0,0,0,0,0},
  {0,-1,-1,-1,0,-1,-1,1,-1,0,-1,0,0,0,0,1,1,0,1,-1,-1,-1,-1,0,0,-1,-1,-1,-1,0,0,-1,-1,-1,-1,-1,-1,1,0,-1,1,-1,-1,1,0,0,-1,-1,0,0,1,1,0,-1,0,1,0,0,-1,1,1,0,1,1,0,-1,0,-1,0,0,-1,0,0,-1,0,0,0,0,-1,1,0,-1,0,0,1,0,0,0,-1,1,0,0,-1,-1,1,0,0,0,0,0,1,0,-1,-1,1,0,1,0,1,0,0,1,0,-1,1,-1,1,1,1,1,0,0,1,1,1,0,0,0,1,-1,1,0,0,0,1,0,-1,0,0,1,0,-1,1,0,0,0,0,0,0,-1,1,1,-1,0,1,0,1,-1,-1,0,0,0,1,1,0,1,-1,-1,1,0,1,1,-1,0,1,0,-1,0,0,0,1,1,-1,0,-1,-1,0,0,0,-1,1,0,0,0,-1,0,0,0,0,-1,0,0,1,1,0,0,0,0,-1,0,0,1,-1,-1,1,1,0,0,1,0,0,0,0,-1,-1,0,0,0,1,0,-1,0,0,1,1,0,-1,0,1,1,1,-1,1,0,-1,1,-1,0,1,-1,0,1,1,0,-1,0,0,0,0,0,-1,-1,0,0,0,0,-1,0,1,-1,-1,-1,0,1,0,0,0,-1,0,0,1,-1,0,-1,-1,1,1,1,-1,0,0,0,0,0,0,0,1,-1,1,-1,1,-1,-1,0,-1,1,0,-1,0,0,-1,0,0,0,0,1,0,0,1,-1,1,0,1,0,-1,-1,0,-1,1,0,0,0,0,-1,0,0,0,0,-1,0,-1,0,1,-1,-1,0,1,-1,0,-1,-1,0,1,0,1,1,0,1,0,0,-1,0,1,0,0,1,0,1,1,1,-1,1,1,-1,0,1,1,0,0,0,-1,1,0,1,0,0,0,0,-1,-1,1,0,-1,0,0,1,-1,1,1,-1,-1,0,1,0,-1,0,0,-1,1,-1,-1,0,1,-1,1,0,-1,-1,0,0,1,0,0,0,0,1,0,-1,1,1,0,-1,1,0,1,0,-1,0,0,1,1,1,0,-1,0,0,0,-1,0,0,0,0,-1,1,0,-1,0,0,-1,0,1,0,1,-1,0,1,0,-1,0,-1,0,-1,0,1,-1,0,1,0,0,1,0,0,-1,-1,1,-1,0,0,0,0,1,1,-1,-1,-1,-1,1,0,0,1,1,-1,0,0,0,1,0,-1,-1,0,-1,0,-1,1,0,0,0,0,0,-1,0,-1,0,0,0,0,0,0,1,0,0,-1,-1,0,0,0,0,0,-1,-1,0,0,-1,1,-1,-1,1,1,-1,1,0,1,0,0,-1,-1,1,1,0,0,1,1,0,0,0,1,0,-1,1,-1,0,1,0,0,-1,0,0,0,0,-1,1,0,0,-1,0,0,-1,0,-1,1,0,0,-1,0,0,0,1,0,1,1,0,0,-1,0,1,0,0,1,0,0,-1,0,1,1,0,1,1,1,0,-1,0,-1,1,0,0,1,1,-1,1,0,-1,1,0,0,0,0,0,0,0,-1,-1,0,0,0,0,1,-1,0,0,-1,-1,0,0,0,0,0,0,0,1,0,-1,0,-1,0,0,-1,0,-1,0,1,1,0,0,0,1,0,-1,0,0,-1,1,0,1,-1,-1,0,-1,1,-1,-1,0,-1,0,0,-1,0,0,-1,0,0,0,0,0,0,0,-1,0,0,-1,1,1,-1,0,0,0,-1,0,1,0,1,0,0,-1,0,0,0,1,0,1,1,-1,-1,1,1,1,1,0,1,0,0,0,-1,0,0,-1,0,0,-1,0,-1,0,0,1,-1,-1,-1,-1,1,0,0,1},
  {0,1,-1,1,0,-1,1,0,0,1,0,0,0,-1,0,-1,0,-1,0,0,0,1,1,1,-1,0,1,-1,1,0,1,1,0,0,0,1,0,1,-1,0,0,0,1,0,1,-1,-1,0,-1,0,-1,0,0,0,-1,-1,1,-1,0,0,0,1,0,1,-1,1,-1,0,0,0,-1,1,0,1,1,0,1,0,-1,0,1,-1,0,-1,1,1,0,-1,-1,-1,-1,1,0,1,0,1,-1,1,0,-1,-1,-1,0,1,0,0,0,-1,1,0,0,0,-1,-1,0,-1,1,0,-1,1,0,0,-1,1,0,0,0,0,0,-1,1,1,0,0,1,0,1,0,-1,1,-1,0,-1,0,0,0,0,0,0,1,0,0,-1,0,0,-1,0,-1,-1,-1,1,-1,0,-1,0,0,-1,0,0,1,-1,1,0,0,0,0,1,0,-1,0,0,1,0,0,0,1,0,0,1,0,0,1,-1,0,1,0,0,-1,-1,-1,0,1,0,0,1,-1,0,0,0,0,-1,1,0,1,1,1,1,1,-1,0,-1,0,0,1,0,-1,1,0,0,0,0,-1,1,1,1,0,-1,1,1,1,0,0,0,1,0,0,0,1,-1,0,0,-1,-1,0,0,-1,0,0,0,0,-1,1,1,-1,0,-1,0,-1,0,1,1,-1,1,1,0,-1,-1,0,0,1,0,0,0,1,0,0,0,0,0,-1,0,-1,-1,0,-1,-1,-1,0,1,1,-1,-1,0,1,0,0,0,0,-1,0,0,-1,0,0,-1,1,-1,1,0,0,1,0,1,0,0,-1,1,1,1,0,0,-1,0,-1,0,0,0,0,1,1,1,1,-1,-1,0,0,0,0,1,-1,0,-1,0,1,-1,0,0,1,-1,0,-1,1,0,0,-1,0,0,1,0,0,0,1,0,0,0,-1,-1,-1,1,-1,0,1,0,1,-1,0,0,0,0,0,0,-1,0,1,0,0,0,0,0,0,0,0,0,-1,0,1,-1,0,-1,0,0,0,1,0,1,1,1,1,0,0,1,-1,-1,0,1,0,0,1,0,-1,1,0,-1,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,-1,0,0,-1,0,1,0,0,0,0,0,0,1,1,-1,-1,1,-1,-1,0,0,-1,0,0,1,1,0,0,1,-1,0,1,0,1,0,0,0,-1,1,0,0,0,0,0,0,1,-1,1,0,-1,1,0,0,-1,-1,1,-1,0,0,1,0,-1,0,-1,0,0,-1,0,0,-1,1,0,1,0,1,-1,-1,0,0,0,0,0,0,0,1,0,0,1,-1,-1,0,1,0,1,1,1,0,0,0,-1,0,0,1,-1,0,1,-1,1,0,-1,0,1,0,-1,0,-1,0,1,0,1,0,0,0,1,-1,0,-1,1,0,1,0,1,0,0,-1,0,1,-1,1,1,1,0,-1,0,-1,-1,-1,0,1,0,1,-1,-1,0,0,-1,0,0,-1,0,1,-1,0,0,-1,1,0,0,0,1,1,1,0,1,1,-1,-1,-1,-1,0,0,0,0,0,0,-1,1,0,-1,0,1,0,0,0,0,0,-1,0,0,-1,-1,-1,-1,0,1,-1,0,0,0,0,0,1,-1,1,1,1,0,0,1,0,1,0,0,-1,0,0,0,0,1,1,-1,-1,0,1,0,-1,-1,0,0,-1,1,0,1,1,1,0,0,-1,-1,-1,0,1,1,0,1,1,1,0,1,0,0,1,-1,1,0,1,0,0,0,-1,1,1,0,-1,0,0,1,-1,0,-1,0,0,0,0,0,0,0,0,-1,0,0,0,-1,-1,0,0,1,0,-1,-1,1,0,-1,0,0,0,-1,0,1,0,0,1,0,1,1},
} ;

static const unsigned char precomputed_core_multsntrup761_c[precomputed_core_multsntrup761_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_multsntrup761_impl(long long impl)
{
  unsigned char *h = test_core_multsntrup761_h;
  unsigned char *n = test_core_multsntrup761_n;
  unsigned char *k = test_core_multsntrup761_k;
  unsigned char *c = test_core_multsntrup761_c;
  unsigned char *h2 = test_core_multsntrup761_h2;
  unsigned char *n2 = test_core_multsntrup761_n2;
  unsigned char *k2 = test_core_multsntrup761_k2;
  unsigned char *c2 = test_core_multsntrup761_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_multsntrup761_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_multsntrup761(impl);
    printf("core_multsntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_multsntrup761_implementation(impl),ntruprime_dispatch_core_multsntrup761_compiler(impl));
  } else {
    crypto_core = ntruprime_core_multsntrup761;
    printf("core_multsntrup761 selected implementation %s compiler %s\n",ntruprime_core_multsntrup761_implementation(),ntruprime_core_multsntrup761_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_multsntrup761_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_multsntrup761_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_multsntrup761_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_multsntrup761_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_multsntrup761_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_multsntrup761_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_multsntrup761_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_multsntrup761_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_multsntrup761_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_multsntrup761_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_multsntrup761(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"multsntrup761")) return;
  storage_core_multsntrup761_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_multsntrup761_h = aligned(storage_core_multsntrup761_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_multsntrup761_n = callocplus(crypto_core_INPUTBYTES);
  test_core_multsntrup761_n = aligned(storage_core_multsntrup761_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_multsntrup761_k = callocplus(crypto_core_KEYBYTES);
  test_core_multsntrup761_k = aligned(storage_core_multsntrup761_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_multsntrup761_c = callocplus(crypto_core_CONSTBYTES);
  test_core_multsntrup761_c = aligned(storage_core_multsntrup761_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_multsntrup761_h2 = callocplus(maxalloc);
  test_core_multsntrup761_h2 = aligned(storage_core_multsntrup761_h2,crypto_core_OUTPUTBYTES);
  storage_core_multsntrup761_n2 = callocplus(maxalloc);
  test_core_multsntrup761_n2 = aligned(storage_core_multsntrup761_n2,crypto_core_INPUTBYTES);
  storage_core_multsntrup761_k2 = callocplus(maxalloc);
  test_core_multsntrup761_k2 = aligned(storage_core_multsntrup761_k2,crypto_core_KEYBYTES);
  storage_core_multsntrup761_c2 = callocplus(maxalloc);
  test_core_multsntrup761_c2 = aligned(storage_core_multsntrup761_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_multsntrup761 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_multsntrup761();++impl)
      forked(test_core_multsntrup761_impl,impl);
    ++test_core_multsntrup761_h;
    ++test_core_multsntrup761_n;
    ++test_core_multsntrup761_k;
    ++test_core_multsntrup761_c;
    ++test_core_multsntrup761_h2;
    ++test_core_multsntrup761_n2;
    ++test_core_multsntrup761_k2;
    ++test_core_multsntrup761_c2;
  }
  free(storage_core_multsntrup761_c2);
  free(storage_core_multsntrup761_k2);
  free(storage_core_multsntrup761_n2);
  free(storage_core_multsntrup761_h2);
  free(storage_core_multsntrup761_c);
  free(storage_core_multsntrup761_k);
  free(storage_core_multsntrup761_n);
  free(storage_core_multsntrup761_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

