.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-query 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dpkg\-query \- Un outil pour interroger la base de données de dpkg
.
.SH SYNOPSIS
\fBdpkg\-query\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBdpkg\-query\fP est un outil pour afficher des informations sur les paquets
connus par la base de données de \fBdpkg\fP.
.
.SH COMMANDES
.TP 
\fB\-l\fP, \fB\-\-list\fP [\fImotif\-de\-nom\-de\-paquet\fP...]
List packages matching given pattern. If no \fIpackage\-name\-pattern\fP is
given, list all packages in \fI%ADMINDIR%/status\fP, excluding the ones marked
as not\-installed (i.e. those which have been previously purged). Normal
shell wildcard characters are allowed in \fIpackage\-name\-pattern\fP. Please
note you will probably have to quote \fIpackage\-name\-pattern\fP to prevent the
shell from performing filename expansion. For example this will list all
package names starting with \*(lqlibc6\*(rq:

.nf
\fBdpkg\-query \-l 'libc6*'\fP
.fi

Les trois premières colonnes affichées montrent dans l'ordre\ : l'action
souhaitée, l'état du paquet et les erreurs.

Action souhaitée\ :
.nf
  u = Inconnu (Unknown)
  i = Installer (Install)
  h = Garder (Hold)
  r = Supprimer (Remove)
  p = Purger (Purge)
.fi

État du paquet\ :
.nf
  n = Non installé (Not\-installed)
  c = Fichiers de configuration (Config\-files)
  H = Semi\-installé (Half\-installed)
  U = Décompressé (Unpacked)
  F = Semi\-configuré (Half\-configured)
  W = Attente de déclenchements (Triggers\-awaiting)
  t = Déclenchements en attente (Triggers\-pending)
  i = Installé (Installed)
.fi

Drapeaux d'erreur\ :
.nf
  <empty> = (aucun)
  R = Réinstallation requise (Reinst\-required)
.fi

Un état en majuscules ou une lettre d'erreur indiquent que le paquet peut
provoquer des problèmes graves. Veuillez consulter \fBdpkg\fP(1) à propos des
états et drapeaux ci\-dessus.

On ne peut pas configurer le format de sortie de cette option. Il s'adapte
automatiquement à la largeur du terminal. Ce format est destiné aux humains
et la machine le lit mal. Voyez \fB\-W\fP (\fB\-\-show\fP) et \fB\-\-showformat\fP pour
une possible configuration de ce format.
.TP 
\fB\-W\fP, \fB\-\-show\fP [\fImotif\-de\-nom\-de\-paquet\fP...]
Tout comme l'option \fB\-\-list\fP, cette option affiche la liste des paquets qui
correspondent au motif donné. La sortie peut cependant être formatée en
utilisant l'option \fB\-\-showformat\fP. Le format de sortie par défaut est le
suivant\ : une ligne pour chaque paquet, avec le nom (éventuellement complété
par l'identifiant d'architecture pour les paquets \fBMulti\-Arch\fP \fBsame\fP) et
la version installée, séparés par une tabulation.
.TP 
\fB\-s\fP, \fB\-\-status\fP \fInom\-du\-paquet\fP ...
Donne l'état du paquet indiqué. C'est simplement l'affichage de l'entrée de
la base de données concernant les états des paquets installés. Lorsque des
\fInoms\-de\-paquets\fP multiples sont indiqués, les entrées d'état demandées
sont séparées par une ligne vide et sont dans l'ordre utilisé pour la liste
de paramètres.
.TP 
\fB\-L\fP, \fB\-\-listfiles\fP \fInom\-du\-paquet\fP...
Affiche la liste des fichiers du \fInom\-du\-paquet\fP installés sur le
système. Lorsque plusieurs \fInom\-du\-paquet\fP sont indiqués, les différentes
listes de fichiers sont séparées par une ligne vide et elles sont fournies
dans l'ordre de la liste de paramètres. Il faut remarquer cependant que les
fichiers créés par les scripts d'installation propres aux paquets ne sont
pas affichés.
.TP 
\fB\-\-control\-list\fP \fInom\-du\-paquet\fP
List control files installed to your system from \fIpackage\-name\fP (since dpkg
1.16.5).  These can be used as input arguments to \fB\-\-control\-show\fP.
.TP 
\fB\-\-control\-show\fP \fInom\-du\-paquet\fP \fIfichier\-de\-contrôle\fP
Print the \fIcontrol\-file\fP installed to your system from \fIpackage\-name\fP to
the standard output (since dpkg 1.16.5).
.TP 
\fB\-c\fP, \fB\-\-control\-path\fP \fInom\-du\-paquet\fP [\fIfichier\-contrôle\fP]
List paths for control files installed to your system from \fIpackage\-name\fP
(since dpkg 1.15.4).  If \fIcontrol\-file\fP is specified then only list the
path for that control file if it is present.

\fBAttention\fP\ :\ cette commande est obsolète parce qu'elle donne un accès
direct à la base de données interne de dpkg, et il est conseillé d'utiliser
\fB\-\-control\-list\fP et \fB\-\-control\-show\fP à la place dans tous les cas où ces
commandes peuvent donner le même résultat. Néanmoins,aussi longtemps qu'il y
a un cas au moins où cette commande est nécessaire (c'est\-à\-dire quand il
faut supprimer le script d'un responsable endommageant postrm), et tant
qu'il n'y aura pas de bonne solution pour cela, cette commande ne sera pas
supprimée.
.TP 
\fB\-S\fP, \fB\-\-search\fP \fImotif\-de\-nom\-à\-rechercher\fP...
Search for packages that own files corresponding to the given pattern.
Standard shell wildcard characters can be used in the pattern, where
asterisk (\fB*\fP) and question mark (\fB?\fP) will match a slash, and blackslash
(\fB\e\fP) will be used as an escape character.

If the first character in the \fIfilename\-search\-pattern\fP is none of
‘\fB*[?/\fP’ then it will be considered a substring match and will be
implicitly surrounded by ‘\fB*\fP’ (as in \fB*\fP\fIfilename\-search\-pattern\fP\fB*\fP).
If the subsequent string contains any of ‘\fB*[?\e\fP’, then it will handled
like a glob pattern, otherwise any trailing ‘\fB/\fP’ or ‘\fB/.\fP’ will be
removed and a literal path lookup will be performed.

This command will not list extra files created by maintainer scripts, nor
will it list alternatives.
.TP 
\fB\-p\fP, \fB\-\-print\-avail\fP \fInom\-du\-paquet\fP...
Affiche les détails relatifs à \fInom\-du\-paquet\fP, tels que présents dans
\fI/var/lib/dpkg/available\fP. Si des \fInom\-paquet\fP multiples sont indiqués,
les entrées \fIavailable\fP correspondantes seront séparées par des lignes
vides et apparaîtront dans l'ordre de la liste de paramètres.

Les utilisateurs des outils basés sur APT devraient plutôt utiliser la
commande \fBapt\-cache show\fP \fInom\-du\-paquet\fP car le fichier \fIavailable\fP
n'est tenu à jour que lorsque \fBdselect\fP est utilisé.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.TP 
\fB\-\-admindir\fP=\fIdir\fP
Change the location of the \fBdpkg\fP database. The default location is
\fI%ADMINDIR%\fP.
.TP 
\fB\-\-load\-avail\fP
Also load the available file when using the \fB\-\-show\fP and \fB\-\-list\fP
commands, which now default to only querying the status file (since dpkg
1.16.2).
.TP 
\fB\-f\fP, \fB\-\-showformat=\fP\fIformat\fP
Cette option sert à spécifier le format de sortie de l'option \fB\-\-show\fP. Ce
format sera utilisé pour chaque paquet listé.

Dans la chaîne, “\fB\e\fP” déspécifie le caractère\ :

.nf
    \fB\en\fP  nouvelle ligne
    \fB\er\fP  retour chariot
    \fB\et\fP  tabulation
.fi

“\fB\e\fP” avant un caractère supprime la signification du caractère qui
suit. C'est utile pour les caractères “\fB\e\fP” et “\fB$\fP”.

L'information relative à un paquet peut être indiquée en insérant des appels
de variables spécifiant des champs du paquet avec la syntaxe suivante\ :
“\fB${\fP\fIfield\fP[\fB;\fP\fIwidth\fP]\fB}\fP”. Les champs sont alignés à droite, à moins
que la largeur ne soit négative, auquel cas ils sont alignés à gauche. Les
champs suivants sont reconnus, mais pas nécessairement disponibles dans le
fichier d'état (seuls les champs internes ou les champs conservés avec le
paquet binaire le sont)\ :

.nf
    \fBArchitecture\fP
    \fBBugs\fP
    \fBConffiles\fP (interne)
    \fBConfig\-Version\fP (interne)
    \fBConflicts\fP
    \fBBreaks\fP
    \fBDepends\fP
    \fBDescription\fP
    \fBEnhances\fP
    \fBEssential\fP
    \fBFilename\fP (interne, lié au programme frontal)
    \fBHomepage\fP
    \fBInstalled\-Size\fP
    \fBMD5sum\fP (interne, lié au programme frontal)
    \fBMSDOS\-Filename\fP (interne, lié au programme frontal)
    \fBMaintainer\fP
    \fBOrigin\fP
    \fBPackage\fP
    \fBPre\-Depends\fP
    \fBPriority\fP
    \fBProvides\fP
    \fBRecommends\fP
    \fBReplaces\fP
    \fBRevision\fP (obsolète)
    \fBSection\fP
    \fBSize\fP (interne, lié au programme frontal)
    \fBSource\fP
    \fBStatus\fP (interne)
    \fBSuggests\fP
    \fBTag\fP (en général pas dans le .deb mais dans les fichiers Packages des dépôts)
    \fBTriggers\-Awaited\fP (interne)
    \fBTriggers\-Pending\fP (interne)
    \fBVersion\fP
.fi

Les champs suivants sont virtuels, créés par \fBdpkg\-query\fP à partir des
valeurs d'autres champs (veuillez noter qu'ils utilisent des noms qui ne
sont pas valables comme noms de champs dans le fichiers de contrôle)\ :
.RS
.TP 
\fBbinary:Package\fP
It contains the binary package name with a possible architecture qualifier
like “libc6:amd64” (since dpkg 1.16.2).  An architecture qualifier will be
present to make the package name unambiguous, for example if the package has
a \fBMulti\-Arch\fP field with a value of \fBsame\fP or the package is of a foreign
architecture.
.TP 
\fBbinary:Summary\fP
Il contient la description courte du paquet (depuis dpkg 1.16.2).
.TP 
\fBdb:Status\-Abbrev\fP
It contains the abbreviated package status (as three characters), such as
“ii ” or “iHR” (since dpkg 1.16.2).  See the \fB\-\-list\fP command description
for more details.
.TP 
\fBdb:Status\-Want\fP
Il contient le statut désiré du paquet, extrait du champ Status (depuis dpkg
1.17.11).
.TP 
\fBdb:Status\-Status\fP
Il contient le statut actuel du paquet, extrait du champ Status (depuis dpkg
1.17.11).
.TP 
\fBdb:Status\-Eflag\fP
Il contient le drapeau d'erreur du statut du paquet, extrait du champ Status
(depuis dpkg 1.17.11).
.TP 
\fBsource:Package\fP
Il contient le nom du paquet source de ce paquet binaire (depuis dpkg
1.16.2).
.TP 
\fBsource:Version\fP
Il contient la version du paquet source de ce paquet binaire (depuis dpkg
1.16.2).
.TP 
\fBsource:Upstream\-Version\fP
It contains the source package upstream version for this binary package
(since dpkg 1.18.16)
.RE
.IP
Le format par défaut est le suivant\ :
“\fB${binary:Package}\et${Version}\en\fP”. Tous les autres champs du fichier
d'état, par exemple des champs définis par l'utilisateur, peuvent être
demandés. Ils seront affichés mais sans aucune mise en forme et aucune
conversion ou vérification n'est faite. Pour obtenir le nom du responsable
de \fBdpkg\fP et la version installée, exécutez par exemple\ :

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\et${Maintainer}\en' dpkg\fP
.fi
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
La requête demandée s'est correctement déroulée.
.TP 
\fB1\fP
The requested query failed either fully or partially, due to no file or
package being found (except for \fB\-\-control\-path\fP, \fB\-\-control\-list\fP and
\fB\-\-control\-show\fP were such errors are fatal).
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_ADMINDIR\fP
Si cette variable est positionnée et que l'option \fB\-\-admindir\fP n'est pas
précisée, ce répertoire sera utilisé comme répertoire de données pour
\fBdpkg\fP.
.TP 
\fBCOLUMNS\fP
Ce réglage influence la sortie de l'option \fB\-\-list\fP en modifiant la largeur
d'affichage.
.
.SH "VOIR AUSSI"
\fBdpkg\fP(1).

.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
