/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.jna.drmaa.v1_0;

import java.util.Map;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.JobInfo;

public class JnaJobInfo
implements JobInfo {
    private final String jobId;
    private final Map<String, String> rusage;
    private final boolean hasExited;
    private final int exitStatus;
    private final boolean hasSignaled;
    private final String terminatingSignal;
    private final boolean hasCoreDump;
    private final boolean wasAborted;

    public JnaJobInfo(String jobId, Map<String, String> rusage2, boolean hasExited, int exitStatus, boolean hasSignaled, String terminatingSignal, boolean hasCoreDump, boolean wasAborted) {
        this.jobId = jobId;
        this.rusage = rusage2;
        this.hasExited = hasExited;
        this.exitStatus = exitStatus;
        this.hasSignaled = hasSignaled;
        this.terminatingSignal = terminatingSignal;
        this.hasCoreDump = hasCoreDump;
        this.wasAborted = wasAborted;
    }

    public String getJobId() throws DrmaaException {
        return this.jobId;
    }

    public Map getResourceUsage() throws DrmaaException {
        return this.rusage;
    }

    public boolean hasExited() throws DrmaaException {
        return this.hasExited;
    }

    public int getExitStatus() throws DrmaaException {
        if (!this.hasExited) {
            throw new IllegalStateException("job has not exited");
        }
        return this.exitStatus;
    }

    public boolean hasSignaled() throws DrmaaException {
        return this.hasSignaled;
    }

    public String getTerminatingSignal() throws DrmaaException {
        if (!this.hasSignaled) {
            throw new IllegalStateException("job has not signaled");
        }
        return this.terminatingSignal;
    }

    public boolean hasCoreDump() throws DrmaaException {
        return this.hasCoreDump;
    }

    public boolean wasAborted() throws DrmaaException {
        return this.wasAborted;
    }
}

