/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_PHYSICALASSETCAPABILITIES_H_
#define OPENDRIM_PHYSICALASSETCAPABILITIES_H_

#include <Instance.h>

const static char* OpenDRIM_PhysicalAssetCapabilities_classnames[] = {"OpenDRIM_PhysicalAssetCapabilities"};
static string OpenDRIM_PhysicalAssetCapabilities_NAMESPACE = _NAMESPACE;

class OpenDRIM_PhysicalAssetCapabilities {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	bool FRUInfoSupported;
	bool FRUInfoSupported_isNULL;
	
	OpenDRIM_PhysicalAssetCapabilities() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		FRUInfoSupported_isNULL = true;
	}
	
	~OpenDRIM_PhysicalAssetCapabilities() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getFRUInfoSupported(bool& value) const {
		if (FRUInfoSupported_isNULL==true)
			return NOT_FOUND;
		value = FRUInfoSupported;
		return OK;
	}
	
	int setFRUInfoSupported(const bool& newValue) {
		FRUInfoSupported = newValue;
		FRUInfoSupported_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_In {

public:

	vector<string> TemplateGoalSettings;
	bool TemplateGoalSettings_isNULL;

	vector<string> SupportedGoalSettings;
	bool SupportedGoalSettings_isNULL;

	OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_In() {
		TemplateGoalSettings_isNULL = true;
		SupportedGoalSettings_isNULL = true;
	}

	~OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_In() {}

	int getTemplateGoalSettings(vector<string>& value) const {
		if (TemplateGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = TemplateGoalSettings;
		return OK;
	}
	int setTemplateGoalSettings(const vector<string>&  newValue) {
		TemplateGoalSettings = newValue;
		TemplateGoalSettings_isNULL = false;
		return OK;
	}

	int getSupportedGoalSettings(vector<string>& value) const {
		if (SupportedGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = SupportedGoalSettings;
		return OK;
	}
	int setSupportedGoalSettings(const vector<string>&  newValue) {
		SupportedGoalSettings = newValue;
		SupportedGoalSettings_isNULL = false;
		return OK;
	}

};

class OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_Out {

public:

	vector<string> SupportedGoalSettings;
	bool SupportedGoalSettings_isNULL;

	OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_Out() {
		SupportedGoalSettings_isNULL = true;
	}

	~OpenDRIM_PhysicalAssetCapabilities_CreateGoalSettings_Out() {}

	int getSupportedGoalSettings(vector<string>& value) const {
		if (SupportedGoalSettings_isNULL == true)
			return NOT_FOUND;
		value = SupportedGoalSettings;
		return OK;
	}
	int setSupportedGoalSettings(const vector<string>&  newValue) {
		SupportedGoalSettings = newValue;
		SupportedGoalSettings_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PHYSICALASSETCAPABILITIES_H_*/
