/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.StringWriter;

/**
 * A very basic read-only XML attribute.
 * The {@link Namespace} interface is implemented, however, its
 * methods, excepting {@link Namespace#getName}, merely return
 * <code>null</code>.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class Attribute 
	implements Namespace
{
	private String name;
	private String value;

	/**
	 * Constructs an Xml attribute.
	 * @param name Name of element
	 * @param value Attribute value
	 */
	public Attribute(String name, String value)
	{
		this.name = name;
		this.value = value;
	}

	/**
	 * Returns the name of this Attribute.
	 * @return the name
	 */
	public String getName() {
		return name;
	}	

	/**
	 * Returns the value of this Attribute, without escaping any
	 * characters.
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * By default, returns null.
	 * @see AttributeNS#getNamespaceURI
	 */
	public String getNamespaceURI() {
		return null;
	}

	/**
	 * By default, returns null.
	 * @see AttributeNS#getPrefix
	 */
	public String getPrefix() {
		return null;
	}

	/**
	 * By default, returns null.
	 * @see AttributeNS#getLocalName
	 */
	public String getLocalName() {
		return null;
	}

	/**
	 * Returns a string representation of this Attribute.  Also,
	 * escapes single quotes, &lt;, and &amp;.
	 * @return this object as the string <code>name='value'</code>
	 */
	@Override
	public String toString() { 
		StringWriter sw = new StringWriter(64);
		StringBuffer sb = sw.getBuffer();
		if (getPrefix() != null)
			sb.append(getPrefix()).append('.');
		sb.append(name).append("=\"");
		try {
			XmlWriter.escape(value, sw);
		} catch (java.io.IOException e) {
			throw new RuntimeException(e.toString());
		}
		return sb.append('"').toString();
	}
}
