/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SPEECH_SYNTHESIS)

#include "JSTestCallbackInterface.h"

#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvert.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMStringList.h"
#include "JSTestNode.h"
#include "ScriptExecutionContext.h"
#include "SerializedScriptValue.h"
#include <runtime/FunctionPrototype.h>
#include <runtime/JSLock.h>

using namespace JSC;

namespace WebCore {

JSTestCallbackInterface::JSTestCallbackInterface(JSObject* callback, JSDOMGlobalObject* globalObject)
    : TestCallbackInterface()
    , ActiveDOMCallback(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackDataStrong(callback, globalObject, this))
{
}

JSTestCallbackInterface::~JSTestCallbackInterface()
{
    ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

using JSTestCallbackInterfaceConstructor = JSDOMConstructorNotConstructable<JSTestCallbackInterface>;

/* Hash table for constructor */

static const HashTableValue JSTestCallbackInterfaceConstructorTableValues[] =
{
    { "CONSTANT1", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CONSTANT2", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

static_assert(TestCallbackInterface::CONSTANT1 == 1, "CONSTANT1 in TestCallbackInterface does not match value from IDL");
static_assert(TestCallbackInterface::CONSTANT2 == 2, "CONSTANT2 in TestCallbackInterface does not match value from IDL");

template<> JSValue JSTestCallbackInterfaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTestCallbackInterfaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(globalObject);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TestCallbackInterface"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSTestCallbackInterfaceConstructorTableValues, *this);
}

template<> const ClassInfo JSTestCallbackInterfaceConstructor::s_info = { "TestCallbackInterface", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestCallbackInterfaceConstructor) };

JSValue JSTestCallbackInterface::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestCallbackInterfaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSTestCallbackInterface::callbackWithNoParam()
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithNoParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallbackInterface::callbackWithArrayParam(RefPtr<Float32Array> arrayParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<Float32Array>>(*state, *m_data->globalObject(), arrayParam));

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithArrayParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallbackInterface::callbackWithSerializedScriptValueParam(RefPtr<SerializedScriptValue>&& srzParam, const String& strParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLSerializedScriptValue<SerializedScriptValue>>(*state, *m_data->globalObject(), srzParam));
    args.append(toJS<IDLDOMString>(*state, strParam));

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithSerializedScriptValueParam"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallbackInterface::callbackWithStringList(DOMStringList* listParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<DOMStringList>>(*state, *m_data->globalObject(), listParam));

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithStringList"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallbackInterface::callbackWithBoolean(bool boolParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLBoolean>(boolParam));

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackWithBoolean"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

bool JSTestCallbackInterface::callbackRequiresThisToPass(int32_t longParam, TestNode* testNodeParam)
{
    if (!canInvokeCallback())
        return true;

    Ref<JSTestCallbackInterface> protectedThis(*this);

    JSLockHolder lock(m_data->globalObject()->vm());

    ExecState* state = m_data->globalObject()->globalExec();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLLong>(longParam));
    args.append(toJS<IDLInterface<TestNode>>(*state, *m_data->globalObject(), testNodeParam));

    NakedPtr<JSC::Exception> returnedException;
    m_data->invokeCallback(args, JSCallbackData::CallbackType::Object, Identifier::fromString(state, "callbackRequiresThisToPass"), returnedException);
    if (returnedException)
        reportException(state, returnedException);
    return !returnedException;
}

JSC::JSValue toJS(TestCallbackInterface& impl)
{
    if (!static_cast<JSTestCallbackInterface&>(impl).callbackData())
        return jsNull();

    return static_cast<JSTestCallbackInterface&>(impl).callbackData()->callback();

}

} // namespace WebCore

#endif // ENABLE(SPEECH_SYNTHESIS)
