# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 580-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53272);
 script_bugtraq_id(11570);
 script_cve_id("CVE-2004-0986");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 580-1 (iptables)";
 script_name(name);

 desc = "The remote host is missing an update to iptables
announced via advisory DSA 580-1.

Faheem Mitha noticed that the iptables command, an administration tool
for IPv4 packet filtering and NAT, did not always load the required
modules on it own as it was supposed to.  This could lead to firewall
rules not being loaded on system startup.  This caused a failure in
connection with rules provided by lokkit at least.

For the stable distribution (woody) this problem has been fixed in
version 1.2.6a-5.0woody2.

For the unstable distribution (sid) this problem has been fixed in
version 1.2.11-4.

We recommend that you upgrade your iptables package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20580-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 580-1 (iptables)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"iptables", ver:"1.2.6a-5.0woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iptables-dev", ver:"1.2.6a-5.0woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
