#
#VID f5e52bf5-fc77-11db-8163-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58856);
 script_cve_id("CVE-2007-1001");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "php -- multiple vulnerabilities";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   php5-imap
   php5-odbc
   php5-session
   php5-shmop
   php5-sqlite
   php5-wddx
   php5
   php4-odbc
   php4-session
   php4-shmop
   php4-wddx
   php4
   mod_php4-twig
   mod_php4
   mod_php5
   mod_php
   php4-cgi
   php4-cli
   php4-dtc
   php4-horde
   php4-nms
   php5-cgi
   php5-cli
   php5-dtc
   php5-horde
   php5-nms

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.php.net/releases/4_4_7.php
http://www.php.net/releases/5_2_2.php
http://www.vuxml.org/freebsd/f5e52bf5-fc77-11db-8163-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "php -- multiple vulnerabilities";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"php5-imap");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-imap version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-odbc");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-odbc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-session");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-session version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-shmop");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-shmop version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-sqlite");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-sqlite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-wddx");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5-wddx version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.2")<0) {
    security_note(0, data:"Package php5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-odbc");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.7")<0) {
    security_note(0, data:"Package php4-odbc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-session");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.7")<0) {
    security_note(0, data:"Package php4-session version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-shmop");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.7")<0) {
    security_note(0, data:"Package php4-shmop version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-wddx");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.7")<0) {
    security_note(0, data:"Package php4-wddx version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.7")<0) {
    security_note(0, data:"Package php4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mod_php4-twig");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package mod_php4-twig version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mod_php4");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package mod_php4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mod_php5");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package mod_php5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mod_php");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package mod_php version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-cgi");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php4-cgi version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-cli");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php4-cli version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-dtc");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php4-dtc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-horde");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php4-horde version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-nms");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php4-nms version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-cgi");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php5-cgi version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-cli");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php5-cli version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-dtc");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php5-dtc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-horde");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php5-horde version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-nms");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package php5-nms version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
