###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_faslo_player_stack_bof_vuln.nasl 5816 2009-11-20 10:06:48Z nov $
#
# Faslo Player .m3u Playlist Processing Buffer Overflow Vulnerability
#
# Authors:
# Maneesh KB <kmaneesh@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900254);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3969");
  script_name("Fasloi Player .m3u Playlist Processing Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with Faslo Player and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs when processing .m3u playlist files containing overly
  long data.

  Impact:
  Attackers can exploit this issue to execute arbitrary code by tricking users
  into opening crafted m3u playlist files and may cause Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  Faslo Player version 7.0 on Windows.

  Fix: No solution or patch is available as on 20th November,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.faslo.com/

  References:
  http://www.milw0rm.com/exploits/9487
  http://secunia.com/advisories/36444/
  http://www.vupen.com/english/advisories/2009/2395

  CVSS Score Report:
    CVSS Base Score    : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score: 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Faslo Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_faslo_player_detect.nasl");
  script_require_keys("FasloPlayer/Ver");
  exit(0);
}


include("version_func.inc");

fpVer = get_kb_item("FasloPlayer/Ver");
if(!fpVer){
  exit(0);
}

if(version_is_equal(version:fpVer, test_version:"7.0")){
  security_warning(0);
}
