###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_freetype_mult_int_overflow_vuln_lin.nasl 1793 2009-04-24 15:15:28 apr $
#
# FreeType Multiple Integer Overflow Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900631);
  script_version("$Revision: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0946");
  script_name("FreeType Multiple Integer Overflow Vulnerability (Linux)");
  desc = "

  Overview:
  This host has FreeType installed and is prone to Multiple Integer Overflow
  vulnerability.

  Vulnerability Insight:
  Multiple integer overflows are due to inadequate validation of data passed
  into cff/cffload.c, sfnt/ttcmap.c and cff/cffload.c while processing
  specially crafted fonts.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary
  code in the context of the affected application.

  Impact Level: System/Application.

  Affected Software/OS:
  FreeType version 2.3.9 and prior on Linux.

  Fix: Apply fix from the below repositories,
  http://git.savannah.gnu.org/cgit/freetype/freetype2.git/commit/?id=0545ec1ca36b27cb928128870a83e5f668980bc5
  http://git.savannah.gnu.org/cgit/freetype/freetype2.git/commit/?id=79972af4f0485a11dcb19551356c45245749fc5b
  http://git.savannah.gnu.org/cgit/freetype/freetype2.git/commit/?id=a18788b14db60ae3673f932249cd02d33a227c4e 

  *****
  NOTE : Ignore this warning, if above mentioned patch is applied already.
  *****

  References:
  http://secunia.com/advisories/34723
  https://bugzilla.redhat.com/show_bug.cgi?id=491384

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor : Critical";

  script_description(desc);
  script_summary("Check for the version of FreeType");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_freetype_detect_lin.nasl");
  script_require_keys("FreeType/Linux/Ver");
  exit(0);
}


include("version_func.inc");

freeVer=get_kb_item("FreeType/Linux/Ver");
if(!freeVer){
  exit(0);
}

if(version_is_less_equal(version:freeVer, test_version:"2.3.9")){
  security_hole(0);
}
