Minutes from 32nd OpenVDB TSC meeting, November 14th, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Peter* C.

Additional Attendees: Bruce Chernia (Intel), Daniel Elliott

Regrets: *Ken* M.

Agenda:

1) Confirm quorum
2) Secretary
3) Peter's Status
4) Const Grid Copying
5) PR 547: LOD Metadata
6) PR 548: Rename Translate
7) POPCNT.
8) PR 498: Install directory
9) VDB Points Merge SOP
10) Windows Update
11) Leaf Node Data
12) Meeting Time
13) Next Meeting

1) Quorum was confirmed.

2) Secretary was Jeff Lait

3) Peter's Status

With Peter's departure from DreamWorks he feels it is likely he will not
be able to contribute as much to the project.  We note that DreamWorks
does not need to have a TSC member in order to attend the meetings, and TSC
members are to be active contributors.  We unanimously agreed that Peter will
retain his TSC status for the next few months.  At that time we will better
know how involved with the project he chooses to be.

4) Const Grid Copying

The PR to allow deep copy of only metadata or transforms was unresolved
due to disputes about how to name.  We concluded that copyFrom was
too ambiguous and the consensus was copyGridReplacingMetadata

5) PR 547: LOD Metadata

We agree we need a more comprehensive solution.  In particular, user
meta data tends to be lost.  A common meta data is something to link
VDBs together that has to survive both .vdb and .bgeo export.

This particular PR is to be pushed, however, as the band-aid is better
than awawiting a fuller version.

6) PR 548: Rename Translate

Similar to PR547, the identified fix would be more righteous.  But this
PR will keep in sync with Houdini pending such a better fix.

7) POPCNT.

It has been verified to be 40% faster.  Compiler flags can
secretly undo the instrinsic, making it seem slower.  We need a CMAKE
flag for SSE4.2 and AVX.  We will have this off by default but turn
it on by default in the future.   Dan will provide a step-by-step guide
of how to make the PR something we can bring in.  Dan will also
offer taking over the PR and resubmitting if the author just wants
the PR in.

8) PR 498: Install directory

This has not been tested on other platforms.  But as it adds the LIBDIR
tuple it might possible solve our install directory problem without
special casing.

9) VDB Points Merge SOP

The initial question was how to detect if grids are unique.  This would
be a GU_PrimVDB::isGridUnique, which Jeff will investigate implementing.
This will not make the 18.0 gold window.

A bigger problem was discovered: the compile SOP world has an INPLACE
but no mode to let you steal all your inputs.  For a many-merge VDB
SOP you want to steal all of them.  It is possible the duplicateInputStealable
doesn't work properly for this (but it has been used in production)  Jeff
is to look at the code and comment.

A VDB Merge Points will be done without the clever stealing, then we
can investigate how to fix Verbs to work with a steal all world.

10) Windows Update

Biggest hiccup for compiling on Windows was setting the 64-bit flag.
The set of PRs submitted should make this a lot more turn key.  They
also remove the magic statics that aren't needed any more.

11) Leaf Node Data

We investigated if there was room to store data in the leaf node.  In
particular, Ken wanted to free up 8-bytes as a general utility.  We
knew we had 4 bytes at the tail, but it would be nice to future proof.
One idea is to have fileinfo always be present.  If we don't purge
fileinfo once a node is paged in, we can then also move the mutexs
into the fileinfo structure.  The absense of a fileinfo node is a signal
there is no need to use those mutexes.  One concern is they may have
already been re-used as an internal flag in some algorithms, but
those may have just been planned uses.

A serious problem raised is that we don't have a good window for these
changes.  It is likely too late for ABI 7, but we couldn't have done it
earlier as we were on ABI6.  This suggests we should have these projects
sitting as PRs lying dormant until the start of a new ABI where we
can bring them in.

12) Meeting Time

The meeting will stay the same regardless of anyone's daylight savings.  Some
confusion existed as it was often reported as EDT/EST.  This means the default
time is now 2-3 EST.

13) Next Meeting

Next planned meeting is:

Novemeber 22nd 2019. 2pm-3pm EST (GMT-5).
